/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class StringTrieBuilder {
    private State state = State.ADDING;
    @Deprecated
    protected StringBuilder strings = new StringBuilder();
    private Node root;
    private HashMap<Node, Node> nodes = new HashMap();
    private ValueNode lookupFinalValueNode = new ValueNode();

    @Deprecated
    protected StringTrieBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected final void addImpl(CharSequence s, int value) {
        void var2_2;
        void var1_1;
        if (this.state != State.ADDING) {
            throw new IllegalStateException("Cannot add (string, value) pairs after build().");
        }
        if (s.length() > 65535) {
            throw new IndexOutOfBoundsException("The maximum string length is 0xffff.");
        }
        if (this.root == null) {
            this.root = this.createSuffixNode(s, 0, value);
            return;
        }
        this.root = this.root.add(this, (CharSequence)var1_1, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected final void buildImpl(Option buildOption) {
        switch (this.state) {
            case ADDING: {
                void var1_1;
                if (this.root == null) {
                    throw new IndexOutOfBoundsException("No (string, value) pairs were added.");
                }
                if (var1_1 == Option.FAST) {
                    this.state = State.BUILDING_FAST;
                    break;
                }
                this.state = State.BUILDING_SMALL;
                break;
            }
            case BUILDING_FAST: 
            case BUILDING_SMALL: {
                throw new IllegalStateException("Builder failed and must be clear()ed.");
            }
            case BUILT: {
                return;
            }
        }
        this.root = this.root.register(this);
        this.root.markRightEdgesFirst(-1);
        this.root.write(this);
        this.state = State.BUILT;
    }

    /*
     * WARNING - void declaration
     */
    private final ValueNode registerFinalValue(int value) {
        void var1_2;
        void var2_3;
        ValueNode newNode;
        ValueNode.access$000(this.lookupFinalValueNode, value);
        Node oldNode = this.nodes.get(this.lookupFinalValueNode);
        if (oldNode != null) {
            return (ValueNode)oldNode;
        }
        ValueNode valueNode = newNode = new ValueNode(value);
        oldNode = this.nodes.put(valueNode, valueNode);
        assert (var2_3 == null);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private ValueNode createSuffixNode(CharSequence s, int start, int sValue) {
        void var3_4;
        ValueNode node = this.registerFinalValue(sValue);
        if (start < s.length()) {
            void var2_2;
            void var1_1;
            int offset = this.strings.length();
            this.strings.append(s, start, s.length());
            node = new LinearMatchNode(this.strings, offset, var1_1.length() - var2_2, node);
        }
        return var3_4;
    }

    @Deprecated
    protected abstract int write(int var1);

    @Deprecated
    protected abstract int write(int var1, int var2);

    @Deprecated
    protected abstract int writeValueAndFinal(int var1, boolean var2);

    @Deprecated
    protected abstract int writeValueAndType(boolean var1, int var2, int var3);

    @Deprecated
    protected abstract int writeDeltaTo(int var1);

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ValueNode access$100(StringTrieBuilder x0, CharSequence x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.createSuffixNode((CharSequence)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Node access$200(StringTrieBuilder x0, Node x1) {
        void var1_1;
        StringTrieBuilder stringTrieBuilder = x0;
        if (stringTrieBuilder.state != State.BUILDING_FAST) {
            Node node = stringTrieBuilder.nodes.get(var1_1);
            if (node != null) {
                return node;
            }
            void v0 = var1_1;
            node = stringTrieBuilder.nodes.put((Node)v0, (Node)v0);
            assert (node == null);
        }
        return var1_1;
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State ADDING = new State();
        public static final /* enum */ State BUILDING_FAST = new State();
        public static final /* enum */ State BUILDING_SMALL = new State();
        public static final /* enum */ State BUILT = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        static {
            $VALUES = new State[]{ADDING, BUILDING_FAST, BUILDING_SMALL, BUILT};
        }
    }

    static final class BranchHeadNode
    extends ValueNode {
        private int length;
        private Node next;

        /*
         * WARNING - void declaration
         */
        public BranchHeadNode(int len, Node subNode) {
            void var2_2;
            void var1_1;
            this.length = var1_1;
            this.next = var2_2;
        }

        @Override
        public final int hashCode() {
            return (0xECCCCBE + this.length) * 37 + this.next.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            BranchHeadNode o = (BranchHeadNode)other;
            return this.length == o.length && this.next == var1_1.next;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int markRightEdgesFirst(int edgeNumber) {
            void var1_1;
            if (this.offset == 0) {
                this.offset = edgeNumber = this.next.markRightEdgesFirst(edgeNumber);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(StringTrieBuilder builder) {
            void var1_1;
            this.next.write(builder);
            if (this.length <= 48) {
                this.offset = builder.writeValueAndType(this.hasValue, this.value, this.length - 1);
                return;
            }
            builder.write(this.length - 1);
            this.offset = var1_1.writeValueAndType(this.hasValue, this.value, 0);
        }
    }

    static final class SplitBranchNode
    extends BranchNode {
        private char unit;
        private Node lessThan;
        private Node greaterOrEqual;

        /*
         * WARNING - void declaration
         */
        public SplitBranchNode(char middleUnit, Node lessThanNode, Node greaterOrEqualNode) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.hash = ((middleUnit + 206918985) * 37 + lessThanNode.hashCode()) * 37 + greaterOrEqualNode.hashCode();
            this.unit = var1_1;
            this.lessThan = var2_2;
            this.greaterOrEqual = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            SplitBranchNode o = (SplitBranchNode)other;
            return this.unit == o.unit && this.lessThan == o.lessThan && this.greaterOrEqual == var1_1.greaterOrEqual;
        }

        @Override
        public final int hashCode() {
            return super.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int markRightEdgesFirst(int edgeNumber) {
            void var1_1;
            if (this.offset == 0) {
                this.firstEdgeNumber = edgeNumber;
                edgeNumber = this.greaterOrEqual.markRightEdgesFirst(edgeNumber);
                this.offset = edgeNumber = this.lessThan.markRightEdgesFirst(edgeNumber - 1);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(StringTrieBuilder builder) {
            void var1_1;
            this.lessThan.writeUnlessInsideRightEdge(this.firstEdgeNumber, this.greaterOrEqual.getOffset(), builder);
            this.greaterOrEqual.write(builder);
            assert (this.lessThan.getOffset() > 0);
            builder.writeDeltaTo(this.lessThan.getOffset());
            this.offset = var1_1.write(this.unit);
        }
    }

    static final class ListBranchNode
    extends BranchNode {
        private Node[] equal;
        private int length;
        private int[] values;
        private char[] units;

        /*
         * WARNING - void declaration
         */
        public ListBranchNode(int capacity) {
            void var1_1;
            this.hash = capacity + 0x9DDDDD4;
            this.equal = new Node[capacity];
            this.values = new int[capacity];
            this.units = new char[var1_1];
        }

        @Override
        public final boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            ListBranchNode o = (ListBranchNode)other;
            for (int i = 0; i < this.length; ++i) {
                if (this.units[i] == o.units[i] && this.values[i] == o.values[i] && this.equal[i] == o.equal[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public final int hashCode() {
            return super.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int markRightEdgesFirst(int edgeNumber) {
            void var1_1;
            if (this.offset == 0) {
                this.firstEdgeNumber = edgeNumber;
                int step = 0;
                int i = this.length;
                do {
                    Node edge;
                    if ((edge = this.equal[--i]) != null) {
                        edgeNumber = edge.markRightEdgesFirst(edgeNumber - step);
                    }
                    step = 1;
                } while (i > 0);
                this.offset = edgeNumber;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(StringTrieBuilder builder) {
            int rightEdgeNumber;
            int unitNumber = this.length - 1;
            Node rightEdge = this.equal[unitNumber];
            int n = rightEdgeNumber = rightEdge == null ? this.firstEdgeNumber : rightEdge.getOffset();
            do {
                if (this.equal[--unitNumber] == null) continue;
                this.equal[unitNumber].writeUnlessInsideRightEdge(this.firstEdgeNumber, rightEdgeNumber, builder);
            } while (unitNumber > 0);
            unitNumber = this.length - 1;
            if (rightEdge == null) {
                builder.writeValueAndFinal(this.values[unitNumber], true);
            } else {
                rightEdge.write(builder);
            }
            while (true) {
                void var3_4;
                boolean isFinal;
                int value;
                this.offset = builder.write(this.units[unitNumber]);
                if (--unitNumber < 0) break;
                if (this.equal[unitNumber] == null) {
                    value = this.values[unitNumber];
                    isFinal = true;
                } else {
                    assert (this.equal[unitNumber].getOffset() > 0);
                    value = this.offset - this.equal[unitNumber].getOffset();
                    isFinal = false;
                }
                builder.writeValueAndFinal((int)var3_4, isFinal);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int c, int value) {
            void var2_2;
            void var1_1;
            this.units[this.length] = (char)c;
            this.equal[this.length] = null;
            this.values[this.length] = value;
            ++this.length;
            this.hash = (this.hash * 37 + var1_1) * 37 + var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int c, Node node) {
            void var2_2;
            void var1_1;
            this.units[this.length] = (char)c;
            this.equal[this.length] = node;
            this.values[this.length] = 0;
            ++this.length;
            this.hash = (this.hash * 37 + var1_1) * 37 + var2_2.hashCode();
        }
    }

    static abstract class BranchNode
    extends Node {
        protected int hash;
        protected int firstEdgeNumber;

        @Override
        public int hashCode() {
            return this.hash;
        }
    }

    static final class DynamicBranchNode
    extends ValueNode {
        private StringBuilder chars = new StringBuilder();
        private ArrayList<Node> equal = new ArrayList();

        /*
         * WARNING - void declaration
         */
        public final void add(char c, Node node) {
            void var2_2;
            void var3_3;
            void var1_1;
            int i = this.find(c);
            this.chars.insert(i, (char)var1_1);
            this.equal.add((int)var3_3, (Node)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Node add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            char c;
            int i;
            if (start == s.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(sValue);
                return this;
            }
            if ((i = this.find(c = s.charAt(start++))) < this.chars.length() && c == this.chars.charAt(i)) {
                ArrayList<Node> arrayList = this.equal;
                arrayList.set(i, arrayList.get(i).add(builder, s, start, sValue));
            } else {
                void var3_3;
                void var2_2;
                void var1_1;
                this.chars.insert(i, c);
                this.equal.add(i, StringTrieBuilder.access$100((StringTrieBuilder)var1_1, (CharSequence)var2_2, (int)var3_3, sValue));
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Node register(StringTrieBuilder builder) {
            void var3_3;
            void var1_1;
            block0: {
                void var2_2;
                BranchHeadNode head;
                Node subNode = this.register(builder, 0, this.chars.length());
                BranchHeadNode result = head = new BranchHeadNode(this.chars.length(), subNode);
                if (!this.hasValue) break block0;
                var2_2.setValue(this.value);
            }
            return StringTrieBuilder.access$200((StringTrieBuilder)var1_1, (Node)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private Node register(StringTrieBuilder builder, int start, int limit) {
            void var1_1;
            int middle;
            int length = limit - start;
            if (length > 5) {
                middle = start + length / 2;
                return StringTrieBuilder.access$200(builder, new SplitBranchNode(this.chars.charAt(middle), this.register(builder, start, middle), this.register(builder, middle, limit)));
            }
            ListBranchNode listNode = new ListBranchNode(middle);
            do {
                char c = this.chars.charAt(start);
                Node node = this.equal.get(start);
                if (node.getClass() == ValueNode.class) {
                    listNode.add((int)c, ((ValueNode)node).value);
                    continue;
                }
                listNode.add((int)c, node.register(builder));
            } while (++start < limit);
            return StringTrieBuilder.access$200((StringTrieBuilder)var1_1, listNode);
        }

        /*
         * WARNING - void declaration
         */
        private int find(char c) {
            void var2_2;
            int start = 0;
            int limit = this.chars.length();
            while (start < limit) {
                int i = (start + limit) / 2;
                char middleChar = this.chars.charAt(i);
                if (c < middleChar) {
                    limit = i;
                    continue;
                }
                if (c == middleChar) {
                    return i;
                }
                start = i + 1;
            }
            return (int)var2_2;
        }
    }

    static final class LinearMatchNode
    extends ValueNode {
        private CharSequence strings;
        private int stringOffset;
        private int length;
        private Node next;
        private int hash;

        /*
         * WARNING - void declaration
         */
        public LinearMatchNode(CharSequence builderStrings, int sOffset, int len, Node nextNode) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.strings = var1_1;
            this.stringOffset = var2_2;
            this.length = var3_3;
            this.next = nextNode;
        }

        @Override
        public final int hashCode() {
            return this.hash;
        }

        @Override
        public final boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            LinearMatchNode o = (LinearMatchNode)other;
            if (this.length != o.length || this.next != o.next) {
                return false;
            }
            int i = this.stringOffset;
            int j = o.stringOffset;
            int limit = this.stringOffset + this.length;
            while (i < limit) {
                if (this.strings.charAt(i) != this.strings.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Node add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (start == s.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(sValue);
                return this;
            }
            int limit = this.stringOffset + this.length;
            int i = this.stringOffset;
            while (i < limit) {
                void var6_7;
                char newChar;
                if (start == s.length()) {
                    int prefixLength = i - this.stringOffset;
                    LinearMatchNode suffixNode = new LinearMatchNode(this.strings, i, this.length - prefixLength, this.next);
                    suffixNode.setValue(sValue);
                    this.length = prefixLength;
                    this.next = suffixNode;
                    return this;
                }
                char thisChar = this.strings.charAt(i);
                if (thisChar != (newChar = s.charAt(start))) {
                    void result;
                    void thisSuffixNode;
                    ValueNode result2;
                    Node thisSuffixNode2;
                    DynamicBranchNode branchNode = new DynamicBranchNode();
                    if (i == this.stringOffset) {
                        if (this.hasValue) {
                            branchNode.setValue(this.value);
                            this.value = 0;
                            this.hasValue = false;
                        }
                        ++this.stringOffset;
                        --this.length;
                        thisSuffixNode2 = this.length > 0 ? this : this.next;
                        result2 = branchNode;
                    } else if (thisSuffixNode == result - true) {
                        --this.length;
                        thisSuffixNode2 = this.next;
                        this.next = branchNode;
                        result2 = this;
                    } else {
                        void prefixLength = thisSuffixNode - this.stringOffset;
                        thisSuffixNode2 = new LinearMatchNode(this.strings, (int)(++thisSuffixNode), this.length - (prefixLength + true), this.next);
                        this.length = prefixLength;
                        this.next = branchNode;
                        result2 = this;
                    }
                    ValueNode newSuffixNode = StringTrieBuilder.access$100(builder, s, start + 1, sValue);
                    branchNode.add(thisChar, thisSuffixNode2);
                    branchNode.add(newChar, newSuffixNode);
                    return result2;
                }
                ++var6_7;
                ++start;
            }
            this.next = this.next.add((StringTrieBuilder)var1_1, (CharSequence)var2_2, (int)var3_3, sValue);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Node register(StringTrieBuilder builder) {
            void var2_2;
            void var1_1;
            this.next = this.next.register(builder);
            while (this.length > 16) {
                int nextOffset = this.stringOffset + this.length - 16;
                this.length -= 16;
                LinearMatchNode suffixNode = new LinearMatchNode(this.strings, nextOffset, 16, this.next);
                suffixNode.setHashCode();
                this.next = StringTrieBuilder.access$200(builder, suffixNode);
            }
            this.setHashCode();
            LinearMatchNode result = this;
            return StringTrieBuilder.access$200((StringTrieBuilder)var1_1, (Node)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int markRightEdgesFirst(int edgeNumber) {
            void var1_1;
            if (this.offset == 0) {
                this.offset = edgeNumber = this.next.markRightEdgesFirst(edgeNumber);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(StringTrieBuilder builder) {
            void var1_1;
            this.next.write(builder);
            builder.write(this.stringOffset, this.length);
            this.offset = var1_1.writeValueAndType(this.hasValue, this.value, 48 + this.length - 1);
        }

        private void setHashCode() {
            this.hash = (124151391 + this.length) * 37 + this.next.hashCode();
            if (this.hasValue) {
                this.hash = this.hash * 37 + this.value;
            }
            int limit = this.stringOffset + this.length;
            for (int i = this.stringOffset; i < limit; ++i) {
                this.hash = this.hash * 37 + this.strings.charAt(i);
            }
        }
    }

    private static class ValueNode
    extends Node {
        protected boolean hasValue;
        protected int value;

        public ValueNode() {
        }

        /*
         * WARNING - void declaration
         */
        public ValueNode(int v) {
            void var1_1;
            this.hasValue = true;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setValue(int v) {
            void var1_1;
            assert (!this.hasValue);
            this.hasValue = true;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int hash = 0x111111;
            if (this.hasValue) {
                hash = 0x2777775 + this.value;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            ValueNode o = (ValueNode)other;
            return this.hasValue == o.hasValue && (!this.hasValue || this.value == var1_1.value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Node add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (start == s.length()) {
                throw new IllegalArgumentException("Duplicate string.");
            }
            ValueNode node = StringTrieBuilder.access$100(builder, (CharSequence)var2_2, (int)var3_3, sValue);
            node.setValue(this.value);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(StringTrieBuilder builder) {
            void var1_1;
            this.offset = var1_1.writeValueAndFinal(this.value, true);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$000(ValueNode x0, int x1) {
            void var1_1;
            ValueNode valueNode = x0;
            x0.hasValue = true;
            valueNode.value = var1_1;
        }
    }

    static abstract class Node {
        protected int offset = 0;

        public abstract int hashCode();

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void var1_1;
            return this == other || this.getClass() == var1_1.getClass();
        }

        public Node add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            return this;
        }

        public Node register(StringTrieBuilder builder) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public int markRightEdgesFirst(int edgeNumber) {
            void var1_1;
            if (this.offset == 0) {
                this.offset = edgeNumber;
            }
            return (int)var1_1;
        }

        public abstract void write(StringTrieBuilder var1);

        /*
         * WARNING - void declaration
         */
        public final void writeUnlessInsideRightEdge(int firstRight, int lastRight, StringTrieBuilder builder) {
            void var1_1;
            void var2_2;
            if (this.offset < 0 && (this.offset < var2_2 || var1_1 < this.offset)) {
                void var3_3;
                this.write((StringTrieBuilder)var3_3);
            }
        }

        public final int getOffset() {
            return this.offset;
        }
    }

    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option FAST = new Option();
        private static /* enum */ Option SMALL = new Option();

        static {
            Option[] optionArray = new Option[]{FAST, SMALL};
        }
    }
}

