/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.CacheBase;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.LocaleIDParser;
import com.ibm.icu.impl.SoftCache;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.InternalLocaleBuilder;
import com.ibm.icu.impl.locale.KeyTypeData;
import com.ibm.icu.impl.locale.LanguageTag;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.LocaleSyntaxException;
import com.ibm.icu.impl.locale.UnicodeLocaleExtension;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ULocale
implements Serializable,
Comparable<ULocale> {
    private static CacheBase<String, String, Void> nameCache = new SoftCache<String, String, Void>(){};
    private static ULocale CHINA;
    private static final Locale EMPTY_LOCALE;
    public static final ULocale ROOT;
    private static final SoftCache<Locale, ULocale, Void> CACHE;
    private volatile transient Locale locale;
    private String localeID;
    private volatile transient BaseLocale baseLocale;
    private volatile transient LocaleExtensions extensions;
    private static String[][] CANONICALIZE_MAP;
    private static Locale defaultLocale;
    private static ULocale defaultULocale;
    private static Locale[] defaultCategoryLocales;
    private static ULocale[] defaultCategoryULocales;
    private static Set<String> gKnownCanonicalizedCases;

    /*
     * WARNING - void declaration
     */
    private ULocale(String localeID, Locale locale) {
        void var2_2;
        void var1_1;
        this.localeID = var1_1;
        this.locale = var2_2;
    }

    public static ULocale forLocale(Locale loc) {
        Locale locale;
        if (loc == null) {
            return null;
        }
        return CACHE.getInstance(locale, null);
    }

    /*
     * WARNING - void declaration
     */
    public ULocale(String localeID) {
        void var1_1;
        this.localeID = ULocale.getName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ULocale(String a, String b, String c) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.localeID = ULocale.getName(ULocale.lscvToID((String)var1_1, (String)var2_2, (String)var3_3, ""));
    }

    public static ULocale createCanonical(ULocale locale) {
        Object object = locale;
        object = ((ULocale)object).localeID;
        return new ULocale(ULocale.canonicalize((String)object), null);
    }

    /*
     * WARNING - void declaration
     */
    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuilder buf = new StringBuilder();
        if (lang != null && lang.length() > 0) {
            String string;
            buf.append(string);
        }
        if (script != null && script.length() > 0) {
            void var1_1;
            buf.append('_');
            buf.append((String)var1_1);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            void var3_3;
            void var2_2;
            if (country == null || var2_2.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append((String)var3_3);
        }
        return buf.toString();
    }

    public final Locale toLocale() {
        if (this.locale == null) {
            this.locale = JDKLocaleHelper.toLocale(this);
        }
        return this.locale;
    }

    public static ULocale getDefault() {
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            if (defaultULocale == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ROOT;
            }
            Locale currentDefault = Locale.getDefault();
            if (!defaultLocale.equals(currentDefault)) {
                defaultLocale = currentDefault;
                defaultULocale = ULocale.forLocale(currentDefault);
                if (!JDKLocaleHelper.hasLocaleCategories()) {
                    for (Category category : Category.values()) {
                        int idx = category.ordinal();
                        ULocale.defaultCategoryLocales[idx] = currentDefault;
                        ULocale.defaultCategoryULocales[idx] = ULocale.forLocale(currentDefault);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultULocale;
        }
    }

    public final Object clone() {
        return this;
    }

    public final int hashCode() {
        return this.localeID.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ULocale) {
            void var1_1;
            return this.localeID.equals(((ULocale)var1_1).localeID);
        }
        return false;
    }

    public final String getLanguage() {
        return this.base().getLanguage();
    }

    public final String getScript() {
        return this.base().getScript();
    }

    public static String getScript(String localeID) {
        String string;
        return new LocaleIDParser(string).getScript();
    }

    public final String getCountry() {
        return this.base().getRegion();
    }

    public final String getVariant() {
        return this.base().getVariant();
    }

    public static String getVariant(String localeID) {
        String string;
        return new LocaleIDParser(string).getVariant();
    }

    public final String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        String string;
        if (localeID.indexOf(64) == -1) {
            return localeID;
        }
        return new LocaleIDParser(string).getBaseName();
    }

    public final String getName() {
        return this.localeID;
    }

    /*
     * WARNING - void declaration
     */
    private static int getShortestSubtagLength(String localeID) {
        void var2_2;
        int localeIDLength;
        int length = localeIDLength = localeID.length();
        boolean reset = true;
        int tmpLength = 0;
        for (int i = 0; i < localeIDLength; ++i) {
            if (localeID.charAt(i) != '_' && localeID.charAt(i) != '-') {
                if (reset) {
                    reset = false;
                    tmpLength = 0;
                }
                ++tmpLength;
                continue;
            }
            if (tmpLength != 0 && tmpLength < length) {
                length = tmpLength;
            }
            reset = true;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(String localeID) {
        void var1_1;
        Object tmpLocaleID = localeID;
        if (localeID != null && !localeID.contains("@") && ULocale.getShortestSubtagLength(localeID) == 1) {
            if (localeID.indexOf(95) >= 0 && localeID.charAt(1) != '_' && localeID.charAt(1) != '-') {
                tmpLocaleID = localeID.replace('_', '-');
            }
            tmpLocaleID = ULocale.forLanguageTag((String)tmpLocaleID);
            tmpLocaleID = ((ULocale)tmpLocaleID).localeID;
            if (((String)tmpLocaleID).length() == 0) {
                tmpLocaleID = localeID;
            }
        } else {
            String string;
            tmpLocaleID = "root".equalsIgnoreCase(localeID) ? "" : ULocale.stripLeadingUnd(string);
        }
        return nameCache.getInstance((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static String stripLeadingUnd(String localeID) {
        String string;
        void var1_1;
        int length = localeID.length();
        if (length < 3) {
            return localeID;
        }
        if (!localeID.regionMatches(true, 0, "und", 0, 3)) {
            return localeID;
        }
        if (length == 3) {
            return "";
        }
        char separator = localeID.charAt(3);
        if (separator == '-' || var1_1 == 95) {
            return localeID.substring(3);
        }
        return string;
    }

    public final String toString() {
        return this.localeID;
    }

    public final Iterator<String> getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    private static Iterator<String> getKeywords(String localeID) {
        String string;
        return new LocaleIDParser(string).getKeywords();
    }

    /*
     * WARNING - void declaration
     */
    public final String getKeywordValue(String keywordName) {
        void var1_1;
        return ULocale.getKeywordValue(this.localeID, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String getKeywordValue(String localeID, String keywordName) {
        void var1_1;
        String string;
        return new LocaleIDParser(string).getKeywordValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalize(String localeID) {
        void var1_3;
        AliasReplacer aliasReplacer;
        String replaced;
        String i2;
        void var3_5;
        LocaleIDParser parser = new LocaleIDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals("")) {
            return "";
        }
        for (int i2 = 0; i2 < CANONICALIZE_MAP.length; ++i2) {
            String[] vals = CANONICALIZE_MAP[i2];
            if (!vals[0].equals(baseName)) continue;
            foundVariant = true;
            parser.setBaseName(vals[1]);
            break;
        }
        if (var3_5 == false && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        if (!ULocale.isKnownCanonicalizedLocale(i2 = parser.getName()) && (replaced = (aliasReplacer = new AliasReplacer(parser.getLanguage(), parser.getScript(), parser.getCountry(), AsciiUtil.toLowerString(parser.getVariant()), parser.getName().substring(parser.getBaseName().length()))).replace()) != null) {
            void var0_2;
            parser = new LocaleIDParser((String)var0_2);
        }
        return var1_3.getName();
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized boolean isKnownCanonicalizedLocale(String name) {
        String string;
        if (name.equals("c") || name.equals("en") || name.equals("en_US")) {
            return true;
        }
        if (gKnownCanonicalizedCases == null) {
            void var1_1;
            List<String> items = Arrays.asList("af", "af_ZA", "am", "am_ET", "ar", "ar_001", "as", "as_IN", "az", "az_AZ", "be", "be_BY", "bg", "bg_BG", "bn", "bn_IN", "bs", "bs_BA", "ca", "ca_ES", "cs", "cs_CZ", "cy", "cy_GB", "da", "da_DK", "de", "de_DE", "el", "el_GR", "en", "en_GB", "en_US", "es", "es_419", "es_ES", "et", "et_EE", "eu", "eu_ES", "fa", "fa_IR", "fi", "fi_FI", "fil", "fil_PH", "fr", "fr_FR", "ga", "ga_IE", "gl", "gl_ES", "gu", "gu_IN", "he", "he_IL", "hi", "hi_IN", "hr", "hr_HR", "hu", "hu_HU", "hy", "hy_AM", "id", "id_ID", "is", "is_IS", "it", "it_IT", "ja", "ja_JP", "jv", "jv_ID", "ka", "ka_GE", "kk", "kk_KZ", "km", "km_KH", "kn", "kn_IN", "ko", "ko_KR", "ky", "ky_KG", "lo", "lo_LA", "lt", "lt_LT", "lv", "lv_LV", "mk", "mk_MK", "ml", "ml_IN", "mn", "mn_MN", "mr", "mr_IN", "ms", "ms_MY", "my", "my_MM", "nb", "nb_NO", "ne", "ne_NP", "nl", "nl_NL", "no", "or", "or_IN", "pa", "pa_IN", "pl", "pl_PL", "ps", "ps_AF", "pt", "pt_BR", "pt_PT", "ro", "ro_RO", "ru", "ru_RU", "sd", "sd_IN", "si", "si_LK", "sk", "sk_SK", "sl", "sl_SI", "so", "so_SO", "sq", "sq_AL", "sr", "sr_Cyrl_RS", "sr_Latn", "sr_RS", "sv", "sv_SE", "sw", "sw_TZ", "ta", "ta_IN", "te", "te_IN", "th", "th_TH", "tk", "tk_TM", "tr", "tr_TR", "uk", "uk_UA", "ur", "ur_PK", "uz", "uz_UZ", "vi", "vi_VN", "yue", "yue_Hant", "yue_Hant_HK", "yue_HK", "zh", "zh_CN", "zh_Hans", "zh_Hans_CN", "zh_Hant", "zh_Hant_TW", "zh_TW", "zu", "zu_ZA");
            gKnownCanonicalizedCases = new HashSet<String>((Collection<String>)var1_1);
        }
        return gKnownCanonicalizedCases.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    public final ULocale setKeywordValue(String keyword, String value) {
        Object object;
        void var2_2;
        void var3_3 = var2_2;
        var2_2 = object;
        object = this.localeID;
        object = new LocaleIDParser((String)object);
        ((LocaleIDParser)object).setKeywordValue((String)var2_2, (String)var3_3);
        return new ULocale(((LocaleIDParser)object).getName(), null);
    }

    /*
     * WARNING - void declaration
     */
    public static ULocale addLikelySubtags(ULocale loc) {
        void var1_1;
        String newLocaleID;
        void var2_2;
        int trailingIndex;
        int n;
        String[] tags = new String[3];
        String trailing = null;
        Object object = tags;
        String string = loc.localeID;
        Object object2 = new LocaleIDParser(string);
        String string2 = ((LocaleIDParser)object2).getLanguage();
        String string3 = ((LocaleIDParser)object2).getScript();
        String string4 = ((LocaleIDParser)object2).getCountry();
        object[0] = ULocale.isEmptyString(string2) ? "und" : string2;
        object[1] = string3.equals("Zzzz") ? "" : string3;
        object[2] = string4.equals("ZZ") ? "" : string4;
        object = ((LocaleIDParser)object2).getVariant();
        int n2 = !ULocale.isEmptyString((String)object) ? ((n = string.indexOf((String)object)) > 0 ? n - 1 : n) : (trailingIndex = (n = string.indexOf(64)) == -1 ? string.length() : n);
        if (n2 < loc.localeID.length()) {
            void var3_7;
            trailing = loc.localeID.substring((int)var3_7);
        }
        string2 = var2_2;
        object2 = tags[2];
        String string5 = tags[1];
        String string6 = tags[0];
        if ((!ULocale.isEmptyString(string5) && !ULocale.isEmptyString((String)object2) && (string4 = ULocale.lookupLikelySubtags(string3 = ULocale.createTagString(string6, string5, (String)object2, null))) != null ? ULocale.createTagString(null, null, null, string2, string4) : (!ULocale.isEmptyString(string5) && (string4 = ULocale.lookupLikelySubtags(string3 = ULocale.createTagString(string6, string5, null, null))) != null ? ULocale.createTagString(null, null, (String)object2, string2, string4) : (!ULocale.isEmptyString((String)object2) && (string4 = ULocale.lookupLikelySubtags(string3 = ULocale.createTagString(string6, null, (String)object2, null))) != null ? ULocale.createTagString(null, string5, null, string2, string4) : (newLocaleID = (string4 = ULocale.lookupLikelySubtags(string3 = ULocale.createTagString(string6, null, null, null))) != null ? ULocale.createTagString(null, string5, (String)object2, string2, string4) : null)))) == null) {
            ULocale uLocale;
            return uLocale;
        }
        return new ULocale((String)var1_1);
    }

    private static boolean isEmptyString(String string) {
        String string2;
        return string == null || string2.length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    private static void appendTag(String tag, StringBuilder buffer) {
        String string;
        void var1_1;
        if (buffer.length() != 0) {
            buffer.append('_');
        }
        var1_1.append(string);
    }

    /*
     * WARNING - void declaration
     */
    private static String createTagString(String lang, String script, String region, String trailing, String alternateTags) {
        String alternateLang;
        LocaleIDParser parser = null;
        boolean regionAppended = false;
        StringBuilder tag = new StringBuilder();
        ULocale.appendTag(!ULocale.isEmptyString(lang) ? lang : (!ULocale.isEmptyString(alternateTags) && !ULocale.isEmptyString(alternateLang = (parser = new LocaleIDParser(alternateTags)).getLanguage()) ? alternateLang : "und"), tag);
        if (!ULocale.isEmptyString(script)) {
            void var1_2;
            ULocale.appendTag((String)var1_2, tag);
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateScript;
            if (parser == null) {
                parser = new LocaleIDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateScript = parser.getScript())) {
                ULocale.appendTag(alternateScript, tag);
            }
        }
        if (!ULocale.isEmptyString(region)) {
            void var2_3;
            ULocale.appendTag((String)var2_3, tag);
            regionAppended = true;
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateRegion;
            if (parser == null) {
                parser = new LocaleIDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateRegion = parser.getCountry())) {
                ULocale.appendTag(alternateRegion, tag);
                regionAppended = true;
            }
        }
        if (trailing != null && trailing.length() > 1) {
            int separators = 0;
            if (trailing.charAt(0) == '_') {
                if (trailing.charAt(1) == '_') {
                    separators = 2;
                }
            } else {
                separators = 1;
            }
            if (regionAppended) {
                if (separators == 2) {
                    tag.append(trailing.substring(1));
                } else {
                    tag.append(trailing);
                }
            } else {
                void var3_4;
                void var0_1;
                if (var0_1 == true) {
                    tag.append('_');
                }
                tag.append((String)var3_4);
            }
        }
        return tag.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String createTagString(String lang, String script, String region, String trailing) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ULocale.createTagString(lang, (String)var1_1, (String)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static String lookupLikelySubtags(String localeId) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b", "likelySubtags");
        try {
            String string;
            void var1_1;
            return var1_1.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toLanguageTag() {
        void var1_1;
        void var3_4;
        String s;
        Object object;
        void e2;
        BaseLocale base = this.base();
        LocaleExtensions exts = this.extensions();
        if (base.getVariant().equalsIgnoreCase("POSIX")) {
            base = BaseLocale.getInstance(base.getLanguage(), base.getScript(), base.getRegion(), "");
            if (exts.getUnicodeLocaleType("va") == null) {
                InternalLocaleBuilder ilocbld = new InternalLocaleBuilder();
                try {
                    ilocbld.setLocale(BaseLocale.ROOT, exts);
                    ilocbld.setUnicodeLocaleKeyword("va", "posix");
                    exts = ilocbld.getLocaleExtensions();
                }
                catch (LocaleSyntaxException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        LanguageTag tag = LanguageTag.parseLocale((BaseLocale)e2, exts);
        StringBuilder buf = new StringBuilder();
        String subtag = tag.getLanguage();
        if (subtag.length() > 0) {
            buf.append(LanguageTag.canonicalizeLanguage(subtag));
        }
        if ((subtag = tag.getScript()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeScript(subtag));
        }
        if ((subtag = tag.getRegion()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeRegion(subtag));
        }
        List<String> subtags = tag.getVariants();
        ArrayList<String> variants = new ArrayList<String>(subtags);
        Collections.sort(variants);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            s = (String)object.next();
            buf.append("-");
            buf.append(LanguageTag.canonicalizeVariant(s));
        }
        object = tag.getExtensions();
        object = object.iterator();
        while (object.hasNext()) {
            s = object.next();
            buf.append("-");
            buf.append(LanguageTag.canonicalizeExtension(s));
        }
        object = var3_4.getPrivateuse();
        if (((String)object).length() > 0) {
            if (buf.length() == 0) {
                buf.append("und");
            }
            buf.append("-");
            buf.append("x-");
            buf.append(LanguageTag.canonicalizePrivateuse((String)object));
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static ULocale forLanguageTag(String languageTag) {
        void var1_1;
        LanguageTag languageTag2;
        LanguageTag tag = LanguageTag.parse(languageTag, null);
        InternalLocaleBuilder bldr = new InternalLocaleBuilder();
        bldr.setLanguageTag(languageTag2);
        return ULocale.getInstance(bldr.getBaseLocale(), var1_1.getLocaleExtensions());
    }

    /*
     * WARNING - void declaration
     */
    public static String toUnicodeLocaleType(String keyword, String value) {
        String string;
        String bcpType = KeyTypeData.toBcpType(keyword, value, null, null);
        if (bcpType == null && UnicodeLocaleExtension.isType(value)) {
            void var1_1;
            bcpType = AsciiUtil.toLowerString((String)var1_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String toLegacyKey(String keyword) {
        void var1_1;
        String legacyKey = KeyTypeData.toLegacyKey(keyword);
        if (legacyKey == null && keyword.matches("[0-9a-zA-Z]+")) {
            String string;
            legacyKey = AsciiUtil.toLowerString(string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String toLegacyType(String keyword, String value) {
        String string;
        String legacyType = KeyTypeData.toLegacyType(keyword, value, null, null);
        if (legacyType == null && value.matches("[0-9a-zA-Z]+([_/\\-][0-9a-zA-Z]+)*")) {
            void var1_1;
            legacyType = AsciiUtil.toLowerString((String)var1_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static ULocale getInstance(BaseLocale base, LocaleExtensions exts) {
        void var2_2;
        String id = ULocale.lscvToID(base.getLanguage(), base.getScript(), base.getRegion(), base.getVariant());
        Set<Character> extKeys = exts.getKeys();
        if (!extKeys.isEmpty()) {
            TreeMap<String, String> kwds = new TreeMap<String, String>();
            for (Character key : extKeys) {
                Set<String> uattributes;
                UnicodeLocaleExtension uext;
                AsciiUtil ext = exts.getExtension$f40ab2c(key);
                if (ext instanceof UnicodeLocaleExtension) {
                    uext = (UnicodeLocaleExtension)ext;
                    Set<String> set = uext.getUnicodeLocaleKeys();
                    for (String bcpKey : set) {
                        String bcpType = uext.getUnicodeLocaleType(bcpKey);
                        String lkey = ULocale.toLegacyKey(bcpKey);
                        String ltype = ULocale.toLegacyType(bcpKey, bcpType.length() == 0 ? "yes" : bcpType);
                        if (lkey.equals("va") && ltype.equals("posix") && base.getVariant().length() == 0) {
                            id = id + "_POSIX";
                            continue;
                        }
                        kwds.put(lkey, ltype);
                    }
                    uattributes = uext.getUnicodeLocaleAttributes();
                    if (uattributes.size() <= 0) continue;
                    StringBuilder attrbuf = new StringBuilder();
                    for (String attr : uattributes) {
                        if (attrbuf.length() > 0) {
                            attrbuf.append('-');
                        }
                        attrbuf.append(attr);
                    }
                    kwds.put("attribute", attrbuf.toString());
                    continue;
                }
                kwds.put(String.valueOf(uext), ((AsciiUtil)((Object)uattributes)).getValue());
            }
            if (!kwds.isEmpty()) {
                void var3_3;
                StringBuilder buf = new StringBuilder(id);
                buf.append("@");
                Set kset = kwds.entrySet();
                boolean insertSep = false;
                for (Map.Entry kwd : kset) {
                    if (insertSep) {
                        buf.append(";");
                    } else {
                        insertSep = true;
                    }
                    buf.append((String)kwd.getKey());
                    buf.append("=");
                    buf.append((String)kwd.getValue());
                }
                id = var3_3.toString();
            }
        }
        return new ULocale((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private BaseLocale base() {
        if (this.baseLocale == null) {
            void var3_2;
            void var2_3;
            void var1_4;
            String string;
            String variant = "";
            String region = "";
            String script = "";
            String language = "";
            if (!this.equals(ROOT)) {
                LocaleIDParser lp = new LocaleIDParser(this.localeID);
                language = lp.getLanguage();
                script = lp.getScript();
                region = lp.getCountry();
                string = lp.getVariant();
            }
            this.baseLocale = BaseLocale.getInstance((String)var1_4, (String)var2_3, (String)var3_2, string);
        }
        return this.baseLocale;
    }

    /*
     * WARNING - void declaration
     */
    private LocaleExtensions extensions() {
        if (this.extensions == null) {
            ULocale uLocale = this;
            Iterator<String> kwitr = ULocale.getKeywords(uLocale.localeID);
            if (kwitr == null) {
                this.extensions = LocaleExtensions.EMPTY_EXTENSIONS;
            } else {
                void var2_2;
                InternalLocaleBuilder intbld = new InternalLocaleBuilder();
                while (kwitr.hasNext()) {
                    void var3_3;
                    String[] key = kwitr.next();
                    if (key.equals("attribute")) {
                        String[] stringArray;
                        key = stringArray = this.getKeywordValue((String)key).split("[-_]");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String uattr = key[i];
                            try {
                                intbld.addUnicodeLocaleAttribute(uattr);
                                continue;
                            }
                            catch (LocaleSyntaxException localeSyntaxException) {}
                        }
                        continue;
                    }
                    if (key.length() >= 2) {
                        String[] stringArray = key;
                        String string = KeyTypeData.toBcpKey((String)key);
                        if (string == null && UnicodeLocaleExtension.isKey((String)stringArray)) {
                            string = AsciiUtil.toLowerString((String)stringArray);
                        }
                        String bcpKey = string;
                        String bcpType = ULocale.toUnicodeLocaleType((String)key, this.getKeywordValue((String)key));
                        if (bcpKey == null || bcpType == null) continue;
                        try {
                            intbld.setUnicodeLocaleKeyword(bcpKey, (String)var3_3);
                        }
                        catch (LocaleSyntaxException localeSyntaxException) {}
                        continue;
                    }
                    if (var3_3.length() != 1 || var3_3.charAt(0) == 'u') continue;
                    try {
                        intbld.setExtension(var3_3.charAt(0), this.getKeywordValue((String)var3_3).replace("_", "-"));
                    }
                    catch (LocaleSyntaxException localeSyntaxException) {
                    }
                }
                this.extensions = var2_2.getLocaleExtensions();
            }
        }
        return this.extensions;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(String x0, String x1, String x2, String x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ULocale.lscvToID(x0, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ ULocale(String x0, Locale x1, byte by) {
        this((String)var1_1, (Locale)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        new ULocale("en", Locale.ENGLISH);
        new ULocale("fr", Locale.FRENCH);
        new ULocale("de", Locale.GERMAN);
        new ULocale("it", Locale.ITALIAN);
        new ULocale("ja", Locale.JAPANESE);
        new ULocale("ko", Locale.KOREAN);
        new ULocale("zh", Locale.CHINESE);
        new ULocale("zh_Hans");
        new ULocale("zh_Hant");
        new ULocale("fr_FR", Locale.FRANCE);
        new ULocale("de_DE", Locale.GERMANY);
        new ULocale("it_IT", Locale.ITALY);
        new ULocale("ja_JP", Locale.JAPAN);
        new ULocale("ko_KR", Locale.KOREA);
        CHINA = new ULocale("zh_Hans_CN");
        new ULocale("zh_Hant_TW");
        new ULocale("en_GB", Locale.UK);
        new ULocale("en_US", Locale.US);
        new ULocale("en_CA", Locale.CANADA);
        new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale("", "");
        ROOT = new ULocale("", EMPTY_LOCALE);
        CACHE = new SoftCache<Locale, ULocale, Void>(){};
        CANONICALIZE_MAP = new String[][]{{"art__LOJBAN", "jbo"}, {"cel__GAULISH", "cel__GAULISH"}, {"de__1901", "de__1901"}, {"de__1906", "de__1906"}, {"en__BOONT", "en__BOONT"}, {"en__SCOUSE", "en__SCOUSE"}, {"hy__AREVELA", "hy", null, null}, {"hy__AREVMDA", "hyw", null, null}, {"sl__ROZAJ", "sl__ROZAJ"}, {"zh__GUOYU", "zh"}, {"zh__HAKKA", "hak"}, {"zh__XIANG", "hsn"}, {"zh_GAN", "gan"}, {"zh_MIN", "zh__MIN"}, {"zh_MIN_NAN", "nan"}, {"zh_WUU", "wuu"}, {"zh_YUE", "yue"}};
        defaultLocale = Locale.getDefault();
        defaultCategoryLocales = new Locale[Category.values().length];
        defaultCategoryULocales = new ULocale[Category.values().length];
        defaultULocale = ULocale.forLocale(defaultLocale);
        if (JDKLocaleHelper.hasLocaleCategories()) {
            for (Category cat : Category.values()) {
                void var3_6;
                int idx = cat.ordinal();
                ULocale.defaultCategoryLocales[idx] = JDKLocaleHelper.getDefault((Category)var3_6);
                ULocale.defaultCategoryULocales[idx] = ULocale.forLocale(defaultCategoryLocales[idx]);
            }
        } else {
            for (Category category : Category.values()) {
                int idx = category.ordinal();
                ULocale.defaultCategoryLocales[idx] = defaultLocale;
                ULocale.defaultCategoryULocales[idx] = defaultULocale;
            }
        }
        gKnownCanonicalizedCases = null;
        new Type(0);
        new Type(0);
    }

    static final class JDKLocaleHelper {
        private static boolean hasLocaleCategories = false;
        private static Method mGetDefault;
        private static Object eDISPLAY;
        private static Object eFORMAT;

        public static boolean hasLocaleCategories() {
            return hasLocaleCategories;
        }

        /*
         * WARNING - void declaration
         */
        public static ULocale toULocale(Locale loc) {
            Locale locale;
            void var1_1;
            String language = loc.getLanguage();
            String country = loc.getCountry();
            String variant = loc.getVariant();
            TreeSet<String> attributes = null;
            TreeMap<String, String> keywords = null;
            String script = loc.getScript();
            Set<Character> extKeys = loc.getExtensionKeys();
            if (!extKeys.isEmpty()) {
                for (Character extKey : extKeys) {
                    String kwVal;
                    if (extKey.charValue() == 'u') {
                        Set<String> uAttributes = loc.getUnicodeLocaleAttributes();
                        if (!uAttributes.isEmpty()) {
                            attributes = new TreeSet<String>();
                            for (String string : uAttributes) {
                                attributes.add(string);
                            }
                        }
                        Set<String> set = loc.getUnicodeLocaleKeys();
                        for (String string : set) {
                            kwVal = loc.getUnicodeLocaleType(string);
                            if (kwVal == null) continue;
                            if (string.equals("va")) {
                                variant = variant.length() == 0 ? kwVal : kwVal + "_" + variant;
                                continue;
                            }
                            if (keywords == null) {
                                keywords = new TreeMap();
                            }
                            keywords.put(string, kwVal);
                        }
                        continue;
                    }
                    String extVal = loc.getExtension(((Character)((Object)kwVal)).charValue());
                    if (extVal == null) continue;
                    if (keywords == null) {
                        keywords = new TreeMap<String, String>();
                    }
                    keywords.put(String.valueOf(kwVal), extVal);
                }
            }
            if (language.equals("no") && country.equals("NO") && variant.equals("NY")) {
                language = "nn";
                variant = "";
            }
            StringBuilder buf = new StringBuilder((String)var1_1);
            if (script.length() > 0) {
                void var2_6;
                buf.append('_');
                buf.append((String)var2_6);
            }
            if (country.length() > 0) {
                buf.append('_');
                buf.append(country);
            }
            if (variant.length() > 0) {
                void var3_2;
                if (var3_2.length() == 0) {
                    buf.append('_');
                }
                buf.append('_');
                buf.append(variant);
            }
            if (attributes != null) {
                StringBuilder attrBuf = new StringBuilder();
                for (String string : attributes) {
                    if (attrBuf.length() != 0) {
                        attrBuf.append('-');
                    }
                    attrBuf.append(string);
                }
                if (keywords == null) {
                    keywords = new TreeMap();
                }
                keywords.put("attribute", attrBuf.toString());
            }
            if (keywords != null) {
                buf.append('@');
                boolean addSep = false;
                for (Map.Entry entry : keywords.entrySet()) {
                    void var10_22;
                    void var11_29;
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    if (string.length() != 1) {
                        String string3 = ULocale.toLegacyKey(string);
                        String string4 = ULocale.toLegacyType(string3, string2.length() == 0 ? "yes" : string2);
                    }
                    if (addSep) {
                        buf.append(';');
                    } else {
                        addSep = true;
                    }
                    buf.append((String)var11_29);
                    buf.append('=');
                    buf.append((String)var10_22);
                }
            }
            return new ULocale(ULocale.getName(buf.toString()), locale, 0);
        }

        /*
         * WARNING - void declaration
         */
        public static Locale toLocale(ULocale uloc) {
            void var1_1;
            void var2_2;
            Object loc = null;
            String ulocStr = uloc.getName();
            if (uloc.getScript().length() > 0 || var2_2.contains("@")) {
                loc = uloc.toLanguageTag();
                loc = AsciiUtil.toUpperString((String)loc);
                loc = Locale.forLanguageTag((String)loc);
            }
            if (loc == null) {
                ULocale uLocale;
                loc = new Locale(uloc.getLanguage(), uloc.getCountry(), uLocale.getVariant());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Locale getDefault(Category category) {
            if (hasLocaleCategories) {
                Category category2;
                Object cat = null;
                switch (category2) {
                    case DISPLAY: {
                        cat = eDISPLAY;
                        break;
                    }
                    case FORMAT: {
                        cat = eFORMAT;
                    }
                }
                if (cat != null) {
                    try {
                        void var1_1;
                        return (Locale)mGetDefault.invoke(null, var1_1);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            return Locale.getDefault();
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                void var0;
                T[] TArray;
                Class<?> cCategory = null;
                Class<?>[] classArray = Locale.class.getDeclaredClasses();
                Class<?>[] classArray2 = classArray;
                classArray2 = classArray;
                int n = classArray.length;
                for (int i = 0; i < n; ++i) {
                    Class<?> c = classArray2[i];
                    if (!c.getName().equals("java.util.Locale$Category")) continue;
                    cCategory = c;
                    break;
                }
                if (cCategory == null) {
                    return;
                }
                mGetDefault = Locale.class.getDeclaredMethod("getDefault", cCategory);
                Locale.class.getDeclaredMethod("setDefault", cCategory, Locale.class);
                Method mName = cCategory.getMethod("name", null);
                T[] TArray2 = TArray = var0.getEnumConstants();
                int n2 = TArray.length;
                for (int i = 0; i < n2; ++i) {
                    Object e = TArray2[i];
                    String catVal = (String)mName.invoke(e, (Object[])null);
                    if (catVal.equals("DISPLAY")) {
                        eDISPLAY = e;
                        continue;
                    }
                    if (!catVal.equals("FORMAT")) continue;
                    eFORMAT = TArray;
                }
                if (eDISPLAY == null || eFORMAT == null) {
                    return;
                }
                hasLocaleCategories = true;
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
            catch (SecurityException securityException) {
                return;
            }
        }
    }

    public static final class Type {
        private Type() {
        }

        /* synthetic */ Type(byte by) {
            this();
        }
    }

    static final class AliasReplacer {
        private String language;
        private String script;
        private String region;
        private List<String> variants;
        private String extensions;
        private static boolean aliasDataIsLoaded = false;
        private static Map<String, String> languageAliasMap = null;
        private static Map<String, String> scriptAliasMap = null;
        private static Map<String, List<String>> territoryAliasMap = null;
        private static Map<String, String> variantAliasMap = null;
        private static Map<String, String> subdivisionAliasMap = null;

        /*
         * WARNING - void declaration
         */
        public AliasReplacer(String language, String script, String region, String variants, String extensions) {
            void var3_3;
            void var2_2;
            void var1_1;
            assert (language != null);
            assert (script != null);
            assert (region != null);
            assert (variants != null);
            assert (extensions != null);
            this.language = var1_1;
            this.script = var2_2;
            this.region = var3_3;
            if (!variants.isEmpty()) {
                this.variants = new ArrayList<String>(Arrays.asList(variants.split("_")));
            }
            this.extensions = extensions;
        }

        /*
         * WARNING - void declaration
         */
        public final String replace() {
            void var1_1;
            boolean changed = false;
            AliasReplacer.loadAliasData();
            int count = 0;
            while (true) {
                if (count++ > 10) {
                    throw new IllegalArgumentException("Have problem to resolve locale alias of " + ULocale.access$000(this.language, this.script, this.region, this.variants == null ? "" : Utility.joinStrings("_", this.variants)) + this.extensions);
                }
                if (!(this.replaceLanguage(true, true, true) || this.replaceLanguage(true, true, false) || this.replaceLanguage(true, false, true) || this.replaceLanguage(true, false, false) || this.replaceLanguage(false, false, true))) {
                    Object object;
                    boolean bl;
                    AliasReplacer aliasReplacer = this;
                    if (aliasReplacer.region == null || aliasReplacer.region.isEmpty()) {
                        bl = false;
                    } else {
                        object = territoryAliasMap.get(aliasReplacer.region);
                        if (object == null) {
                            bl = false;
                        } else {
                            String string;
                            object = object.size() > 1 ? (object.contains(string = ULocale.addLikelySubtags(new ULocale(aliasReplacer.language, aliasReplacer.script, null)).getCountry()) ? string : (String)object.get(0)) : object.get(0);
                            assert (!aliasReplacer.region.equals(object));
                            aliasReplacer.region = object;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        boolean bl2;
                        aliasReplacer = this;
                        if (aliasReplacer.script == null || aliasReplacer.script.isEmpty()) {
                            bl2 = false;
                        } else {
                            object = scriptAliasMap.get(aliasReplacer.script);
                            if (object == null) {
                                bl2 = false;
                            } else {
                                assert (!aliasReplacer.script.equals(object));
                                aliasReplacer.script = object;
                                bl2 = true;
                            }
                        }
                        if (!bl2 && !this.replaceVariant()) break;
                    }
                }
                changed = true;
            }
            if (this.extensions == null && !changed) {
                return null;
            }
            String result = ULocale.access$000(this.language, this.script, this.region, this.variants == null ? "" : Utility.joinStrings("_", this.variants));
            if (this.extensions != null) {
                void var3_5;
                boolean keywordChanged = false;
                ULocale temp = new ULocale(result + this.extensions);
                Iterator<String> keywords = temp.getKeywords();
                while (keywords != null && keywords.hasNext()) {
                    String key = keywords.next();
                    if (!key.equals("rg") && !key.equals("sd") && !key.equals("t")) continue;
                    String value = temp.getKeywordValue(key);
                    String replacement = key.equals("t") ? AliasReplacer.replaceTransformedExtensions(value) : subdivisionAliasMap.get(value);
                    if (replacement == null) continue;
                    temp = temp.setKeywordValue(key, replacement);
                    keywordChanged = true;
                }
                if (var3_5 != false) {
                    this.extensions = temp.getName().substring(temp.getBaseName().length());
                    changed = true;
                }
                result = result + this.extensions;
            }
            if (var1_1 != false) {
                void var2_3;
                return var2_3;
            }
            return null;
        }

        private static synchronized void loadAliasData() {
            String aliasTo;
            String aliasFrom;
            UResourceBundle res;
            int i;
            if (aliasDataIsLoaded) {
                return;
            }
            languageAliasMap = new HashMap<String, String>();
            scriptAliasMap = new HashMap<String, String>();
            territoryAliasMap = new HashMap<String, List<String>>();
            variantAliasMap = new HashMap<String, String>();
            subdivisionAliasMap = new HashMap<String, String>();
            UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b", "metadata", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle metadataAlias = uResourceBundle.get("alias");
            UResourceBundle languageAlias = metadataAlias.get("language");
            UResourceBundle scriptAlias = metadataAlias.get("script");
            UResourceBundle territoryAlias = metadataAlias.get("territory");
            UResourceBundle variantAlias = metadataAlias.get("variant");
            UResourceBundle subdivisionAlias = metadataAlias.get("subdivision");
            for (i = 0; i < languageAlias.getSize(); ++i) {
                res = languageAlias.get(i);
                aliasFrom = res.getKey();
                aliasTo = res.get("replacement").getString();
                Locale testLocale = new Locale(aliasFrom);
                if (!testLocale.getScript().isEmpty() || aliasFrom.startsWith("und") && !testLocale.getCountry().isEmpty()) {
                    throw new IllegalArgumentException("key [" + aliasFrom + "] in alias:language contains unsupported fields combination.");
                }
                languageAliasMap.put(aliasFrom, aliasTo);
            }
            for (i = 0; i < scriptAlias.getSize(); ++i) {
                res = scriptAlias.get(i);
                aliasFrom = res.getKey();
                aliasTo = res.get("replacement").getString();
                if (aliasFrom.length() != 4) {
                    throw new IllegalArgumentException("Incorrect key [" + aliasFrom + "] in alias:script.");
                }
                scriptAliasMap.put(aliasFrom, aliasTo);
            }
            for (i = 0; i < territoryAlias.getSize(); ++i) {
                res = territoryAlias.get(i);
                aliasFrom = res.getKey();
                aliasTo = res.get("replacement").getString();
                if (aliasFrom.length() < 2 || aliasFrom.length() > 3) {
                    throw new IllegalArgumentException("Incorrect key [" + aliasFrom + "] in alias:territory.");
                }
                territoryAliasMap.put(aliasFrom, new ArrayList<String>(Arrays.asList(aliasTo.split(" "))));
            }
            for (i = 0; i < variantAlias.getSize(); ++i) {
                res = variantAlias.get(i);
                aliasFrom = res.getKey();
                aliasTo = res.get("replacement").getString();
                if (aliasFrom.length() < 4 || aliasFrom.length() > 8 || aliasFrom.length() == 4 && (aliasFrom.charAt(0) < '0' || aliasFrom.charAt(0) > '9')) {
                    throw new IllegalArgumentException("Incorrect key [" + aliasFrom + "] in alias:variant.");
                }
                if (aliasTo.length() < 4 || aliasTo.length() > 8 || aliasTo.length() == 4 && (aliasTo.charAt(0) < '0' || aliasTo.charAt(0) > '9')) {
                    throw new IllegalArgumentException("Incorrect variant [" + aliasTo + "] for the key [" + aliasFrom + "] in alias:variant.");
                }
                variantAliasMap.put(aliasFrom, aliasTo);
            }
            for (i = 0; i < subdivisionAlias.getSize(); ++i) {
                res = subdivisionAlias.get(i);
                aliasFrom = res.getKey();
                aliasTo = res.get("replacement").getString().split(" ")[0];
                if (aliasFrom.length() < 3 || aliasFrom.length() > 8) {
                    throw new IllegalArgumentException("Incorrect key [" + aliasFrom + "] in alias:territory.");
                }
                if (aliasTo.length() == 2) {
                    aliasTo = aliasTo + "zzzz";
                } else if (aliasTo.length() < 2 || aliasTo.length() > 8) {
                    throw new IllegalArgumentException("Incorrect value [" + aliasTo + "] in alias:territory.");
                }
                subdivisionAliasMap.put(aliasFrom, aliasTo);
            }
            aliasDataIsLoaded = true;
        }

        /*
         * WARNING - void declaration
         */
        private static String deleteOrReplace(String input, String type, String replacement) {
            void var1_1;
            if (replacement != null && !replacement.isEmpty()) {
                if (input == null || input.isEmpty()) {
                    void var2_2;
                    return var2_2;
                }
                return input;
            }
            if (type == null || var1_1.isEmpty()) {
                String string;
                return string;
            }
            return null;
        }

        private boolean replaceLanguage(boolean checkLanguage, boolean checkRegion, boolean checkVariants) {
            if (checkRegion && (this.region == null || this.region.isEmpty()) || checkVariants && this.variants == null) {
                return false;
            }
            int variantSize = checkVariants ? this.variants.size() : 1;
            String searchLanguage = checkLanguage ? this.language : "und";
            String searchRegion = checkRegion ? this.region : null;
            String searchVariant = null;
            for (int variantIndex = 0; variantIndex < variantSize; ++variantIndex) {
                String replacedLanguage;
                String typeKey;
                String replacement;
                if (checkVariants) {
                    searchVariant = this.variants.get(variantIndex);
                }
                if (searchVariant != null && searchVariant.length() < 4) {
                    searchVariant = null;
                }
                String string = searchVariant;
                String string2 = searchRegion;
                String string3 = searchLanguage;
                assert (string == null || string.length() >= 4);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string3);
                if (string2 != null && !string2.isEmpty()) {
                    stringBuilder.append('_');
                    stringBuilder.append(string2);
                }
                if (string != null && !string.isEmpty()) {
                    stringBuilder.append('_');
                    stringBuilder.append(string);
                }
                if ((replacement = languageAliasMap.get(typeKey = stringBuilder.toString())) == null) continue;
                String replacedScript = null;
                String replacedRegion = null;
                String replacedVariant = null;
                String replacedExtensions = null;
                if (replacement.indexOf(95) < 0) {
                    replacedLanguage = replacement.equals("und") ? this.language : replacement;
                } else {
                    String[] replacementFields = replacement.split("_");
                    replacedLanguage = replacementFields[0];
                    int index = 1;
                    if (replacedLanguage.equals("und")) {
                        replacedLanguage = this.language;
                    }
                    int consumed = replacementFields[0].length() + 1;
                    while (replacementFields.length > index) {
                        String field = replacementFields[index];
                        int len = field.length();
                        if (1 == len) {
                            replacedExtensions = replacement.substring(consumed);
                            break;
                        }
                        if (len >= 2 && len <= 3) {
                            assert (replacedRegion == null);
                            replacedRegion = field;
                        } else if (len >= 5 && len <= 8) {
                            assert (replacedVariant == null);
                            replacedVariant = field;
                        } else if (len == 4) {
                            if (field.charAt(0) >= '0' && field.charAt(0) <= '9') {
                                assert (replacedVariant == null);
                                replacedVariant = field;
                            } else {
                                assert (replacedScript == null);
                                replacedScript = field;
                            }
                        }
                        ++index;
                        consumed += len + 1;
                    }
                }
                replacedScript = AliasReplacer.deleteOrReplace(this.script, null, replacedScript);
                replacedRegion = AliasReplacer.deleteOrReplace(this.region, searchRegion, replacedRegion);
                String string4 = searchVariant;
                replacedVariant = AliasReplacer.deleteOrReplace(string4, string4, replacedVariant);
                if (this.language.equals(replacedLanguage) && this.script.equals(replacedScript) && this.region.equals(replacedRegion) && Objects.equals(searchVariant, replacedVariant) && replacedExtensions == null) continue;
                this.language = replacedLanguage;
                this.script = replacedScript;
                this.region = replacedRegion;
                if (searchVariant != null && !searchVariant.isEmpty()) {
                    if (replacedVariant != null && !replacedVariant.isEmpty()) {
                        this.variants.set(variantIndex, replacedVariant);
                    } else {
                        this.variants.remove(variantIndex);
                        if (this.variants.isEmpty()) {
                            this.variants = null;
                        }
                    }
                }
                if (replacedExtensions != null) {
                    replacedExtensions.isEmpty();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean replaceVariant() {
            if (this.variants == null) {
                return false;
            }
            for (int i = 0; i < this.variants.size(); ++i) {
                void var2_2;
                void var3_3;
                String variant = this.variants.get(i);
                String replacement = variantAliasMap.get(variant);
                if (replacement == null) continue;
                assert (replacement.length() >= 4);
                assert (replacement.length() <= 8);
                assert (replacement.length() != 4 || replacement.charAt(0) >= '0' && replacement.charAt(0) <= '9');
                if (variant.equals(replacement)) continue;
                this.variants.set(i, (String)var3_3);
                if (var2_2.equals("heploc")) {
                    this.variants.remove("hepburn");
                    if (this.variants.isEmpty()) {
                        this.variants = null;
                    }
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static String replaceTransformedExtensions(String extensions) {
            void var1_1;
            Object object;
            StringBuilder builder = new StringBuilder();
            ArrayList<String> subtags = new ArrayList<String>(Arrays.asList(extensions.split("-")));
            ArrayList<String> tfields = new ArrayList<String>();
            int processedLength = 0;
            int tlangLength = 0;
            String tkey = "";
            object = object.iterator();
            while (object.hasNext()) {
                String subtag = (String)object.next();
                if (LanguageTag.isTKey(subtag)) {
                    if (tlangLength == 0) {
                        tlangLength = processedLength - 1;
                    }
                    if (builder.length() > 0) {
                        tfields.add(builder.toString());
                        builder.setLength(0);
                    }
                    tkey = subtag;
                    builder.append(subtag);
                } else if (tlangLength != 0) {
                    builder.append("-").append(ULocale.toUnicodeLocaleType(tkey, subtag));
                }
                processedLength += subtag.length() + 1;
            }
            if (builder.length() > 0) {
                tfields.add(builder.toString());
                builder.setLength(0);
            }
            if (((String)(tlangLength > 0 ? extensions.substring(0, tlangLength) : (object = tfields.size() == 0 ? extensions : ""))).length() > 0) {
                String string;
                String canonicalized = ULocale.createCanonical(ULocale.forLanguageTag(string)).toLanguageTag();
                builder.append(AsciiUtil.toLowerString(canonicalized));
            }
            if (tfields.size() > 0) {
                void var3_3;
                if (builder.length() > 0) {
                    builder.append("-");
                }
                Collections.sort(tfields);
                builder.append(Utility.joinStrings("-", (Iterable<? extends CharSequence>)var3_3));
            }
            return var1_1.toString();
        }
    }

    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category DISPLAY = new Category();
        public static final /* enum */ Category FORMAT = new Category();
        private static final /* synthetic */ Category[] $VALUES;

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        static {
            $VALUES = new Category[]{DISPLAY, FORMAT};
        }
    }
}

