/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import java.util.concurrent.ConcurrentHashMap;

public final class VersionInfo
implements Comparable<VersionInfo> {
    private static VersionInfo UNICODE_15_0;
    private static VersionInfo ICU_VERSION;
    private int m_version_;
    private static final ConcurrentHashMap<Integer, VersionInfo> MAP_;
    private static volatile String TZDATA_VERSION;

    /*
     * WARNING - void declaration
     */
    public static VersionInfo getInstance(String version) {
        void var2_2;
        void var1_1;
        int index;
        int length = version.length();
        int[] array = new int[]{0, 0, 0, 0};
        int count = 0;
        for (index = 0; count < 4 && index < length; ++index) {
            char c = version.charAt(index);
            if (c == '.') {
                ++count;
                continue;
            }
            if ((c = (char)(c - 48)) < '\u0000' || c > '\t') {
                throw new IllegalArgumentException("Invalid version number: Version number may be negative or greater than 255");
            }
            int n = count;
            array[n] = array[n] * 10;
            int n2 = count;
            array[n2] = array[n2] + c;
        }
        if (index != var1_1) {
            String string;
            throw new IllegalArgumentException("Invalid version number: String '" + string + "' exceeds version format");
        }
        for (int i = 0; i < 4; ++i) {
            if (array[i] >= 0 && array[i] <= 255) continue;
            throw new IllegalArgumentException("Invalid version number: Version number may be negative or greater than 255");
        }
        return VersionInfo.getInstance(array[0], array[1], array[2], (int)var2_2[3]);
    }

    /*
     * WARNING - void declaration
     */
    public static VersionInfo getInstance(int major, int minor, int milli, int micro) {
        void var2_5;
        void var1_3;
        VersionInfo tmpvi;
        void var3_6;
        if (major < 0 || major > 255 || minor < 0 || minor > 255 || milli < 0 || milli > 255 || micro < 0 || micro > 255) {
            throw new IllegalArgumentException("Invalid version number: Version number may be negative or greater than 255");
        }
        int version = VersionInfo.getInt(major, minor, milli, (int)var3_6);
        Integer key = version;
        VersionInfo result = MAP_.get(key);
        if (result == null && (tmpvi = MAP_.putIfAbsent((Integer)var1_3, result = new VersionInfo(version))) != null) {
            void var0_1;
            result = var0_1;
        }
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder result = new StringBuilder(7);
        VersionInfo versionInfo = this;
        result.append(versionInfo.m_version_ >>> 24);
        result.append('.');
        versionInfo = this;
        result.append(versionInfo.m_version_ >> 16 & 0xFF);
        result.append('.');
        versionInfo = this;
        result.append(versionInfo.m_version_ >> 8 & 0xFF);
        result.append('.');
        versionInfo = this;
        result.append(versionInfo.m_version_ & 0xFF);
        return var1_1.toString();
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return this.m_version_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(VersionInfo other) {
        void var1_1;
        int diff = (this.m_version_ >>> 1) - (other.m_version_ >>> 1);
        if (diff != 0) {
            void var2_2;
            return (int)var2_2;
        }
        return (this.m_version_ & 1) - (var1_1.m_version_ & 1);
    }

    /*
     * WARNING - void declaration
     */
    private VersionInfo(int compactversion) {
        void var1_1;
        this.m_version_ = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getInt(int major, int minor, int milli, int micro) {
        void var3_3;
        void var2_2;
        void var1_1;
        return major << 24 | var1_1 << 16 | var2_2 << 8 | var3_3;
    }

    static {
        MAP_ = new ConcurrentHashMap();
        VersionInfo.getInstance(1, 0, 0, 0);
        VersionInfo.getInstance(1, 0, 1, 0);
        VersionInfo.getInstance(1, 1, 0, 0);
        VersionInfo.getInstance(1, 1, 5, 0);
        VersionInfo.getInstance(2, 0, 0, 0);
        VersionInfo.getInstance(2, 1, 2, 0);
        VersionInfo.getInstance(2, 1, 5, 0);
        VersionInfo.getInstance(2, 1, 8, 0);
        VersionInfo.getInstance(2, 1, 9, 0);
        VersionInfo.getInstance(3, 0, 0, 0);
        VersionInfo.getInstance(3, 0, 1, 0);
        VersionInfo.getInstance(3, 1, 0, 0);
        VersionInfo.getInstance(3, 1, 1, 0);
        VersionInfo.getInstance(3, 2, 0, 0);
        VersionInfo.getInstance(4, 0, 0, 0);
        VersionInfo.getInstance(4, 0, 1, 0);
        VersionInfo.getInstance(4, 1, 0, 0);
        VersionInfo.getInstance(5, 0, 0, 0);
        VersionInfo.getInstance(5, 1, 0, 0);
        VersionInfo.getInstance(5, 2, 0, 0);
        VersionInfo.getInstance(6, 0, 0, 0);
        VersionInfo.getInstance(6, 1, 0, 0);
        VersionInfo.getInstance(6, 2, 0, 0);
        VersionInfo.getInstance(6, 3, 0, 0);
        VersionInfo.getInstance(7, 0, 0, 0);
        VersionInfo.getInstance(8, 0, 0, 0);
        VersionInfo.getInstance(9, 0, 0, 0);
        VersionInfo.getInstance(10, 0, 0, 0);
        VersionInfo.getInstance(11, 0, 0, 0);
        VersionInfo.getInstance(12, 0, 0, 0);
        VersionInfo.getInstance(12, 1, 0, 0);
        VersionInfo.getInstance(13, 0, 0, 0);
        VersionInfo.getInstance(14, 0, 0, 0);
        UNICODE_15_0 = VersionInfo.getInstance(15, 0, 0, 0);
        ICU_VERSION = VersionInfo.getInstance(73, 1, 0, 0);
        int n = 9;
        VersionInfo.getInstance(9, 0, 0, 0);
        n = 9;
        VersionInfo.getInstance(9, 0, 0, 0);
        n = 1;
        VersionInfo.getInstance(1, 0, 0, 0);
        TZDATA_VERSION = null;
    }
}

