/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import io.github.g00fy2.versioncompare.VersionComparator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Version
implements Comparable<Version> {
    @Nullable
    private final String originalString;
    @Nonnull
    private final List<Integer> subversionNumbers = new ArrayList<Integer>();
    @Nonnull
    private final List<Integer> subversionNumbersWithoutTrailingZeros = new ArrayList<Integer>();
    @Nonnull
    private String suffix = "";

    /*
     * WARNING - void declaration
     */
    public Version(@Nullable String versionString) {
        this((String)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Version(@Nullable String versionString, boolean throwExceptions) {
        void var1_1;
        this.originalString = var1_1;
        this.initVersion();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEqual(Version otherVersion) {
        void var1_1;
        return VersionComparator.compareSubversionNumbers(this.subversionNumbersWithoutTrailingZeros, otherVersion.subversionNumbersWithoutTrailingZeros) == 0 && VersionComparator.compareSuffix(this.suffix, var1_1.suffix) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtLeast(Version otherVersion, boolean ignoreSuffix) {
        void var2_2;
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbersWithoutTrailingZeros, otherVersion.subversionNumbersWithoutTrailingZeros);
        if (subversionsResult == 0) {
            void var1_1;
            return VersionComparator.compareSuffix(this.suffix, var1_1.suffix) >= 0;
        }
        return var2_2 >= 0;
    }

    /*
     * Unable to fully structure code
     */
    private void initVersion() {
        if (this.originalString != null) {
            var7_1 = this.originalString;
            if ((var7_1 = var7_1.trim()).length() > 0 && Character.isDigit(var7_1.charAt(0)) != false) {
                versionTokens = this.originalString.replaceAll("\\s", "").split("\\.");
                suffixFound = false;
                suffixSb = null;
                block0: for (void versionToken : var1_3) {
                    if (suffixFound) {
                        suffixSb.append(".");
                        suffixSb.append((String)versionToken);
                        continue;
                    }
                    var7_1 = versionToken;
                    var8_9 = var7_1.length();
                    if (var8_9 > 0) {
                        for (var9_10 = 0; var9_10 < var8_9; ++var9_10) {
                            if (Character.isDigit(var7_1.charAt(var9_10))) {
                                continue;
                            }
                            ** break block14
                        }
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (v0) {
                        this.subversionNumbers.add(VersionComparator.safeParseInt((String)versionToken));
                        continue;
                    }
                    for (i = 0; i < versionToken.length(); ++i) {
                        if (Character.isDigit(versionToken.charAt(i))) continue;
                        suffixSb = new StringBuilder();
                        if (i > 0) {
                            this.subversionNumbers.add(VersionComparator.safeParseInt(versionToken.substring(0, i)));
                            suffixSb.append(versionToken.substring(i));
                        } else {
                            suffixSb.append((String)versionToken);
                        }
                        suffixFound = true;
                        continue block0;
                    }
                }
                this.subversionNumbersWithoutTrailingZeros.addAll(this.subversionNumbers);
                while (!this.subversionNumbersWithoutTrailingZeros.isEmpty() && this.subversionNumbersWithoutTrailingZeros.lastIndexOf(0) == this.subversionNumbersWithoutTrailingZeros.size() - 1) {
                    this.subversionNumbersWithoutTrailingZeros.remove(this.subversionNumbersWithoutTrailingZeros.lastIndexOf(0));
                }
                if (suffixSb != null) {
                    this.suffix = var3_5.toString();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (o instanceof Version && this.isEqual((Version)o)) {
            return true;
        }
        return super.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        void var1_1;
        void var2_2;
        int hash = 31 + this.subversionNumbersWithoutTrailingZeros.hashCode();
        if (this.suffix.isEmpty()) {
            return hash;
        }
        int releaseQualifier = VersionComparator.qualifierToNumber(this.suffix);
        int releaseQualifierVersion = VersionComparator.preReleaseVersion(this.suffix, releaseQualifier);
        hash = hash * 31 + var2_2;
        var1_1 = var1_1 * 31 + var3_3;
        return (int)var1_1;
    }
}

