/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import java.util.List;
import javax.annotation.Nonnull;

final class VersionComparator {
    static int compareSubversionNumbers(@Nonnull List<Integer> subversionsA, @Nonnull List<Integer> subversionsB) {
        int versASize = subversionsA.size();
        int versBSize = subversionsB.size();
        int maxSize = Math.max(versASize, versBSize);
        for (int i = 0; i < maxSize; ++i) {
            if ((i < versASize ? subversionsA.get(i) : 0) > (i < versBSize ? subversionsB.get(i) : 0)) {
                return 1;
            }
            if ((i < versASize ? subversionsA.get(i) : 0) >= (i < versBSize ? subversionsB.get(i) : 0)) continue;
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    static int compareSuffix(@Nonnull String suffixA, @Nonnull String suffixB) {
        if (suffixA.length() > 0 || suffixB.length() > 0) {
            int qualifierB;
            int qualifierA = VersionComparator.qualifierToNumber(suffixA);
            if (qualifierA > (qualifierB = VersionComparator.qualifierToNumber(suffixB))) {
                return 1;
            }
            if (qualifierA < qualifierB) {
                return -1;
            }
            if (qualifierA != 5 && qualifierA != 0) {
                void var1_3;
                void var0_1;
                void var3_5;
                int suffixVersionB;
                void var2_4;
                int suffixVersionA = VersionComparator.preReleaseVersion(suffixA, (int)var2_4);
                if (suffixVersionA > (suffixVersionB = VersionComparator.preReleaseVersion(suffixB, (int)var3_5))) {
                    return 1;
                }
                if (var0_1 < var1_3) {
                    return -1;
                }
            }
        }
        return 0;
    }

    static int qualifierToNumber(@Nonnull String suffix) {
        if (suffix.length() > 0) {
            String string;
            if ((suffix = suffix.toLowerCase()).contains("rc")) {
                return 4;
            }
            if (suffix.contains("beta")) {
                return 3;
            }
            if (suffix.contains("alpha")) {
                if (suffix.substring(0, suffix.indexOf("alpha")).contains("pre")) {
                    return 1;
                }
                return 2;
            }
            if (string.contains("snapshot")) {
                return 0;
            }
        }
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    static int preReleaseVersion(@Nonnull String suffix, int qualifier) {
        int maxStartIndex;
        int startIndex = VersionComparator.indexOfQualifier(suffix, qualifier);
        if (startIndex < suffix.length() && VersionComparator.containsNumeric(suffix.substring(startIndex, maxStartIndex = Math.min(startIndex + 2, suffix.length())))) {
            void var2_3;
            StringBuilder versionNumber = new StringBuilder();
            for (int i = startIndex; i < suffix.length(); ++i) {
                char c = suffix.charAt(i);
                if (Character.isDigit(c)) {
                    versionNumber.append(c);
                    continue;
                }
                if (i != startIndex) break;
            }
            return VersionComparator.safeParseInt(var2_3.toString());
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfQualifier(@Nonnull String suffix, int qualifier) {
        void var1_1;
        if (qualifier == 4) {
            return suffix.indexOf("rc") + 2;
        }
        if (qualifier == 3) {
            return suffix.indexOf("beta") + 4;
        }
        if (qualifier == 2 || var1_1 == true) {
            String string;
            return string.indexOf("alpha") + 5;
        }
        return 0;
    }

    static int safeParseInt(@Nonnull String numbers) {
        String string;
        if (numbers.length() > 9) {
            numbers = numbers.substring(0, 9);
        }
        return Integer.parseInt(string);
    }

    private static boolean containsNumeric(@Nonnull CharSequence cs) {
        int sz = cs.length();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                if (!Character.isDigit(cs.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

