/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._UtilKt;
import okio.internal._BufferKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u0090\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u0000J$\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\f2\b\b\u0002\u0010\u001b\u001a\u00020\fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\fJ \u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fH\u0087\u0002\u00a2\u0006\u0002\b+J\u0015\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\fH\u0007\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001dH\u0002J\u000e\u00102\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001dJ\u000e\u00103\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001dJ\u000e\u00104\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001dJ\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020)H\u0016J\u0018\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\fH\u0016J \u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\f2\u0006\u00109\u001a\u00020\u001dH\u0016J\u0018\u00105\u001a\u00020\f2\u0006\u00109\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\fH\u0016J\u0010\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\u001dH\u0016J\u0018\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\fH\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020#H\u0016J\u0006\u0010?\u001a\u00020\u001dJ\b\u0010@\u001a\u00020\u0019H\u0016J\b\u0010A\u001a\u00020\u0001H\u0016J\u0018\u0010B\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u00109\u001a\u00020\u001dH\u0016J(\u0010B\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u00109\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020/H\u0016J\u0010\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020GH\u0016J \u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020G2\u0006\u0010\u001a\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020/H\u0016J\u0018\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010H\u001a\u00020\f2\u0006\u0010E\u001a\u00020IH\u0016J\u0012\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020KH\u0007J\b\u0010M\u001a\u00020)H\u0016J\b\u0010N\u001a\u00020GH\u0016J\u0010\u0010N\u001a\u00020G2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010O\u001a\u00020\u001dH\u0016J\u0010\u0010O\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010P\u001a\u00020\fH\u0016J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020=J\u0016\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020=2\u0006\u0010\u001b\u001a\u00020\fJ \u0010Q\u001a\u00020\u00122\u0006\u0010R\u001a\u00020=2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010S\u001a\u00020#H\u0002J\u0010\u0010T\u001a\u00020\u00122\u0006\u0010E\u001a\u00020GH\u0016J\u0018\u0010T\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010U\u001a\u00020\fH\u0016J\b\u0010V\u001a\u00020/H\u0016J\b\u0010W\u001a\u00020/H\u0016J\b\u0010X\u001a\u00020\fH\u0016J\b\u0010Y\u001a\u00020\fH\u0016J\b\u0010Z\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020[H\u0016J\u0010\u0010]\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020_H\u0016J\u0018\u0010]\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010^\u001a\u00020_H\u0016J\u0012\u0010`\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020KH\u0007J\b\u0010a\u001a\u00020\u001fH\u0016J\u0010\u0010a\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010b\u001a\u00020/H\u0016J\n\u0010c\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010d\u001a\u00020\u001fH\u0016J\u0010\u0010d\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020\fH\u0016J\u0010\u0010f\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010g\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010h\u001a\u00020/2\u0006\u0010i\u001a\u00020jH\u0016J\u0006\u0010k\u001a\u00020\u001dJ\u0006\u0010l\u001a\u00020\u001dJ\u0006\u0010m\u001a\u00020\u001dJ\r\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0002\bnJ\u0010\u0010o\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0006\u0010p\u001a\u00020\u001dJ\u000e\u0010p\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020/J\b\u0010q\u001a\u00020rH\u0016J\b\u0010s\u001a\u00020\u001fH\u0016J\u0015\u0010t\u001a\u00020\n2\u0006\u0010u\u001a\u00020/H\u0000\u00a2\u0006\u0002\bvJ\u0010\u0010w\u001a\u00020/2\u0006\u0010x\u001a\u00020FH\u0016J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010x\u001a\u00020GH\u0016J \u0010w\u001a\u00020\u00002\u0006\u0010x\u001a\u00020G2\u0006\u0010\u001a\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020/H\u0016J\u0018\u0010w\u001a\u00020\u00122\u0006\u0010x\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010w\u001a\u00020\u00002\u0006\u0010y\u001a\u00020\u001dH\u0016J \u0010w\u001a\u00020\u00002\u0006\u0010y\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020/H\u0016J\u0018\u0010w\u001a\u00020\u00002\u0006\u0010x\u001a\u00020z2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010{\u001a\u00020\f2\u0006\u0010x\u001a\u00020zH\u0016J\u0010\u0010|\u001a\u00020\u00002\u0006\u00106\u001a\u00020/H\u0016J\u0010\u0010}\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\fH\u0016J\u0010\u0010\u007f\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\fH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020\u00002\u0007\u0010\u0081\u0001\u001a\u00020/H\u0016J\u0012\u0010\u0082\u0001\u001a\u00020\u00002\u0007\u0010\u0081\u0001\u001a\u00020/H\u0016J\u0011\u0010\u0083\u0001\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\fH\u0016J\u0011\u0010\u0084\u0001\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\fH\u0016J\u0012\u0010\u0085\u0001\u001a\u00020\u00002\u0007\u0010\u0086\u0001\u001a\u00020/H\u0016J\u0012\u0010\u0087\u0001\u001a\u00020\u00002\u0007\u0010\u0086\u0001\u001a\u00020/H\u0016J\u001a\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020_H\u0016J,\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u001f2\u0007\u0010\u008a\u0001\u001a\u00020/2\u0007\u0010\u008b\u0001\u001a\u00020/2\u0006\u0010^\u001a\u00020_H\u0016J\u001b\u0010\u008c\u0001\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\fH\u0007J\u0012\u0010\u008d\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u001fH\u0016J$\u0010\u008d\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u001f2\u0007\u0010\u008a\u0001\u001a\u00020/2\u0007\u0010\u008b\u0001\u001a\u00020/H\u0016J\u0012\u0010\u008e\u0001\u001a\u00020\u00002\u0007\u0010\u008f\u0001\u001a\u00020/H\u0016R\u0014\u0010\u0006\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0091\u0001"}, d2={"Lokio/Buffer;", "Lokio/BufferedSource;", "Lokio/BufferedSink;", "", "Ljava/nio/channels/ByteChannel;", "()V", "buffer", "getBuffer", "()Lokio/Buffer;", "head", "Lokio/Segment;", "<set-?>", "", "size", "()J", "setSize$okio", "(J)V", "clear", "", "clone", "close", "completeSegmentByteCount", "copy", "copyTo", "out", "Ljava/io/OutputStream;", "offset", "byteCount", "digest", "Lokio/ByteString;", "algorithm", "", "emit", "emitCompleteSegments", "equals", "", "other", "", "exhausted", "flush", "get", "", "pos", "getByte", "index", "-deprecated_getByte", "hashCode", "", "hmac", "key", "hmacSha1", "hmacSha256", "hmacSha512", "indexOf", "b", "fromIndex", "toIndex", "bytes", "indexOfElement", "targetBytes", "inputStream", "Ljava/io/InputStream;", "isOpen", "md5", "outputStream", "peek", "rangeEquals", "bytesOffset", "read", "sink", "Ljava/nio/ByteBuffer;", "", "readAll", "Lokio/Sink;", "readAndWriteUnsafe", "Lokio/Buffer$UnsafeCursor;", "unsafeCursor", "readByte", "readByteArray", "readByteString", "readDecimalLong", "readFrom", "input", "forever", "readFully", "readHexadecimalUnsignedLong", "readInt", "readIntLe", "readLong", "readLongLe", "readShort", "", "readShortLe", "readString", "charset", "Ljava/nio/charset/Charset;", "readUnsafe", "readUtf8", "readUtf8CodePoint", "readUtf8Line", "readUtf8LineStrict", "limit", "request", "require", "select", "options", "Lokio/Options;", "sha1", "sha256", "sha512", "-deprecated_size", "skip", "snapshot", "timeout", "Lokio/Timeout;", "toString", "writableSegment", "minimumCapacity", "writableSegment$okio", "write", "source", "byteString", "Lokio/Source;", "writeAll", "writeByte", "writeDecimalLong", "v", "writeHexadecimalUnsignedLong", "writeInt", "i", "writeIntLe", "writeLong", "writeLongLe", "writeShort", "s", "writeShortLe", "writeString", "string", "beginIndex", "endIndex", "writeTo", "writeUtf8", "writeUtf8CodePoint", "codePoint", "UnsafeCursor", "okio"})
public final class Buffer
implements Cloneable,
ByteChannel,
BufferedSink,
BufferedSource {
    @JvmField
    public Segment head;
    private long size;

    @JvmName(name="size")
    public final long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSize$okio(long l) {
        void var1_1;
        this.size = var1_1;
    }

    @Override
    public final Buffer getBuffer() {
        return this;
    }

    @Override
    public final OutputStream outputStream() {
        return new OutputStream(this){
            private /* synthetic */ Buffer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void write(int b) {
                void var1_1;
                this.this$0.writeByte((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void write(byte[] data, int offset, int byteCount) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.this$0.write((byte[])var1_1, (int)var2_2, (int)var3_3);
            }

            public final void flush() {
            }

            public final void close() {
            }

            public final String toString() {
                return this.this$0 + ".outputStream()";
            }
        };
    }

    @Override
    public final boolean exhausted() {
        return this.size == 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void require(long byteCount) throws EOFException {
        void var1_1;
        if (this.size < var1_1) {
            throw new EOFException();
        }
    }

    @Override
    public final InputStream inputStream() {
        return new InputStream(this){
            private /* synthetic */ Buffer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final int read() {
                if (this.this$0.size() > 0L) {
                    byte by = this.this$0.readByte();
                    return by & 0xFF;
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            public final int read(byte[] sink2, int offset, int byteCount) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                return this.this$0.read((byte[])var1_1, (int)var2_2, (int)var3_3);
            }

            public final int available() {
                long l = this.this$0.size();
                return (int)Math.min(l, Integer.MAX_VALUE);
            }

            public final void close() {
            }

            public final String toString() {
                return this.this$0 + ".inputStream()";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Buffer copyTo(Buffer out, long offset2, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Buffer $this$commonCopyTo$iv = this;
        long offset$iv = offset2;
        long byteCount$iv = byteCount;
        Buffer offset2 = $this$commonCopyTo$iv;
        _UtilKt.checkOffsetAndCount(offset2.size, offset$iv, byteCount$iv);
        if (byteCount$iv != 0L) {
            Buffer buffer = out;
            offset2 = buffer;
            long l = buffer.size + byteCount$iv;
            offset2 = buffer;
            buffer.size = l;
            Segment s$iv = $this$commonCopyTo$iv.head;
            while (true) {
                Segment segment = s$iv;
                Intrinsics.checkNotNull((Object)segment);
                if (offset$iv < (long)(segment.limit - s$iv.pos)) break;
                offset$iv -= (long)(s$iv.limit - s$iv.pos);
                s$iv = s$iv.next;
            }
            while (byteCount$iv > 0L) {
                void var3_9;
                Segment segment = s$iv;
                Intrinsics.checkNotNull((Object)segment);
                Segment copy$iv = segment.sharedCopy();
                segment.sharedCopy().pos = copy$iv.pos + (int)offset$iv;
                copy$iv.limit = Math.min(copy$iv.pos + (int)byteCount$iv, copy$iv.limit);
                if (out.head == null) {
                    out.head = copy$iv.next = (copy$iv.prev = copy$iv);
                } else {
                    Segment segment2 = out.head;
                    Intrinsics.checkNotNull((Object)segment2);
                    Segment segment3 = segment2.prev;
                    Intrinsics.checkNotNull((Object)segment3);
                    segment3.push(copy$iv);
                }
                byteCount$iv -= (long)(copy$iv.limit - var3_9.pos);
                offset$iv = 0L;
                s$iv = s$iv.next;
            }
        }
        return $this$commonCopyTo$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final long completeSegmentByteCount() {
        void var2_3;
        Buffer $this$commonCompleteSegmentByteCount$iv;
        Buffer buffer = $this$commonCompleteSegmentByteCount$iv = this;
        long result$iv = $this$commonCompleteSegmentByteCount$iv.size;
        if (result$iv == 0L) {
            return 0L;
        }
        Segment segment = $this$commonCompleteSegmentByteCount$iv.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment.prev;
        Intrinsics.checkNotNull((Object)segment2);
        Segment tail$iv = segment2;
        if (segment2.limit < 8192 && tail$iv.owner) {
            void var1_1;
            result$iv -= (long)(tail$iv.limit - var1_1.pos);
        }
        return (long)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte readByte() throws EOFException {
        Buffer $this$commonReadByte$iv;
        Buffer buffer = $this$commonReadByte$iv = this;
        if ($this$commonReadByte$iv.size == 0L) {
            throw new EOFException();
        }
        Segment segment = $this$commonReadByte$iv.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment$iv = segment;
        int pos$iv = segment.pos;
        int limit$iv = segment$iv.limit;
        byte[] byArray = segment$iv.data;
        byte b$iv = segment$iv.data[pos$iv++];
        Buffer buffer2 = $this$commonReadByte$iv;
        buffer = buffer2;
        long l = buffer2.size - 1L;
        buffer = buffer2;
        buffer2.size = l;
        if (pos$iv == limit$iv) {
            var1_1.head = segment$iv.pop();
            SegmentPool.recycle(segment$iv);
        } else {
            void var3_4;
            var2_3.pos = var3_4;
        }
        return b$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="getByte")
    public final byte getByte(long pos) {
        void offset$iv;
        void var1_1;
        void var3_2;
        long nextOffset$iv$iv;
        Segment s$iv;
        Buffer $this$commonGet$iv = this;
        Object object = $this$commonGet$iv;
        _UtilKt.checkOffsetAndCount($this$commonGet$iv.size, pos, 1L);
        Buffer $this$seek$iv$iv = $this$commonGet$iv;
        Segment segment = $this$seek$iv$iv.head;
        if (segment == null) {
            s$iv = null;
            Intrinsics.checkNotNull((Object)s$iv);
            return s$iv.data[(int)((long)s$iv.pos + pos - -1L)];
        }
        Segment s$iv$iv = segment;
        object = s$iv;
        if (((Buffer)object).size - pos < pos) {
            void offset$iv2;
            long offset$iv$iv;
            object = s$iv;
            for (offset$iv$iv = ((Buffer)object).size; offset$iv$iv > pos; offset$iv$iv -= (long)(s$iv$iv.limit - s$iv$iv.pos)) {
                Intrinsics.checkNotNull((Object)s$iv$iv.prev);
            }
            long l = offset$iv$iv;
            s$iv = s$iv$iv;
            Intrinsics.checkNotNull((Object)s$iv);
            return s$iv.data[(int)((long)s$iv.pos + pos - offset$iv2)];
        }
        long offset$iv$iv = 0L;
        while ((nextOffset$iv$iv = offset$iv$iv + (long)(s$iv$iv.limit - s$iv$iv.pos)) <= pos) {
            Intrinsics.checkNotNull((Object)s$iv$iv.next);
            offset$iv$iv = nextOffset$iv$iv;
        }
        long l = offset$iv$iv;
        s$iv = s$iv$iv;
        Intrinsics.checkNotNull((Object)s$iv);
        return s$iv.data[(int)((long)var3_2.pos + var1_1 - offset$iv)];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short readShort() throws EOFException {
        Buffer $this$commonReadShort$iv;
        Buffer buffer = $this$commonReadShort$iv = this;
        if ($this$commonReadShort$iv.size < 2L) {
            throw new EOFException();
        }
        Segment segment = $this$commonReadShort$iv.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment$iv = segment;
        int pos$iv = segment.pos;
        int limit$iv = segment$iv.limit;
        if (limit$iv - pos$iv < 2) {
            byte by = $this$commonReadShort$iv.readByte();
            byte by2 = by;
            by2 = $this$commonReadShort$iv.readByte();
            int n = (by & 0xFF) << 8 | by2 & 0xFF;
            return (short)n;
        }
        byte[] data$iv = segment$iv.data;
        byte by = segment$iv.data[pos$iv++];
        byte by3 = by;
        by3 = data$iv[pos$iv++];
        int s$iv = (by & 0xFF) << 8 | by3 & 0xFF;
        Buffer buffer2 = $this$commonReadShort$iv;
        buffer = buffer2;
        long l = buffer2.size - 2L;
        buffer = buffer2;
        buffer2.size = l;
        if (pos$iv == limit$iv) {
            var1_1.head = segment$iv.pop();
            SegmentPool.recycle(segment$iv);
        } else {
            void var3_5;
            var2_4.pos = var3_5;
        }
        return (short)s$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readInt() throws EOFException {
        Buffer $this$commonReadInt$iv;
        Buffer buffer = $this$commonReadInt$iv = this;
        if ($this$commonReadInt$iv.size < 4L) {
            throw new EOFException();
        }
        Segment segment = $this$commonReadInt$iv.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment$iv = segment;
        int pos$iv = segment.pos;
        int limit$iv = segment$iv.limit;
        if ((long)(limit$iv - pos$iv) < 4L) {
            byte by = $this$commonReadInt$iv.readByte();
            byte by2 = by;
            byte by3 = $this$commonReadInt$iv.readByte();
            by2 = by3;
            byte by4 = $this$commonReadInt$iv.readByte();
            by2 = by4;
            by2 = $this$commonReadInt$iv.readByte();
            return (by & 0xFF) << 24 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by2 & 0xFF;
        }
        byte[] data$iv = segment$iv.data;
        byte by = segment$iv.data[pos$iv++];
        byte by5 = by;
        byte by6 = data$iv[pos$iv++];
        by5 = by6;
        byte by7 = data$iv[pos$iv++];
        by5 = by7;
        by5 = data$iv[pos$iv++];
        int i$iv = (by & 0xFF) << 24 | (by6 & 0xFF) << 16 | (by7 & 0xFF) << 8 | by5 & 0xFF;
        Buffer buffer2 = $this$commonReadInt$iv;
        Buffer buffer3 = buffer2;
        long l = buffer2.size - 4L;
        buffer3 = buffer2;
        buffer2.size = l;
        if (pos$iv == limit$iv) {
            var1_1.head = segment$iv.pop();
            SegmentPool.recycle(segment$iv);
        } else {
            void var3_6;
            var2_5.pos = var3_6;
        }
        return i$iv;
    }

    @Override
    public final short readShortLe() throws EOFException {
        return _UtilKt.reverseBytes(this.readShort());
    }

    @Override
    public final int readIntLe() throws EOFException {
        return _UtilKt.reverseBytes(this.readInt());
    }

    @Override
    public final long readLongLe() throws EOFException {
        long l;
        Buffer buffer = this;
        Buffer buffer2 = buffer;
        buffer2 = buffer;
        Object object = buffer;
        if (buffer.size < 8L) {
            throw new EOFException();
        }
        Segment segment = buffer2.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int n = segment.pos;
        int n2 = segment2.limit;
        if ((long)(n2 - n) < 8L) {
            int n3 = buffer2.readInt();
            int n4 = n3;
            n4 = buffer2.readInt();
            l = ((long)n3 & 0xFFFFFFFFL) << 32 | (long)n4 & 0xFFFFFFFFL;
        } else {
            object = segment2.data;
            byte by = segment2.data[n++];
            Object object2 = by;
            Object object3 = object[n++];
            object2 = object3;
            Object object4 = object[n++];
            object2 = object4;
            Object object5 = object[n++];
            object2 = object5;
            Object object6 = object[n++];
            object2 = object6;
            Object object7 = object[n++];
            object2 = object7;
            Object object8 = object[n++];
            object2 = object8;
            Object object9 = object[n++];
            object2 = object9;
            long l2 = ((long)by & 0xFFL) << 56 | ((long)object3 & 0xFFL) << 48 | ((long)object4 & 0xFFL) << 40 | ((long)object5 & 0xFFL) << 32 | ((long)object6 & 0xFFL) << 24 | ((long)object7 & 0xFFL) << 16 | ((long)object8 & 0xFFL) << 8 | (long)object9 & 0xFFL;
            Buffer buffer3 = buffer2;
            object = buffer3;
            long l3 = buffer3.size - 8L;
            object = buffer3;
            buffer3.size = l3;
            if (n == n2) {
                buffer2.head = segment2.pop();
                SegmentPool.recycle(segment2);
            } else {
                segment2.pos = n;
            }
            l = l2;
        }
        return _UtilKt.reverseBytes(l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readHexadecimalUnsignedLong() throws EOFException {
        void var2_5;
        void var1_1;
        Buffer $this$commonReadHexadecimalUnsignedLong$iv;
        Buffer buffer = $this$commonReadHexadecimalUnsignedLong$iv = this;
        if ($this$commonReadHexadecimalUnsignedLong$iv.size == 0L) {
            throw new EOFException();
        }
        long value$iv = 0L;
        int seen$iv = 0;
        boolean done$iv = false;
        do {
            Segment segment$iv;
            Intrinsics.checkNotNull((Object)$this$commonReadHexadecimalUnsignedLong$iv.head);
            byte[] data$iv = segment$iv.data;
            int pos$iv = segment$iv.pos;
            int limit$iv = segment$iv.limit;
            while (pos$iv < limit$iv) {
                int digit$iv;
                byte b$iv = data$iv[pos$iv];
                if (b$iv >= 48 && b$iv <= 57) {
                    digit$iv = b$iv - 48;
                } else if (b$iv >= 97 && b$iv <= 102) {
                    digit$iv = b$iv - 97 + 10;
                } else if (b$iv >= 65 && b$iv <= 70) {
                    digit$iv = b$iv - 65 + 10;
                } else {
                    if (seen$iv == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + _UtilKt.toHexString(b$iv));
                    }
                    done$iv = true;
                    break;
                }
                if ((value$iv & 0xF000000000000000L) != 0L) {
                    Buffer buffer$iv = new Buffer().writeHexadecimalUnsignedLong(value$iv).writeByte(b$iv);
                    throw new NumberFormatException("Number too large: " + var1_1.readUtf8());
                }
                value$iv <<= 4;
                value$iv |= (long)digit$iv;
                ++pos$iv;
                ++seen$iv;
            }
            if (pos$iv == limit$iv) {
                var1_1.head = segment$iv.pop();
                SegmentPool.recycle(segment$iv);
                continue;
            }
            segment$iv.pos = pos$iv;
        } while (!done$iv && var1_1.head != null);
        void v0 = var1_1;
        void var5_4 = v0;
        long l = v0.size - (long)seen$iv;
        var5_4 = v0;
        v0.size = l;
        return (long)var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString readByteString() {
        void var1_1;
        Buffer $this$commonReadByteString$iv = this;
        return $this$commonReadByteString$iv.readByteString(var1_1.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString readByteString(long byteCount22) throws EOFException {
        void var1_1;
        void var3_3;
        long byteCount22;
        Buffer $this$commonReadByteString$iv = this;
        if (!(byteCount22 >= 0L && byteCount22 <= Integer.MAX_VALUE)) {
            String byteCount22 = "byteCount: " + byteCount22;
            throw new IllegalArgumentException(byteCount22.toString());
        }
        Object object = $this$commonReadByteString$iv;
        if (((Buffer)object).size < byteCount22) {
            throw new EOFException();
        }
        if (byteCount22 >= 4096L) {
            object = $this$commonReadByteString$iv.snapshot((int)byteCount22);
            $this$commonReadByteString$iv.skip(byteCount22);
            return object;
        }
        return new ByteString(var3_3.readByteArray((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int select(Options options) {
        void var3_4;
        void var1_2;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Buffer $this$commonSelect$iv = this;
        int index$iv = _BufferKt.selectPrefix$default$56ad841b($this$commonSelect$iv, (Options)options, false, 2);
        if (index$iv == -1) {
            return -1;
        }
        options = ((Options)options).getByteStrings$okio()[index$iv];
        int selectedSize$iv = ((ByteString)options).getSize$okio();
        var2_3.skip((long)var1_2);
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readAll(Sink sink2) throws IOException {
        void var3_4;
        Buffer $this$commonReadAll$iv;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Buffer buffer = $this$commonReadAll$iv = this;
        long byteCount$iv = $this$commonReadAll$iv.size;
        if (byteCount$iv > 0L) {
            void var2_2;
            void var1_1;
            var1_1.write((Buffer)var2_2, byteCount$iv);
        }
        return (long)var3_4;
    }

    public final String readUtf8() {
        Buffer buffer = this;
        return buffer.readString(buffer.size, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readUtf8(long byteCount) throws EOFException {
        void var1_1;
        return this.readString((long)var1_1, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readString(Charset charset) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Buffer buffer = this;
        return buffer.readString(buffer.size, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String readString(long byteCount, Charset charset) throws EOFException {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            charset = "byteCount: " + byteCount;
            throw new IllegalArgumentException(charset.toString());
        }
        if (this.size < byteCount) {
            throw new EOFException();
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        if ((long)segment.pos + byteCount > (long)s.limit) {
            return new String(this.readByteArray(byteCount), (Charset)charset);
        }
        String result = new String(s.data, s.pos, (int)byteCount, (Charset)charset);
        s.pos += (int)byteCount;
        this.size -= var1_1;
        if (s.pos == s.limit) {
            this.head = s.pop();
            SegmentPool.recycle(s);
        }
        return var3_2;
    }

    @Override
    public final String readUtf8LineStrict() throws EOFException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readUtf8LineStrict(long limit22) throws EOFException {
        void var1_1;
        void var3_3;
        long limit22;
        Buffer $this$commonReadUtf8LineStrict$iv = this;
        if (!(limit22 >= 0L)) {
            String limit22 = "limit < 0: " + limit22;
            throw new IllegalArgumentException(limit22.toString());
        }
        long scanLength$iv = limit22 == Long.MAX_VALUE ? Long.MAX_VALUE : limit22 + 1L;
        long newline$iv = $this$commonReadUtf8LineStrict$iv.indexOf((byte)10, 0L, scanLength$iv);
        if (newline$iv != -1L) {
            return _BufferKt.readUtf8Line($this$commonReadUtf8LineStrict$iv, newline$iv);
        }
        Buffer buffer = $this$commonReadUtf8LineStrict$iv;
        if (scanLength$iv < buffer.size && $this$commonReadUtf8LineStrict$iv.getByte(scanLength$iv - 1L) == 13 && $this$commonReadUtf8LineStrict$iv.getByte(scanLength$iv) == 10) {
            return _BufferKt.readUtf8Line($this$commonReadUtf8LineStrict$iv, scanLength$iv);
        }
        Buffer data$iv = new Buffer();
        buffer = $this$commonReadUtf8LineStrict$iv;
        long b$iv$iv = buffer.size;
        $this$commonReadUtf8LineStrict$iv.copyTo(data$iv, 0L, Math.min(32L, b$iv$iv));
        buffer = var3_3;
        throw new EOFException("\\n not found: limit=" + Math.min(buffer.size, (long)var1_1) + " content=" + data$iv.readByteString().hex() + '\u2026');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] readByteArray(long byteCount22) throws EOFException {
        void var1_3;
        void var3_4;
        long byteCount22;
        Buffer $this$commonReadByteArray$iv = this;
        if (!(byteCount22 >= 0L && byteCount22 <= Integer.MAX_VALUE)) {
            String byteCount22 = "byteCount: " + byteCount22;
            throw new IllegalArgumentException(byteCount22.toString());
        }
        Buffer buffer = $this$commonReadByteArray$iv;
        if (buffer.size < byteCount22) {
            throw new EOFException();
        }
        byte[] result$iv = new byte[(int)byteCount22];
        var3_4.readFully(result$iv);
        return var1_3;
    }

    private void readFully(byte[] sink2) throws EOFException {
        int read$iv;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Buffer $this$commonReadFully$iv = this;
        for (int offset$iv = 0; offset$iv < sink2.length; offset$iv += read$iv) {
            read$iv = $this$commonReadFully$iv.read(sink2, offset$iv, sink2.length - offset$iv);
            if (read$iv != -1) continue;
            throw new EOFException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int read(byte[] sink2, int offset, int byteCount) {
        void var3_3;
        void var2_2;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Buffer $this$commonRead$iv = this;
        _UtilKt.checkOffsetAndCount(sink2.length, offset, byteCount);
        Segment segment = $this$commonRead$iv.head;
        if (segment == null) {
            return -1;
        }
        Segment s$iv = segment;
        int toCopy$iv = Math.min(byteCount, s$iv.limit - s$iv.pos);
        ArraysKt.copyInto((byte[])s$iv.data, (byte[])buffer, (int)var2_2, (int)s$iv.pos, (int)(s$iv.pos + toCopy$iv));
        s$iv.pos += toCopy$iv;
        Buffer buffer2 = $this$commonRead$iv;
        buffer = buffer2;
        long l = buffer2.size - (long)toCopy$iv;
        buffer = buffer2;
        buffer2.size = l;
        if (s$iv.pos == s$iv.limit) {
            $this$commonRead$iv.head = s$iv.pop();
            SegmentPool.recycle(s$iv);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(ByteBuffer sink2) throws IOException {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(sink2.remaining(), s.limit - s.pos);
        var1_1.put(s.data, s.pos, toCopy);
        s.pos += toCopy;
        this.size -= (long)toCopy;
        if (s.pos == s.limit) {
            void var2_2;
            this.head = s.pop();
            SegmentPool.recycle((Segment)var2_2);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        void var1_1;
        Buffer $this$commonClear$iv = this;
        $this$commonClear$iv.skip(var1_1.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void skip(long byteCount) throws EOFException {
        Buffer $this$commonSkip$iv = this;
        long byteCount$iv = byteCount;
        while (byteCount$iv > 0L) {
            void var1_2;
            void var2_5;
            Segment head$iv;
            if ($this$commonSkip$iv.head == null) {
                throw new EOFException();
            }
            int b$iv$iv = head$iv.limit - head$iv.pos;
            int toSkip$iv = (int)Math.min(byteCount$iv, (long)b$iv$iv);
            Buffer buffer = $this$commonSkip$iv;
            Buffer buffer2 = buffer;
            long l = buffer.size - (long)toSkip$iv;
            buffer2 = buffer;
            buffer.size = l;
            byteCount$iv -= (long)toSkip$iv;
            head$iv.pos += var2_5;
            if (head$iv.pos != head$iv.limit) continue;
            $this$commonSkip$iv.head = head$iv.pop();
            SegmentPool.recycle((Segment)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer write(ByteString byteString) {
        void var2_2;
        void var3_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        Buffer $this$commonWrite_u24default$iv = this;
        ByteString byteString2 = byteString;
        int byteCount$iv = byteString2.getSize$okio();
        var1_1.write$okio($this$commonWrite_u24default$iv, 0, (int)var3_4);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeUtf8(String string) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.writeUtf8(string, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public final Buffer writeUtf8(String string, int beginIndex22, int endIndex) {
        int beginIndex22;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Buffer $this$commonWriteUtf8$iv = this;
        if (!(beginIndex22 >= 0)) {
            String beginIndex22 = "beginIndex < 0: " + beginIndex22;
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        if (!(endIndex >= beginIndex22)) {
            String beginIndex22 = "endIndex < beginIndex: " + endIndex + " < " + beginIndex22;
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        if (!(endIndex <= string.length())) {
            String beginIndex22 = "endIndex > string.length: " + endIndex + " > " + string.length();
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        int i$iv = beginIndex22;
        while (i$iv < endIndex) {
            char low$iv;
            long l;
            void var2_2;
            block12: {
                block11: {
                    char c$iv = string.charAt(i$iv);
                    if (c$iv < '\u0080') {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(1);
                        byte[] data$iv = ((Segment)tail$iv).data;
                        int segmentOffset$iv = ((Segment)tail$iv).limit - i$iv;
                        int runLimit$iv = Math.min(endIndex, 8192 - segmentOffset$iv);
                        data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        while (i$iv < runLimit$iv && (c$iv = string.charAt(i$iv)) < '\u0080') {
                            data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        }
                        int runSize$iv = i$iv + segmentOffset$iv - ((Segment)tail$iv).limit;
                        ((Segment)tail$iv).limit += runSize$iv;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + (long)var2_2;
                        tail$iv = buffer;
                        buffer.size = l;
                        continue;
                    }
                    if (var2_2 < 2048) {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(2);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit] = (byte)(var2_2 >> 6 | 0xC0);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 1] = (byte)(var2_2 & 0x3F | 0x80);
                        ((Segment)tail$iv).limit += 2;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + 2L;
                        tail$iv = buffer;
                        buffer.size = l;
                        ++i$iv;
                        continue;
                    }
                    if (var2_2 < 55296 || var2_2 > 57343) {
                        Object tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(3);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit] = (byte)(var2_2 >> 12 | 0xE0);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 1] = (byte)(var2_2 >> 6 & 0x3F | 0x80);
                        ((Segment)tail$iv).data[((Segment)tail$iv).limit + 2] = (byte)(var2_2 & 0x3F | 0x80);
                        ((Segment)tail$iv).limit += 3;
                        Buffer buffer = $this$commonWriteUtf8$iv;
                        tail$iv = buffer;
                        l = buffer.size + 3L;
                        tail$iv = buffer;
                        buffer.size = l;
                        ++i$iv;
                        continue;
                    }
                    char c = low$iv = i$iv + 1 < endIndex ? string.charAt(i$iv + 1) : (char)'\u0000';
                    if (var2_2 > 56319) break block11;
                    if ('\udc00' <= low$iv ? low$iv < '\ue000' : false) break block12;
                }
                $this$commonWriteUtf8$iv.writeByte(63);
                ++i$iv;
                continue;
            }
            int codePoint$iv = 65536 + ((var2_2 & 0x3FF) << 10 | low$iv & 0x3FF);
            Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment$okio(4);
            tail$iv.data[tail$iv.limit] = (byte)(codePoint$iv >> 18 | 0xF0);
            tail$iv.data[tail$iv.limit + 1] = (byte)(codePoint$iv >> 12 & 0x3F | 0x80);
            tail$iv.data[tail$iv.limit + 2] = (byte)(codePoint$iv >> 6 & 0x3F | 0x80);
            tail$iv.data[tail$iv.limit + 3] = (byte)(codePoint$iv & 0x3F | 0x80);
            tail$iv.limit += 4;
            Buffer buffer = $this$commonWriteUtf8$iv;
            Buffer buffer2 = buffer;
            l = buffer.size + 4L;
            buffer2 = buffer;
            buffer.size = l;
            i$iv += 2;
        }
        return $this$commonWriteUtf8$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final Buffer writeUtf8CodePoint(int codePoint22) {
        void var2_5;
        Buffer $this$commonWriteUtf8CodePoint$iv = this;
        if (codePoint22 < 128) {
            $this$commonWriteUtf8CodePoint$iv.writeByte(codePoint22);
        } else if (codePoint22 < 2048) {
            Segment tail$iv = $this$commonWriteUtf8CodePoint$iv.writableSegment$okio(2);
            tail$iv.data[tail$iv.limit] = (byte)(codePoint22 >> 6 | 0xC0);
            tail$iv.data[tail$iv.limit + 1] = (byte)(codePoint22 & 0x3F | 0x80);
            tail$iv.limit += 2;
            Buffer buffer = $this$commonWriteUtf8CodePoint$iv;
            Buffer codePoint22 = buffer;
            long l = buffer.size + 2L;
            codePoint22 = buffer;
            buffer.size = l;
        } else {
            int codePoint22;
            boolean bl = 55296 <= codePoint22 ? codePoint22 < 57344 : false;
            if (bl) {
                $this$commonWriteUtf8CodePoint$iv.writeByte(63);
            } else if (codePoint22 < 65536) {
                Segment tail$iv = $this$commonWriteUtf8CodePoint$iv.writableSegment$okio(3);
                tail$iv.data[tail$iv.limit] = (byte)(codePoint22 >> 12 | 0xE0);
                tail$iv.data[tail$iv.limit + 1] = (byte)(codePoint22 >> 6 & 0x3F | 0x80);
                tail$iv.data[tail$iv.limit + 2] = (byte)(codePoint22 & 0x3F | 0x80);
                tail$iv.limit += 3;
                Buffer buffer = $this$commonWriteUtf8CodePoint$iv;
                Buffer codePoint22 = buffer;
                long l = buffer.size + 3L;
                codePoint22 = buffer;
                buffer.size = l;
            } else if (codePoint22 <= 0x10FFFF) {
                Segment tail$iv = $this$commonWriteUtf8CodePoint$iv.writableSegment$okio(4);
                tail$iv.data[tail$iv.limit] = (byte)(codePoint22 >> 18 | 0xF0);
                tail$iv.data[tail$iv.limit + 1] = (byte)(codePoint22 >> 12 & 0x3F | 0x80);
                tail$iv.data[tail$iv.limit + 2] = (byte)(codePoint22 >> 6 & 0x3F | 0x80);
                tail$iv.data[tail$iv.limit + 3] = (byte)(codePoint22 & 0x3F | 0x80);
                var3_8.limit += 4;
                Buffer buffer = $this$commonWriteUtf8CodePoint$iv;
                Buffer codePoint22 = buffer;
                long l = buffer.size + 4L;
                codePoint22 = buffer;
                buffer.size = l;
            } else {
                void var1_1;
                throw new IllegalArgumentException("Unexpected code point: 0x" + _UtilKt.toHexString((int)var1_1));
            }
        }
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer write(byte[] source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Buffer buffer = this;
        return buffer.write(source2, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer write(byte[] source2, int offset, int byteCount) {
        void var3_3;
        void offset$iv;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Buffer $this$commonWrite$iv = this;
        _UtilKt.checkOffsetAndCount(source2.length, (long)offset$iv, byteCount);
        void limit$iv = offset$iv + byteCount;
        while (offset$iv < limit$iv) {
            Segment tail$iv = $this$commonWrite$iv.writableSegment$okio(1);
            int toCopy$iv = Math.min((int)(limit$iv - offset$iv), 8192 - tail$iv.limit);
            void v0 = offset$iv;
            ArraysKt.copyInto((byte[])source2, (byte[])tail$iv.data, (int)tail$iv.limit, (int)v0, (int)(v0 + toCopy$iv));
            offset$iv += toCopy$iv;
            tail$iv.limit += toCopy$iv;
        }
        Buffer buffer = $this$commonWrite$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + (long)var3_3;
        buffer2 = buffer;
        buffer.size = l;
        return $this$commonWrite$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int write(ByteBuffer source2) throws IOException {
        void var2_2;
        int byteCount;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        int remaining = byteCount = source2.remaining();
        while (remaining > 0) {
            Segment tail = this.writableSegment$okio(1);
            int toCopy = Math.min(remaining, 8192 - tail.limit);
            source2.get(tail.data, tail.limit, toCopy);
            remaining -= toCopy;
            tail.limit += toCopy;
        }
        this.size += (long)byteCount;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final long writeAll(Source source2) throws IOException {
        void var3_3;
        long readCount$iv;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Buffer $this$commonWriteAll$iv = this;
        long totalBytesRead$iv = 0L;
        while ((readCount$iv = source2.read($this$commonWriteAll$iv, 8192L)) != -1L) {
            totalBytesRead$iv += readCount$iv;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeByte(int b) {
        void var2_3;
        void var1_1;
        Buffer $this$commonWriteByte$iv = this;
        Segment tail$iv = $this$commonWriteByte$iv.writableSegment$okio(1);
        int n = tail$iv.limit;
        var3_4.limit = n + 1;
        tail$iv.data[n] = (byte)var1_1;
        Buffer buffer = $this$commonWriteByte$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + 1L;
        buffer2 = buffer;
        buffer.size = l;
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeShort(int s) {
        void var2_3;
        void var1_1;
        Buffer $this$commonWriteShort$iv = this;
        Segment tail$iv = $this$commonWriteShort$iv.writableSegment$okio(2);
        byte[] data$iv = tail$iv.data;
        int limit$iv = tail$iv.limit;
        data$iv[limit$iv++] = (byte)(s >>> 8);
        data$iv[limit$iv++] = (byte)var1_1;
        var3_4.limit = limit$iv;
        Buffer buffer = $this$commonWriteShort$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + 2L;
        buffer2 = buffer;
        buffer.size = l;
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeInt(int i) {
        void var2_3;
        void var1_1;
        Buffer $this$commonWriteInt$iv = this;
        Segment tail$iv = $this$commonWriteInt$iv.writableSegment$okio(4);
        byte[] data$iv = tail$iv.data;
        int limit$iv = tail$iv.limit;
        data$iv[limit$iv++] = (byte)(i >>> 24);
        data$iv[limit$iv++] = (byte)(i >>> 16);
        data$iv[limit$iv++] = (byte)(i >>> 8);
        data$iv[limit$iv++] = (byte)var1_1;
        var3_4.limit = limit$iv;
        Buffer buffer = $this$commonWriteInt$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + 4L;
        buffer2 = buffer;
        buffer.size = l;
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeDecimalLong(long v) {
        void var3_4;
        void var2_6;
        void var1_2;
        int width$iv;
        Buffer $this$commonWriteDecimalLong$iv = this;
        long v$iv = v;
        if (v$iv == 0L) {
            return $this$commonWriteDecimalLong$iv.writeByte(48);
        }
        boolean negative$iv = false;
        if (v$iv < 0L) {
            if ((v$iv = -v$iv) < 0L) {
                return $this$commonWriteDecimalLong$iv.writeUtf8("-9223372036854775808");
            }
            negative$iv = true;
        }
        int n = v$iv < 100000000L ? (v$iv < 10000L ? (v$iv < 100L ? (v$iv < 10L ? 1 : 2) : (v$iv < 1000L ? 3 : 4)) : (v$iv < 1000000L ? (v$iv < 100000L ? 5 : 6) : (v$iv < 10000000L ? 7 : 8))) : (v$iv < 1000000000000L ? (v$iv < 10000000000L ? (v$iv < 1000000000L ? 9 : 10) : (v$iv < 100000000000L ? 11 : 12)) : (v$iv < 1000000000000000L ? (v$iv < 10000000000000L ? 13 : (v$iv < 100000000000000L ? 14 : 15)) : (v$iv < 100000000000000000L ? (v$iv < 10000000000000000L ? 16 : 17) : (width$iv = v$iv < 1000000000000000000L ? 18 : 19))));
        if (negative$iv) {
            ++width$iv;
        }
        Segment tail$iv = $this$commonWriteDecimalLong$iv.writableSegment$okio(width$iv);
        byte[] data$iv = tail$iv.data;
        int pos$iv = tail$iv.limit + width$iv;
        while (v$iv != 0L) {
            int digit$iv = (int)(v$iv % 10L);
            data$iv[--pos$iv] = _BufferKt.getHEX_DIGIT_BYTES()[digit$iv];
            v$iv /= 10L;
        }
        if (var1_2 != false) {
            data$iv[--pos$iv] = 45;
        }
        tail$iv.limit += width$iv;
        Buffer buffer = $this$commonWriteDecimalLong$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + (long)var2_6;
        buffer2 = buffer;
        buffer.size = l;
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Buffer writeHexadecimalUnsignedLong(long v) {
        void var3_3;
        void var1_2;
        Buffer $this$commonWriteHexadecimalUnsignedLong$iv = this;
        long v$iv = v;
        if (v$iv == 0L) {
            return $this$commonWriteHexadecimalUnsignedLong$iv.writeByte(48);
        }
        long x$iv = v$iv;
        x$iv |= x$iv >>> 1;
        x$iv |= x$iv >>> 2;
        x$iv |= x$iv >>> 4;
        x$iv |= x$iv >>> 8;
        x$iv |= x$iv >>> 16;
        x$iv |= x$iv >>> 32;
        x$iv -= x$iv >>> 1 & 0x5555555555555555L;
        x$iv = (x$iv >>> 2 & 0x3333333333333333L) + (x$iv & 0x3333333333333333L);
        x$iv = (x$iv >>> 4) + x$iv & 0xF0F0F0F0F0F0F0FL;
        x$iv += x$iv >>> 8;
        x$iv += x$iv >>> 16;
        x$iv = (x$iv & 0x3FL) + (x$iv >>> 32 & 0x3FL);
        int width$iv = (int)((x$iv + 3L) / 4L);
        Segment tail$iv = $this$commonWriteHexadecimalUnsignedLong$iv.writableSegment$okio(width$iv);
        byte[] data$iv = tail$iv.data;
        int start$iv = tail$iv.limit;
        for (int pos$iv = tail$iv.limit + width$iv - 1; pos$iv >= start$iv; --pos$iv) {
            data$iv[pos$iv] = _BufferKt.getHEX_DIGIT_BYTES()[(int)(v$iv & 0xFL)];
            v$iv >>>= 4;
        }
        ((Segment)((Object)buffer2)).limit += width$iv;
        Buffer buffer = $this$commonWriteHexadecimalUnsignedLong$iv;
        Buffer buffer2 = buffer;
        long l = buffer.size + (long)var1_2;
        buffer2 = buffer;
        buffer.size = l;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final Segment writableSegment$okio(int minimumCapacity2) {
        void var3_4;
        Buffer $this$commonWritableSegment$iv = this;
        if (!(minimumCapacity2 > 0 && minimumCapacity2 <= 8192)) {
            String minimumCapacity2 = "unexpected capacity";
            throw new IllegalArgumentException(minimumCapacity2.toString());
        }
        if ($this$commonWritableSegment$iv.head == null) {
            Segment result$iv;
            $this$commonWritableSegment$iv.head = result$iv = SegmentPool.take();
            result$iv.prev = result$iv;
            result$iv.next = result$iv;
        } else {
            void var1_1;
            void var2_3;
            Segment segment = var2_3.head;
            Intrinsics.checkNotNull((Object)segment);
            Segment tail$iv = segment.prev;
            Intrinsics.checkNotNull((Object)tail$iv);
            if (tail$iv.limit + var1_1 > 8192 || !tail$iv.owner) {
                tail$iv = tail$iv.push(SegmentPool.take());
            }
        }
        return var3_4;
    }

    @Override
    public final void write(Buffer source2, long byteCount2) {
        long movedByteCount$iv;
        long byteCount$iv;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Buffer $this$commonWrite$iv = this;
        if (!(source2 != $this$commonWrite$iv)) {
            source2 = "source == this";
            throw new IllegalArgumentException(source2.toString());
        }
        Buffer byteCount2 = source2;
        _UtilKt.checkOffsetAndCount(byteCount2.size, 0L, byteCount$iv);
        for (byteCount$iv = byteCount2; byteCount$iv > 0L; byteCount$iv -= movedByteCount$iv) {
            Object object;
            Object object2;
            long l;
            Segment segment = ((Buffer)source2).head;
            Intrinsics.checkNotNull((Object)segment);
            int n = segment.limit;
            Segment segment2 = ((Buffer)source2).head;
            Intrinsics.checkNotNull((Object)segment2);
            if (byteCount$iv < (long)(n - segment2.pos)) {
                Object tail$iv;
                Object object3;
                if ($this$commonWrite$iv.head != null) {
                    Segment segment3 = $this$commonWrite$iv.head;
                    Intrinsics.checkNotNull((Object)segment3);
                    object3 = segment3.prev;
                } else {
                    object3 = tail$iv = null;
                }
                if (object3 != null && ((Segment)tail$iv).owner && byteCount$iv + (long)((Segment)tail$iv).limit - (long)(((Segment)tail$iv).shared ? 0 : ((Segment)tail$iv).pos) <= 8192L) {
                    Segment segment4 = ((Buffer)source2).head;
                    Intrinsics.checkNotNull((Object)segment4);
                    segment4.writeTo((Segment)tail$iv, (int)byteCount$iv);
                    Object object4 = source2;
                    tail$iv = object4;
                    l = ((Buffer)object4).size - byteCount$iv;
                    tail$iv = object4;
                    ((Buffer)object4).size = l;
                    Buffer buffer = $this$commonWrite$iv;
                    tail$iv = buffer;
                    l = buffer.size + byteCount$iv;
                    tail$iv = buffer;
                    buffer.size = l;
                    return;
                }
                Segment segment5 = ((Buffer)source2).head;
                Intrinsics.checkNotNull((Object)segment5);
                int n2 = (int)byteCount$iv;
                tail$iv = segment5;
                if (!(n2 > 0 && n2 <= ((Segment)tail$iv).limit - ((Segment)tail$iv).pos)) {
                    source2 = "byteCount out of range";
                    throw new IllegalArgumentException(source2.toString());
                }
                if (n2 >= 1024) {
                    object2 = ((Segment)tail$iv).sharedCopy();
                } else {
                    object2 = SegmentPool.take();
                    ArraysKt.copyInto$default((byte[])((Segment)tail$iv).data, (byte[])((Segment)object2).data, (int)0, (int)((Segment)tail$iv).pos, (int)(((Segment)tail$iv).pos + n2), (int)2, null);
                }
                ((Segment)object2).limit = ((Segment)object2).pos + n2;
                ((Segment)tail$iv).pos += n2;
                Segment segment6 = ((Segment)tail$iv).prev;
                Intrinsics.checkNotNull((Object)segment6);
                segment6.push((Segment)object2);
                ((Buffer)source2).head = object2;
            }
            Segment segmentToMove$iv = ((Buffer)source2).head;
            Intrinsics.checkNotNull((Object)segmentToMove$iv);
            movedByteCount$iv = segmentToMove$iv.limit - segmentToMove$iv.pos;
            ((Buffer)source2).head = segmentToMove$iv.pop();
            if ($this$commonWrite$iv.head == null) {
                $this$commonWrite$iv.head = segmentToMove$iv;
                segmentToMove$iv.next = segmentToMove$iv.prev = segmentToMove$iv;
            } else {
                Segment segment7 = $this$commonWrite$iv.head;
                Intrinsics.checkNotNull((Object)segment7);
                Segment segment8 = segment7.prev;
                Intrinsics.checkNotNull((Object)segment8);
                segment8 = segment8.push((Segment)object);
                object = segment8;
                if (!(segment8.prev != object)) {
                    object2 = "cannot compact";
                    throw new IllegalStateException(object2.toString());
                }
                Segment segment9 = ((Segment)object).prev;
                Intrinsics.checkNotNull((Object)segment9);
                if (segment9.owner) {
                    int n3;
                    int n4 = ((Segment)object).limit - ((Segment)object).pos;
                    Segment segment10 = ((Segment)object).prev;
                    Intrinsics.checkNotNull((Object)segment10);
                    int n5 = 8192 - segment10.limit;
                    Segment segment11 = ((Segment)object).prev;
                    Intrinsics.checkNotNull((Object)segment11);
                    if (segment11.shared) {
                        n3 = 0;
                    } else {
                        Segment segment12 = ((Segment)object).prev;
                        Intrinsics.checkNotNull((Object)segment12);
                        n3 = segment12.pos;
                    }
                    int n6 = n5 + n3;
                    if (n4 <= n6) {
                        Object object5 = object;
                        Segment segment13 = ((Segment)object5).prev;
                        Intrinsics.checkNotNull((Object)segment13);
                        ((Segment)object5).writeTo(segment13, n4);
                        ((Segment)object).pop();
                        SegmentPool.recycle((Segment)object);
                    }
                }
            }
            Object object6 = source2;
            object = object6;
            l = ((Buffer)object6).size - movedByteCount$iv;
            object = object6;
            ((Buffer)object6).size = l;
            Buffer buffer = $this$commonWrite$iv;
            object = buffer;
            l = buffer.size + movedByteCount$iv;
            object = buffer;
            buffer.size = l;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Buffer $this$commonRead$iv = this;
        long byteCount$iv = var2_2;
        if (!(byteCount$iv >= 0L)) {
            sink2 = "byteCount < 0: " + byteCount$iv;
            throw new IllegalArgumentException(sink2.toString());
        }
        Buffer buffer = $this$commonRead$iv;
        if (buffer.size == 0L) {
            return -1L;
        }
        buffer = $this$commonRead$iv;
        if (byteCount$iv > buffer.size) {
            buffer = $this$commonRead$iv;
            byteCount$iv = buffer.size;
        }
        var1_1.write($this$commonRead$iv, byteCount$iv);
        return byteCount$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final long indexOf(byte b2, long fromIndex2, long toIndex2) {
        Buffer $this$commonIndexOf$iv = this;
        long fromIndex$iv = fromIndex2;
        long toIndex$iv = toIndex2;
        if (!(0L <= fromIndex$iv ? fromIndex$iv <= toIndex$iv : false)) {
            Buffer toIndex2 = $this$commonIndexOf$iv;
            String b2 = "size=" + toIndex2.size + " fromIndex=" + fromIndex$iv + " toIndex=" + toIndex$iv;
            throw new IllegalArgumentException(b2.toString());
        }
        Buffer toIndex2 = $this$commonIndexOf$iv;
        if (toIndex$iv > toIndex2.size) {
            toIndex2 = $this$commonIndexOf$iv;
            toIndex$iv = toIndex2.size;
        }
        if (fromIndex$iv != toIndex$iv) {
            Segment $this$seek$iv$iv;
            Buffer fromIndex2 = $this$commonIndexOf$iv;
            long fromIndex$iv$iv = fromIndex$iv;
            Segment segment = ((Buffer)((Object)$this$seek$iv$iv)).head;
            if (segment != null) {
                byte b2;
                Object data$iv;
                Object s$iv;
                Segment s$iv$iv = segment;
                toIndex2 = $this$seek$iv$iv;
                if (toIndex2.size - fromIndex$iv$iv < fromIndex$iv$iv) {
                    long offset$iv$iv;
                    toIndex2 = $this$seek$iv$iv;
                    for (offset$iv$iv = toIndex2.size; offset$iv$iv > fromIndex$iv$iv; offset$iv$iv -= (long)(s$iv$iv.limit - s$iv$iv.pos)) {
                        Intrinsics.checkNotNull((Object)s$iv$iv.prev);
                    }
                    long l = offset$iv$iv;
                    $this$seek$iv$iv = s$iv$iv;
                    if ($this$seek$iv$iv != null) {
                        void offset$iv;
                        s$iv = $this$seek$iv$iv;
                        void offset$iv2 = offset$iv;
                        while (offset$iv2 < toIndex$iv) {
                            data$iv = ((Segment)s$iv).data;
                            int limit$iv = (int)Math.min((long)((Segment)s$iv).limit, (long)((Segment)s$iv).pos + toIndex$iv - offset$iv2);
                            for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv2); pos$iv < limit$iv; ++pos$iv) {
                                if (data$iv[pos$iv] != b2) continue;
                                return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv2;
                            }
                            fromIndex$iv = offset$iv2 += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                            Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                        }
                        return -1L;
                    }
                } else {
                    long nextOffset$iv$iv;
                    long offset$iv$iv = 0L;
                    while ((nextOffset$iv$iv = offset$iv$iv + (long)(((Segment)data$iv).limit - ((Segment)data$iv).pos)) <= fromIndex$iv$iv) {
                        Intrinsics.checkNotNull((Object)((Segment)data$iv).next);
                        offset$iv$iv = nextOffset$iv$iv;
                    }
                    long l = offset$iv$iv;
                    s$iv = data$iv;
                    if (s$iv != null) {
                        void offset$iv;
                        void offset$iv3 = offset$iv;
                        while (offset$iv3 < toIndex$iv) {
                            byte[] data$iv2 = ((Segment)s$iv).data;
                            int limit$iv = (int)Math.min((long)((Segment)s$iv).limit, (long)((Segment)s$iv).pos + toIndex$iv - offset$iv3);
                            for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv3); pos$iv < limit$iv; ++pos$iv) {
                                if (data$iv2[pos$iv] != b2) continue;
                                return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv3;
                            }
                            fromIndex$iv = offset$iv3 += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                            Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                        }
                    }
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public final long indexOfElement(ByteString targetBytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)targetBytes, (String)"targetBytes");
        return this.indexOfElement((ByteString)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private long indexOfElement(ByteString targetBytes, long fromIndex) {
        Intrinsics.checkNotNullParameter((Object)targetBytes, (String)"targetBytes");
        Buffer $this$commonIndexOfElement$iv = this;
        long fromIndex$iv = 0L;
        if (!(0L >= 0L)) {
            targetBytes = "fromIndex < 0: " + 0L;
            throw new IllegalArgumentException(targetBytes.toString());
        }
        Object $this$seek$iv$iv = $this$commonIndexOfElement$iv;
        Segment segment = ((Buffer)$this$seek$iv$iv).head;
        if (segment != null) {
            Object targetByteArray$iv;
            Object s$iv;
            Segment s$iv$iv = segment;
            Buffer buffer = $this$seek$iv$iv;
            if (buffer.size < 0L) {
                long offset$iv$iv;
                buffer = $this$seek$iv$iv;
                for (offset$iv$iv = buffer.size; offset$iv$iv > 0L; offset$iv$iv -= (long)(s$iv$iv.limit - s$iv$iv.pos)) {
                    Intrinsics.checkNotNull((Object)s$iv$iv.prev);
                }
                long l = offset$iv$iv;
                $this$seek$iv$iv = s$iv$iv;
                if ($this$seek$iv$iv != null) {
                    void offset$iv222;
                    s$iv = $this$seek$iv$iv;
                    void offset$iv = offset$iv222;
                    Object offset$iv222 = targetBytes;
                    if (((ByteString)offset$iv222).getSize$okio() == 2) {
                        int n = 0;
                        offset$iv222 = targetBytes;
                        byte b0$iv = ((ByteString)offset$iv222).internalGet$okio(n);
                        n = 1;
                        offset$iv222 = targetBytes;
                        byte b1$iv = ((ByteString)offset$iv222).internalGet$okio(n);
                        while (true) {
                            Buffer offset$iv222 = $this$commonIndexOfElement$iv;
                            if (offset$iv < offset$iv222.size) {
                                byte[] data$iv = ((Segment)s$iv).data;
                                int limit$iv = ((Segment)s$iv).limit;
                                for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv); pos$iv < limit$iv; ++pos$iv) {
                                    byte b$iv = data$iv[pos$iv];
                                    if (b$iv != b0$iv && b$iv != b1$iv) continue;
                                    return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv;
                                }
                                fromIndex$iv = offset$iv += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                                Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                                continue;
                            }
                            break;
                        }
                    } else {
                        void b1$iv;
                        targetByteArray$iv = b1$iv.internalArray$okio();
                        while (true) {
                            Buffer limit$iv = $this$commonIndexOfElement$iv;
                            if (offset$iv >= limit$iv.size) break;
                            byte[] data$iv = ((Segment)s$iv).data;
                            int limit$iv2 = ((Segment)s$iv).limit;
                            for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv); pos$iv < limit$iv2; ++pos$iv) {
                                byte b$iv = data$iv[pos$iv];
                                for (Object t$iv : targetByteArray$iv) {
                                    if (b$iv != t$iv) continue;
                                    return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv;
                                }
                            }
                            fromIndex$iv = offset$iv += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                            Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                        }
                    }
                    return -1L;
                }
            } else {
                long nextOffset$iv$iv;
                long offset$iv$iv = 0L;
                while ((nextOffset$iv$iv = offset$iv$iv + (long)(((Segment)targetByteArray$iv).limit - ((Segment)targetByteArray$iv).pos)) <= 0L) {
                    Intrinsics.checkNotNull((Object)((Segment)targetByteArray$iv).next);
                    offset$iv$iv = nextOffset$iv$iv;
                }
                long l = offset$iv$iv;
                s$iv = targetByteArray$iv;
                if (s$iv != null) {
                    Object data$iv;
                    void var1_1;
                    void offset$iv;
                    void offset$iv2 = offset$iv;
                    Buffer b$iv = var1_1;
                    if (((ByteString)((Object)b$iv)).getSize$okio() == 2) {
                        int limit$iv2 = 0;
                        b$iv = var1_1;
                        byte b0$iv = ((ByteString)((Object)b$iv)).internalGet$okio(limit$iv2);
                        limit$iv2 = 1;
                        b$iv = var1_1;
                        byte b1$iv = ((ByteString)((Object)b$iv)).internalGet$okio(limit$iv2);
                        while (true) {
                            b$iv = $this$commonIndexOfElement$iv;
                            if (offset$iv2 < b$iv.size) {
                                data$iv = ((Segment)s$iv).data;
                                int limit$iv = ((Segment)s$iv).limit;
                                for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv2); pos$iv < limit$iv; ++pos$iv) {
                                    Object b$iv2 = data$iv[pos$iv];
                                    if (b$iv2 != b0$iv && b$iv2 != b1$iv) continue;
                                    return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv2;
                                }
                                fromIndex$iv = offset$iv2 += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                                Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                                continue;
                            }
                            break;
                        }
                    } else {
                        byte[] targetByteArray$iv2 = var1_1.internalArray$okio();
                        while (true) {
                            data$iv = $this$commonIndexOfElement$iv;
                            if (offset$iv2 >= ((Buffer)data$iv).size) break;
                            byte[] data$iv2 = ((Segment)s$iv).data;
                            int limit$iv = ((Segment)s$iv).limit;
                            for (int pos$iv = (int)((long)((Segment)s$iv).pos + fromIndex$iv - offset$iv2); pos$iv < limit$iv; ++pos$iv) {
                                byte b$iv3 = data$iv2[pos$iv];
                                for (byte t$iv : targetByteArray$iv2) {
                                    if (b$iv3 != t$iv) continue;
                                    return (long)(pos$iv - ((Segment)s$iv).pos) + offset$iv2;
                                }
                            }
                            fromIndex$iv = offset$iv2 += (long)(((Segment)s$iv).limit - ((Segment)s$iv).pos);
                            Intrinsics.checkNotNull((Object)((Segment)s$iv).next);
                        }
                    }
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean rangeEquals(long offset, ByteString bytes) {
        Buffer buffer;
        long l;
        ByteString byteString;
        int n;
        Object object;
        block4: {
            block3: {
                void var3_4;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                object = var3_4;
                n = ((ByteString)object).getSize$okio();
                boolean bl = false;
                byteString = bytes;
                l = 0L;
                buffer = this;
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"bytes");
                if (l < 0L || n < 0) break block3;
                object = buffer;
                if (((Buffer)object).size - l >= (long)n && ((ByteString)(object = byteString)).getSize$okio() >= n) break block4;
            }
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i + 0;
            object = byteString;
            if (buffer.getByte(l + (long)i) == ((ByteString)object).internalGet$okio(n2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final void close() {
    }

    @Override
    public final Timeout timeout() {
        return Timeout.NONE;
    }

    public final boolean equals(Object other) {
        Buffer $this$commonEquals$iv = this;
        if ($this$commonEquals$iv != other) {
            if (!(other instanceof Buffer)) {
                return false;
            }
            Buffer buffer = $this$commonEquals$iv;
            Buffer buffer2 = buffer;
            buffer2 = (Buffer)other;
            if (buffer.size != buffer2.size) {
                return false;
            }
            buffer2 = $this$commonEquals$iv;
            if (buffer2.size != 0L) {
                Segment segment = $this$commonEquals$iv.head;
                Intrinsics.checkNotNull((Object)segment);
                Segment sa$iv = segment;
                Segment segment2 = ((Buffer)other).head;
                Intrinsics.checkNotNull((Object)segment2);
                Segment sb$iv = segment2;
                int posA$iv = sa$iv.pos;
                int posB$iv = sb$iv.pos;
                long pos$iv = 0L;
                while (true) {
                    buffer2 = $this$commonEquals$iv;
                    if (pos$iv >= buffer2.size) break;
                    long count$iv = Math.min(sa$iv.limit - posA$iv, sb$iv.limit - posB$iv);
                    long l = count$iv;
                    for (long i$iv = 0L; i$iv < l; ++i$iv) {
                        if (sa$iv.data[posA$iv++] == sb$iv.data[posB$iv++]) continue;
                        return false;
                    }
                    if (posA$iv == sa$iv.limit) {
                        Intrinsics.checkNotNull((Object)sa$iv.next);
                        posA$iv = sa$iv.pos;
                    }
                    if (posB$iv == sb$iv.limit) {
                        Intrinsics.checkNotNull((Object)sb$iv.next);
                        posB$iv = sb$iv.pos;
                    }
                    pos$iv += count$iv;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        Buffer $this$commonHashCode$iv = this;
        Segment segment = $this$commonHashCode$iv.head;
        if (segment == null) {
            return 0;
        }
        Segment s$iv = segment;
        int result$iv = 1;
        do {
            int limit$iv = s$iv.limit;
            for (int pos$iv = s$iv.pos; pos$iv < limit$iv; ++pos$iv) {
                result$iv = result$iv * 31 + s$iv.data[pos$iv];
            }
            Intrinsics.checkNotNull((Object)s$iv.next);
        } while (s$iv != $this$commonHashCode$iv.head);
        return (int)var3_3;
    }

    public final String toString() {
        Buffer buffer = this;
        Object object = buffer;
        object = buffer;
        Buffer buffer2 = buffer;
        if (!(buffer.size <= Integer.MAX_VALUE)) {
            buffer2 = object;
            object = "size > Int.MAX_VALUE: " + buffer2.size;
            throw new IllegalStateException(object.toString());
        }
        buffer2 = object;
        return buffer2.snapshot((int)buffer2.size).toString();
    }

    /*
     * WARNING - void declaration
     */
    private ByteString snapshot(int byteCount) {
        void var2_2;
        Buffer $this$commonSnapshot$iv = this;
        if (byteCount == 0) {
            return ByteString.EMPTY;
        }
        Buffer buffer = $this$commonSnapshot$iv;
        _UtilKt.checkOffsetAndCount(buffer.size, 0L, byteCount);
        int offset$iv = 0;
        int segmentCount$iv = 0;
        Segment s$iv = $this$commonSnapshot$iv.head;
        while (offset$iv < byteCount) {
            Segment segment = s$iv;
            Intrinsics.checkNotNull((Object)segment);
            if (segment.limit == s$iv.pos) {
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            offset$iv += s$iv.limit - s$iv.pos;
            ++segmentCount$iv;
            s$iv = s$iv.next;
        }
        byte[][] segments$iv = new byte[segmentCount$iv][];
        int[] directory$iv = new int[segmentCount$iv << 1];
        offset$iv = 0;
        segmentCount$iv = 0;
        s$iv = var2_2.head;
        while (offset$iv < byteCount) {
            Segment segment = s$iv;
            Intrinsics.checkNotNull((Object)segment);
            segments$iv[segmentCount$iv] = segment.data;
            directory$iv[segmentCount$iv] = Math.min(offset$iv += s$iv.limit - s$iv.pos, byteCount);
            directory$iv[segmentCount$iv + ((Object[])segments$iv).length] = s$iv.pos;
            s$iv.shared = true;
            ++segmentCount$iv;
            s$iv = s$iv.next;
        }
        return new SegmentedByteString(segments$iv, directory$iv);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokio/Buffer$UnsafeCursor;", "Ljava/io/Closeable;", "()V", "buffer", "Lokio/Buffer;", "data", "", "end", "", "offset", "", "readWrite", "", "segment", "Lokio/Segment;", "getSegment$okio", "()Lokio/Segment;", "setSegment$okio", "(Lokio/Segment;)V", "start", "close", "", "expandBuffer", "minByteCount", "next", "resizeBuffer", "newSize", "seek", "okio"})
    public static final class UnsafeCursor
    implements Closeable {
        @JvmField
        private Buffer buffer;

        @Override
        public final void close() {
            Object $this$commonClose$iv = this;
            if (!(((UnsafeCursor)$this$commonClose$iv).buffer != null)) {
                $this$commonClose$iv = "not attached to a buffer";
                throw new IllegalStateException($this$commonClose$iv.toString());
            }
            var1_1.buffer = null;
        }
    }
}

