/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._UtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002()B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u000eH$J\b\u0010\u0016\u001a\u00020\u000eH$J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH$J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011H$J\b\u0010\u001f\u001a\u00020\u0011H$J(\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH$J&\u0010!\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011J \u0010#\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0011J&\u0010&\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011J \u0010'\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lokio/FileHandle;", "Ljava/io/Closeable;", "Lokio/Closeable;", "readWrite", "", "(Z)V", "closed", "openStreamCount", "", "getReadWrite", "()Z", "appendingSink", "Lokio/Sink;", "close", "", "flush", "position", "", "sink", "source", "Lokio/Source;", "protectedClose", "protectedFlush", "protectedRead", "fileOffset", "array", "", "arrayOffset", "byteCount", "protectedResize", "size", "protectedSize", "protectedWrite", "read", "Lokio/Buffer;", "readNoCloseCheck", "reposition", "resize", "write", "writeNoCloseCheck", "FileHandleSink", "FileHandleSource", "okio"})
public abstract class FileHandle
implements Closeable {
    private final boolean readWrite;
    private boolean closed;
    private int openStreamCount;

    /*
     * WARNING - void declaration
     */
    public FileHandle(boolean readWrite) {
        void var1_1;
        this.readWrite = var1_1;
    }

    public final long size() throws IOException {
        FileHandle fileHandle = this;
        synchronized (fileHandle) {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
        }
        return this.protectedSize();
    }

    public final void flush() throws IOException {
        if (!this.readWrite) {
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        FileHandle fileHandle = this;
        synchronized (fileHandle) {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
        }
        this.protectedFlush();
    }

    /*
     * WARNING - void declaration
     */
    public final Source source(long fileOffset2) throws IOException {
        void var1_1;
        FileHandle fileHandle = this;
        synchronized (fileHandle) {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
            int n = this.openStreamCount;
            this.openStreamCount = n + 1;
        }
        return new FileHandleSource(this, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Sink sink(long fileOffset2) throws IOException {
        void var1_1;
        if (!this.readWrite) {
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        FileHandle fileHandle = this;
        synchronized (fileHandle) {
            if (!(!this.closed)) {
                String fileOffset2 = "closed";
                throw new IllegalStateException(fileOffset2.toString());
            }
            int n = this.openStreamCount;
            this.openStreamCount = n + 1;
        }
        return new FileHandleSink(this, (long)var1_1);
    }

    public static /* synthetic */ Sink sink$default(FileHandle fileHandle, long l, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sink");
        }
        return fileHandle.sink(0L);
    }

    @Override
    public final void close() throws IOException {
        FileHandle fileHandle = this;
        synchronized (fileHandle) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.openStreamCount != 0) {
                return;
            }
        }
        this.protectedClose();
    }

    protected abstract int protectedRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedFlush() throws IOException;

    protected abstract long protectedSize() throws IOException;

    protected abstract void protectedClose() throws IOException;

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$writeNoCloseCheck(FileHandle $this, long fileOffset, Buffer source2, long byteCount) {
        int n;
        void var1_1;
        void var3_3;
        long l = byteCount;
        void var1_2 = var3_3;
        void var7_7 = var1_1;
        FileHandle fileHandle = $this;
        _UtilKt.checkOffsetAndCount(var1_2.size(), 0L, l);
        void var14_9 = var7_7 + l;
        for (void var12_8 = var7_7; var12_8 < var14_9; var12_8 += (long)n) {
            Segment segment;
            Intrinsics.checkNotNull((Object)var1_2.head);
            void var18_10 = var14_9 - var12_8;
            n = segment.limit - segment.pos;
            n = (int)Math.min((long)var18_10, (long)n);
            fileHandle.protectedWrite((long)var12_8, segment.data, segment.pos, n);
            segment.pos += n;
            void v0 = var1_2;
            v0.setSize$okio(v0.size() - (long)n);
            if (segment.pos != segment.limit) continue;
            var1_2.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setOpenStreamCount$p(FileHandle $this, int n) {
        void var1_1;
        $this.openStreamCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$readNoCloseCheck(FileHandle $this, long fileOffset, Buffer sink2, long byteCount) {
        void var12_9;
        int n;
        void var1_1;
        void var3_3;
        long l = byteCount;
        void var1_2 = var3_3;
        void var7_7 = var1_1;
        FileHandle fileHandle = $this;
        if (!(l >= 0L)) {
            String string = "byteCount < 0: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        void var14_10 = var7_7 + l;
        for (var12_9 = var7_7; var12_9 < var14_10; var12_9 += (long)n) {
            Segment segment = var1_2.writableSegment$okio(1);
            void var18_11 = var14_10 - var12_9;
            n = 8192 - segment.limit;
            if ((n = fileHandle.protectedRead((long)var12_9, segment.data, segment.limit, (int)Math.min((long)var18_11, (long)n))) == -1) {
                if (segment.pos == segment.limit) {
                    var1_2.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                if (var7_7 != var12_9) break;
                return -1L;
            }
            segment.limit += n;
            void v0 = var1_2;
            v0.setSize$okio(v0.size() + (long)n);
        }
        return (long)(var12_9 - var7_7);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lokio/FileHandle$FileHandleSink;", "Lokio/Sink;", "fileHandle", "Lokio/FileHandle;", "position", "", "(Lokio/FileHandle;J)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "getFileHandle", "()Lokio/FileHandle;", "getPosition", "()J", "setPosition", "(J)V", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "okio"})
    static final class FileHandleSink
    implements Sink {
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        /*
         * WARNING - void declaration
         */
        public FileHandleSink(FileHandle fileHandle, long position) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)fileHandle, (String)"fileHandle");
            this.fileHandle = var1_1;
            this.position = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Buffer source2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (!(!this.closed)) {
                source2 = "closed";
                throw new IllegalStateException(source2.toString());
            }
            FileHandle.access$writeNoCloseCheck(this.fileHandle, this.position, (Buffer)var1_1, byteCount);
            this.position += var2_2;
        }

        @Override
        public final void flush() {
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            this.fileHandle.protectedFlush();
        }

        @Override
        public final Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FileHandle fileHandle = this.fileHandle;
            FileHandle fileHandle2 = fileHandle;
            fileHandle2 = fileHandle;
            synchronized (fileHandle) {
                FileHandle fileHandle3 = this.fileHandle;
                int n = fileHandle3.openStreamCount;
                FileHandle.access$setOpenStreamCount$p(fileHandle3, n + -1);
                if (this.fileHandle.openStreamCount != 0 || !this.fileHandle.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.fileHandle.protectedClose();
                return;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lokio/FileHandle$FileHandleSource;", "Lokio/Source;", "fileHandle", "Lokio/FileHandle;", "position", "", "(Lokio/FileHandle;J)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "getFileHandle", "()Lokio/FileHandle;", "getPosition", "()J", "setPosition", "(J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "okio"})
    static final class FileHandleSource
    implements Source {
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        /*
         * WARNING - void declaration
         */
        public FileHandleSource(FileHandle fileHandle, long position) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)fileHandle, (String)"fileHandle");
            this.fileHandle = var1_1;
            this.position = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink2, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            long result = FileHandle.access$readNoCloseCheck(this.fileHandle, this.position, (Buffer)var1_1, (long)var2_2);
            if (result != -1L) {
                this.position += result;
            }
            return result;
        }

        @Override
        public final Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FileHandle fileHandle = this.fileHandle;
            FileHandle fileHandle2 = fileHandle;
            fileHandle2 = fileHandle;
            synchronized (fileHandle) {
                FileHandle fileHandle3 = this.fileHandle;
                int n = fileHandle3.openStreamCount;
                FileHandle.access$setOpenStreamCount$p(fileHandle3, n + -1);
                if (this.fileHandle.openStreamCount != 0 || !this.fileHandle.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.fileHandle.protectedClose();
                return;
            }
        }
    }
}

