/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.InflaterSource;
import okio.RealBufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lokio/GzipSource;", "Lokio/Source;", "source", "(Lokio/Source;)V", "crc", "Ljava/util/zip/CRC32;", "inflater", "Ljava/util/zip/Inflater;", "inflaterSource", "Lokio/InflaterSource;", "section", "", "Lokio/RealBufferedSource;", "checkEqual", "", "name", "", "expected", "", "actual", "close", "consumeHeader", "consumeTrailer", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "updateCrc", "buffer", "offset", "okio"})
public final class GzipSource
implements Source {
    private byte section;
    private final RealBufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    /*
     * WARNING - void declaration
     */
    public GzipSource(Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = new RealBufferedSource((Source)var1_1);
        this.inflater = new Inflater(true);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
        this.crc = new CRC32();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) throws IOException {
        GzipSource gzipSource;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!(byteCount >= 0L)) {
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            short s;
            short s2;
            gzipSource = this;
            gzipSource.source.require(10L);
            RealBufferedSource realBufferedSource = gzipSource.source;
            short s3 = s2 = realBufferedSource.bufferField.getByte(3L);
            boolean bl = (s2 >> 1 & 1) == 1;
            if (bl) {
                GzipSource gzipSource2 = gzipSource;
                RealBufferedSource realBufferedSource2 = gzipSource2.source;
                gzipSource2.updateCrc(realBufferedSource2.bufferField, 0L, 10L);
            }
            s3 = gzipSource.source.readShort();
            GzipSource.checkEqual("ID1ID2", 8075, s3);
            gzipSource.source.skip(8L);
            short s4 = s2;
            if ((s4 >> 2 & 1) == 1) {
                gzipSource.source.require(2L);
                if (bl) {
                    GzipSource gzipSource3 = gzipSource;
                    RealBufferedSource realBufferedSource3 = gzipSource3.source;
                    gzipSource3.updateCrc(realBufferedSource3.bufferField, 0L, 2L);
                }
                RealBufferedSource realBufferedSource4 = gzipSource.source;
                long l = realBufferedSource4.bufferField.readShortLe();
                gzipSource.source.require(l);
                if (bl) {
                    GzipSource gzipSource4 = gzipSource;
                    realBufferedSource4 = gzipSource4.source;
                    gzipSource4.updateCrc(realBufferedSource4.bufferField, 0L, l);
                }
                gzipSource.source.skip(l);
            }
            if (((s4 = s2) >> 3 & 1) == 1) {
                long l = gzipSource.source.indexOf((byte)0);
                if (l == -1L) {
                    throw new EOFException();
                }
                if (bl) {
                    GzipSource gzipSource5 = gzipSource;
                    RealBufferedSource realBufferedSource5 = gzipSource5.source;
                    gzipSource5.updateCrc(realBufferedSource5.bufferField, 0L, l + 1L);
                }
                gzipSource.source.skip(l + 1L);
            }
            if (((s = s2) >> 4 & 1) == 1) {
                long l = gzipSource.source.indexOf((byte)0);
                if (l == -1L) {
                    throw new EOFException();
                }
                if (bl) {
                    GzipSource gzipSource6 = gzipSource;
                    RealBufferedSource realBufferedSource6 = gzipSource6.source;
                    gzipSource6.updateCrc(realBufferedSource6.bufferField, 0L, l + 1L);
                }
                gzipSource.source.skip(l + 1L);
            }
            if (bl) {
                GzipSource.checkEqual("FHCRC", gzipSource.source.readShortLe(), (short)gzipSource.crc.getValue());
                gzipSource.crc.reset();
            }
            this.section = 1;
        }
        if (this.section == 1) {
            void var2_2;
            long offset = sink2.size();
            long result = this.inflaterSource.read(sink2, (long)var2_2);
            if (result != -1L) {
                void var1_1;
                this.updateCrc((Buffer)var1_1, offset, result);
                return result;
            }
            this.section = (byte)2;
        }
        if (this.section == 2) {
            gzipSource = this;
            GzipSource.checkEqual("CRC", gzipSource.source.readIntLe(), (int)gzipSource.crc.getValue());
            GzipSource.checkEqual("ISIZE", gzipSource.source.readIntLe(), (int)gzipSource.inflater.getBytesWritten());
            this.section = (byte)3;
            if (!this.source.exhausted()) {
                throw new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
        this.inflaterSource.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCrc(Buffer buffer, long offset, long byteCount) {
        long offset2;
        long byteCount2 = byteCount;
        Segment segment = buffer.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (offset2 = offset; offset2 >= (long)(s.limit - s.pos); offset2 -= (long)(s.limit - s.pos)) {
            Intrinsics.checkNotNull((Object)s.next);
        }
        while (byteCount2 > 0L) {
            void var2_3;
            int pos = (int)((long)s.pos + offset2);
            int n = s.limit - pos;
            int toUpdate = (int)Math.min((long)n, byteCount2);
            this.crc.update(s.data, (int)var2_3, toUpdate);
            byteCount2 -= (long)n;
            offset2 = 0L;
            Intrinsics.checkNotNull((Object)s.next);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            void var1_1;
            void var2_2;
            String string;
            String string2 = "%s: actual 0x%08x != expected 0x%08x";
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray2[1] = (int)var2_2;
            objectArray2[2] = (int)var1_1;
            String string3 = String.format(string2, Arrays.copyOf(objectArray2, 3));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            throw new IOException(string3);
        }
    }
}

