/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Okio__JvmOkioKt;
import okio.Segment;
import okio.SegmentPool;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokio/InputStreamSource;", "Lokio/Source;", "input", "Ljava/io/InputStream;", "timeout", "Lokio/Timeout;", "(Ljava/io/InputStream;Lokio/Timeout;)V", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "toString", "", "okio"})
final class InputStreamSource
implements Source {
    private final InputStream input;
    private final Timeout timeout;

    /*
     * WARNING - void declaration
     */
    public InputStreamSource(InputStream input, Timeout timeout) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.input = var1_1;
        this.timeout = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount2) {
        AssertionError assertionError;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (byteCount2 == 0L) {
            return 0L;
        }
        if (!(byteCount2 >= 0L)) {
            String byteCount2 = "byteCount < 0: " + byteCount2;
            throw new IllegalArgumentException(byteCount2.toString());
        }
        try {
            void var2_4;
            long byteCount2;
            this.timeout.throwIfReached();
            Segment tail = sink2.writableSegment$okio(1);
            int b$iv = 8192 - tail.limit;
            int maxToCopy = (int)Math.min(byteCount2, (long)b$iv);
            int bytesRead = this.input.read(tail.data, tail.limit, (int)var2_4);
            if (bytesRead == -1) {
                if (tail.pos == tail.limit) {
                    sink2.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                return -1L;
            }
            tail.limit += bytesRead;
            AssertionError assertionError2 = assertionError;
            ((Buffer)((Object)assertionError2)).setSize$okio(((Buffer)((Object)assertionError2)).size() + (long)bytesRead);
            return bytesRead;
        }
        catch (AssertionError assertionError3) {
            AssertionError e = assertionError3;
            assertionError = assertionError3;
            if (Okio__JvmOkioKt.isAndroidGetsocknameError(assertionError3)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public final void close() {
        this.input.close();
    }

    @Override
    public final Timeout timeout() {
        return this.timeout;
    }

    public final String toString() {
        return "source(" + this.input + ')';
    }
}

