/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.FileHandle;
import okio.FileSystem;
import okio.JvmFileHandle;
import okio.Okio;
import okio.Okio__JvmOkioKt;
import okio.Path;
import okio.Source;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\"\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lokio/JvmSystemFileSystem;", "Lokio/FileSystem;", "()V", "appendingSink", "Lokio/Sink;", "file", "Lokio/Path;", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "toString", "", "requireCreate", "requireExist", "okio"})
public class JvmSystemFileSystem
extends FileSystem {
    /*
     * WARNING - void declaration
     */
    @Override
    public Okio metadataOrNull$3008182d(Path path) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        boolean isRegularFile = file.isFile();
        boolean isDirectory = file.isDirectory();
        long lastModifiedAtMillis = file.lastModified();
        long size = file.length();
        if (!(isRegularFile || isDirectory || lastModifiedAtMillis != 0L || size != 0L || var1_1.exists())) {
            return null;
        }
        return new Okio((boolean)var2_2, (boolean)var3_3, null, size, null, lastModifiedAtMillis, null, null, 128);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileHandle openReadOnly(Path file) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JvmFileHandle(false, new RandomAccessFile(var1_1.toFile(), "r"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JvmFileHandle(true, new RandomAccessFile(var1_1.toFile(), "rw"));
    }

    @Override
    public final Source source(Path file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file2 = ((Path)((Object)file2)).toFile();
        return Okio__JvmOkioKt.source(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createDirectory(Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.toFile().mkdir()) {
            void var1_1;
            boolean bl;
            Okio okio = this.metadataOrNull$3008182d(dir);
            boolean bl2 = okio != null ? okio.isDirectory() : (bl = false);
            if (bl2) {
                return;
            }
            throw new IOException("failed to create directory: " + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atomicMove(Path source2, Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = source2.toFile().renameTo(target.toFile());
        if (!bl) {
            void var2_2;
            void var1_1;
            throw new IOException("failed to move " + var1_1 + " to " + var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void delete(Path path, boolean mustExist) {
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        boolean bl = file.delete();
        if (!bl && var2_3.exists()) {
            void var1_1;
            throw new IOException("failed to delete " + var1_1);
        }
    }

    public String toString() {
        return "JvmSystemFileSystem";
    }
}

