/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.internal._PathKt;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\rH\u0087\u0002\u00a2\u0006\u0002\b\"J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003H\u0087\u0002\u00a2\u0006\u0002\b\"J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0002\b\"J\u0013\u0010#\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u001eH\u0016J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\r2\b\b\u0002\u0010(\u001a\u00020\bJ\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\bJ\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020\bJ\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006/"}, d2={"Lokio/Path;", "", "bytes", "Lokio/ByteString;", "(Lokio/ByteString;)V", "getBytes$okio", "()Lokio/ByteString;", "isAbsolute", "", "()Z", "isRelative", "isRoot", "name", "", "()Ljava/lang/String;", "nameBytes", "parent", "()Lokio/Path;", "root", "getRoot", "segments", "", "getSegments", "()Ljava/util/List;", "segmentsBytes", "getSegmentsBytes", "volumeLetter", "", "()Ljava/lang/Character;", "compareTo", "", "other", "div", "child", "resolve", "equals", "", "hashCode", "normalized", "relativeTo", "normalize", "toFile", "Ljava/io/File;", "toNioPath", "Ljava/nio/file/Path;", "toString", "Companion", "okio"})
public final class Path
implements Comparable<Path> {
    public static final Companion Companion = new Companion(0);
    private final ByteString bytes;
    @JvmField
    public static final String DIRECTORY_SEPARATOR;

    /*
     * WARNING - void declaration
     */
    public Path(ByteString bytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = var1_1;
    }

    public final ByteString getBytes$okio() {
        return this.bytes;
    }

    /*
     * WARNING - void declaration
     */
    private Path getRoot() {
        void var2_2;
        void var1_1;
        Path $this$commonRoot$iv = this;
        int rootLength$iv = _PathKt.access$rootLength($this$commonRoot$iv);
        if (rootLength$iv == -1) {
            return null;
        }
        return new Path(var1_1.bytes.substring(0, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private List<ByteString> getSegmentsBytes() {
        void var2_2;
        int n;
        Comparable<Path> comparable;
        Path $this$commonSegmentsBytes$iv = this;
        List result$iv = new ArrayList();
        int segmentStart$iv = _PathKt.access$rootLength($this$commonSegmentsBytes$iv);
        if (segmentStart$iv == -1) {
            segmentStart$iv = 0;
        } else {
            comparable = $this$commonSegmentsBytes$iv;
            comparable = comparable.bytes;
            if (segmentStart$iv < ((ByteString)comparable).getSize$okio()) {
                comparable = $this$commonSegmentsBytes$iv;
                comparable = comparable.bytes;
                if (((ByteString)comparable).internalGet$okio(n = segmentStart$iv++) == 92) {
                    // empty if block
                }
            }
        }
        comparable = $this$commonSegmentsBytes$iv;
        comparable = comparable.bytes;
        int n2 = ((ByteString)comparable).getSize$okio();
        for (int i$iv = segmentStart$iv; i$iv < n2; ++i$iv) {
            comparable = $this$commonSegmentsBytes$iv;
            comparable = comparable.bytes;
            n = i$iv;
            if (((ByteString)comparable).internalGet$okio(n) != 47) {
                comparable = $this$commonSegmentsBytes$iv;
                comparable = comparable.bytes;
                n = i$iv;
                if (((ByteString)comparable).internalGet$okio(n) != 92) continue;
            }
            comparable = $this$commonSegmentsBytes$iv;
            ((Collection)result$iv).add(comparable.bytes.substring(segmentStart$iv, i$iv));
            segmentStart$iv = i$iv + 1;
        }
        comparable = $this$commonSegmentsBytes$iv;
        comparable = comparable.bytes;
        if (segmentStart$iv < ((ByteString)comparable).getSize$okio()) {
            void var3_3;
            void var1_1;
            Path path = $this$commonSegmentsBytes$iv;
            comparable = path;
            comparable = var1_1;
            comparable = comparable.bytes;
            ((Collection)result$iv).add(path.bytes.substring((int)var3_3, ((ByteString)comparable).getSize$okio()));
        }
        return var2_2;
    }

    public final boolean isAbsolute() {
        Path path = this;
        return _PathKt.access$rootLength(path) != -1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="volumeLetter")
    public final Character volumeLetter() {
        void var1_2;
        Path $this$commonVolumeLetter$iv;
        Comparable<Path> comparable = $this$commonVolumeLetter$iv = this;
        if (ByteString.indexOf$default($this$commonVolumeLetter$iv.bytes, _PathKt.access$getSLASH$p(), 0, 2, null) != -1) {
            return null;
        }
        comparable = $this$commonVolumeLetter$iv;
        comparable = comparable.bytes;
        if (((ByteString)comparable).getSize$okio() < 2) {
            return null;
        }
        comparable = $this$commonVolumeLetter$iv;
        comparable = comparable.bytes;
        int n = 1;
        if (((ByteString)comparable).internalGet$okio(n) != 58) {
            return null;
        }
        comparable = $this$commonVolumeLetter$iv;
        comparable = comparable.bytes;
        n = 0;
        char c$iv = (char)((ByteString)comparable).internalGet$okio(n);
        if (!('a' <= c$iv ? c$iv < '{' : false)) {
            if (!('A' <= c$iv ? c$iv < '[' : false)) {
                return null;
            }
        }
        return Character.valueOf((char)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="nameBytes")
    private ByteString nameBytes() {
        void var1_1;
        Comparable<Path> comparable;
        Path $this$commonNameBytes$iv = this;
        int lastSlash$iv = _PathKt.access$getIndexOfLastSlash($this$commonNameBytes$iv);
        if (lastSlash$iv != -1) {
            void var2_2;
            Path path = $this$commonNameBytes$iv;
            return ByteString.substring$default(path.bytes, (int)(var2_2 + true), 0, 2, null);
        }
        if ($this$commonNameBytes$iv.volumeLetter() != null) {
            comparable = $this$commonNameBytes$iv;
            comparable = comparable.bytes;
            if (((ByteString)comparable).getSize$okio() == 2) {
                return ByteString.EMPTY;
            }
        }
        comparable = var1_1;
        return comparable.bytes;
    }

    @JvmName(name="name")
    public final String name() {
        Path path = this;
        return path.nameBytes().utf8();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="parent")
    public final Path parent() {
        void var2_3;
        void var1_1;
        Comparable<Path> comparable;
        Path $this$commonParent$iv;
        block12: {
            block11: {
                comparable = $this$commonParent$iv = this;
                if (Intrinsics.areEqual((Object)$this$commonParent$iv.bytes, (Object)_PathKt.access$getDOT$p())) break block11;
                comparable = $this$commonParent$iv;
                if (Intrinsics.areEqual((Object)comparable.bytes, (Object)_PathKt.access$getSLASH$p())) break block11;
                comparable = $this$commonParent$iv;
                if (!Intrinsics.areEqual((Object)comparable.bytes, (Object)_PathKt.access$getBACKSLASH$p()) && !_PathKt.access$lastSegmentIsDotDot($this$commonParent$iv)) break block12;
            }
            return null;
        }
        int lastSlash$iv = _PathKt.access$getIndexOfLastSlash($this$commonParent$iv);
        if (lastSlash$iv == 2 && $this$commonParent$iv.volumeLetter() != null) {
            comparable = $this$commonParent$iv;
            comparable = comparable.bytes;
            if (((ByteString)comparable).getSize$okio() == 3) {
                return null;
            }
            comparable = $this$commonParent$iv;
            return new Path(ByteString.substring$default(comparable.bytes, 0, 3, 1, null));
        }
        if (lastSlash$iv == 1) {
            comparable = $this$commonParent$iv;
            if (comparable.bytes.startsWith(_PathKt.access$getBACKSLASH$p())) {
                return null;
            }
        }
        if (lastSlash$iv == -1 && $this$commonParent$iv.volumeLetter() != null) {
            comparable = $this$commonParent$iv;
            comparable = comparable.bytes;
            if (((ByteString)comparable).getSize$okio() == 2) {
                return null;
            }
            comparable = $this$commonParent$iv;
            return new Path(ByteString.substring$default(comparable.bytes, 0, 2, 1, null));
        }
        if (lastSlash$iv == -1) {
            return new Path(_PathKt.access$getDOT$p());
        }
        if (lastSlash$iv == 0) {
            comparable = $this$commonParent$iv;
            return new Path(ByteString.substring$default(comparable.bytes, 0, 1, 1, null));
        }
        comparable = var1_1;
        return new Path(ByteString.substring$default(comparable.bytes, 0, (int)var2_3, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="resolve")
    public final Path resolve(String child) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = this;
        Buffer child$iv$iv = new Buffer().writeUtf8(child);
        return _PathKt.commonResolve(path, _PathKt.toPath((Buffer)var1_1, false), false);
    }

    /*
     * WARNING - void declaration
     */
    public final Path resolve(Path child, boolean normalize) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return _PathKt.commonResolve(this, (Path)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public final Path relativeTo(Path other2222) {
        int i$iv;
        void var3_7;
        Object other2222;
        int firstNewSegmentIndex$iv;
        Intrinsics.checkNotNullParameter((Object)other2222, (String)"other");
        Path $this$commonRelativeTo$iv = this;
        if (!Intrinsics.areEqual((Object)$this$commonRelativeTo$iv.getRoot(), (Object)((Path)other2222).getRoot())) {
            String string = "Paths of different roots cannot be relative to each other: " + $this$commonRelativeTo$iv + " and " + other2222;
            throw new IllegalArgumentException(string.toString());
        }
        List<ByteString> thisSegments$iv = $this$commonRelativeTo$iv.getSegmentsBytes();
        List<ByteString> otherSegments$iv = ((Path)other2222).getSegmentsBytes();
        int minSegmentsSize$iv2 = Math.min(thisSegments$iv.size(), otherSegments$iv.size());
        for (firstNewSegmentIndex$iv = 0; firstNewSegmentIndex$iv < minSegmentsSize$iv2 && Intrinsics.areEqual((Object)thisSegments$iv.get(firstNewSegmentIndex$iv), (Object)otherSegments$iv.get(firstNewSegmentIndex$iv)); ++firstNewSegmentIndex$iv) {
        }
        if (firstNewSegmentIndex$iv == minSegmentsSize$iv2) {
            Object minSegmentsSize$iv2 = $this$commonRelativeTo$iv;
            ByteString byteString = ((Path)minSegmentsSize$iv2).bytes;
            minSegmentsSize$iv2 = byteString;
            minSegmentsSize$iv2 = other2222;
            minSegmentsSize$iv2 = ((Path)minSegmentsSize$iv2).bytes;
            if (byteString.getSize$okio() == ((ByteString)minSegmentsSize$iv2).getSize$okio()) {
                boolean other2222 = true;
                other2222 = false;
                String other2222 = ".";
                minSegmentsSize$iv2 = Companion;
                return okio.Path$Companion.get(other2222, false);
            }
        }
        if (!(otherSegments$iv.subList(firstNewSegmentIndex$iv, otherSegments$iv.size()).indexOf(_PathKt.access$getDOT_DOT$p()) == -1)) {
            other2222 = "Impossible relative path to resolve: " + $this$commonRelativeTo$iv + " and " + other2222;
            throw new IllegalArgumentException(other2222.toString());
        }
        Buffer buffer$iv = new Buffer();
        ByteString byteString = _PathKt.access$getSlash((Path)other2222);
        if (byteString == null && (byteString = _PathKt.access$getSlash($this$commonRelativeTo$iv)) == null) {
            byteString = _PathKt.access$toSlash(DIRECTORY_SEPARATOR);
        }
        ByteString slash$iv = byteString;
        int n = var3_7.size();
        for (i$iv = firstNewSegmentIndex$iv; i$iv < n; ++i$iv) {
            buffer$iv.write(_PathKt.access$getDOT_DOT$p());
            buffer$iv.write(slash$iv);
        }
        n = thisSegments$iv.size();
        for (i$iv = firstNewSegmentIndex$iv; i$iv < n; ++i$iv) {
            buffer$iv.write(thisSegments$iv.get(i$iv));
            buffer$iv.write(slash$iv);
        }
        return _PathKt.toPath(buffer$iv, false);
    }

    public final File toFile() {
        return new File(this.toString());
    }

    @IgnoreJRERequirement
    public final java.nio.file.Path toNioPath() {
        java.nio.file.Path path = Paths.get(this.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(toString())");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        Path $this$commonEquals$iv = this;
        if (other instanceof Path) {
            Path path;
            void var2_2;
            Path path2;
            path2 = path2;
            path2 = var2_2;
            if (Intrinsics.areEqual((Object)path.bytes, (Object)path2.bytes)) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        Path path = this;
        Path path2 = path;
        path2 = path;
        return path.bytes.hashCode();
    }

    public final String toString() {
        Path path = this;
        Path path2 = path;
        path2 = path;
        return path.bytes.utf8();
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        DIRECTORY_SEPARATOR = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\nJ\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\nJ\u001b\u0010\f\u001a\u00020\u0006*\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokio/Path$Companion;", "", "()V", "DIRECTORY_SEPARATOR", "", "toOkioPath", "Lokio/Path;", "Ljava/io/File;", "normalize", "", "get", "Ljava/nio/file/Path;", "toPath", "okio"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        @JvmOverloads
        public static Path get(String $this$toPath, boolean normalize) {
            void var1_1;
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
            return _PathKt.commonToPath(string, (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        @JvmOverloads
        public final Path get(File $this$toOkioPath, boolean normalize) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toOkioPath, (String)"<this>");
            String string = var1_1.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            return okio.Path$Companion.get(string, (boolean)var2_2);
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

