/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._UtilKt;
import okio.internal._BufferKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020'H\u0016J \u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020'2\u0006\u0010 \u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010%\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020'H\u0016J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J\b\u00100\u001a\u00020\"H\u0016J\b\u00101\u001a\u00020\"H\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u0012H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0018\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020\u00122\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u000208H\u0016J\u0010\u0010;\u001a\u0002082\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010<\u001a\u00020\"H\u0016J\n\u0010=\u001a\u0004\u0018\u000108H\u0016J\b\u0010>\u001a\u000208H\u0016J\u0010\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020\u0012H\u0016J\u0010\u0010@\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u000208H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068\u00d6\u0002X\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lokio/RealBufferedSource;", "Lokio/BufferedSource;", "source", "Lokio/Source;", "(Lokio/Source;)V", "buffer", "Lokio/Buffer;", "getBuffer$annotations", "()V", "getBuffer", "()Lokio/Buffer;", "bufferField", "closed", "", "close", "", "exhausted", "indexOf", "", "b", "", "fromIndex", "toIndex", "bytes", "Lokio/ByteString;", "indexOfElement", "targetBytes", "inputStream", "Ljava/io/InputStream;", "isOpen", "peek", "rangeEquals", "offset", "bytesOffset", "", "byteCount", "read", "sink", "Ljava/nio/ByteBuffer;", "", "readAll", "Lokio/Sink;", "readByte", "readByteArray", "readByteString", "readDecimalLong", "readFully", "readHexadecimalUnsignedLong", "readInt", "readIntLe", "readLong", "readLongLe", "readShort", "", "readShortLe", "readString", "", "charset", "Ljava/nio/charset/Charset;", "readUtf8", "readUtf8CodePoint", "readUtf8Line", "readUtf8LineStrict", "limit", "request", "require", "select", "options", "Lokio/Options;", "skip", "timeout", "Lokio/Timeout;", "toString", "okio"})
public final class RealBufferedSource
implements BufferedSource {
    @JvmField
    public final Source source;
    @JvmField
    public final Buffer bufferField;
    @JvmField
    public boolean closed;

    /*
     * WARNING - void declaration
     */
    public RealBufferedSource(Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = var1_1;
        this.bufferField = new Buffer();
    }

    @Override
    public final Buffer getBuffer() {
        return this.bufferField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        RealBufferedSource $this$commonRead$iv = this;
        if (!(byteCount >= 0L)) {
            sink2 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(sink2.toString());
        }
        if (!(!$this$commonRead$iv.closed)) {
            sink2 = "closed";
            throw new IllegalStateException(sink2.toString());
        }
        RealBufferedSource realBufferedSource = $this$commonRead$iv;
        if (realBufferedSource.bufferField.size() == 0L) {
            realBufferedSource = $this$commonRead$iv;
            long l = $this$commonRead$iv.source.read(realBufferedSource.bufferField, 8192L);
            if (l == -1L) {
                return -1L;
            }
        }
        realBufferedSource = $this$commonRead$iv;
        long l = realBufferedSource.bufferField.size();
        long toRead$iv = Math.min((long)var2_2, l);
        realBufferedSource = $this$commonRead$iv;
        return realBufferedSource.bufferField.read((Buffer)var1_1, toRead$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean exhausted() {
        Object $this$commonExhausted$iv = this;
        if (!(!((RealBufferedSource)$this$commonExhausted$iv).closed)) {
            $this$commonExhausted$iv = "closed";
            throw new IllegalStateException($this$commonExhausted$iv.toString());
        }
        RealBufferedSource realBufferedSource = $this$commonExhausted$iv;
        if (realBufferedSource.bufferField.exhausted()) {
            void var1_1;
            realBufferedSource = var1_1;
            if (((RealBufferedSource)$this$commonExhausted$iv).source.read(realBufferedSource.bufferField, 8192L) == -1L) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void require(long byteCount) {
        void var1_1;
        RealBufferedSource realBufferedSource = this;
        if (!realBufferedSource.request((long)var1_1)) {
            throw new EOFException();
        }
    }

    private boolean request(long byteCount2) {
        block3: {
            RealBufferedSource realBufferedSource;
            RealBufferedSource $this$commonRequest$iv = this;
            if (!(byteCount2 >= 0L)) {
                String byteCount2 = "byteCount < 0: " + byteCount2;
                throw new IllegalArgumentException(byteCount2.toString());
            }
            if (!(!$this$commonRequest$iv.closed)) {
                String byteCount2 = "closed";
                throw new IllegalStateException(byteCount2.toString());
            }
            do {
                long byteCount2;
                realBufferedSource = $this$commonRequest$iv;
                if (realBufferedSource.bufferField.size() >= byteCount2) break block3;
                realBufferedSource = $this$commonRequest$iv;
            } while ($this$commonRequest$iv.source.read(realBufferedSource.bufferField, 8192L) != -1L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte readByte() {
        void var1_1;
        RealBufferedSource $this$commonReadByte$iv = this;
        $this$commonReadByte$iv.require(1L);
        return var1_1.bufferField.readByte();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString readByteString(long byteCount) {
        void var1_1;
        void var3_2;
        RealBufferedSource $this$commonReadByteString$iv = this;
        $this$commonReadByteString$iv.require(byteCount);
        return var3_2.bufferField.readByteString((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int select(Options options) {
        void var3_5;
        void var2_2;
        ByteString byteString;
        int index$iv;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        RealBufferedSource $this$commonSelect$iv = this;
        if (!(!$this$commonSelect$iv.closed)) {
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        block4: while (true) {
            RealBufferedSource realBufferedSource = $this$commonSelect$iv;
            index$iv = _BufferKt.selectPrefix(realBufferedSource.bufferField, options, true);
            switch (index$iv) {
                case -1: {
                    return -1;
                }
                case -2: {
                    realBufferedSource = $this$commonSelect$iv;
                    if ($this$commonSelect$iv.source.read(realBufferedSource.bufferField, 8192L) != -1L) continue block4;
                    return -1;
                }
            }
            break;
        }
        byteString = ((Options)((Object)byteString)).getByteStrings$okio()[index$iv];
        int selectedSize$iv = byteString.getSize$okio();
        byteString = var2_2;
        ((RealBufferedSource)((Object)byteString)).bufferField.skip((long)var3_5);
        return index$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] readByteArray(long byteCount) {
        void var1_1;
        void var3_2;
        RealBufferedSource $this$commonReadByteArray$iv = this;
        $this$commonReadByteArray$iv.require(byteCount);
        return var3_2.bufferField.readByteArray((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(ByteBuffer sink2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        RealBufferedSource realBufferedSource = this;
        if (realBufferedSource.bufferField.size() == 0L) {
            realBufferedSource = this;
            long l = this.source.read(realBufferedSource.bufferField, 8192L);
            if (l == -1L) {
                return -1;
            }
        }
        realBufferedSource = this;
        return realBufferedSource.bufferField.read((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readAll(Sink sink2) {
        void var3_3;
        RealBufferedSource realBufferedSource;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        RealBufferedSource $this$commonReadAll$iv = this;
        long totalBytesWritten$iv = 0L;
        while (true) {
            realBufferedSource = $this$commonReadAll$iv;
            if ($this$commonReadAll$iv.source.read(realBufferedSource.bufferField, 8192L) == -1L) break;
            realBufferedSource = $this$commonReadAll$iv;
            long emitByteCount$iv = realBufferedSource.bufferField.completeSegmentByteCount();
            if (emitByteCount$iv <= 0L) continue;
            totalBytesWritten$iv += emitByteCount$iv;
            realBufferedSource = $this$commonReadAll$iv;
            sink2.write(realBufferedSource.bufferField, emitByteCount$iv);
        }
        realBufferedSource = $this$commonReadAll$iv;
        if (realBufferedSource.bufferField.size() > 0L) {
            void var1_1;
            void var2_2;
            realBufferedSource = $this$commonReadAll$iv;
            totalBytesWritten$iv += realBufferedSource.bufferField.size();
            RealBufferedSource realBufferedSource2 = $this$commonReadAll$iv;
            realBufferedSource = realBufferedSource2;
            realBufferedSource = var2_2;
            var1_1.write(realBufferedSource2.bufferField, realBufferedSource.bufferField.size());
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readUtf8(long byteCount) {
        void var1_1;
        void var3_2;
        RealBufferedSource $this$commonReadUtf8$iv = this;
        $this$commonReadUtf8$iv.require(byteCount);
        return var3_2.bufferField.readUtf8((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readString(Charset charset) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.bufferField.writeAll(this.source);
        realBufferedSource = this;
        return realBufferedSource.bufferField.readString((Charset)var1_1);
    }

    @Override
    public final String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readUtf8LineStrict(long limit22) {
        void var1_1;
        void var3_3;
        long limit22;
        RealBufferedSource $this$commonReadUtf8LineStrict$iv = this;
        if (!(limit22 >= 0L)) {
            String limit22 = "limit < 0: " + limit22;
            throw new IllegalArgumentException(limit22.toString());
        }
        long scanLength$iv = limit22 == Long.MAX_VALUE ? Long.MAX_VALUE : limit22 + 1L;
        long newline$iv = $this$commonReadUtf8LineStrict$iv.indexOf((byte)10, 0L, scanLength$iv);
        if (newline$iv != -1L) {
            RealBufferedSource realBufferedSource = $this$commonReadUtf8LineStrict$iv;
            return _BufferKt.readUtf8Line(realBufferedSource.bufferField, newline$iv);
        }
        if (scanLength$iv < Long.MAX_VALUE && $this$commonReadUtf8LineStrict$iv.request(scanLength$iv)) {
            RealBufferedSource realBufferedSource = $this$commonReadUtf8LineStrict$iv;
            if (realBufferedSource.bufferField.getByte(scanLength$iv - 1L) == 13 && $this$commonReadUtf8LineStrict$iv.request(scanLength$iv + 1L)) {
                realBufferedSource = $this$commonReadUtf8LineStrict$iv;
                if (realBufferedSource.bufferField.getByte(scanLength$iv) == 10) {
                    realBufferedSource = $this$commonReadUtf8LineStrict$iv;
                    return _BufferKt.readUtf8Line(realBufferedSource.bufferField, scanLength$iv);
                }
            }
        }
        Buffer data$iv = new Buffer();
        RealBufferedSource realBufferedSource = $this$commonReadUtf8LineStrict$iv;
        RealBufferedSource realBufferedSource2 = realBufferedSource;
        realBufferedSource2 = $this$commonReadUtf8LineStrict$iv;
        long b$iv$iv = realBufferedSource2.bufferField.size();
        realBufferedSource.bufferField.copyTo(data$iv, 0L, Math.min(32L, b$iv$iv));
        realBufferedSource2 = var3_3;
        throw new EOFException("\\n not found: limit=" + Math.min(realBufferedSource2.bufferField.size(), (long)var1_1) + " content=" + data$iv.readByteString().hex() + '\u2026');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short readShort() {
        void var1_1;
        RealBufferedSource $this$commonReadShort$iv = this;
        $this$commonReadShort$iv.require(2L);
        return var1_1.bufferField.readShort();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short readShortLe() {
        void var1_1;
        RealBufferedSource $this$commonReadShortLe$iv = this;
        $this$commonReadShortLe$iv.require(2L);
        return var1_1.bufferField.readShortLe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readInt() {
        void var1_1;
        RealBufferedSource $this$commonReadInt$iv = this;
        $this$commonReadInt$iv.require(4L);
        return var1_1.bufferField.readInt();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readIntLe() {
        void var1_1;
        RealBufferedSource $this$commonReadIntLe$iv = this;
        $this$commonReadIntLe$iv.require(4L);
        return var1_1.bufferField.readIntLe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readLongLe() {
        void var1_1;
        RealBufferedSource $this$commonReadLongLe$iv = this;
        $this$commonReadLongLe$iv.require(8L);
        return var1_1.bufferField.readLongLe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readHexadecimalUnsignedLong() {
        void var1_1;
        RealBufferedSource $this$commonReadHexadecimalUnsignedLong$iv = this;
        $this$commonReadHexadecimalUnsignedLong$iv.require(1L);
        int pos$iv = 0;
        while ($this$commonReadHexadecimalUnsignedLong$iv.request(pos$iv + 1)) {
            RealBufferedSource realBufferedSource = $this$commonReadHexadecimalUnsignedLong$iv;
            byte b$iv = realBufferedSource.bufferField.getByte(pos$iv);
            if (!(b$iv >= 48 && b$iv <= 57 || b$iv >= 97 && b$iv <= 102 || b$iv >= 65 && b$iv <= 70)) {
                void var3_3;
                if (pos$iv != 0) break;
                StringBuilder stringBuilder = new StringBuilder("Expected leading [0-9a-fA-F] character but was 0x");
                String string = Integer.toString((int)var3_3, CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                throw new NumberFormatException(stringBuilder.append(string).toString());
            }
            ++pos$iv;
        }
        void var3_5 = var1_1;
        return var3_5.bufferField.readHexadecimalUnsignedLong();
    }

    @Override
    public final void skip(long byteCount) {
        long toSkip$iv;
        RealBufferedSource $this$commonSkip$iv = this;
        if (!(!$this$commonSkip$iv.closed)) {
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        for (void byteCount$iv = var1_1; byteCount$iv > 0L; byteCount$iv -= toSkip$iv) {
            RealBufferedSource realBufferedSource = $this$commonSkip$iv;
            if (realBufferedSource.bufferField.size() == 0L) {
                realBufferedSource = $this$commonSkip$iv;
                if ($this$commonSkip$iv.source.read(realBufferedSource.bufferField, 8192L) == -1L) {
                    throw new EOFException();
                }
            }
            realBufferedSource = $this$commonSkip$iv;
            long l = realBufferedSource.bufferField.size();
            toSkip$iv = Math.min((long)byteCount$iv, l);
            realBufferedSource = $this$commonSkip$iv;
            realBufferedSource.bufferField.skip(toSkip$iv);
        }
    }

    public final long indexOf(byte b) {
        return this.indexOf((byte)0, 0L, Long.MAX_VALUE);
    }

    private long indexOf(byte b2, long fromIndex, long toIndex) {
        RealBufferedSource $this$commonIndexOf$iv = this;
        long fromIndex$iv = 0L;
        if (!(!$this$commonIndexOf$iv.closed)) {
            String b2 = "closed";
            throw new IllegalStateException(b2.toString());
        }
        if (!(0L <= 0L ? 0L <= toIndex : false)) {
            String b2 = "fromIndex=" + 0L + " toIndex=" + toIndex;
            throw new IllegalArgumentException(b2.toString());
        }
        while (fromIndex$iv < toIndex) {
            long lastBufferSize$iv;
            block8: {
                block7: {
                    byte b2;
                    RealBufferedSource realBufferedSource = $this$commonIndexOf$iv;
                    long result$iv = realBufferedSource.bufferField.indexOf(b2, fromIndex$iv, toIndex);
                    if (result$iv != -1L) {
                        return result$iv;
                    }
                    realBufferedSource = $this$commonIndexOf$iv;
                    lastBufferSize$iv = realBufferedSource.bufferField.size();
                    if (lastBufferSize$iv >= toIndex) break block7;
                    realBufferedSource = $this$commonIndexOf$iv;
                    if ($this$commonIndexOf$iv.source.read(realBufferedSource.bufferField, 8192L) != -1L) break block8;
                }
                return -1L;
            }
            fromIndex$iv = Math.max(fromIndex$iv, lastBufferSize$iv);
        }
        return -1L;
    }

    @Override
    public final InputStream inputStream() {
        return new InputStream(this){
            private /* synthetic */ RealBufferedSource this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final int read() {
                if (this.this$0.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSource realBufferedSource = this.this$0;
                if (realBufferedSource.bufferField.size() == 0L) {
                    realBufferedSource = this.this$0;
                    long l = this.this$0.source.read(realBufferedSource.bufferField, 8192L);
                    if (l == -1L) {
                        return -1;
                    }
                }
                realBufferedSource = this.this$0;
                byte by = realBufferedSource.bufferField.readByte();
                return by & 0xFF;
            }

            /*
             * WARNING - void declaration
             */
            public final int read(byte[] data, int offset, int byteCount) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (this.this$0.closed) {
                    throw new IOException("closed");
                }
                _UtilKt.checkOffsetAndCount(data.length, offset, byteCount);
                RealBufferedSource realBufferedSource = this.this$0;
                if (realBufferedSource.bufferField.size() == 0L) {
                    realBufferedSource = this.this$0;
                    long l = this.this$0.source.read(realBufferedSource.bufferField, 8192L);
                    if (l == -1L) {
                        return -1;
                    }
                }
                realBufferedSource = this.this$0;
                return realBufferedSource.bufferField.read((byte[])var1_1, (int)var2_2, (int)var3_3);
            }

            public final int available() {
                if (this.this$0.closed) {
                    throw new IOException("closed");
                }
                RealBufferedSource realBufferedSource = this.this$0;
                long l = realBufferedSource.bufferField.size();
                return (int)Math.min(l, Integer.MAX_VALUE);
            }

            public final void close() {
                this.this$0.close();
            }

            public final String toString() {
                return this.this$0 + ".inputStream()";
            }
        };
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        RealBufferedSource $this$commonClose$iv = this;
        if (!$this$commonClose$iv.closed) {
            void var1_1;
            $this$commonClose$iv.closed = true;
            $this$commonClose$iv.source.close();
            var1_1.bufferField.clear();
        }
    }

    @Override
    public final Timeout timeout() {
        RealBufferedSource realBufferedSource = this;
        return realBufferedSource.source.timeout();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        RealBufferedSource $this$commonToString$iv = this;
        return "buffer(" + var1_1.source + ')';
    }
}

