/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okio.Segment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\b\u0010\u0014\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lokio/SegmentPool;", "", "()V", "HASH_BUCKET_COUNT", "", "LOCK", "Lokio/Segment;", "MAX_SIZE", "getMAX_SIZE", "()I", "byteCount", "getByteCount", "hashBuckets", "", "Ljava/util/concurrent/atomic/AtomicReference;", "[Ljava/util/concurrent/atomic/AtomicReference;", "firstRef", "recycle", "", "segment", "take", "okio"})
public final class SegmentPool {
    private static SegmentPool INSTANCE = new SegmentPool();
    private static final int MAX_SIZE = 65536;
    private static final Segment LOCK = new Segment(new byte[0], 0, 0, false, false);
    private static final int HASH_BUCKET_COUNT = Integer.highestOneBit((Runtime.getRuntime().availableProcessors() << 1) - 1);
    private static final AtomicReference<Segment>[] hashBuckets;

    private SegmentPool() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Segment take() {
        void var1_1;
        void var0;
        AtomicReference<Segment> firstRef = SegmentPool.firstRef();
        Segment first = firstRef.getAndSet(LOCK);
        if (first == LOCK) {
            return new Segment();
        }
        if (first == null) {
            firstRef.set(null);
            return new Segment();
        }
        var0.set(first.next);
        first.next = null;
        first.limit = 0;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void recycle(Segment segment) {
        void var2_2;
        void var1_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (!(segment.next == null && segment.prev == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (segment.shared) {
            return;
        }
        AtomicReference<Segment> firstRef = SegmentPool.firstRef();
        Segment first = firstRef.get();
        if (first == LOCK) {
            return;
        }
        Segment segment2 = first;
        int firstLimit = segment2 != null ? segment2.limit : 0;
        if (firstLimit >= 65536) {
            return;
        }
        segment.next = first;
        segment.pos = 0;
        segment.limit = var3_4 + 8192;
        if (!var1_3.compareAndSet(var2_2, segment)) {
            var0.next = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AtomicReference<Segment> firstRef() {
        void var0;
        int hashBucket = (int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L);
        return hashBuckets[var0];
    }

    static {
        int n = 0;
        int n2 = HASH_BUCKET_COUNT;
        AtomicReference[] atomicReferenceArray = new AtomicReference[n2];
        while (n < n2) {
            int n3 = n++;
            atomicReferenceArray[n3] = new AtomicReference();
        }
        hashBuckets = atomicReferenceArray;
    }
}

