/*
 * Decompiled with CFR 0.152.
 */
package okio;

import androidx.compose.animation.core.AnimationSpecKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio._UtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0015\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\r\u0010 \u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\u001d\u0010$\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0015H\u0016J\r\u0010)\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b.J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0015H\u0016J(\u00100\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J(\u00100\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u0015H\u0016J\b\u00108\u001a\u00020\u0001H\u0016J\b\u00109\u001a\u00020\u0001H\u0016J\b\u0010:\u001a\u00020\u0004H\u0016J\b\u0010;\u001a\u00020\u0001H\u0002J\b\u0010<\u001a\u00020\u0010H\u0016J\u0010\u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?H\u0016J%\u0010=\u001a\u00020\u00132\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\bBJ\b\u0010C\u001a\u00020DH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006E"}, d2={"Lokio/SegmentedByteString;", "Lokio/ByteString;", "segments", "", "", "directory", "", "([[B[I)V", "getDirectory$okio", "()[I", "getSegments$okio", "()[[B", "[[B", "asByteBuffer", "Ljava/nio/ByteBuffer;", "base64", "", "base64Url", "copyInto", "", "offset", "", "target", "targetOffset", "byteCount", "digest", "algorithm", "digest$okio", "equals", "", "other", "", "getSize", "getSize$okio", "hashCode", "hex", "hmac", "key", "hmac$okio", "indexOf", "fromIndex", "internalArray", "internalArray$okio", "internalGet", "", "pos", "internalGet$okio", "lastIndexOf", "rangeEquals", "otherOffset", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toByteString", "toString", "write", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$okio", "writeReplace", "Ljava/lang/Object;", "okio"})
public final class SegmentedByteString
extends ByteString {
    private final transient byte[][] segments;
    private final transient int[] directory;

    /*
     * WARNING - void declaration
     */
    public SegmentedByteString(byte[][] segments, int[] directory) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(ByteString.EMPTY.getData$okio());
        this.segments = var1_1;
        this.directory = var2_2;
    }

    public final byte[][] getSegments$okio() {
        return this.segments;
    }

    public final int[] getDirectory$okio() {
        return this.directory;
    }

    @Override
    public final String base64() {
        return this.toByteString().base64();
    }

    @Override
    public final String hex() {
        return this.toByteString().hex();
    }

    @Override
    public final ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString digest$okio(String algorithm) {
        void var1_1;
        SegmentedByteString $this$forEachSegment$iv;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest $this$digest_u24lambda_u2d1 = MessageDigest.getInstance(algorithm);
        SegmentedByteString segmentedByteString = $this$forEachSegment$iv = this;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.segments).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            segmentedByteString = $this$forEachSegment$iv;
            int segmentPos$iv = segmentedByteString.directory[segmentCount$iv + s$iv];
            segmentedByteString = $this$forEachSegment$iv;
            int nextSegmentOffset$iv = segmentedByteString.directory[s$iv];
            segmentedByteString = $this$forEachSegment$iv;
            pos$iv = nextSegmentOffset$iv - pos$iv;
            byte[] data = segmentedByteString.segments[s$iv];
            $this$digest_u24lambda_u2d1.update(data, (int)offset, (int)byteCount);
            int n = nextSegmentOffset$iv;
        }
        byte[] digestBytes = $this$digest_u24lambda_u2d1.digest();
        Intrinsics.checkNotNullExpressionValue((Object)digestBytes, (String)"digestBytes");
        return new ByteString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        void var1_1;
        int n;
        SegmentedByteString $this$commonSubstring$iv = this;
        int endIndex$iv2 = _UtilKt.resolveDefaultParameter($this$commonSubstring$iv, endIndex);
        if (!(beginIndex >= 0)) {
            String string = "beginIndex=" + beginIndex + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentedByteString segmentedByteString = $this$commonSubstring$iv;
        if (!(endIndex$iv2 <= ((ByteString)segmentedByteString).getSize$okio())) {
            segmentedByteString = $this$commonSubstring$iv;
            String string = "endIndex=" + endIndex$iv2 + " > length(" + ((ByteString)segmentedByteString).getSize$okio() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        int subLen$iv = endIndex$iv2 - beginIndex;
        if (!(subLen$iv >= 0)) {
            String endIndex$iv2 = "endIndex=" + endIndex$iv2 + " < beginIndex=" + beginIndex;
            throw new IllegalArgumentException(endIndex$iv2.toString());
        }
        if (beginIndex == 0 && endIndex$iv2 == ((ByteString)(segmentedByteString = $this$commonSubstring$iv)).getSize$okio()) {
            return $this$commonSubstring$iv;
        }
        if (beginIndex == endIndex$iv2) {
            return ByteString.EMPTY;
        }
        int beginSegment$iv = AnimationSpecKt.segment((SegmentedByteString)$this$commonSubstring$iv, (int)beginIndex);
        int endSegment$iv = AnimationSpecKt.segment((SegmentedByteString)$this$commonSubstring$iv, (int)(endIndex$iv2 - 1));
        segmentedByteString = $this$commonSubstring$iv;
        Object[] objectArray = (Object[])segmentedByteString.segments;
        int n2 = endSegment$iv + 1;
        byte[][] newSegments$iv = (byte[][])ArraysKt.copyOfRange((Object[])objectArray, (int)beginSegment$iv, (int)n2);
        int[] newDirectory$iv = new int[((Object[])newSegments$iv).length << 1];
        int index$iv = 0;
        int s$iv = beginSegment$iv;
        if (s$iv <= endSegment$iv) {
            while (true) {
                segmentedByteString = $this$commonSubstring$iv;
                newDirectory$iv[index$iv] = Math.min(segmentedByteString.directory[s$iv] - beginIndex, subLen$iv);
                int n3 = index$iv++;
                SegmentedByteString segmentedByteString2 = $this$commonSubstring$iv;
                segmentedByteString = segmentedByteString2;
                segmentedByteString = $this$commonSubstring$iv;
                newDirectory$iv[n3 + ((Object[])newSegments$iv).length] = segmentedByteString2.directory[s$iv + ((Object[])segmentedByteString.segments).length];
                if (s$iv == endSegment$iv) break;
                ++s$iv;
            }
        }
        if (beginSegment$iv == 0) {
            n = 0;
        } else {
            void var3_4;
            segmentedByteString = var3_4;
            n = segmentedByteString.directory[beginSegment$iv - 1];
        }
        int segmentOffset$iv = n;
        int n4 = ((Object[])newSegments$iv).length;
        newDirectory$iv[n4] = newDirectory$iv[n4] + (var1_1 - segmentOffset$iv);
        return new SegmentedByteString(newSegments$iv, newDirectory$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte internalGet$okio(int pos) {
        void var1_1;
        void var3_4;
        void var2_2;
        int n;
        SegmentedByteString $this$commonInternalGet$iv;
        SegmentedByteString segmentedByteString = $this$commonInternalGet$iv = this;
        segmentedByteString = $this$commonInternalGet$iv;
        _UtilKt.checkOffsetAndCount($this$commonInternalGet$iv.directory[((Object[])segmentedByteString.segments).length - 1], pos, 1L);
        int segment$iv = AnimationSpecKt.segment((SegmentedByteString)$this$commonInternalGet$iv, (int)pos);
        if (segment$iv == 0) {
            n = 0;
        } else {
            segmentedByteString = $this$commonInternalGet$iv;
            n = segmentedByteString.directory[segment$iv - 1];
        }
        int segmentOffset$iv = n;
        SegmentedByteString segmentedByteString2 = $this$commonInternalGet$iv;
        segmentedByteString = segmentedByteString2;
        segmentedByteString = $this$commonInternalGet$iv;
        int segmentPos$iv = segmentedByteString2.directory[segment$iv + ((Object[])segmentedByteString.segments).length];
        segmentedByteString = var2_2;
        return segmentedByteString.segments[var3_4][var1_1 - segmentOffset$iv + segmentPos$iv];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSize$okio() {
        void var1_1;
        SegmentedByteString $this$commonGetSize$iv;
        SegmentedByteString segmentedByteString = $this$commonGetSize$iv = this;
        segmentedByteString = var1_1;
        return $this$commonGetSize$iv.directory[((Object[])segmentedByteString.segments).length - 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] toByteArray() {
        void var2_3;
        SegmentedByteString $this$commonToByteArray$iv = this;
        Object object = $this$commonToByteArray$iv;
        byte[] result$iv = new byte[((ByteString)$this$commonToByteArray$iv).getSize$okio()];
        int resultPos$iv = 0;
        SegmentedByteString $this$forEachSegment$iv$iv = $this$commonToByteArray$iv;
        object = $this$forEachSegment$iv$iv;
        int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.segments).length;
        int pos$iv$iv = 0;
        for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            object = $this$forEachSegment$iv$iv;
            int segmentPos$iv$iv = ((SegmentedByteString)object).directory[segmentCount$iv$iv + s$iv$iv];
            object = $this$forEachSegment$iv$iv;
            int nextSegmentOffset$iv$iv = ((SegmentedByteString)object).directory[s$iv$iv];
            object = $this$forEachSegment$iv$iv;
            byte[] byArray = ((SegmentedByteString)object).segments[s$iv$iv];
            pos$iv$iv = nextSegmentOffset$iv$iv - pos$iv$iv;
            object = byArray;
            void v1 = offset$iv;
            ArraysKt.copyInto((byte[])byArray, (byte[])result$iv, (int)resultPos$iv, (int)v1, (int)(v1 + byteCount$iv));
            resultPos$iv += byteCount$iv;
            int n = nextSegmentOffset$iv$iv;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write$okio(Buffer buffer, int offset2, int byteCount) {
        void var3_4;
        void var1_1;
        void $this$forEachSegment$iv$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        SegmentedByteString offset2 = this;
        int endIndex$iv$iv = byteCount + 0;
        int s$iv$iv = AnimationSpecKt.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)0);
        int pos$iv$iv = 0;
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            void var9_12;
            int n;
            if (s$iv$iv == 0) {
                n = 0;
            } else {
                var9_12 = $this$forEachSegment$iv$iv;
                n = var9_12.directory[s$iv$iv - 1];
            }
            int segmentOffset$iv$iv = n;
            var9_12 = $this$forEachSegment$iv$iv;
            int segmentSize$iv$iv = var9_12.directory[s$iv$iv] - segmentOffset$iv$iv;
            void v1 = $this$forEachSegment$iv$iv;
            var9_12 = v1;
            var9_12 = $this$forEachSegment$iv$iv;
            int segmentPos$iv$iv322 = v1.directory[((Object[])var9_12.segments).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int offset$iv$iv = segmentPos$iv$iv322 + (pos$iv$iv - segmentOffset$iv$iv);
            void segmentPos$iv$iv322 = $this$forEachSegment$iv$iv;
            int n2 = offset$iv$iv;
            offset$iv$iv = byteCount$iv$iv;
            int segmentPos$iv$iv322 = n2;
            byte[] data$iv = segmentPos$iv$iv322.segments[s$iv$iv];
            void v3 = offset$iv;
            Segment segment$iv = new Segment(data$iv, (int)v3, (int)(v3 + byteCount$iv), true, false);
            if (buffer.head == null) {
                buffer.head = segment$iv.next = (segment$iv.prev = segment$iv);
            } else {
                Segment segment = buffer.head;
                Intrinsics.checkNotNull((Object)segment);
                Segment segment2 = segment.prev;
                Intrinsics.checkNotNull((Object)segment2);
                segment2.push(segment$iv);
            }
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        void v6 = var1_1;
        v6.setSize$okio(v6.size() + (long)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        void pos$iv$iv;
        void $this$forEachSegment$iv$iv;
        SegmentedByteString segmentedByteString;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SegmentedByteString $this$commonRangeEquals$iv = this;
        if (offset < 0 || offset > ((ByteString)(segmentedByteString = $this$commonRangeEquals$iv)).getSize$okio() - byteCount) {
            return false;
        }
        int otherOffset$iv = 0;
        int endIndex$iv$iv = offset + byteCount;
        int s$iv$iv = AnimationSpecKt.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)offset);
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            int n;
            if (s$iv$iv == 0) {
                n = 0;
            } else {
                segmentedByteString = $this$forEachSegment$iv$iv;
                n = segmentedByteString.directory[s$iv$iv - 1];
            }
            int segmentOffset$iv$iv = n;
            segmentedByteString = $this$forEachSegment$iv$iv;
            int segmentSize$iv$iv = segmentedByteString.directory[s$iv$iv] - segmentOffset$iv$iv;
            void v1 = $this$forEachSegment$iv$iv;
            segmentedByteString = v1;
            segmentedByteString = $this$forEachSegment$iv$iv;
            int segmentPos$iv$iv322 = v1.directory[((Object[])segmentedByteString.segments).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int offset$iv$iv = segmentPos$iv$iv322 + (pos$iv$iv - segmentOffset$iv$iv);
            void segmentPos$iv$iv322 = $this$forEachSegment$iv$iv;
            int n2 = offset$iv$iv;
            offset$iv$iv = byteCount$iv$iv;
            int segmentPos$iv$iv322 = n2;
            byte[] data$iv = segmentPos$iv$iv322.segments[s$iv$iv];
            if (!other.rangeEquals(otherOffset$iv, data$iv, (int)offset$iv, (int)byteCount$iv)) {
                return false;
            }
            otherOffset$iv += byteCount$iv;
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        void pos$iv$iv;
        void $this$forEachSegment$iv$iv;
        SegmentedByteString segmentedByteString;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SegmentedByteString $this$commonRangeEquals$iv = this;
        if (offset < 0 || offset > ((ByteString)(segmentedByteString = $this$commonRangeEquals$iv)).getSize$okio() - byteCount || otherOffset < 0 || otherOffset > other.length - byteCount) {
            return false;
        }
        int endIndex$iv$iv = offset + byteCount;
        int s$iv$iv = AnimationSpecKt.segment((SegmentedByteString)$this$forEachSegment$iv$iv, (int)offset);
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void otherOffset$iv;
            void offset$iv;
            int n;
            if (s$iv$iv == 0) {
                n = 0;
            } else {
                segmentedByteString = $this$forEachSegment$iv$iv;
                n = segmentedByteString.directory[s$iv$iv - 1];
            }
            int segmentOffset$iv$iv = n;
            segmentedByteString = $this$forEachSegment$iv$iv;
            int segmentSize$iv$iv = segmentedByteString.directory[s$iv$iv] - segmentOffset$iv$iv;
            void v1 = $this$forEachSegment$iv$iv;
            segmentedByteString = v1;
            segmentedByteString = $this$forEachSegment$iv$iv;
            int segmentPos$iv$iv322 = v1.directory[((Object[])segmentedByteString.segments).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int offset$iv$iv = segmentPos$iv$iv322 + (pos$iv$iv - segmentOffset$iv$iv);
            void segmentPos$iv$iv322 = $this$forEachSegment$iv$iv;
            int n2 = offset$iv$iv;
            offset$iv$iv = byteCount$iv$iv;
            int segmentPos$iv$iv322 = n2;
            byte[] byArray = segmentPos$iv$iv322.segments[s$iv$iv];
            if (!_UtilKt.arrayRangeEquals(byArray, (int)offset$iv, other, (int)otherOffset$iv, (int)byteCount$iv)) {
                return false;
            }
            otherOffset$iv += byteCount$iv;
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(byte[] other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toByteString().indexOf((byte[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(byte[] other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toByteString().lastIndexOf((byte[])var1_1, (int)var2_2);
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    public final byte[] internalArray$okio() {
        return this.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        SegmentedByteString $this$commonEquals$iv = this;
        if (other == $this$commonEquals$iv) {
            return true;
        }
        if (other instanceof ByteString) {
            void var2_2;
            void var1_1;
            ByteString byteString = (ByteString)other;
            ByteString byteString2 = byteString;
            byteString2 = $this$commonEquals$iv;
            return byteString.getSize$okio() == byteString2.getSize$okio() && $this$commonEquals$iv.rangeEquals(0, (ByteString)var1_1, 0, (byteString2 = var2_2).getSize$okio());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var2_2;
        void var1_1;
        SegmentedByteString $this$forEachSegment$iv$iv;
        SegmentedByteString $this$commonHashCode$iv = this;
        int result$iv = $this$commonHashCode$iv.getHashCode$okio();
        if (result$iv != 0) {
            return result$iv;
        }
        result$iv = 1;
        SegmentedByteString segmentedByteString = $this$forEachSegment$iv$iv = $this$commonHashCode$iv;
        int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.segments).length;
        int pos$iv$iv = 0;
        for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            segmentedByteString = $this$forEachSegment$iv$iv;
            int segmentPos$iv$iv = segmentedByteString.directory[segmentCount$iv$iv + s$iv$iv];
            segmentedByteString = $this$forEachSegment$iv$iv;
            int nextSegmentOffset$iv$iv = segmentedByteString.directory[s$iv$iv];
            segmentedByteString = $this$forEachSegment$iv$iv;
            pos$iv$iv = nextSegmentOffset$iv$iv - pos$iv$iv;
            byte[] data$iv = segmentedByteString.segments[s$iv$iv];
            void limit$iv = offset$iv + byteCount$iv;
            for (void i$iv = offset$iv; i$iv < limit$iv; ++i$iv) {
                result$iv = result$iv * 31 + data$iv[i$iv];
            }
            int n = nextSegmentOffset$iv$iv;
        }
        var1_1.setHashCode$okio(result$iv);
        return (int)var2_2;
    }

    @Override
    public final String toString() {
        return this.toByteString().toString();
    }
}

