/*
 * Decompiled with CFR 0.152.
 */
package okio;

import androidx.compose.runtime.saveable.SaveableStateHolderKt;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileSystem;
import okio.InflaterSource;
import okio.Okio;
import okio.Okio__OkioKt;
import okio.Path;
import okio.Source;
import okio.internal.FixedLengthSource;
import okio.internal.ZipKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lokio/ZipFileSystem;", "Lokio/FileSystem;", "zipPath", "Lokio/Path;", "fileSystem", "entries", "", "Lokio/internal/ZipEntry;", "comment", "", "(Lokio/Path;Lokio/FileSystem;Ljava/util/Map;Ljava/lang/String;)V", "appendingSink", "Lokio/Sink;", "file", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "canonicalizeInternal", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "Companion", "okio"})
public final class ZipFileSystem
extends FileSystem {
    private final Path zipPath;
    private final FileSystem fileSystem;
    private final Map<Path, SaveableStateHolderKt> entries;
    @Deprecated
    private static final Path ROOT;

    /*
     * WARNING - void declaration
     */
    public ZipFileSystem(Path zipPath, FileSystem fileSystem, Map<Path, SaveableStateHolderKt> entries, String comment) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.zipPath = var1_1;
        this.fileSystem = var2_2;
        this.entries = var3_3;
    }

    private static Path canonicalizeInternal(Path path) {
        Path path2;
        return ROOT.resolve(path2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Okio metadataOrNull$3008182d(Path path) {
        void var2_2;
        Source source2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = ZipFileSystem.canonicalizeInternal(path);
        SaveableStateHolderKt saveableStateHolderKt = this.entries.get(canonicalPath);
        if (saveableStateHolderKt == null) {
            return null;
        }
        SaveableStateHolderKt entry = saveableStateHolderKt;
        Okio basicMetadata = new Okio(!entry.isDirectory(), entry.isDirectory(), null, entry.isDirectory() ? null : Long.valueOf(entry.getSize()), null, entry.getLastModifiedAtMillis(), null, null, 128);
        if (entry.getOffset() == -1L) {
            return basicMetadata;
        }
        Closeable $this$use$iv = this.fileSystem.openReadOnly(this.zipPath);
        BufferedSource result$iv = null;
        Throwable thrown$iv = null;
        try {
            object = (FileHandle)$this$use$iv;
            source2 = ((FileHandle)object).source(source2.getOffset());
            result$iv = Okio__OkioKt.buffer(source2);
        }
        catch (Throwable throwable) {
            object = throwable;
            thrown$iv = throwable;
        }
        try {
            void var3_3;
            void v2 = var3_3;
            if (v2 != null) {
                v2.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        BufferedSource bufferedSource = result$iv;
        Intrinsics.checkNotNull((Object)bufferedSource);
        source2 = bufferedSource;
        return ZipKt.readLocalHeader$25a7697d(bufferedSource, (Okio)var2_2);
    }

    @Override
    public final FileHandle openReadOnly(Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    public final FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException("zip entries are not writable");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Source source(Path file) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path canonicalPath = ZipFileSystem.canonicalizeInternal(file);
        SaveableStateHolderKt saveableStateHolderKt = this.entries.get(canonicalPath);
        if (saveableStateHolderKt == null) {
            throw new FileNotFoundException("no such file: " + file);
        }
        SaveableStateHolderKt entry = saveableStateHolderKt;
        Closeable $this$use$iv = this.fileSystem.openReadOnly(this.zipPath);
        BufferedSource result$iv = null;
        Throwable thrown$iv = null;
        try {
            object = (FileHandle)$this$use$iv;
            object = ((FileHandle)object).source(entry.getOffset());
            result$iv = Okio__OkioKt.buffer((Source)object);
        }
        catch (Throwable throwable) {
            object = throwable;
            thrown$iv = throwable;
        }
        try {
            Closeable closeable = $this$use$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        void v4 = var3_3;
        Intrinsics.checkNotNull((Object)v4);
        void source2 = v4;
        ZipKt.skipLocalHeader((BufferedSource)v4);
        if (entry.getCompressionMethod() == 0) {
            return new FixedLengthSource((Source)source2, entry.getSize(), true);
        }
        InflaterSource inflaterSource = new InflaterSource(new FixedLengthSource((Source)source2, entry.getCompressedSize(), true), new Inflater(true));
        return new FixedLengthSource((Source)var2_2, var1_1.getSize(), false);
    }

    @Override
    public final void createDirectory(Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        throw new IOException("zip file systems are read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException("zip file systems are read-only");
    }

    @Override
    public final void delete(Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw new IOException("zip file systems are read-only");
    }

    static {
        new Companion(0);
        boolean bl = true;
        bl = false;
        String string = "/";
        Path.Companion companion = Path.Companion;
        ROOT = Path.Companion.get(string, false);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokio/ZipFileSystem$Companion;", "", "()V", "ROOT", "Lokio/Path;", "getROOT", "()Lokio/Path;", "okio"})
    static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

