/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import androidx.compose.runtime.saveable.SaveableStateHolderKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.ZipFileSystem;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lokio/internal/EocdRecord;", "", "entryCount", "", "centralDirectoryOffset", "commentByteCount", "", "(JJI)V", "getCentralDirectoryOffset", "()J", "getCommentByteCount", "()I", "getEntryCount", "okio"})
public class ZipKt {
    private final long entryCount;
    private final long centralDirectoryOffset;
    private final int commentByteCount;

    /*
     * WARNING - void declaration
     */
    public static final ZipFileSystem openZip(Path zipPath, FileSystem fileSystem, Function1<? super SaveableStateHolderKt, Boolean> predicate) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Closeable closeable = fileSystem.openReadOnly(zipPath);
        Throwable throwable = null;
        try {
            void var1_2;
            ZipFileSystem zipFileSystem;
            Object object;
            Throwable diskWithCentralDir32;
            Object object2;
            String comment;
            ZipKt record;
            long l;
            int n;
            Object object3;
            FileHandle fileHandle;
            block42: {
                long eocdOffset;
                block41: {
                    fileHandle = (FileHandle)closeable;
                    long scanOffset = fileHandle.size() - 22L;
                    if (scanOffset < 0L) {
                        throw new IOException("not a zip: size=" + fileHandle.size());
                    }
                    long stopOffset = Math.max(scanOffset - 65536L, 0L);
                    do {
                        try (BufferedSource source2 = Okio.buffer(fileHandle.source(scanOffset));){
                            long l2;
                            if (source2.readIntLe() != 101010256) continue;
                            eocdOffset = scanOffset;
                            object3 = source2;
                            int n2 = object3.readShortLe() & 0xFFFF;
                            n = object3.readShortLe() & 0xFFFF;
                            long l3 = object3.readShortLe() & 0xFFFF;
                            if (l3 != (l2 = (long)(object3.readShortLe() & 0xFFFF)) || n2 != 0 || n != 0) {
                                throw new IOException("unsupported zip: spanned");
                            }
                            object3.skip(4L);
                            l = (long)object3.readIntLe() & 0xFFFFFFFFL;
                            int n3 = object3.readShortLe() & 0xFFFF;
                            record = new ZipKt(l3, l, n3);
                            comment = source2.readUtf8(record.getCommentByteCount());
                            break block41;
                        }
                    } while ((record += -1L) >= stopOffset);
                    throw new IOException("not a zip: end of central directory signature not found");
                }
                long zip64LocatorOffset = eocdOffset - 20L;
                if (zip64LocatorOffset > 0L) {
                    Closeable stopOffset = Okio.buffer(fileHandle.source(zip64LocatorOffset));
                    object2 = null;
                    try {
                        BufferedSource zip64LocatorSource = (BufferedSource)stopOffset;
                        if (zip64LocatorSource.readIntLe() != 117853008) break block42;
                        int diskWithCentralDir32 = zip64LocatorSource.readIntLe();
                        long zip64EocdRecordOffset = zip64LocatorSource.readLongLe();
                        int n4 = zip64LocatorSource.readIntLe();
                        if (n4 != 1 || diskWithCentralDir32 != 0) {
                            throw new IOException("unsupported zip: spanned");
                        }
                        Closeable closeable2 = Okio.buffer(fileHandle.source(zip64EocdRecordOffset));
                        diskWithCentralDir32 = null;
                        try {
                            BufferedSource zip64EocdSource = (BufferedSource)closeable2;
                            int zip64EocdSignature = zip64EocdSource.readIntLe();
                            if (zip64EocdSignature != 101075792) {
                                throw new IOException("bad zip: expected " + ZipKt.getHex(101075792) + " but was " + ZipKt.getHex(zip64EocdSignature));
                            }
                            ZipKt zipKt = record;
                            object3 = zip64EocdSource;
                            object3.skip(12L);
                            n = object3.readIntLe();
                            int n5 = object3.readIntLe();
                            long l4 = object3.readLongLe();
                            long l5 = object3.readLongLe();
                            if (l4 != l5 || n != 0 || n5 != 0) {
                                throw new IOException("unsupported zip: spanned");
                            }
                            object3.skip(8L);
                            long l6 = object3.readLongLe();
                            record = new ZipKt(l4, l6, zipKt.getCommentByteCount());
                        }
                        catch (Throwable throwable2) {
                            object = throwable2;
                            diskWithCentralDir32 = throwable2;
                            throw object;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)diskWithCentralDir32);
                        }
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        object2 = throwable3;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)stopOffset, (Throwable)object2);
                    }
                }
            }
            List entries = new ArrayList();
            object2 = Okio.buffer(fileHandle.source(record.getCentralDirectoryOffset()));
            Throwable throwable5 = null;
            try {
                BufferedSource source3 = (BufferedSource)object2;
                long l7 = record.getEntryCount();
                for (long i = 0L; i < l7; ++i) {
                    boolean bl;
                    Long l8;
                    object3 = source3;
                    Intrinsics.checkNotNullParameter((Object)object3, (String)"<this>");
                    int n6 = object3.readIntLe();
                    if (n6 != 33639248) {
                        throw new IOException("bad zip: expected " + ZipKt.getHex(33639248) + " but was " + ZipKt.getHex(n6));
                    }
                    object3.skip(4L);
                    n = object3.readShortLe() & 0xFFFF;
                    if ((n & 1) != 0) {
                        throw new IOException("unsupported zip: general purpose bit flag=" + ZipKt.getHex(n));
                    }
                    int n7 = object3.readShortLe() & 0xFFFF;
                    int n8 = object3.readShortLe() & 0xFFFF;
                    int n9 = object3.readShortLe() & 0xFFFF;
                    int n10 = n8;
                    int diskWithCentralDir32 = n9;
                    if (n10 == -1) {
                        l8 = null;
                    } else {
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        gregorianCalendar.set(14, 0);
                        n = 1980 + (diskWithCentralDir32 >> 9 & 0x7F);
                        int n11 = diskWithCentralDir32 >> 5 & 0xF;
                        int n12 = n10 >> 11 & 0x1F;
                        int n13 = n10 >> 5 & 0x3F;
                        int n14 = (n10 & 0x1F) << 1;
                        gregorianCalendar.set(n, n11 - 1, diskWithCentralDir32 &= 0x1F, n12, n13, n14);
                        l8 = gregorianCalendar.getTime().getTime();
                    }
                    Long l9 = l8;
                    l = (long)object3.readIntLe() & 0xFFFFFFFFL;
                    Ref.LongRef longRef = new Ref.LongRef();
                    new Ref.LongRef().element = (long)object3.readIntLe() & 0xFFFFFFFFL;
                    diskWithCentralDir32 = new Ref.LongRef();
                    new Ref.LongRef().element = (long)object3.readIntLe() & 0xFFFFFFFFL;
                    n10 = object3.readShortLe() & 0xFFFF;
                    int n15 = object3.readShortLe() & 0xFFFF;
                    n = object3.readShortLe() & 0xFFFF;
                    object3.skip(8L);
                    Ref.LongRef longRef2 = new Ref.LongRef();
                    new Ref.LongRef().element = (long)object3.readIntLe() & 0xFFFFFFFFL;
                    object = object3.readUtf8(n10);
                    if (StringsKt.contains$default((CharSequence)((CharSequence)object), (char)'\u0000', (boolean)false, (int)2, null)) {
                        throw new IOException("bad zip: filename contains 0x00");
                    }
                    long l10 = 0L;
                    if (((Ref.LongRef)diskWithCentralDir32).element == 0xFFFFFFFFL) {
                        l10 = 8L;
                    }
                    if (longRef.element == 0xFFFFFFFFL) {
                        l10 += 8L;
                    }
                    if (longRef2.element == 0xFFFFFFFFL) {
                        l10 += 8L;
                    }
                    long l11 = l10;
                    Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                    ZipKt.readExtra((BufferedSource)object3, n15, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>(booleanRef, l11, (Ref.LongRef)diskWithCentralDir32, (BufferedSource)object3, longRef, longRef2){
                        private /* synthetic */ Ref.BooleanRef $hasZip64Extra;
                        private /* synthetic */ long $requiredZip64ExtraSize;
                        private /* synthetic */ Ref.LongRef $size;
                        private /* synthetic */ BufferedSource $this_readEntry;
                        private /* synthetic */ Ref.LongRef $compressedSize;
                        private /* synthetic */ Ref.LongRef $offset;
                        {
                            void var2_2;
                            void var1_1;
                            this.$hasZip64Extra = var1_1;
                            this.$requiredZip64ExtraSize = var2_2;
                            this.$size = $size;
                            this.$this_readEntry = $receiver;
                            this.$compressedSize = $compressedSize;
                            this.$offset = $offset;
                            super(2);
                        }
                    }));
                    if (l11 > 0L && !booleanRef.element) {
                        throw new IOException("bad zip: zip64 extra required but absent");
                    }
                    object3 = object3.readUtf8(n);
                    boolean bl2 = true;
                    boolean bl3 = false;
                    String string = "/";
                    Path.Companion companion = Path.Companion;
                    Path path = Path.Companion.get(string, false).resolve((String)object);
                    SaveableStateHolderKt entry = new SaveableStateHolderKt(path, bl = StringsKt.endsWith$default((String)object, (String)"/", (boolean)false, (int)2, null), (String)object3, l, longRef.element, ((Ref.LongRef)diskWithCentralDir32).element, n7, l9, longRef2.element);
                    if (entry.getOffset() >= record.getCentralDirectoryOffset()) {
                        throw new IOException("bad zip: local file header offset >= central directory offset");
                    }
                    if (!((Boolean)predicate.invoke((Object)entry)).booleanValue()) continue;
                    ((Collection)entries).add(entry);
                }
            }
            catch (Throwable throwable6) {
                Throwable throwable7 = throwable6;
                throwable5 = throwable6;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable5);
            }
            Map<Path, SaveableStateHolderKt> index = ZipKt.buildIndex(entries);
            zipFileSystem = new ZipFileSystem((Path)((Object)zipFileSystem), (FileSystem)var1_2, index, comment);
            return zipFileSystem;
        }
        catch (Throwable throwable8) {
            Throwable throwable9 = throwable8;
            throwable = throwable8;
            throw throwable9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Map<Path, SaveableStateHolderKt> buildIndex(List<SaveableStateHolderKt> entries) {
        boolean bl = true;
        bl = false;
        Object object = "/";
        Path.Companion companion = Path.Companion;
        Path root = Path.Companion.get((String)object, false);
        Pair[] pairArray = new Pair[1];
        object = pairArray;
        pairArray[0] = TuplesKt.to((Object)root, (Object)new SaveableStateHolderKt(root, true, null, 0L, 0L, 0L, 0, null, 0L, 508));
        Map result = MapsKt.mutableMapOf((Pair[])object);
        entries = entries;
        block0: for (SaveableStateHolderKt entry : CollectionsKt.sortedWith((Iterable)entries, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (SaveableStateHolderKt)a;
                SaveableStateHolderKt it = (SaveableStateHolderKt)comparable;
                comparable = a.getCanonicalPath();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)var1_1.getCanonicalPath());
            }
        })) {
            SaveableStateHolderKt child;
            SaveableStateHolderKt saveableStateHolderKt = result.put(entry.getCanonicalPath(), entry);
            if (saveableStateHolderKt != null) continue;
            while (child.getCanonicalPath().parent() != null) {
                Path parentPath;
                SaveableStateHolderKt parentEntry = (SaveableStateHolderKt)result.get(parentPath);
                if (parentEntry != null) {
                    ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                    continue block0;
                }
                parentEntry = new SaveableStateHolderKt(parentPath, true, null, 0L, 0L, 0L, 0, null, 0L, 508);
                result.put(saveableStateHolderKt, parentEntry);
                ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                child = parentEntry;
            }
        }
        return companion;
    }

    /*
     * WARNING - void declaration
     */
    private static final void readExtra(BufferedSource $this$readExtra, int extraSize, Function2<? super Integer, ? super Long, Unit> block) {
        long dataSize;
        for (long remaining = (long)extraSize; remaining != 0L; remaining -= dataSize) {
            if (remaining < 4L) {
                throw new IOException("bad zip: truncated header in extra field");
            }
            int headerId = $this$readExtra.readShortLe() & 0xFFFF;
            dataSize = (long)$this$readExtra.readShortLe() & 0xFFFFL;
            if ((remaining -= 4L) < dataSize) {
                throw new IOException("bad zip: truncated value in extra field");
            }
            $this$readExtra.require(dataSize);
            long sizeBefore = $this$readExtra.getBuffer().size();
            block.invoke((Object)headerId, (Object)dataSize);
            long fieldRemaining = dataSize + $this$readExtra.getBuffer().size() - sizeBefore;
            if (fieldRemaining < 0L) {
                void var1_1;
                throw new IOException("unsupported zip: too many bytes processed for " + (int)var1_1);
            }
            if (fieldRemaining <= 0L) continue;
            $this$readExtra.getBuffer().skip(fieldRemaining);
        }
    }

    public static final void skipLocalHeader(BufferedSource $this$skipLocalHeader) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$skipLocalHeader, (String)"<this>");
        ZipKt.readOrSkipLocalHeader$25a7697d(bufferedSource, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final Okio readLocalHeader$25a7697d(BufferedSource $this$readLocalHeader, Okio basicMetadata) {
        void var1_1;
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$readLocalHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)basicMetadata, (String)"basicMetadata");
        Okio okio = ZipKt.readOrSkipLocalHeader$25a7697d(bufferedSource, (Okio)var1_1);
        Intrinsics.checkNotNull((Object)okio);
        return okio;
    }

    /*
     * WARNING - void declaration
     */
    private static final Okio readOrSkipLocalHeader$25a7697d(BufferedSource $this$readOrSkipLocalHeader, Okio basicMetadata) {
        void var3_3;
        void var2_2;
        void var1_1;
        BufferedSource bufferedSource;
        Ref.ObjectRef lastModifiedAtMillis = new Ref.ObjectRef();
        Okio okio = basicMetadata;
        new Ref.ObjectRef().element = okio != null ? okio.getLastModifiedAtMillis() : null;
        Ref.ObjectRef lastAccessedAtMillis = new Ref.ObjectRef();
        Ref.ObjectRef createdAtMillis = new Ref.ObjectRef();
        int signature = $this$readOrSkipLocalHeader.readIntLe();
        if (signature != 67324752) {
            throw new IOException("bad zip: expected " + ZipKt.getHex(67324752) + " but was " + ZipKt.getHex(signature));
        }
        $this$readOrSkipLocalHeader.skip(2L);
        int bitFlag = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipKt.getHex(bitFlag));
        }
        $this$readOrSkipLocalHeader.skip(18L);
        long fileNameLength = (long)$this$readOrSkipLocalHeader.readShortLe() & 0xFFFFL;
        int extraSize = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        $this$readOrSkipLocalHeader.skip(fileNameLength);
        if (basicMetadata == null) {
            $this$readOrSkipLocalHeader.skip(extraSize);
            return null;
        }
        ZipKt.readExtra($this$readOrSkipLocalHeader, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>(bufferedSource, (Ref.ObjectRef<Long>)lastModifiedAtMillis, (Ref.ObjectRef<Long>)lastAccessedAtMillis, (Ref.ObjectRef<Long>)createdAtMillis){
            private /* synthetic */ BufferedSource $this_readOrSkipLocalHeader;
            private /* synthetic */ Ref.ObjectRef<Long> $lastModifiedAtMillis;
            private /* synthetic */ Ref.ObjectRef<Long> $lastAccessedAtMillis;
            private /* synthetic */ Ref.ObjectRef<Long> $createdAtMillis;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$this_readOrSkipLocalHeader = var1_1;
                this.$lastModifiedAtMillis = var2_2;
                this.$lastAccessedAtMillis = var3_3;
                this.$createdAtMillis = $createdAtMillis;
                super(2);
            }
        }));
        return new Okio(basicMetadata.isRegularFile(), basicMetadata.isDirectory(), null, var1_1.getSize(), (Long)createdAtMillis.element, (Long)var2_2.element, (Long)var3_3.element, null, 128);
    }

    private static final String getHex(int $this$hex) {
        int n;
        StringBuilder stringBuilder = new StringBuilder("0x");
        String string = Integer.toString(n, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private ZipKt(long entryCount, long centralDirectoryOffset, int commentByteCount) {
        void var3_2;
        void var1_1;
        this.entryCount = var1_1;
        this.centralDirectoryOffset = var3_2;
        this.commentByteCount = commentByteCount;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getCentralDirectoryOffset() {
        return this.centralDirectoryOffset;
    }

    public int getCommentByteCount() {
        return this.commentByteCount;
    }
}

