/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/foundation/text/UndoManager;", "", "maxStoredCharacters", "", "(I)V", "forceNextSnapshot", "", "lastSnapshot", "", "Ljava/lang/Long;", "getMaxStoredCharacters", "()I", "redoStack", "Landroidx/compose/foundation/text/UndoManager$Entry;", "storedCharacters", "undoStack", "", "makeSnapshot", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "redo", "removeLastUndo", "snapshotIfNeeded", "now", "undo", "Entry", "foundation"})
public final class UndoManager {
    private final int maxStoredCharacters;
    private Entry undoStack;
    private Entry redoStack;
    private int storedCharacters;
    private Long lastSnapshot;
    private boolean forceNextSnapshot;

    /*
     * WARNING - void declaration
     */
    private UndoManager(int maxStoredCharacters) {
        void var1_1;
        this.maxStoredCharacters = var1_1;
    }

    public /* synthetic */ UndoManager(int n, int n2) {
        this(100000);
    }

    /*
     * WARNING - void declaration
     */
    public final void snapshotIfNeeded(TextFieldValue value2, long now) {
        block3: {
            void var1_1;
            void var2_2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (this.forceNextSnapshot) break block2;
                Long l = this.lastSnapshot;
                if (now <= (l != null ? l : 0L) + (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) break block3;
            }
            this.lastSnapshot = (long)var2_2;
            this.makeSnapshot((TextFieldValue)var1_1);
        }
    }

    public final void forceNextSnapshot() {
        this.forceNextSnapshot = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void makeSnapshot(TextFieldValue value2) {
        void var1_1;
        Entry entry;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.forceNextSnapshot = false;
        Entry entry2 = this.undoStack;
        if (Intrinsics.areEqual((Object)value2, (Object)(entry2 != null ? entry2.getValue() : null))) {
            return;
        }
        if (Intrinsics.areEqual((Object)value2.getText(), (entry = this.undoStack) != null && (entry = entry.getValue()) != null ? entry.getText() : null)) {
            Entry entry3 = this.undoStack;
            if (entry3 == null) {
                return;
            }
            entry3.setValue(value2);
            return;
        }
        Entry entry4 = this.undoStack;
        this.undoStack = new Entry(entry4, value2);
        this.redoStack = null;
        this.storedCharacters += var1_1.getText().length();
        if (this.storedCharacters > this.maxStoredCharacters) {
            this.removeLastUndo();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeLastUndo() {
        void var1_1;
        Entry entry;
        Entry entry2 = this.undoStack;
        if ((entry2 != null ? entry2.getNext() : null) == null) {
            return;
        }
        while (((entry = entry2) != null && (entry = entry.getNext()) != null ? entry.getNext() : null) != null) {
            entry2 = entry2.getNext();
        }
        void v1 = var1_1;
        if (v1 == null) {
            return;
        }
        v1.setNext(null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TextFieldValue undo() {
        void var2_2;
        TextFieldValue textFieldValue;
        Entry nextEntry;
        Entry entry = this.undoStack;
        if (entry == null) return null;
        Entry undoEntry = entry;
        Entry entry2 = entry.getNext();
        if (entry2 == null) return null;
        this.undoStack = nextEntry = entry2;
        this.storedCharacters -= undoEntry.getValue().getText().length();
        textFieldValue = textFieldValue.getValue();
        Entry entry3 = this.redoStack;
        this.redoStack = new Entry(entry3, textFieldValue);
        TextFieldValue textFieldValue2 = var2_2.getValue();
        return textFieldValue2;
    }

    /*
     * WARNING - void declaration
     */
    public final TextFieldValue redo() {
        Entry entry = this.redoStack;
        if (entry != null) {
            void var1_1;
            Entry redoEntry = entry;
            this.redoStack = redoEntry.getNext();
            TextFieldValue textFieldValue = redoEntry.getValue();
            Entry entry2 = this.undoStack;
            this.undoStack = new Entry(entry2, textFieldValue);
            this.storedCharacters += redoEntry.getValue().getText().length();
            return var1_1.getValue();
        }
        return null;
    }

    public UndoManager() {
        this(0, 1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/foundation/text/UndoManager$Entry;", "", "next", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "(Landroidx/compose/foundation/text/UndoManager$Entry;Landroidx/compose/ui/text/input/TextFieldValue;)V", "getNext", "()Landroidx/compose/foundation/text/UndoManager$Entry;", "setNext", "(Landroidx/compose/foundation/text/UndoManager$Entry;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "foundation"})
    static final class Entry {
        private Entry next;
        private TextFieldValue value;

        /*
         * WARNING - void declaration
         */
        public Entry(Entry next, TextFieldValue value2) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.next = var1_1;
            this.value = var2_2;
        }

        public final Entry getNext() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        public final void setNext(Entry entry) {
            void var1_1;
            this.next = var1_1;
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void setValue(TextFieldValue textFieldValue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = var1_1;
        }
    }
}

