/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.Unit;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.Utils;
import retrofit2.http.Streaming;

final class BuiltInConverters
extends Converter.Factory {
    private boolean checkForKotlinUnit = true;

    BuiltInConverters() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type == ResponseBody.class) {
            void var2_2;
            if (Utils.isAnnotationPresent((Annotation[])var2_2, Streaming.class)) {
                return StreamingResponseBodyConverter.INSTANCE;
            }
            return BufferingResponseBodyConverter.INSTANCE;
        }
        if (type == Void.class) {
            return VoidResponseBodyConverter.INSTANCE;
        }
        if (this.checkForKotlinUnit) {
            try {
                void var1_1;
                if (var1_1 == Unit.class) {
                    return UnitResponseBodyConverter.INSTANCE;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.checkForKotlinUnit = false;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        void var1_1;
        if (RequestBody.class.isAssignableFrom(Utils.getRawType((Type)var1_1))) {
            return RequestBodyConverter.INSTANCE;
        }
        return null;
    }

    static final class StreamingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final StreamingResponseBodyConverter INSTANCE = new StreamingResponseBodyConverter();

        StreamingResponseBodyConverter() {
        }
    }

    static final class BufferingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final BufferingResponseBodyConverter INSTANCE = new BufferingResponseBodyConverter();

        BufferingResponseBodyConverter() {
        }

        private static ResponseBody convert(ResponseBody value) throws IOException {
            ResponseBody responseBody;
            try {
                responseBody = Utils.buffer(value);
            }
            catch (Throwable throwable) {
                ResponseBody responseBody2;
                responseBody2.close();
                throw throwable;
            }
            value.close();
            return responseBody;
        }
    }

    static final class VoidResponseBodyConverter
    implements Converter<ResponseBody, Void> {
        static final VoidResponseBodyConverter INSTANCE = new VoidResponseBodyConverter();

        VoidResponseBodyConverter() {
        }
    }

    static final class UnitResponseBodyConverter
    implements Converter<ResponseBody, Unit> {
        static final UnitResponseBodyConverter INSTANCE = new UnitResponseBodyConverter();

        UnitResponseBodyConverter() {
        }
    }

    static final class RequestBodyConverter
    implements Converter<RequestBody, RequestBody> {
        static final RequestBodyConverter INSTANCE = new RequestBodyConverter();

        RequestBodyConverter() {
        }
    }

    static final class ToStringConverter
    implements Converter<Object, String> {
        static final ToStringConverter INSTANCE = new ToStringConverter();

        ToStringConverter() {
        }
    }
}

