/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.SkipCallbackExecutor;
import retrofit2.Utils;

final class DefaultCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Executor callbackExecutor;

    /*
     * WARNING - void declaration
     */
    DefaultCallAdapterFactory(@Nullable Executor callbackExecutor) {
        void var1_1;
        this.callbackExecutor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final CallAdapter<?, ?> get$6dcb2c11(Type returnType, Annotation[] annotations) {
        void var2_2;
        void var1_1;
        Type type = returnType;
        if (Utils.getRawType(type) != Call.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
        }
        Type responseType = Utils.getParameterUpperBound(0, (ParameterizedType)returnType);
        Executor executor = Utils.isAnnotationPresent(annotations, SkipCallbackExecutor.class) ? null : this.callbackExecutor;
        return new CallAdapter<Object, Call<?>>(){
            private /* synthetic */ Type val$responseType;
            private /* synthetic */ Executor val$executor;
            {
                this.val$responseType = type;
                this.val$executor = executor;
            }

            @Override
            public final Type responseType() {
                return this.val$responseType;
            }
        };
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        final Executor callbackExecutor;
        final Call<T> delegate;

        /*
         * WARNING - void declaration
         */
        ExecutorCallbackCall(Executor callbackExecutor, Call<T> delegate) {
            void var2_2;
            void var1_1;
            this.callbackExecutor = var1_1;
            this.delegate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void enqueue(Callback<T> callback) {
            void var1_1;
            Objects.requireNonNull(callback, "callback == null");
            this.delegate.enqueue(new Callback<T>(){
                private /* synthetic */ Callback val$callback;
                private /* synthetic */ ExecutorCallbackCall this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$callback = callback;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void onResponse(Call<T> call, Response<T> response) {
                    void var2_2;
                    1 v0 = this;
                    this.this$0.callbackExecutor.execute(() -> v0.lambda$onResponse$0(v0.val$callback, (Response)var2_2));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void onFailure(Call<T> call, Throwable t) {
                    void var2_2;
                    1 v0 = this;
                    this.this$0.callbackExecutor.execute(() -> v0.lambda$onFailure$1(v0.val$callback, (Throwable)var2_2));
                }

                /*
                 * WARNING - void declaration
                 */
                private /* synthetic */ void lambda$onFailure$1(Callback callback, Throwable t) {
                    void var2_2;
                    callback.onFailure(this.this$0, (Throwable)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                private /* synthetic */ void lambda$onResponse$0(Callback callback, Response response) {
                    void var2_2;
                    void var1_1;
                    if (this.this$0.delegate.isCanceled()) {
                        callback.onFailure(this.this$0, new IOException("Canceled"));
                        return;
                    }
                    var1_1.onResponse(this.this$0, var2_2);
                }
            });
        }

        @Override
        public final void cancel() {
            this.delegate.cancel();
        }

        @Override
        public final boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        public final Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone());
        }

        @Override
        public final Request request() {
            return this.delegate.request();
        }
    }
}

