/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import kotlin.KotlinNullPointerException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Invocation;
import retrofit2.KotlinExtensions;
import retrofit2.OkHttpCall;
import retrofit2.RequestFactory;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.ServiceMethod;
import retrofit2.SkipCallbackExecutorImpl;
import retrofit2.Utils;

abstract class HttpServiceMethod<ResponseT, ReturnT>
extends ServiceMethod<ReturnT> {
    private final RequestFactory requestFactory;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, ResponseT> responseConverter;

    /*
     * WARNING - void declaration
     */
    static <ResponseT, ReturnT> HttpServiceMethod<ResponseT, ReturnT> parseAnnotations(Retrofit retrofit, Method method, RequestFactory requestFactory) {
        void var1_1;
        Retrofit retrofit2;
        void var2_2;
        void var3_3;
        Type adapterType;
        Type responseType;
        boolean isKotlinSuspendFunction = requestFactory.isKotlinSuspendFunction;
        boolean continuationWantsResponse = false;
        Annotation[] annotations = method.getAnnotations();
        if (isKotlinSuspendFunction) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            responseType = Utils.getParameterLowerBound(0, (ParameterizedType)parameterTypes[parameterTypes.length - 1]);
            if (Utils.getRawType(responseType) == Response.class && responseType instanceof ParameterizedType) {
                responseType = Utils.getParameterUpperBound(0, (ParameterizedType)responseType);
                continuationWantsResponse = true;
            }
            adapterType = new Utils.ParameterizedTypeImpl(null, (Type)((Object)Call.class), responseType);
            annotations = SkipCallbackExecutorImpl.ensurePresent(annotations);
        } else {
            adapterType = method.getGenericReturnType();
        }
        CallAdapter<ResponseT, ReturnT> callAdapter = HttpServiceMethod.createCallAdapter(retrofit, method, adapterType, annotations);
        responseType = callAdapter.responseType();
        if (responseType == okhttp3.Response.class) {
            throw Utils.methodError(method, "'" + Utils.getRawType(responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        if (responseType == Response.class) {
            throw Utils.methodError(method, "Response must include generic type (e.g., Response<String>)", new Object[0]);
        }
        if (requestFactory.httpMethod.equals("HEAD") && !Void.class.equals((Object)responseType)) {
            throw Utils.methodError(method, "HEAD method must use Void as response type.", new Object[0]);
        }
        Converter<ResponseBody, ResponseT> responseConverter = HttpServiceMethod.createResponseConverter(retrofit, method, responseType);
        Retrofit callFactory = retrofit.callFactory;
        if (var3_3 == false) {
            return new CallAdapted<ResponseT, ReturnT>(requestFactory, (Call.Factory)callFactory, responseConverter, callAdapter);
        }
        if (continuationWantsResponse) {
            return new SuspendForResponse<ResponseT>(requestFactory, (Call.Factory)callFactory, responseConverter, callAdapter);
        }
        return new SuspendForBody<ResponseT>((RequestFactory)var2_2, (Call.Factory)retrofit2, var1_1, callAdapter, false);
    }

    /*
     * WARNING - void declaration
     */
    private static <ResponseT, ReturnT> CallAdapter<ResponseT, ReturnT> createCallAdapter(Retrofit retrofit, Method method, Type returnType, Annotation[] annotations) {
        try {
            int n;
            Type type;
            Type type2 = type;
            type = returnType;
            void var5_6 = type2;
            type2 = type;
            type = null;
            Objects.requireNonNull(type2, "returnType == null");
            Objects.requireNonNull(var5_6, "annotations == null");
            int n2 = retrofit.callAdapterFactories.size();
            for (int i = n = retrofit.callAdapterFactories.indexOf(type) + 1; i < n2; ++i) {
                CallAdapter<?, ?> callAdapter = retrofit.callAdapterFactories.get(i).get$6dcb2c11(type2, (Annotation[])var5_6);
                if (callAdapter == null) continue;
                return callAdapter;
            }
            StringBuilder stringBuilder = new StringBuilder("Could not locate call adapter for ").append(type2).append(".\n");
            if (type != null) {
                stringBuilder.append("  Skipped:");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuilder.append("\n   * ").append(retrofit.callAdapterFactories.get(n2).getClass().getName());
                }
                stringBuilder.append('\n');
            }
            stringBuilder.append("  Tried:");
            int n3 = retrofit.callAdapterFactories.size();
            for (n2 = n; n2 < n3; ++n2) {
                stringBuilder.append("\n   * ").append(retrofit.callAdapterFactories.get(n2).getClass().getName());
            }
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        catch (RuntimeException e) {
            void var2_3;
            void var0_1;
            void var1_2;
            throw Utils.methodError((Method)var1_2, (Throwable)var0_1, "Unable to create call adapter for %s", var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <ResponseT> Converter<ResponseBody, ResponseT> createResponseConverter(Retrofit retrofit, Method method, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            Type type;
            void var4_5 = type;
            type = responseType;
            return retrofit.nextResponseBodyConverter(null, type, (Annotation[])var4_5);
        }
        catch (RuntimeException e) {
            void var2_3;
            void var0_1;
            void var1_2;
            throw Utils.methodError((Method)var1_2, (Throwable)var0_1, "Unable to create converter for %s", var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    HttpServiceMethod(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requestFactory = var1_1;
        this.callFactory = var2_2;
        this.responseConverter = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    final ReturnT invoke(Object[] args) {
        void var1_1;
        void var2_2;
        OkHttpCall<ResponseT> call = new OkHttpCall<ResponseT>(this.requestFactory, args, this.callFactory, this.responseConverter);
        return this.adapt((Call<ResponseT>)var2_2, (Object[])var1_1);
    }

    @Nullable
    protected abstract ReturnT adapt(Call<ResponseT> var1, Object[] var2);

    static final class CallAdapted<ResponseT, ReturnT>
    extends HttpServiceMethod<ResponseT, ReturnT> {
        private final CallAdapter<ResponseT, ReturnT> callAdapter;

        /*
         * WARNING - void declaration
         */
        CallAdapted(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, ReturnT> callAdapter) {
            super((RequestFactory)var1_1, (Call.Factory)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.callAdapter = callAdapter;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final ReturnT adapt(Call<ResponseT> call, Object[] args) {
            void var1_1;
            return this.callAdapter.adapt((Call<ResponseT>)var1_1);
        }
    }

    static final class SuspendForResponse<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;

        /*
         * WARNING - void declaration
         */
        SuspendForResponse(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter) {
            super((RequestFactory)var1_1, (Call.Factory)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.callAdapter = callAdapter;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Object adapt(Call<ResponseT> call, Object[] args) {
            Exception exception;
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                Continuation continuation2;
                Continuation continuation3 = continuation2 = continuation;
                continuation3 = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)continuation3), 1);
                CancellableContinuation cancellableContinuation = (CancellableContinuation)continuation3;
                cancellableContinuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>((Call)((Object)exception)){
                    private /* synthetic */ Call $this_awaitResponse$inlined;
                    {
                        this.$this_awaitResponse$inlined = call;
                        super(1);
                    }
                });
                exception.enqueue(new Callback<T>(cancellableContinuation){
                    private /* synthetic */ CancellableContinuation $continuation;

                    public final void onResponse(Call<T> call, Response<T> response) {
                        Object object;
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        Continuation continuation = (Continuation)this.$continuation;
                        object = Result.constructor-impl((Object)object);
                        continuation.resumeWith(object);
                    }

                    public final void onFailure(Call<T> call, Throwable t) {
                        Object object;
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        Continuation continuation = (Continuation)this.$continuation;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object));
                        continuation.resumeWith(object);
                    }
                    {
                        void var1_1;
                        this.$continuation = var1_1;
                    }
                });
                Object object = continuation3.getResult();
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)continuation2);
                }
                return object;
            }
            catch (Exception exception2) {
                void var2_2;
                exception = exception2;
                return KotlinExtensions.suspendAndThrow(exception2, var2_2);
            }
        }
    }

    static final class SuspendForBody<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;
        private final boolean isNullable;

        /*
         * WARNING - void declaration
         */
        SuspendForBody(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter, boolean isNullable) {
            super((RequestFactory)var1_1, (Call.Factory)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.callAdapter = callAdapter;
            this.isNullable = false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Object adapt(Call<ResponseT> call, Object[] args) {
            Exception exception;
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                Continuation continuation2;
                if (this.isNullable) {
                    Continuation continuation3;
                    Continuation continuation4 = continuation3 = continuation;
                    continuation4 = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)continuation4), 1);
                    CancellableContinuation cancellableContinuation = (CancellableContinuation)continuation4;
                    cancellableContinuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(call){
                        private /* synthetic */ Call $this_await$inlined;
                        {
                            this.$this_await$inlined = call;
                            super(1);
                        }
                    });
                    call.enqueue(new Callback<T>(cancellableContinuation){
                        private /* synthetic */ CancellableContinuation $continuation;

                        public final void onResponse(Call<T> call, Response<T> response) {
                            Object object;
                            Continuation continuation;
                            Intrinsics.checkParameterIsNotNull(call, (String)"call");
                            Intrinsics.checkParameterIsNotNull(response, (String)"response");
                            if (((Response)response).isSuccessful()) {
                                continuation = (Continuation)this.$continuation;
                                response = ((Response)response).body();
                                response = Result.constructor-impl(response);
                                continuation.resumeWith(response);
                                return;
                            }
                            continuation = (Continuation)this.$continuation;
                            object = new HttpException((Response<?>)object);
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object));
                            continuation.resumeWith(object);
                        }

                        public final void onFailure(Call<T> call, Throwable t) {
                            Object object;
                            Intrinsics.checkParameterIsNotNull(call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            Continuation continuation = (Continuation)this.$continuation;
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object));
                            continuation.resumeWith(object);
                        }
                        {
                            void var1_1;
                            this.$continuation = var1_1;
                        }
                    });
                    Object object = continuation4.getResult();
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)continuation3);
                    }
                    return object;
                }
                Continuation continuation5 = continuation2 = continuation;
                continuation5 = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)continuation5), 1);
                CancellableContinuation cancellableContinuation = (CancellableContinuation)continuation5;
                cancellableContinuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>((Call)((Object)exception)){
                    private /* synthetic */ Call $this_await$inlined;
                    {
                        this.$this_await$inlined = call;
                        super(1);
                    }
                });
                exception.enqueue(new Callback<T>(cancellableContinuation){
                    private /* synthetic */ CancellableContinuation $continuation;

                    /*
                     * WARNING - void declaration
                     */
                    public final void onResponse(Call<T> call, Response<T> response) {
                        Continuation continuation;
                        Object object;
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        if (response.isSuccessful()) {
                            void var3_3;
                            T body = response.body();
                            if (body == null) {
                                Object object2 = call.request().tag(Invocation.class);
                                if (object2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"call.request().tag(Invocation::class.java)!!");
                                call = (Invocation)object2;
                                Method method = ((Invocation)call).method();
                                StringBuilder stringBuilder = new StringBuilder("Response from ");
                                Method method2 = method;
                                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                                Class<?> clazz = method2.getDeclaringClass();
                                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.declaringClass");
                                KotlinNullPointerException e = new KotlinNullPointerException(stringBuilder.append(clazz.getName()).append('.').append(method.getName()).append(" was null but response body type was declared as non-null").toString());
                                response = (Continuation)this.$continuation;
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)object)));
                                response.resumeWith(object);
                                return;
                            }
                            object = (Continuation)this.$continuation;
                            response = object;
                            object = Result.constructor-impl((Object)var3_3);
                            response.resumeWith(object);
                            return;
                        }
                        Continuation continuation2 = (Continuation)this.$continuation;
                        object = new HttpException((Response<?>)continuation);
                        continuation = continuation2;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object));
                        continuation.resumeWith(object);
                    }

                    public final void onFailure(Call<T> call, Throwable t) {
                        Object object;
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        Continuation continuation = (Continuation)this.$continuation;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object));
                        continuation.resumeWith(object);
                    }
                    {
                        void var1_1;
                        this.$continuation = var1_1;
                    }
                });
                Object object = continuation5.getResult();
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)continuation2);
                }
                return object;
            }
            catch (Exception exception2) {
                void var2_2;
                exception = exception2;
                return KotlinExtensions.suspendAndThrow(exception2, var2_2);
            }
        }
    }
}

