/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.RequestFactory;
import retrofit2.Response;
import retrofit2.Utils;

final class OkHttpCall<T>
implements Call<T> {
    private final RequestFactory requestFactory;
    private final Object[] args;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, T> responseConverter;
    private volatile boolean canceled;
    @Nullable
    @GuardedBy(value="this")
    private okhttp3.Call rawCall;
    @Nullable
    @GuardedBy(value="this")
    private Throwable creationFailure;
    @GuardedBy(value="this")
    private boolean executed;

    /*
     * WARNING - void declaration
     */
    OkHttpCall(RequestFactory requestFactory, Object[] args, Call.Factory callFactory, Converter<ResponseBody, T> responseConverter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requestFactory = var1_1;
        this.args = var2_2;
        this.callFactory = var3_3;
        this.responseConverter = responseConverter;
    }

    @Override
    private OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.requestFactory, this.args, this.callFactory, this.responseConverter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized Request request() {
        try {
            return this.getRawCall().request();
        }
        catch (IOException e) {
            void var1_1;
            throw new RuntimeException("Unable to create request.", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GuardedBy(value="this")
    private okhttp3.Call getRawCall() throws IOException {
        okhttp3.Call call = this.rawCall;
        if (call != null) {
            return call;
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw (IOException)this.creationFailure;
            }
            if (this.creationFailure instanceof RuntimeException) {
                throw (RuntimeException)this.creationFailure;
            }
            throw (Error)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall;
        }
        catch (IOException | Error | RuntimeException throwable) {
            void var1_1;
            Throwable e = throwable;
            Utils.throwIfFatal(throwable);
            this.creationFailure = e;
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void enqueue(Callback<T> callback) {
        void var1_1;
        void var2_4;
        Throwable failure;
        okhttp3.Call call;
        Objects.requireNonNull(callback, "callback == null");
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall;
            failure = this.creationFailure;
            if (call == null && failure == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (Throwable throwable) {
                    Throwable t = throwable;
                    Utils.throwIfFatal(throwable);
                    t = this.creationFailure = t;
                }
            }
        }
        if (failure != null) {
            void var3_5;
            callback.onFailure(this, (Throwable)var3_5);
            return;
        }
        if (this.canceled) {
            call.cancel();
        }
        var2_4.enqueue(new okhttp3.Callback(){
            private /* synthetic */ Callback val$callback;
            private /* synthetic */ OkHttpCall this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$callback = callback;
            }

            /*
             * WARNING - void declaration
             */
            public final void onResponse$42f4142c(okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = this.this$0.parseResponse(rawResponse);
                }
                catch (Throwable throwable) {
                    Throwable e = throwable;
                    Utils.throwIfFatal(throwable);
                    this.callFailure(e);
                    return;
                }
                try {
                    this.val$callback.onResponse(this.this$0, response);
                    return;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Throwable t = throwable;
                    Utils.throwIfFatal(throwable);
                    var1_1.printStackTrace();
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void onFailure$1b4f1832(IOException e) {
                void var1_1;
                this.callFailure((Throwable)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            private void callFailure(Throwable e) {
                try {
                    this.val$callback.onFailure(this.this$0, e);
                    return;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Throwable t = throwable;
                    Utils.throwIfFatal(throwable);
                    var1_1.printStackTrace();
                    return;
                }
            }
        });
    }

    private okhttp3.Call createRawCall() throws IOException {
        okhttp3.Call call = this.callFactory.newCall(this.requestFactory.create(this.args));
        return call;
    }

    /*
     * WARNING - void declaration
     */
    final Response<T> parseResponse(okhttp3.Response rawResponse) throws IOException {
        void var1_1;
        void var2_3;
        ResponseBody rawBody = rawResponse.body();
        int code2 = (rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code2 < 200 || code2 >= 300) {
            try {
                ResponseBody code2 = Utils.buffer(rawBody);
                Response response = Response.error(code2, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code2 == 204 || code2 == 205) {
            rawBody.close();
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody((ResponseBody)var2_3);
        try {
            T t = this.responseConverter.convert(catchingBody);
            return Response.success(t, (okhttp3.Response)var1_1);
        }
        catch (RuntimeException e) {
            void var3_6;
            var1_1 = var3_6;
            if (var1_1.thrownException != null) {
                throw var1_1.thrownException;
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void cancel() {
        okhttp3.Call call;
        this.canceled = true;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call = this.rawCall;
        }
        if (call != null) {
            void var1_2;
            var1_2.cancel();
        }
    }

    @Override
    public final boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        /*
         * WARNING - void declaration
         */
        NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            void var2_2;
            void var1_1;
            this.contentType = var1_1;
            this.contentLength = var2_2;
        }

        public final MediaType contentType() {
            return this.contentType;
        }

        public final long contentLength() {
            return this.contentLength;
        }

        public final BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private final BufferedSource delegateSource;
        @Nullable
        IOException thrownException;

        /*
         * WARNING - void declaration
         */
        ExceptionCatchingResponseBody(ResponseBody delegate) {
            void var1_1;
            this.delegate = delegate;
            this.delegateSource = Okio.buffer((Source)new ForwardingSource(this, (Source)var1_1.source()){
                private /* synthetic */ ExceptionCatchingResponseBody this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((Source)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        void var2_3;
                        return super.read(sink, (long)var2_3);
                    }
                    catch (IOException e) {
                        void var1_2;
                        this.this$0.thrownException = e;
                        throw var1_2;
                    }
                }
            });
        }

        public final MediaType contentType() {
            return this.delegate.contentType();
        }

        public final long contentLength() {
            return this.delegate.contentLength();
        }

        public final BufferedSource source() {
            return this.delegateSource;
        }

        public final void close() {
            this.delegate.close();
        }
    }
}

