/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.RequestBuilder;
import retrofit2.Utils;

abstract class ParameterHandler<T> {
    ParameterHandler() {
    }

    abstract void apply(RequestBuilder var1, @Nullable T var2) throws IOException;

    final ParameterHandler<Iterable<T>> iterable() {
        return new ParameterHandler<Iterable<T>>(this){
            private /* synthetic */ ParameterHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }
        };
    }

    final ParameterHandler<Object> array() {
        return new ParameterHandler<Object>(this){
            private /* synthetic */ ParameterHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            final void apply(RequestBuilder builder, @Nullable Object values) throws IOException {
                if (values == null) {
                    return;
                }
                int size = Array.getLength(values);
                for (int i = 0; i < size; ++i) {
                    this.this$0.apply(builder, Array.get(values, i));
                }
            }
        };
    }

    static final class Tag<T>
    extends ParameterHandler<T> {
        final Class<T> cls;

        /*
         * WARNING - void declaration
         */
        Tag(Class<T> cls) {
            void var1_1;
            this.cls = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) {
            void var2_2;
            builder.addTag(this.cls, var2_2);
        }
    }

    static final class Body<T>
    extends ParameterHandler<T> {
        private final Method method;
        private final int p;
        private final Converter<T, RequestBody> converter;

        /*
         * WARNING - void declaration
         */
        Body(Method method, int p, Converter<T, RequestBody> converter) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.converter = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) {
            void var3_4;
            void var1_1;
            if (value == null) {
                throw Utils.parameterError(this.method, this.p, "Body parameter value must not be null.", new Object[0]);
            }
            try {
                RequestBody body = this.converter.convert(value);
            }
            catch (IOException e) {
                void var2_3;
                void var1_2;
                throw Utils.parameterError(this.method, (Throwable)var1_2, this.p, "Unable to convert " + var2_3 + " to RequestBody", new Object[0]);
            }
            var1_1.setBody((RequestBody)var3_4);
        }
    }

    static final class PartMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final Converter<T, RequestBody> valueConverter;
        private final String transferEncoding;

        /*
         * WARNING - void declaration
         */
        PartMap(Method method, int p, Converter<T, RequestBody> valueConverter, String transferEncoding) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.valueConverter = var3_3;
            this.transferEncoding = transferEncoding;
        }
    }

    static final class RawPart
    extends ParameterHandler<MultipartBody.Part> {
        static final RawPart INSTANCE = new RawPart();

        private RawPart() {
        }
    }

    static final class Part<T>
    extends ParameterHandler<T> {
        private final Method method;
        private final int p;
        private final okhttp3.Headers headers;
        private final Converter<T, RequestBody> converter;

        /*
         * WARNING - void declaration
         */
        Part(Method method, int p, okhttp3.Headers headers, Converter<T, RequestBody> converter) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.headers = var3_3;
            this.converter = converter;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) {
            void var3_4;
            void var1_1;
            if (value == null) {
                return;
            }
            try {
                RequestBody body = this.converter.convert(value);
            }
            catch (IOException e) {
                void var1_2;
                void var2_3;
                throw Utils.parameterError(this.method, this.p, "Unable to convert " + var2_3 + " to RequestBody", var1_2);
            }
            var1_1.addPart(this.headers, (RequestBody)var3_4);
        }
    }

    static final class FieldMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        FieldMap(Method method, int p, Converter<T, String> valueConverter, boolean encoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.valueConverter = var3_3;
            this.encoded = encoded;
        }
    }

    static final class Field<T>
    extends ParameterHandler<T> {
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        Field(String name, Converter<T, String> valueConverter, boolean encoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = (String)Objects.requireNonNull(var1_1, "name == null");
            this.valueConverter = var2_2;
            this.encoded = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                return;
            }
            String fieldValue = this.valueConverter.convert(value);
            if (fieldValue == null) {
                return;
            }
            var1_1.addFormField(this.name, (String)var2_2, this.encoded);
        }
    }

    static final class Headers
    extends ParameterHandler<okhttp3.Headers> {
        private final Method method;
        private final int p;

        /*
         * WARNING - void declaration
         */
        Headers(Method method, int p) {
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
        }
    }

    static final class HeaderMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;

        /*
         * WARNING - void declaration
         */
        HeaderMap(Method method, int p, Converter<T, String> valueConverter) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.valueConverter = var3_3;
        }
    }

    static final class QueryMap<T>
    extends ParameterHandler<Map<String, T>> {
        private final Method method;
        private final int p;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        QueryMap(Method method, int p, Converter<T, String> valueConverter, boolean encoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.valueConverter = var3_3;
            this.encoded = encoded;
        }
    }

    static final class QueryName<T>
    extends ParameterHandler<T> {
        private final Converter<T, String> nameConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        QueryName(Converter<T, String> nameConverter, boolean encoded) {
            void var2_2;
            void var1_1;
            this.nameConverter = var1_1;
            this.encoded = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                return;
            }
            var1_1.addQueryParam(this.nameConverter.convert(var2_2), null, this.encoded);
        }
    }

    static final class Query<T>
    extends ParameterHandler<T> {
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        Query(String name, Converter<T, String> valueConverter, boolean encoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = (String)Objects.requireNonNull(var1_1, "name == null");
            this.valueConverter = var2_2;
            this.encoded = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                return;
            }
            String queryValue = this.valueConverter.convert(value);
            if (queryValue == null) {
                return;
            }
            var1_1.addQueryParam(this.name, (String)var2_2, this.encoded);
        }
    }

    static final class Path<T>
    extends ParameterHandler<T> {
        private final Method method;
        private final int p;
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        /*
         * WARNING - void declaration
         */
        Path(Method method, int p, String name, Converter<T, String> valueConverter, boolean encoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
            this.name = (String)Objects.requireNonNull(var3_3, "name == null");
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                throw Utils.parameterError(this.method, this.p, "Path parameter \"" + this.name + "\" value must not be null.", new Object[0]);
            }
            var1_1.addPathParam(this.name, this.valueConverter.convert(var2_2), this.encoded);
        }
    }

    static final class Header<T>
    extends ParameterHandler<T> {
        private final String name;
        private final Converter<T, String> valueConverter;

        /*
         * WARNING - void declaration
         */
        Header(String name, Converter<T, String> valueConverter) {
            void var2_2;
            void var1_1;
            this.name = (String)Objects.requireNonNull(var1_1, "name == null");
            this.valueConverter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable T value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                return;
            }
            String headerValue = this.valueConverter.convert(value);
            if (headerValue == null) {
                return;
            }
            var1_1.addHeader(this.name, (String)var2_2);
        }
    }

    static final class RelativeUrl
    extends ParameterHandler<Object> {
        private final Method method;
        private final int p;

        /*
         * WARNING - void declaration
         */
        RelativeUrl(Method method, int p) {
            void var2_2;
            void var1_1;
            this.method = var1_1;
            this.p = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void apply(RequestBuilder builder, @Nullable Object value) {
            void var2_2;
            void var1_1;
            if (value == null) {
                throw Utils.parameterError(this.method, this.p, "@Url parameter is null.", new Object[0]);
            }
            var1_1.setRelativeUrl(var2_2);
        }
    }
}

