/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import retrofit2.CallAdapter;
import retrofit2.CompletableFutureCallAdapterFactory;
import retrofit2.Converter;
import retrofit2.DefaultCallAdapterFactory;
import retrofit2.OptionalConverterFactory;

class Platform {
    private static final Platform PLATFORM = "Dalvik".equals(System.getProperty("java.vm.name")) ? new Android() : new Platform(true);
    private final boolean hasJava8Types;
    @Nullable
    private final Constructor<MethodHandles.Lookup> lookupConstructor;

    static Platform get() {
        return PLATFORM;
    }

    /*
     * WARNING - void declaration
     */
    Platform(boolean hasJava8Types) {
        void var2_2;
        void var1_1;
        this.hasJava8Types = hasJava8Types;
        Constructor lookupConstructor = null;
        if (var1_1 != false) {
            try {
                lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookupConstructor.setAccessible(true);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.lookupConstructor = var2_2;
    }

    @Nullable
    Executor defaultCallbackExecutor() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
        void var1_1;
        DefaultCallAdapterFactory executorFactory = new DefaultCallAdapterFactory(callbackExecutor);
        if (this.hasJava8Types) {
            return Arrays.asList(CompletableFutureCallAdapterFactory.INSTANCE, executorFactory);
        }
        return Collections.singletonList(var1_1);
    }

    final List<? extends Converter.Factory> defaultConverterFactories() {
        if (this.hasJava8Types) {
            return Collections.singletonList(OptionalConverterFactory.INSTANCE);
        }
        return Collections.emptyList();
    }

    final int defaultConverterFactoriesSize() {
        if (this.hasJava8Types) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreJRERequirement
    final boolean isDefaultMethod(Method method) {
        void var1_1;
        return this.hasJava8Types && var1_1.isDefault();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @IgnoreJRERequirement
    Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
        void var3_3;
        void var2_2;
        void var1_1;
        MethodHandles.Lookup lookup = this.lookupConstructor != null ? this.lookupConstructor.newInstance(declaringClass, -1) : MethodHandles.lookup();
        return lookup.unreflectSpecial((Method)var1_1, (Class<?>)var2_2).bindTo(var3_3).invokeWithArguments(args);
    }

    static final class Android
    extends Platform {
        Android() {
            super(Build.VERSION.SDK_INT >= 24);
        }

        @Override
        public final Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        final Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
            void var3_3;
            void var2_2;
            void var1_1;
            if (Build.VERSION.SDK_INT < 26) {
                throw new UnsupportedOperationException("Calling default methods on API 24 and 25 is not supported");
            }
            return super.invokeDefaultMethod((Method)var1_1, (Class<?>)var2_2, var3_3, args);
        }

        static final class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void execute(Runnable r) {
                void var1_1;
                this.handler.post((Runnable)var1_1);
            }
        }
    }
}

