/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

final class RequestBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern PATH_TRAVERSAL = Pattern.compile("(.*/)?(\\.|%2e|%2E){1,2}(/.*)?");
    private final String method;
    private final HttpUrl baseUrl;
    @Nullable
    private String relativeUrl;
    @Nullable
    private HttpUrl.Builder urlBuilder;
    private final Request.Builder requestBuilder;
    private final Headers.Builder headersBuilder;
    @Nullable
    private MediaType contentType;
    private final boolean hasBody;
    @Nullable
    private MultipartBody.Builder multipartBuilder;
    @Nullable
    private FormBody.Builder formBuilder;
    @Nullable
    private RequestBody body;

    /*
     * WARNING - void declaration
     */
    RequestBuilder(String method, HttpUrl baseUrl, @Nullable String relativeUrl, @Nullable Headers headers, @Nullable MediaType contentType, boolean hasBody, boolean isFormEncoded, boolean isMultipart) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.method = var1_1;
        this.baseUrl = var2_2;
        this.relativeUrl = var3_3;
        this.requestBuilder = new Request.Builder();
        this.contentType = contentType;
        this.hasBody = hasBody;
        this.headersBuilder = headers != null ? headers.newBuilder() : new Headers.Builder();
        if (isFormEncoded) {
            this.formBuilder = new FormBody.Builder();
            return;
        }
        if (isMultipart) {
            this.multipartBuilder = new MultipartBody.Builder();
            this.multipartBuilder.setType(MultipartBody.FORM);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setRelativeUrl(Object relativeUrl) {
        void var1_1;
        this.relativeUrl = var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    final void addHeader(String name, String value) {
        void var2_3;
        void var1_1;
        if ("Content-Type".equalsIgnoreCase(name)) {
            try {
                this.contentType = MediaType.get((String)value);
                return;
            }
            catch (IllegalArgumentException e) {
                void var1_2;
                throw new IllegalArgumentException("Malformed content type: " + value, (Throwable)var1_2);
            }
        }
        this.headersBuilder.add((String)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    final void addHeaders(Headers headers) {
        void var1_1;
        this.headersBuilder.addAll((Headers)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void addPathParam(String name, String value, boolean encoded) {
        void var1_1;
        void var3_4;
        if (this.relativeUrl == null) {
            throw new AssertionError();
        }
        String replacement = RequestBuilder.canonicalizeForPath(value, encoded);
        String newRelativeUrl = this.relativeUrl.replace("{" + name + "}", (CharSequence)var3_4);
        if (PATH_TRAVERSAL.matcher(newRelativeUrl).matches()) {
            void var2_2;
            throw new IllegalArgumentException("@Path parameters shouldn't perform path traversal ('.' or '..'): " + (String)var2_2);
        }
        this.relativeUrl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String canonicalizeForPath(String input, boolean alreadyEncoded2) {
        String string;
        void var2_5;
        int limit = input.length();
        for (int i = 0; i < limit; i += Character.charCount((int)var2_5)) {
            void var2_6;
            int codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && " \"<>^`{}|\\?#".indexOf(codePoint) == -1 && (alreadyEncoded2 || codePoint != 47 && codePoint != 37)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, 0, i);
            boolean bl = alreadyEncoded2;
            String alreadyEncoded2 = input;
            input = out;
            Buffer buffer = null;
            for (int j = i; j < limit; j += Character.charCount(i)) {
                i = alreadyEncoded2.codePointAt(j);
                if (bl && (i == 9 || i == 10 || i == 12 || i == 13)) continue;
                if (i < 32 || i >= 127 || " \"<>^`{}|\\?#".indexOf(i) != -1 || !bl && (i == 47 || i == 37)) {
                    if (buffer == null) {
                        buffer = new Buffer();
                    }
                    buffer.writeUtf8CodePoint(i);
                    while (!buffer.exhausted()) {
                        int n = buffer.readByte() & 0xFF;
                        input.writeByte(37);
                        input.writeByte((int)HEX_DIGITS[n >> 4 & 0xF]);
                        input.writeByte((int)HEX_DIGITS[n & 0xF]);
                    }
                    continue;
                }
                input.writeUtf8CodePoint(i);
            }
            return var2_6.readUtf8();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    final void addQueryParam(String name, @Nullable String value, boolean encoded) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (this.relativeUrl != null) {
            this.urlBuilder = this.baseUrl.newBuilder(this.relativeUrl);
            if (this.urlBuilder == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
            this.relativeUrl = null;
        }
        if (var3_3 != false) {
            this.urlBuilder.addEncodedQueryParameter(name, value);
            return;
        }
        this.urlBuilder.addQueryParameter((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void addFormField(String name, String value, boolean encoded) {
        void var2_2;
        void var1_1;
        if (encoded) {
            this.formBuilder.addEncoded(name, value);
            return;
        }
        this.formBuilder.add((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void addPart(Headers headers, RequestBody body) {
        void var2_2;
        void var1_1;
        this.multipartBuilder.addPart((Headers)var1_1, (RequestBody)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void addPart(MultipartBody.Part part) {
        void var1_1;
        this.multipartBuilder.addPart((MultipartBody.Part)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setBody(RequestBody body) {
        void var1_1;
        this.body = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final <T> void addTag(Class<T> cls, @Nullable T value) {
        void var2_2;
        void var1_1;
        this.requestBuilder.tag((Class)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final Request.Builder get() {
        void var2_2;
        void var1_1;
        MediaType contentType;
        HttpUrl url;
        HttpUrl.Builder urlBuilder = this.urlBuilder;
        if (urlBuilder != null) {
            url = urlBuilder.build();
        } else {
            url = this.baseUrl.resolve(this.relativeUrl);
            if (url == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
        }
        RequestBody body = this.body;
        if (body == null) {
            if (this.formBuilder != null) {
                body = this.formBuilder.build();
            } else if (this.multipartBuilder != null) {
                body = this.multipartBuilder.build();
            } else if (this.hasBody) {
                body = RequestBody.create(null, (byte[])new byte[0]);
            }
        }
        if ((contentType = this.contentType) != null) {
            if (body != null) {
                body = new ContentTypeOverridingRequestBody(body, contentType);
            } else {
                void var3_3;
                this.headersBuilder.add("Content-Type", var3_3.toString());
            }
        }
        return this.requestBuilder.url((HttpUrl)var1_1).headers(this.headersBuilder.build()).method(this.method, (RequestBody)var2_2);
    }

    static final class ContentTypeOverridingRequestBody
    extends RequestBody {
        private final RequestBody delegate;
        private final MediaType contentType;

        /*
         * WARNING - void declaration
         */
        ContentTypeOverridingRequestBody(RequestBody delegate, MediaType contentType) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.contentType = var2_2;
        }

        public final MediaType contentType() {
            return this.contentType;
        }

        public final long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        /*
         * WARNING - void declaration
         */
        public final void writeTo(BufferedSink sink) throws IOException {
            void var1_1;
            this.delegate.writeTo((BufferedSink)var1_1);
        }
    }
}

