/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import kotlin.coroutines.Continuation;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Invocation;
import retrofit2.ParameterHandler;
import retrofit2.RequestBuilder;
import retrofit2.Retrofit;
import retrofit2.Utils;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.OPTIONS;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.QueryName;
import retrofit2.http.Tag;
import retrofit2.http.Url;

final class RequestFactory {
    private final Method method;
    private final HttpUrl baseUrl;
    final String httpMethod;
    @Nullable
    private final String relativeUrl;
    @Nullable
    private final okhttp3.Headers headers;
    @Nullable
    private final MediaType contentType;
    private final boolean hasBody;
    private final boolean isFormEncoded;
    private final boolean isMultipart;
    private final ParameterHandler<?>[] parameterHandlers;
    final boolean isKotlinSuspendFunction;

    /*
     * WARNING - void declaration
     */
    RequestFactory(Builder builder) {
        void var1_1;
        this.method = builder.method;
        this.baseUrl = builder.retrofit.baseUrl;
        this.httpMethod = builder.httpMethod;
        this.relativeUrl = builder.relativeUrl;
        this.headers = builder.headers;
        this.contentType = builder.contentType;
        this.hasBody = builder.hasBody;
        this.isFormEncoded = builder.isFormEncoded;
        this.isMultipart = builder.isMultipart;
        this.parameterHandlers = builder.parameterHandlers;
        this.isKotlinSuspendFunction = var1_1.isKotlinSuspendFunction;
    }

    final Request create(Object[] args) throws IOException {
        int argumentCount = args.length;
        ParameterHandler<?>[] handlers = this.parameterHandlers;
        if (argumentCount != handlers.length) {
            throw new IllegalArgumentException("Argument count (" + argumentCount + ") doesn't match expected count (" + handlers.length + ")");
        }
        RequestBuilder requestBuilder = new RequestBuilder(this.httpMethod, this.baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart);
        if (this.isKotlinSuspendFunction) {
            --argumentCount;
        }
        ArrayList<Object> argumentList = new ArrayList<Object>(argumentCount);
        for (int p = 0; p < argumentCount; ++p) {
            argumentList.add(args[p]);
            handlers[p].apply(requestBuilder, args[p]);
        }
        return requestBuilder.get().tag(Invocation.class, (Object)new Invocation(this.method, argumentList)).build();
    }

    static final class Builder {
        private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
        private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
        final Retrofit retrofit;
        final Method method;
        private Annotation[] methodAnnotations;
        private Annotation[][] parameterAnnotationsArray;
        private Type[] parameterTypes;
        private boolean gotField;
        private boolean gotPart;
        private boolean gotBody;
        private boolean gotPath;
        private boolean gotQuery;
        private boolean gotQueryName;
        private boolean gotQueryMap;
        private boolean gotUrl;
        @Nullable
        String httpMethod;
        boolean hasBody;
        boolean isFormEncoded;
        boolean isMultipart;
        @Nullable
        String relativeUrl;
        @Nullable
        okhttp3.Headers headers;
        @Nullable
        MediaType contentType;
        @Nullable
        private Set<String> relativeUrlParamNames;
        @Nullable
        ParameterHandler<?>[] parameterHandlers;
        boolean isKotlinSuspendFunction;

        /*
         * WARNING - void declaration
         */
        Builder(Retrofit retrofit, Method method) {
            void var2_2;
            void var1_1;
            this.retrofit = var1_1;
            this.method = method;
            this.methodAnnotations = method.getAnnotations();
            this.parameterTypes = method.getGenericParameterTypes();
            this.parameterAnnotationsArray = var2_2.getParameterAnnotations();
        }

        final RequestFactory build() {
            Annotation[] annotationArray = this.methodAnnotations;
            int n = this.methodAnnotations.length;
            for (int i = 0; i < n; ++i) {
                String[] annotation;
                String[] stringArray = annotation = annotationArray[i];
                Builder builder = this;
                if (stringArray instanceof DELETE) {
                    builder.parseHttpMethodAndPath("DELETE", ((DELETE)stringArray).value(), false);
                    continue;
                }
                if (stringArray instanceof GET) {
                    builder.parseHttpMethodAndPath("GET", ((GET)stringArray).value(), false);
                    continue;
                }
                if (stringArray instanceof HEAD) {
                    builder.parseHttpMethodAndPath("HEAD", ((HEAD)stringArray).value(), false);
                    continue;
                }
                if (stringArray instanceof PATCH) {
                    builder.parseHttpMethodAndPath("PATCH", ((PATCH)stringArray).value(), true);
                    continue;
                }
                if (stringArray instanceof POST) {
                    builder.parseHttpMethodAndPath("POST", ((POST)stringArray).value(), true);
                    continue;
                }
                if (stringArray instanceof PUT) {
                    builder.parseHttpMethodAndPath("PUT", ((PUT)stringArray).value(), true);
                    continue;
                }
                if (stringArray instanceof OPTIONS) {
                    builder.parseHttpMethodAndPath("OPTIONS", ((OPTIONS)stringArray).value(), false);
                    continue;
                }
                if (stringArray instanceof HTTP) {
                    stringArray = (HTTP)stringArray;
                    builder.parseHttpMethodAndPath(stringArray.method(), stringArray.path(), stringArray.hasBody());
                    continue;
                }
                if (stringArray instanceof Headers) {
                    if ((stringArray = ((Headers)stringArray).value()).length == 0) {
                        throw Utils.methodError(builder.method, "@Headers annotation is empty.", new Object[0]);
                    }
                    builder.headers = builder.parseHeaders(stringArray);
                    continue;
                }
                if (stringArray instanceof Multipart) {
                    if (builder.isFormEncoded) {
                        throw Utils.methodError(builder.method, "Only one encoding annotation is allowed.", new Object[0]);
                    }
                    builder.isMultipart = true;
                    continue;
                }
                if (!(stringArray instanceof FormUrlEncoded)) continue;
                if (builder.isMultipart) {
                    throw Utils.methodError(builder.method, "Only one encoding annotation is allowed.", new Object[0]);
                }
                builder.isFormEncoded = true;
            }
            if (this.httpMethod == null) {
                throw Utils.methodError(this.method, "HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
            }
            if (!this.hasBody) {
                if (this.isMultipart) {
                    throw Utils.methodError(this.method, "Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                }
                if (this.isFormEncoded) {
                    throw Utils.methodError(this.method, "FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                }
            }
            int parameterCount = this.parameterAnnotationsArray.length;
            this.parameterHandlers = new ParameterHandler[parameterCount];
            int lastParameter = parameterCount - 1;
            for (int p = 0; p < parameterCount; ++p) {
                this.parameterHandlers[p] = this.parseParameter(p, this.parameterTypes[p], this.parameterAnnotationsArray[p], p == lastParameter);
            }
            if (this.relativeUrl == null && !this.gotUrl) {
                throw Utils.methodError(this.method, "Missing either @%s URL or @Url parameter.", this.httpMethod);
            }
            if (!this.isFormEncoded && !this.isMultipart && !this.hasBody && this.gotBody) {
                throw Utils.methodError(this.method, "Non-body HTTP method cannot contain @Body.", new Object[0]);
            }
            if (this.isFormEncoded && !this.gotField) {
                throw Utils.methodError(this.method, "Form-encoded method must contain at least one @Field.", new Object[0]);
            }
            if (this.isMultipart && !this.gotPart) {
                throw Utils.methodError(this.method, "Multipart method must contain at least one @Part.", new Object[0]);
            }
            return new RequestFactory(this);
        }

        /*
         * WARNING - void declaration
         */
        private void parseHttpMethodAndPath(String httpMethod, String value, boolean hasBody) {
            void var2_4;
            String queryParams;
            Matcher matcher;
            void var3_5;
            if (this.httpMethod != null) {
                throw Utils.methodError(this.method, "Only one HTTP method is allowed. Found: %s and %s.", this.httpMethod, httpMethod);
            }
            this.httpMethod = httpMethod;
            this.hasBody = var3_5;
            if (value.isEmpty()) {
                return;
            }
            int question = value.indexOf(63);
            if (question != -1 && question < value.length() - 1 && (matcher = PARAM_URL_REGEX.matcher(queryParams = value.substring(question + 1))).find()) {
                void var1_3;
                throw Utils.methodError(this.method, "URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", var1_3);
            }
            this.relativeUrl = value;
            this.relativeUrlParamNames = Builder.parsePathParameters((String)var2_4);
        }

        /*
         * WARNING - void declaration
         */
        private okhttp3.Headers parseHeaders(String[] headers) {
            void var2_3;
            Headers.Builder builder = new Headers.Builder();
            for (String header : headers) {
                int colon = header.indexOf(58);
                if (colon == -1 || colon == 0 || colon == header.length() - 1) {
                    throw Utils.methodError(this.method, "@Headers value must be in the form \"Name: Value\". Found: \"%s\"", header);
                }
                String headerName = header.substring(0, colon);
                String headerValue = header.substring(colon + 1).trim();
                if ("Content-Type".equalsIgnoreCase(headerName)) {
                    try {
                        this.contentType = MediaType.get((String)headerValue);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        void var1_2;
                        throw Utils.methodError(this.method, (Throwable)var1_2, "Malformed content type: %s", headerValue);
                    }
                }
                builder.add(headerName, headerValue);
            }
            return var2_3.build();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private ParameterHandler<?> parseParameter(int p, Type parameterType, @Nullable Annotation[] annotations, boolean allowContinuation) {
            ParameterHandler<?> result = null;
            if (annotations != null) {
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                for (int i = 0; i < n; ++i) {
                    Annotation annotation = annotationArray[i];
                    ParameterHandler<?> annotationAction = this.parseParameterAnnotation(p, parameterType, annotations, annotation);
                    if (annotationAction == null) continue;
                    if (result != null) {
                        throw Utils.parameterError(this.method, p, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
                    }
                    result = annotationAction;
                }
            }
            if (result == null) {
                void var1_1;
                if (allowContinuation) {
                    try {
                        void var2_2;
                        if (Utils.getRawType((Type)var2_2) == Continuation.class) {
                            this.isKotlinSuspendFunction = true;
                            return null;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
                throw Utils.parameterError(this.method, (int)var1_1, "No Retrofit annotation found.", new Object[0]);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private ParameterHandler<?> parseParameterAnnotation(int p, Type type, Annotation[] annotations, Annotation annotation) {
            void var3_3;
            void var2_2;
            Converter valueConverter;
            Type valueType;
            Converter converter;
            Class<?> arrayComponentType;
            Converter converter2;
            Type iterableType;
            ParameterizedType parameterizedType;
            if (annotation instanceof Url) {
                this.validateResolvableType(p, type);
                if (this.gotUrl) {
                    throw Utils.parameterError(this.method, p, "Multiple @Url method annotations found.", new Object[0]);
                }
                if (this.gotPath) {
                    throw Utils.parameterError(this.method, p, "@Path parameters may not be used with @Url.", new Object[0]);
                }
                if (this.gotQuery) {
                    throw Utils.parameterError(this.method, p, "A @Url parameter must not come after a @Query.", new Object[0]);
                }
                if (this.gotQueryName) {
                    throw Utils.parameterError(this.method, p, "A @Url parameter must not come after a @QueryName.", new Object[0]);
                }
                if (this.gotQueryMap) {
                    throw Utils.parameterError(this.method, p, "A @Url parameter must not come after a @QueryMap.", new Object[0]);
                }
                if (this.relativeUrl != null) {
                    throw Utils.parameterError(this.method, p, "@Url cannot be used with @%s URL", this.httpMethod);
                }
                this.gotUrl = true;
                if (type == HttpUrl.class || type == String.class || type == URI.class || type instanceof Class && "android.net.Uri".equals(((Class)type).getName())) {
                    return new ParameterHandler.RelativeUrl(this.method, p);
                }
                throw Utils.parameterError(this.method, p, "@Url must be okhttp3.HttpUrl, String, java.net.URI, or android.net.Uri type.", new Object[0]);
            }
            if (annotation instanceof Path) {
                String name;
                this.validateResolvableType(p, type);
                if (this.gotQuery) {
                    throw Utils.parameterError(this.method, p, "A @Path parameter must not come after a @Query.", new Object[0]);
                }
                if (this.gotQueryName) {
                    throw Utils.parameterError(this.method, p, "A @Path parameter must not come after a @QueryName.", new Object[0]);
                }
                if (this.gotQueryMap) {
                    throw Utils.parameterError(this.method, p, "A @Path parameter must not come after a @QueryMap.", new Object[0]);
                }
                if (this.gotUrl) {
                    throw Utils.parameterError(this.method, p, "@Path parameters may not be used with @Url.", new Object[0]);
                }
                if (this.relativeUrl == null) {
                    throw Utils.parameterError(this.method, p, "@Path can only be used with relative url on @%s", this.httpMethod);
                }
                this.gotPath = true;
                Path path = (Path)annotation;
                String string = name = path.value();
                int n = p;
                annotation = this;
                if (!PARAM_NAME_REGEX.matcher(string).matches()) {
                    throw Utils.parameterError(((Builder)annotation).method, n, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), string);
                }
                if (!((Builder)annotation).relativeUrlParamNames.contains(string)) {
                    throw Utils.parameterError(((Builder)annotation).method, n, "URL \"%s\" does not contain \"{%s}\".", ((Builder)annotation).relativeUrl, string);
                }
                Converter converter3 = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.Path(this.method, p, name, converter3, path.encoded());
            }
            if (annotation instanceof Query) {
                this.validateResolvableType(p, type);
                Query query = (Query)annotation;
                String name = query.value();
                boolean encoded = query.encoded();
                Class<?> rawParameterType = Utils.getRawType(type);
                this.gotQuery = true;
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw Utils.parameterError(this.method, p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    parameterizedType = (ParameterizedType)type;
                    iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    converter2 = this.retrofit.stringConverter(iterableType, annotations);
                    return new ParameterHandler.Query(name, converter2, encoded).iterable();
                }
                if (rawParameterType.isArray()) {
                    arrayComponentType = Builder.boxIfPrimitive(rawParameterType.getComponentType());
                    converter = this.retrofit.stringConverter(arrayComponentType, (Annotation[])converter2);
                    return new ParameterHandler.Query(name, converter, encoded).array();
                }
                converter = this.retrofit.stringConverter((Type)((Object)converter), (Annotation[])converter2);
                return new ParameterHandler.Query(name, converter, encoded);
            }
            if (annotation instanceof QueryName) {
                this.validateResolvableType(p, (Type)((Object)converter));
                QueryName rawParameterType = (QueryName)annotation;
                boolean encoded = rawParameterType.encoded();
                Class<?> rawParameterType2 = Utils.getRawType((Type)((Object)converter));
                this.gotQueryName = true;
                if (Iterable.class.isAssignableFrom(rawParameterType2)) {
                    if (!(converter instanceof ParameterizedType)) {
                        throw Utils.parameterError(this.method, p, rawParameterType2.getSimpleName() + " must include generic type (e.g., " + rawParameterType2.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType2 = (ParameterizedType)((Object)converter);
                    iterableType = Utils.getParameterUpperBound(0, parameterizedType2);
                    converter = this.retrofit.stringConverter(iterableType, (Annotation[])converter2);
                    return new ParameterHandler.QueryName(converter, encoded).iterable();
                }
                if (rawParameterType2.isArray()) {
                    Class<?> arrayComponentType2 = Builder.boxIfPrimitive(rawParameterType2.getComponentType());
                    converter = this.retrofit.stringConverter(arrayComponentType2, (Annotation[])converter2);
                    return new ParameterHandler.QueryName(converter, encoded).array();
                }
                Converter converter4 = this.retrofit.stringConverter((Type)((Object)converter), (Annotation[])converter2);
                return new ParameterHandler.QueryName(converter4, encoded);
            }
            if (annotation instanceof QueryMap) {
                this.validateResolvableType(p, (Type)((Object)converter));
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)converter));
                this.gotQueryMap = true;
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw Utils.parameterError(this.method, p, "@QueryMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype((Type)((Object)converter), rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw Utils.parameterError(this.method, p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType3 = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType3);
                if (String.class != keyType) {
                    throw Utils.parameterError(this.method, p, "@QueryMap keys must be of type String: " + keyType, new Object[0]);
                }
                valueType = Utils.getParameterUpperBound(1, parameterizedType3);
                valueConverter = this.retrofit.stringConverter(valueType, (Annotation[])converter2);
                return new ParameterHandler.QueryMap(this.method, p, valueConverter, ((QueryMap)annotation).encoded());
            }
            if (annotation instanceof Header) {
                this.validateResolvableType(p, (Type)((Object)valueConverter));
                Header keyType = (Header)annotation;
                String name = keyType.value();
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)valueConverter));
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(valueConverter instanceof ParameterizedType)) {
                        throw Utils.parameterError(this.method, p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType4 = (ParameterizedType)((Object)valueConverter);
                    iterableType = Utils.getParameterUpperBound(0, parameterizedType4);
                    converter = this.retrofit.stringConverter(iterableType, (Annotation[])converter2);
                    return new ParameterHandler.Header(name, converter).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType3 = Builder.boxIfPrimitive(rawParameterType.getComponentType());
                    converter = this.retrofit.stringConverter(arrayComponentType3, (Annotation[])converter2);
                    return new ParameterHandler.Header(name, converter).array();
                }
                Converter converter5 = this.retrofit.stringConverter((Type)((Object)converter), (Annotation[])converter2);
                return new ParameterHandler.Header(name, converter5);
            }
            if (annotation instanceof HeaderMap) {
                if (converter == okhttp3.Headers.class) {
                    return new ParameterHandler.Headers(this.method, p);
                }
                this.validateResolvableType(p, (Type)((Object)converter));
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)converter));
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw Utils.parameterError(this.method, p, "@HeaderMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype((Type)((Object)converter), rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw Utils.parameterError(this.method, p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType5 = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType5);
                if (String.class != keyType) {
                    throw Utils.parameterError(this.method, p, "@HeaderMap keys must be of type String: " + keyType, new Object[0]);
                }
                valueType = Utils.getParameterUpperBound(1, parameterizedType5);
                valueConverter = this.retrofit.stringConverter(valueType, (Annotation[])converter2);
                return new ParameterHandler.HeaderMap(this.method, p, valueConverter);
            }
            if (annotation instanceof Field) {
                this.validateResolvableType(p, (Type)((Object)valueConverter));
                if (!this.isFormEncoded) {
                    throw Utils.parameterError(this.method, p, "@Field parameters can only be used with form encoding.", new Object[0]);
                }
                Field field = (Field)annotation;
                String name = field.value();
                boolean encoded = field.encoded();
                this.gotField = true;
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)valueConverter));
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(valueConverter instanceof ParameterizedType)) {
                        throw Utils.parameterError(this.method, p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    parameterizedType = (ParameterizedType)((Object)valueConverter);
                    iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    converter2 = this.retrofit.stringConverter(iterableType, (Annotation[])converter2);
                    return new ParameterHandler.Field(name, converter2, encoded).iterable();
                }
                if (rawParameterType.isArray()) {
                    arrayComponentType = Builder.boxIfPrimitive(rawParameterType.getComponentType());
                    converter = this.retrofit.stringConverter(arrayComponentType, (Annotation[])converter2);
                    return new ParameterHandler.Field(name, converter, encoded).array();
                }
                converter = this.retrofit.stringConverter((Type)((Object)converter), (Annotation[])converter2);
                return new ParameterHandler.Field(name, converter, encoded);
            }
            if (annotation instanceof FieldMap) {
                this.validateResolvableType(p, (Type)((Object)converter));
                if (!this.isFormEncoded) {
                    throw Utils.parameterError(this.method, p, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
                }
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)converter));
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw Utils.parameterError(this.method, p, "@FieldMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(converter, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw Utils.parameterError(this.method, p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType6 = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType6);
                if (String.class != keyType) {
                    throw Utils.parameterError(this.method, p, "@FieldMap keys must be of type String: " + keyType, new Object[0]);
                }
                valueType = Utils.getParameterUpperBound(1, parameterizedType6);
                valueConverter = this.retrofit.stringConverter(valueType, (Annotation[])converter2);
                this.gotField = true;
                return new ParameterHandler.FieldMap(this.method, p, valueConverter, ((FieldMap)annotation).encoded());
            }
            if (annotation instanceof Part) {
                Class<?> arrayComponentType4;
                this.validateResolvableType(p, (Type)((Object)valueConverter));
                if (!this.isMultipart) {
                    throw Utils.parameterError(this.method, p, "@Part parameters can only be used with multipart encoding.", new Object[0]);
                }
                Part part = (Part)annotation;
                this.gotPart = true;
                String partName = part.value();
                Class<?> rawParameterType = Utils.getRawType((Type)((Object)valueConverter));
                if (partName.isEmpty()) {
                    if (Iterable.class.isAssignableFrom(rawParameterType)) {
                        if (!(valueConverter instanceof ParameterizedType)) {
                            throw Utils.parameterError(this.method, p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                        }
                        ParameterizedType parameterizedType7 = (ParameterizedType)((Object)valueConverter);
                        iterableType = Utils.getParameterUpperBound(0, parameterizedType7);
                        if (!MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(iterableType))) {
                            throw Utils.parameterError(this.method, p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                        }
                        return ParameterHandler.RawPart.INSTANCE.iterable();
                    }
                    if (rawParameterType.isArray()) {
                        arrayComponentType4 = rawParameterType.getComponentType();
                        if (!MultipartBody.Part.class.isAssignableFrom(arrayComponentType4)) {
                            throw Utils.parameterError(this.method, p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                        }
                        return ParameterHandler.RawPart.INSTANCE.array();
                    }
                    if (MultipartBody.Part.class.isAssignableFrom(rawParameterType)) {
                        return ParameterHandler.RawPart.INSTANCE;
                    }
                    throw Utils.parameterError(this.method, p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                }
                okhttp3.Headers headers = okhttp3.Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + partName + "\"", "Content-Transfer-Encoding", arrayComponentType4.encoding()});
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(iterableType instanceof ParameterizedType)) {
                        throw Utils.parameterError(this.method, p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    parameterizedType = (ParameterizedType)iterableType;
                    if (MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(iterableType = Utils.getParameterUpperBound(0, parameterizedType)))) {
                        throw Utils.parameterError(this.method, p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                    }
                    converter2 = this.retrofit.requestBodyConverter(iterableType, (Annotation[])converter2, this.methodAnnotations);
                    return new ParameterHandler.Part(this.method, p, headers, converter2).iterable();
                }
                if (rawParameterType.isArray()) {
                    arrayComponentType = Builder.boxIfPrimitive(rawParameterType.getComponentType());
                    if (MultipartBody.Part.class.isAssignableFrom(arrayComponentType)) {
                        throw Utils.parameterError(this.method, p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                    }
                    converter = this.retrofit.requestBodyConverter(arrayComponentType, (Annotation[])converter2, this.methodAnnotations);
                    return new ParameterHandler.Part(this.method, p, headers, converter).array();
                }
                if (MultipartBody.Part.class.isAssignableFrom(rawParameterType)) {
                    throw Utils.parameterError(this.method, p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                }
                converter = this.retrofit.requestBodyConverter((Type)((Object)converter), (Annotation[])converter2, this.methodAnnotations);
                return new ParameterHandler.Part(this.method, p, headers, converter);
            }
            if (annotation instanceof PartMap) {
                this.validateResolvableType(p, (Type)((Object)converter));
                if (!this.isMultipart) {
                    throw Utils.parameterError(this.method, p, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
                }
                this.gotPart = true;
                Class<?> rawParameterType = Utils.getRawType(converter);
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw Utils.parameterError(this.method, p, "@PartMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(converter, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw Utils.parameterError(this.method, p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType8 = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType8);
                if (String.class != keyType) {
                    throw Utils.parameterError(this.method, p, "@PartMap keys must be of type String: " + keyType, new Object[0]);
                }
                valueType = Utils.getParameterUpperBound(1, parameterizedType8);
                if (MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(valueType))) {
                    throw Utils.parameterError(this.method, p, "@PartMap values cannot be MultipartBody.Part. Use @Part List<Part> or a different value type instead.", new Object[0]);
                }
                valueConverter = this.retrofit.requestBodyConverter(valueType, (Annotation[])converter2, this.methodAnnotations);
                PartMap partMap = (PartMap)annotation;
                return new ParameterHandler.PartMap(this.method, p, var2_2, var3_3.encoding());
            }
            if (annotation instanceof Body) {
                Converter converter6;
                this.validateResolvableType(p, (Type)var2_2);
                if (this.isFormEncoded || this.isMultipart) {
                    throw Utils.parameterError(this.method, p, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
                }
                if (this.gotBody) {
                    throw Utils.parameterError(this.method, p, "Multiple @Body method annotations found.", new Object[0]);
                }
                try {
                    converter6 = this.retrofit.requestBodyConverter((Type)var2_2, (Annotation[])var3_3, this.methodAnnotations);
                }
                catch (RuntimeException e) {
                    throw Utils.parameterError(this.method, e, p, "Unable to create @Body converter for %s", var2_2);
                }
                this.gotBody = true;
                return new ParameterHandler.Body(this.method, p, converter6);
            }
            if (annotation instanceof Tag) {
                this.validateResolvableType(p, (Type)var2_2);
                Class<?> tagType = Utils.getRawType((Type)var2_2);
                for (int i = p - 1; i >= 0; --i) {
                    ParameterHandler<?> otherHandler = this.parameterHandlers[i];
                    if (!(otherHandler instanceof ParameterHandler.Tag) || !((ParameterHandler.Tag)otherHandler).cls.equals(tagType)) continue;
                    throw Utils.parameterError(this.method, p, "@Tag type " + tagType.getName() + " is duplicate of parameter #" + (i + 1) + " and would always overwrite its value.", new Object[0]);
                }
                return new ParameterHandler.Tag(tagType);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private void validateResolvableType(int p, Type type) {
            if (Utils.hasUnresolvableType(type)) {
                void var2_2;
                void var1_1;
                throw Utils.parameterError(this.method, (int)var1_1, "Parameter type must not include a type variable or wildcard: %s", var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static Set<String> parsePathParameters(String path) {
            void var1_1;
            Matcher m = PARAM_URL_REGEX.matcher(path);
            LinkedHashSet<String> patterns = new LinkedHashSet<String>();
            while (m.find()) {
                patterns.add(m.group(1));
            }
            return var1_1;
        }

        private static Class<?> boxIfPrimitive(Class<?> type) {
            Class<?> clazz;
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            return clazz;
        }
    }
}

