/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.BuiltInConverters;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpServiceMethod;
import retrofit2.Platform;
import retrofit2.RequestFactory;
import retrofit2.ServiceMethod;
import retrofit2.Utils;

public final class Retrofit {
    private final Map<Method, ServiceMethod<?>> serviceMethodCache = new ConcurrentHashMap();
    final Call.Factory callFactory;
    final HttpUrl baseUrl;
    private List<Converter.Factory> converterFactories;
    final List<CallAdapter.Factory> callAdapterFactories;
    private boolean validateEagerly;

    /*
     * WARNING - void declaration
     */
    Retrofit(Call.Factory callFactory, HttpUrl baseUrl, List<Converter.Factory> converterFactories, List<CallAdapter.Factory> callAdapterFactories, @Nullable Executor callbackExecutor, boolean validateEagerly) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.callFactory = var1_1;
        this.baseUrl = var2_2;
        this.converterFactories = var3_3;
        this.callAdapterFactories = callAdapterFactories;
        this.validateEagerly = validateEagerly;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T create(Class<T> service) {
        void var1_1;
        Object object;
        Class<T> clazz = service;
        Retrofit retrofit = this;
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("API declarations must be interfaces.");
        }
        Object object2 = new ArrayDeque(1);
        object2.add(clazz);
        while (!object2.isEmpty()) {
            object = (Class)object2.removeFirst();
            if (((Class)object).getTypeParameters().length != 0) {
                object2 = new StringBuilder("Type parameters are unsupported on ").append(((Class)object).getName());
                if (object != clazz) {
                    ((StringBuilder)object2).append(" which is an interface of ").append(clazz.getName());
                }
                throw new IllegalArgumentException(((StringBuilder)object2).toString());
            }
            Collections.addAll(object2, ((Class)object).getInterfaces());
        }
        if (retrofit.validateEagerly) {
            object = Platform.get();
            for (Method method : clazz.getDeclaredMethods()) {
                if (((Platform)object).isDefaultMethod(method) || Modifier.isStatic(method.getModifiers())) continue;
                retrofit.loadServiceMethod(method);
            }
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){
            private final Platform platform = Platform.get();
            private final Object[] emptyArgs = new Object[0];
            private /* synthetic */ Class val$service;
            private /* synthetic */ Retrofit this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$service = clazz;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public final Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
                void var3_3;
                void var2_2;
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                Object[] objectArray = args = args != null ? args : this.emptyArgs;
                if (this.platform.isDefaultMethod(method)) {
                    void var1_1;
                    return this.platform.invokeDefaultMethod(method, this.val$service, var1_1, args);
                }
                return this.this$0.loadServiceMethod((Method)var2_2).invoke((Object[])var3_3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    final ServiceMethod<?> loadServiceMethod(Method method) {
        void var2_3;
        ServiceMethod result = this.serviceMethodCache.get(method);
        if (result != null) {
            return result;
        }
        Map<Method, ServiceMethod<?>> map = this.serviceMethodCache;
        synchronized (map) {
            result = this.serviceMethodCache.get(method);
            if (result == null) {
                void var1_1;
                Method method2 = method;
                result = this;
                Object object = method2;
                Object object2 = result;
                object2 = new RequestFactory.Builder((Retrofit)object2, (Method)object).build();
                object = method2.getGenericReturnType();
                if (Utils.hasUnresolvableType((Type)object)) {
                    throw Utils.methodError(method2, "Method return type must not include a type variable or wildcard: %s", object);
                }
                if (object == Void.TYPE) {
                    throw Utils.methodError(method2, "Service methods cannot return void.", new Object[0]);
                }
                result = HttpServiceMethod.parseAnnotations((Retrofit)((Object)result), method2, (RequestFactory)object2);
                this.serviceMethodCache.put((Method)var1_1, result);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.nextRequestBodyConverter(null, (Type)var1_1, (Annotation[])var2_2, (Annotation[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <T> Converter<T, RequestBody> nextRequestBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        int i;
        void var1_1;
        void var2_2;
        int start;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(parameterAnnotations, "parameterAnnotations == null");
        Objects.requireNonNull(methodAnnotations, "methodAnnotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter.Factory factory = this.converterFactories.get(i2);
            Converter<?, RequestBody> converter = factory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate RequestBody converter for ").append(var2_2).append(".\n");
        if (var1_1 != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Converter<ResponseBody, T> nextResponseBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] annotations) {
        int i;
        void var1_1;
        void var2_2;
        int start;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i2).responseBodyConverter(type, annotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate ResponseBody converter for ").append(var2_2).append(".\n");
        if (var1_1 != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Converter<T, String> stringConverter(Type type, Annotation[] annotations) {
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i = 0; i < count; ++i) {
            void var3_5;
            this.converterFactories.get(i);
            Object converter = null;
            if (null == null) continue;
            return var3_5;
        }
        return BuiltInConverters.ToStringConverter.INSTANCE;
    }

    public static final class Builder {
        private final Platform platform;
        @Nullable
        private Call.Factory callFactory;
        @Nullable
        private HttpUrl baseUrl;
        private final List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private final List<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        @Nullable
        private Executor callbackExecutor;

        /*
         * WARNING - void declaration
         */
        private Builder(Platform platform) {
            void var1_1;
            this.platform = var1_1;
        }

        public Builder() {
            this(Platform.get());
        }

        /*
         * WARNING - void declaration
         */
        public final Builder callFactory(Call.Factory factory) {
            void var1_1;
            this.callFactory = (Call.Factory)Objects.requireNonNull(var1_1, "factory == null");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder baseUrl(HttpUrl baseUrl) {
            void var1_1;
            void var2_2;
            Objects.requireNonNull(baseUrl, "baseUrl == null");
            List pathSegments = baseUrl.pathSegments();
            void v0 = var2_2;
            if (!"".equals(v0.get(v0.size() - 1))) {
                throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
            }
            this.baseUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addConverterFactory(Converter.Factory factory) {
            void var1_1;
            this.converterFactories.add((Converter.Factory)Objects.requireNonNull(var1_1, "factory == null"));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Retrofit build() {
            void var2_2;
            void var3_3;
            void var1_1;
            Executor callbackExecutor;
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((callbackExecutor = this.callbackExecutor) == null) {
                callbackExecutor = this.platform.defaultCallbackExecutor();
            }
            ArrayList<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>(this.callAdapterFactories);
            callAdapterFactories.addAll(this.platform.defaultCallAdapterFactories(callbackExecutor));
            ArrayList<? extends Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(1 + this.converterFactories.size() + this.platform.defaultConverterFactoriesSize());
            converterFactories.add(new BuiltInConverters());
            converterFactories.addAll(this.converterFactories);
            converterFactories.addAll(this.platform.defaultConverterFactories());
            return new Retrofit((Call.Factory)var1_1, this.baseUrl, Collections.unmodifiableList(converterFactories), Collections.unmodifiableList(var3_3), (Executor)var2_2, false);
        }
    }
}

