/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;

final class Utils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    /*
     * WARNING - void declaration
     */
    static RuntimeException methodError(Method method, String message, Object ... args) {
        void var2_2;
        void var1_1;
        return Utils.methodError(method, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static RuntimeException methodError(Method method, @Nullable Throwable cause, String message, Object ... args) {
        void var1_1;
        Method method2;
        void var2_2;
        void var3_3;
        message = String.format(message, (Object[])var3_3);
        return new IllegalArgumentException((String)var2_2 + "\n    for method " + method.getDeclaringClass().getSimpleName() + "." + method2.getName(), (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static RuntimeException parameterError(Method method, Throwable cause, int p, String message, Object ... args) {
        void var2_2;
        void var3_3;
        void var1_1;
        return Utils.methodError(method, (Throwable)var1_1, (String)var3_3 + " (parameter #" + (int)(var2_2 + true) + ")", args);
    }

    /*
     * WARNING - void declaration
     */
    static RuntimeException parameterError(Method method, int p, String message, Object ... args) {
        void var3_4;
        void var1_1;
        void var2_3;
        String string = (String)var2_3 + " (parameter #" + (int)(var1_1 + true) + ")";
        var2_3 = var3_4;
        String string2 = string;
        Method method2 = method;
        return Utils.methodError(method2, null, string2, (Object[])var2_3);
    }

    static Class<?> getRawType(Type type) {
        Type type2;
        while (true) {
            Objects.requireNonNull(type, "type == null");
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                Type rawType = (type = (ParameterizedType)type).getRawType();
                if (!(rawType instanceof Class)) {
                    throw new IllegalArgumentException();
                }
                return (Class)type2;
            }
            if (type2 instanceof GenericArrayType) {
                type2 = ((GenericArrayType)type2).getGenericComponentType();
                return Array.newInstance(Utils.getRawType(type2), 0).getClass();
            }
            if (type2 instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type2 instanceof WildcardType)) break;
            type2 = ((WildcardType)type2).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type2 + "> is of type " + type2.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    static boolean equals(Type a, Type b) {
        WildcardType wb;
        Type wa;
        Type gb;
        Type ga;
        while (true) {
            ParameterizedType pb;
            Type pa;
            if (a == b) {
                return true;
            }
            if (a instanceof Class) {
                return a.equals(b);
            }
            if (a instanceof ParameterizedType) {
                void var3_3;
                void var2_2;
                Type ownerB;
                if (!(b instanceof ParameterizedType)) {
                    return false;
                }
                pa = (ParameterizedType)a;
                pb = (ParameterizedType)b;
                Type ownerA = pa.getOwnerType();
                return (ownerA == (ownerB = pb.getOwnerType()) || ownerA != null && var2_2.equals(var3_3)) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
            }
            if (!(pa instanceof GenericArrayType)) break;
            if (!(pb instanceof GenericArrayType)) {
                return false;
            }
            ga = (GenericArrayType)pa;
            gb = (GenericArrayType)((Object)pb);
            gb = gb.getGenericComponentType();
            ga = ga.getGenericComponentType();
        }
        if (ga instanceof WildcardType) {
            if (!(gb instanceof WildcardType)) {
                return false;
            }
            wa = (WildcardType)ga;
            wb = (WildcardType)gb;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (wa instanceof TypeVariable) {
            void var1_1;
            Type type;
            if (!(wb instanceof TypeVariable)) {
                return false;
            }
            Type va = (TypeVariable)wa;
            TypeVariable vb = (TypeVariable)((Object)wb);
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && type.getName().equals(var1_1.getName());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        void var2_2;
        block0: while (true) {
            if (toResolve == rawType) {
                return context;
            }
            if (toResolve.isInterface()) {
                Object interfaces = ((Class)rawType).getInterfaces();
                int length = ((Class<?>[])interfaces).length;
                for (int i = 0; i < length; ++i) {
                    if (interfaces[i] == toResolve) {
                        return ((Class)rawType).getGenericInterfaces()[i];
                    }
                    if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                    Type type = ((Class)rawType).getGenericInterfaces()[i];
                    rawType = interfaces[i];
                    interfaces = type;
                    continue block0;
                }
            }
            if (((Class)rawType).isInterface()) break;
            while (rawType != Object.class) {
                Object object;
                Object rawSupertype = ((Class)rawType).getSuperclass();
                if (rawSupertype == toResolve) {
                    return ((Class)rawType).getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom((Class<?>)rawSupertype)) {
                    Type type = ((Class)rawType).getGenericSuperclass();
                    rawType = rawSupertype;
                    rawSupertype = type;
                    continue block0;
                }
                rawType = object;
            }
            break;
        }
        return var2_2;
    }

    static String typeToString(Type type) {
        Type type2;
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        void var2_2;
        void var1_1;
        Type type;
        if (!supertype.isAssignableFrom(contextRawType)) {
            throw new IllegalArgumentException();
        }
        return Utils.resolve(context, contextRawType, Utils.getGenericSupertype(type, var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        void var2_2;
        Type[] args;
        Class<?> componentType;
        Type original;
        while (toResolve instanceof TypeVariable) {
            Type type;
            TypeVariable typeVariable;
            TypeVariable typeVariable2 = typeVariable = (TypeVariable)toResolve;
            Class<?> clazz = contextRawType;
            toResolve = context;
            Type type2 = typeVariable2;
            Object object = type2.getGenericDeclaration();
            type2 = object instanceof Class ? (Class)object : null;
            if (type2 != null && (toResolve = Utils.getGenericSupertype(toResolve, clazz, type2)) instanceof ParameterizedType) {
                int n;
                block18: {
                    object = typeVariable2;
                    type2 = ((Class)type2).getTypeParameters();
                    for (n = 0; n < ((Type)type2).length; ++n) {
                        if (!object.equals(type2[n])) {
                            continue;
                        }
                        break block18;
                    }
                    throw new NoSuchElementException();
                }
                type = ((ParameterizedType)toResolve).getActualTypeArguments()[n];
            } else {
                type = toResolve = typeVariable2;
            }
            if (type != typeVariable) continue;
            return toResolve;
        }
        if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
            Type newComponentType;
            original = (Class)toResolve;
            componentType = ((Class)original).getComponentType();
            if (componentType == (newComponentType = Utils.resolve(context, contextRawType, componentType))) {
                return original;
            }
            return new GenericArrayTypeImpl(newComponentType);
        }
        if (componentType instanceof GenericArrayType) {
            Type newComponentType;
            original = (GenericArrayType)((Object)componentType);
            if ((componentType = original.getGenericComponentType()) == (newComponentType = Utils.resolve(context, contextRawType, componentType))) {
                return original;
            }
            return new GenericArrayTypeImpl(newComponentType);
        }
        if (componentType instanceof ParameterizedType) {
            original = (ParameterizedType)((Object)componentType);
            Type ownerType = original.getOwnerType();
            Type newOwnerType = Utils.resolve(context, contextRawType, ownerType);
            boolean changed = newOwnerType != ownerType;
            args = original.getActualTypeArguments();
            int length = args.length;
            for (int t = 0; t < length; ++t) {
                Type resolvedTypeArgument = Utils.resolve(context, contextRawType, args[t]);
                if (resolvedTypeArgument == args[t]) continue;
                if (!changed) {
                    args = (Type[])args.clone();
                    changed = true;
                }
                args[t] = resolvedTypeArgument;
            }
            if (changed) {
                return new ParameterizedTypeImpl(newOwnerType, original.getRawType(), args);
            }
            return original;
        }
        if (args instanceof WildcardType) {
            void var3_3;
            void var1_1;
            Type type;
            Type upperBound;
            original = (WildcardType)args;
            Type[] originalLowerBound = original.getLowerBounds();
            Type[] originalUpperBound = original.getUpperBounds();
            if (originalLowerBound.length == 1) {
                Type lowerBound = Utils.resolve(context, contextRawType, originalLowerBound[0]);
                if (lowerBound != var2_2[0]) {
                    return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{lowerBound});
                }
            } else if (originalUpperBound.length == 1 && (upperBound = Utils.resolve(type, var1_1, originalUpperBound[0])) != originalUpperBound[0]) {
                return new WildcardTypeImpl(new Type[]{upperBound}, EMPTY_TYPE_ARRAY);
            }
            return var3_3;
        }
        return var2_2;
    }

    static void checkNotPrimitive(Type type) {
        Type type2;
        if (type instanceof Class && ((Class)type2).isPrimitive()) {
            throw new IllegalArgumentException();
        }
    }

    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> cls) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation = annotationArray[i];
            if (!cls.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static ResponseBody buffer(ResponseBody body) throws IOException {
        void var1_1;
        ResponseBody responseBody;
        Buffer buffer = new Buffer();
        body.source().readAll((Sink)buffer);
        return ResponseBody.create((MediaType)body.contentType(), (long)responseBody.contentLength(), (BufferedSource)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Type getParameterUpperBound(int index, ParameterizedType type) {
        void var0_1;
        void var2_3;
        Type[] types = type.getActualTypeArguments();
        if (index < 0 || index >= types.length) {
            void var1_2;
            throw new IllegalArgumentException("Index " + index + " not in range [0," + types.length + ") for " + var1_2);
        }
        void paramType = var2_3[index];
        if (paramType instanceof WildcardType) {
            return ((WildcardType)paramType).getUpperBounds()[0];
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static Type getParameterLowerBound(int index, ParameterizedType type) {
        void var0_1;
        Type paramType = type.getActualTypeArguments()[0];
        if (paramType instanceof WildcardType) {
            return ((WildcardType)paramType).getLowerBounds()[0];
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static boolean hasUnresolvableType(@Nullable Type type) {
        void var1_3;
        Type type2;
        while (true) {
            if (type instanceof Class) {
                return false;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type type3 : parameterizedType.getActualTypeArguments()) {
                    if (!Utils.hasUnresolvableType(type3)) continue;
                    return true;
                }
                return false;
            }
            if (!(type instanceof GenericArrayType)) break;
            type = ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof WildcardType) {
            return true;
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type2 + "> is of type " + (String)var1_3);
    }

    static void throwIfFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            Throwable throwable;
            throw (LinkageError)throwable;
        }
    }

    static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        /*
         * WARNING - void declaration
         */
        GenericArrayTypeImpl(Type componentType) {
            void var1_1;
            this.componentType = var1_1;
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            return o instanceof GenericArrayType && Utils.equals(this, (GenericArrayType)var1_1);
        }

        public final int hashCode() {
            return this.componentType.hashCode();
        }

        public final String toString() {
            return Utils.typeToString(this.componentType) + "[]";
        }
    }

    static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        /*
         * WARNING - void declaration
         */
        ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type ... typeArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (rawType instanceof Class && ownerType == null != (((Class)rawType).getEnclosingClass() == null)) {
                throw new IllegalArgumentException();
            }
            Type[] typeArray = typeArguments;
            int n = typeArguments.length;
            for (int i = 0; i < n; ++i) {
                Type typeArgument = typeArray[i];
                Objects.requireNonNull(typeArgument, "typeArgument == null");
                Utils.checkNotPrimitive(typeArgument);
            }
            this.ownerType = var1_1;
            this.rawType = var2_2;
            this.typeArguments = (Type[])var3_3.clone();
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getRawType() {
            return this.rawType;
        }

        @Override
        @Nullable
        public final Type getOwnerType() {
            return this.ownerType;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof ParameterizedType && Utils.equals(this, (ParameterizedType)var1_1);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ (this.ownerType != null ? this.ownerType.hashCode() : 0);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            if (this.typeArguments.length == 0) {
                return Utils.typeToString(this.rawType);
            }
            StringBuilder result = new StringBuilder(30 * (this.typeArguments.length + 1));
            result.append(Utils.typeToString(this.rawType));
            result.append("<").append(Utils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                result.append(", ").append(Utils.typeToString(this.typeArguments[i]));
            }
            return var1_1.append(">").toString();
        }
    }

    static final class WildcardTypeImpl
    implements WildcardType {
        private final Type upperBound;
        @Nullable
        private final Type lowerBound;

        /*
         * WARNING - void declaration
         */
        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            void var1_1;
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException();
            }
            if (lowerBounds.length == 1) {
                void var2_2;
                if (lowerBounds[0] == null) {
                    throw new NullPointerException();
                }
                Utils.checkNotPrimitive(lowerBounds[0]);
                if (upperBounds[0] != Object.class) {
                    throw new IllegalArgumentException();
                }
                this.lowerBound = var2_2[0];
                this.upperBound = Object.class;
                return;
            }
            if (upperBounds[0] == null) {
                throw new NullPointerException();
            }
            Utils.checkNotPrimitive(upperBounds[0]);
            this.lowerBound = null;
            this.upperBound = var1_1[0];
        }

        @Override
        public final Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public final Type[] getLowerBounds() {
            if (this.lowerBound != null) {
                return new Type[]{this.lowerBound};
            }
            return EMPTY_TYPE_ARRAY;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof WildcardType && Utils.equals(this, (WildcardType)var1_1);
        }

        public final int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public final String toString() {
            if (this.lowerBound != null) {
                return "? super " + Utils.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + Utils.typeToString(this.upperBound);
        }
    }
}

