/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryLevel;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Breadcrumb
implements JsonSerializable {
    private final Date timestamp;
    private String message;
    private String type;
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private String category;
    private SentryLevel level;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public Breadcrumb(Date timestamp) {
        void var1_1;
        this.timestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Breadcrumb(Breadcrumb breadcrumb) {
        void var1_1;
        this.timestamp = breadcrumb.timestamp;
        this.message = breadcrumb.message;
        this.type = breadcrumb.type;
        this.category = breadcrumb.category;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb.data);
        if (dataClone != null) {
            void var2_2;
            this.data = var2_2;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb.unknown);
        this.level = var1_1.level;
    }

    public Breadcrumb() {
        this(AnimationSpecKt.getCurrentDateTime());
    }

    public final Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breadcrumb that = (Breadcrumb)o;
        return this.timestamp.getTime() == that.timestamp.getTime() && AnimationSpecKt.equals((Object)this.message, (Object)that.message) && AnimationSpecKt.equals((Object)this.type, (Object)that.type) && AnimationSpecKt.equals((Object)this.category, (Object)that.category) && this.level == var1_1.level;
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.timestamp, this.message, this.type, this.category, this.level};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("timestamp").value(logger, this.timestamp);
        if (this.message != null) {
            writer.name("message").value(this.message);
        }
        if (this.type != null) {
            writer.name("type").value(this.type);
        }
        writer.name("data").value(logger, this.data);
        if (this.category != null) {
            writer.name("category").value(this.category);
        }
        if (this.level != null) {
            writer.name("level").value(logger, this.level);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(Breadcrumb x0, String x1) {
        void var1_1;
        x0.message = var1_1;
        return x0.message;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(Breadcrumb x0, String x1) {
        void var1_1;
        x0.type = var1_1;
        return x0.type;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$202(Breadcrumb x0, Map x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(Breadcrumb x0, String x1) {
        void var1_1;
        x0.category = var1_1;
        return x0.category;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryLevel access$402(Breadcrumb x0, SentryLevel x1) {
        void var1_1;
        x0.level = var1_1;
        return x0.level;
    }

    public static final class Deserializer
    implements JsonDeserializer<Breadcrumb> {
        /*
         * WARNING - void declaration
         */
        private static Breadcrumb deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            JsonObjectReader jsonObjectReader;
            void var3_3;
            void var2_2;
            reader.beginObject();
            Date timestamp = AnimationSpecKt.getCurrentDateTime();
            String message = null;
            String type = null;
            Map data = new ConcurrentHashMap();
            String category = null;
            SentryLevel level = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                void exception2;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "timestamp": {
                        Date deserializedDate = reader.nextDateOrNull(logger);
                        if (deserializedDate == null) continue block18;
                        timestamp = deserializedDate;
                        continue block18;
                    }
                    case "message": {
                        message = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "type": {
                        type = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        if (deserializedData == null) continue block18;
                        data = deserializedData;
                        continue block18;
                    }
                    case "category": {
                        category = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "level": {
                        try {
                            new SentryLevel.Deserializer();
                            level = SentryLevel.Deserializer.deserialize$6da8e991(reader);
                        }
                        catch (Exception exception2) {
                            logger.log(SentryLevel.ERROR, exception2, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)exception2);
            }
            Breadcrumb breadcrumb = new Breadcrumb((Date)var2_2);
            Breadcrumb.access$002(breadcrumb, (String)var3_3);
            Breadcrumb.access$102(breadcrumb, type);
            Breadcrumb.access$202(breadcrumb, data);
            Breadcrumb.access$302(breadcrumb, category);
            Breadcrumb.access$402(breadcrumb, level);
            breadcrumb.setUnknown(unknown);
            jsonObjectReader.endObject();
            return breadcrumb;
        }
    }
}

