/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.IEnvelopeReader;
import io.sentry.ISerializer;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEnvelopeItemHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public final class EnvelopeReader
implements IEnvelopeReader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ISerializer serializer;

    /*
     * WARNING - void declaration
     */
    public EnvelopeReader(ISerializer serializer) {
        void var1_1;
        this.serializer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CloseKt read$7815be51(InputStream stream) throws IOException {
        Object buffer = new byte[1024];
        int streamOffset = 0;
        int envelopeEndHeaderOffset = -1;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            void var3_14;
            void var1_1;
            int currentLength;
            while ((currentLength = stream.read((byte[])buffer)) > 0) {
                for (int i = 0; envelopeEndHeaderOffset == -1 && i < currentLength; ++i) {
                    if (buffer[i] != 10) continue;
                    envelopeEndHeaderOffset = streamOffset + i;
                    break;
                }
                outputStream.write((byte[])buffer, 0, currentLength);
                streamOffset += currentLength;
            }
            byte[] envelopeBytes = outputStream.toByteArray();
            if (envelopeBytes.length == 0) {
                throw new IllegalArgumentException("Empty stream.");
            }
            if (envelopeEndHeaderOffset == -1) {
                throw new IllegalArgumentException("Envelope contains no header.");
            }
            int n = envelopeEndHeaderOffset;
            int n2 = 0;
            Object object = envelopeBytes;
            buffer = this;
            object = new String((byte[])object, 0, n, UTF_8);
            SentryEnvelopeHeader header = buffer.serializer.deserialize((Reader)(object = (Object)new StringReader((String)object)), SentryEnvelopeHeader.class);
            if (header == null) {
                throw new IllegalArgumentException("Envelope header is null.");
            }
            int itemHeaderStartOffset2 = envelopeEndHeaderOffset + 1;
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            while (true) {
                void var2_4;
                int lineBreakIndex = -1;
                for (int i = itemHeaderStartOffset2; i < envelopeBytes.length; ++i) {
                    if (envelopeBytes[i] != 10) continue;
                    lineBreakIndex = i;
                    break;
                }
                if (lineBreakIndex == -1) {
                    throw new IllegalArgumentException("Invalid envelope. Item at index '" + items.size() + "'. has no header delimiter.");
                }
                n = lineBreakIndex - itemHeaderStartOffset2;
                n2 = itemHeaderStartOffset2;
                object = envelopeBytes;
                EnvelopeReader itemHeaderStartOffset2 = this;
                object = new String((byte[])object, n2, n, UTF_8);
                SentryEnvelopeItemHeader itemHeader = itemHeaderStartOffset2.serializer.deserialize((Reader)(object = (Object)new StringReader((String)object)), SentryEnvelopeItemHeader.class);
                if (itemHeader == null || itemHeader.getLength() <= 0) {
                    throw new IllegalArgumentException("Item header at index '" + items.size() + "' is null or empty.");
                }
                int payloadEndOffsetExclusive = lineBreakIndex + itemHeader.getLength() + 1;
                if (payloadEndOffsetExclusive > envelopeBytes.length) {
                    throw new IllegalArgumentException("Invalid length for item at index '" + items.size() + "'. Item is '" + payloadEndOffsetExclusive + "' bytes. There are '" + envelopeBytes.length + "' in the buffer.");
                }
                byte[] envelopeItemBytes = Arrays.copyOfRange(envelopeBytes, lineBreakIndex + 1, payloadEndOffsetExclusive);
                SentryEnvelopeItem item = new SentryEnvelopeItem(itemHeader, envelopeItemBytes);
                items.add(item);
                if (payloadEndOffsetExclusive == envelopeBytes.length) break;
                if (payloadEndOffsetExclusive + 1 == envelopeBytes.length) {
                    if (envelopeBytes[payloadEndOffsetExclusive] == 10) break;
                    throw new IllegalArgumentException("Envelope has invalid data following an item.");
                }
                ++var2_4;
            }
            CloseKt closeKt = new CloseKt((SentryEnvelopeHeader)var1_1, (Iterable)var3_14);
            return closeKt;
        }
    }
}

