/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.IntegrationName;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.SentryClient;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Stack;
import io.sentry.TracesSampler;
import io.sentry.protocol.SentryId;
import io.sentry.util.Pair;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class Hub
implements IHub {
    private volatile SentryId lastEventId;
    private final SentryOptions options;
    private volatile boolean isEnabled;
    private final Stack stack;
    private final Map<Throwable, Pair<WeakReference<ISpan>, String>> throwableToSpan;

    /*
     * WARNING - void declaration
     */
    public Hub(SentryOptions options) {
        void var1_1;
        Hub.validateOptions((SentryOptions)var1_1);
        Scope scope = new Scope((SentryOptions)var1_1);
        SentryClient sentryClient = new SentryClient((SentryOptions)var1_1);
        this((SentryOptions)var1_1, new Stack.StackItem((SentryOptions)var1_1, sentryClient, scope));
    }

    /*
     * WARNING - void declaration
     */
    private Hub(SentryOptions options, Stack stack) {
        void var1_1;
        void var2_2;
        this.throwableToSpan = Collections.synchronizedMap(new WeakHashMap());
        Hub.validateOptions(options);
        this.options = options;
        new TracesSampler(options);
        this.stack = var2_2;
        this.lastEventId = SentryId.EMPTY_ID;
        var1_1.getTransactionPerformanceCollector();
        this.isEnabled = true;
    }

    /*
     * WARNING - void declaration
     */
    private Hub(SentryOptions options, Stack.StackItem rootStackItem) {
        this(options, new Stack(var1_1.getLogger(), (Stack.StackItem)var2_2));
        void var2_2;
        void var1_1;
    }

    private static void validateOptions(SentryOptions options) {
        SentryOptions sentryOptions;
        AnimationSpecKt.requireNonNull((Object)options, (String)"SentryOptions is required.");
        if (options.getDsn() == null || sentryOptions.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Hub requires a DSN to be instantiated. Considering using the NoOpHub if no DSN is available.");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, Hint hint) {
        void var2_2;
        void var1_1;
        return this.captureEventInternal((SentryEvent)var1_1, (Hint)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureEventInternal(SentryEvent event, Hint hint, ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                void var3_3;
                this.assignTraceContext(event);
                Stack.StackItem item = this.stack.peek();
                Scope scope = this.buildLocalScope(item.getScope(), scopeCallback);
                this.lastEventId = sentryId = item.getClient().captureEvent(event, (Scope)var3_3, (Hint)var2_2);
            }
            catch (Throwable e) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing event with id: " + var1_1.getEventId(), e);
            }
        }
        return sentryId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope$87b3736(CloseKt envelope, Hint hint) {
        void var3_4;
        AnimationSpecKt.requireNonNull((Object)envelope, (String)"SentryEnvelope is required.");
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEnvelope' call is a no-op.", new Object[0]);
        } else {
            try {
                void var2_3;
                SentryId capturedEnvelopeId = this.stack.peek().getClient().captureEnvelope$87b3736(envelope, (Hint)var2_3);
                if (capturedEnvelopeId != null) {
                    sentryId = capturedEnvelopeId;
                }
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing envelope.", (Throwable)var1_2);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureException(Throwable throwable, Hint hint) {
        void var2_2;
        void var1_1;
        return this.captureExceptionInternal((Throwable)var1_1, (Hint)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId captureExceptionInternal(Throwable throwable, Hint hint, ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                void var2_2;
                void var3_3;
                Stack.StackItem item = this.stack.peek();
                SentryEvent event = new SentryEvent(throwable);
                this.assignTraceContext(event);
                Scope scope = this.buildLocalScope(item.getScope(), scopeCallback);
                sentryId = item.getClient().captureEvent(event, (Scope)var3_3, (Hint)var2_2);
            }
            catch (Throwable e) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing exception: " + var1_1.getMessage(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    /*
     * WARNING - void declaration
     */
    private void assignTraceContext(SentryEvent event) {
        Pair<WeakReference<ISpan>, String> pair;
        if (this.options.isTracingEnabled() && event.getThrowable() != null && (pair = this.throwableToSpan.get(AnimationSpecKt.findRootCause((Throwable)event.getThrowable()))) != null) {
            void var2_2;
            ISpan span;
            WeakReference<ISpan> spanWeakRef = pair.getFirst();
            if (event.getContexts().getTrace() == null && spanWeakRef != null && (span = (ISpan)spanWeakRef.get()) != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            String transactionName = (String)var2_2.getSecond();
            if (event.getTransaction() == null && transactionName != null) {
                void var3_3;
                void var1_1;
                var1_1.setTransaction((String)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        Object object = this;
        if (!((Hub)object).isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
            return;
        }
        try {
            for (IntegrationName integration : this.options.getIntegrations()) {
                void var2_3;
                if (!(integration instanceof Closeable)) continue;
                ((Closeable)var2_3).close();
            }
            this.configureScope(scope -> scope.clear());
            this.options.getTransactionProfiler();
            this.options.getTransactionPerformanceCollector();
            this.options.getExecutorService().close(this.options.getShutdownTimeoutMillis());
            object = this.stack.peek();
            ((Stack.StackItem)object).getClient().close();
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error while closing the Hub.", (Throwable)var1_2);
        }
        this.isEnabled = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void configureScope(ScopeCallback callback) {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'configureScope' call is a no-op.", new Object[0]);
            return;
        }
        try {
            callback.run(this.stack.peek().getScope());
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'configureScope' callback.", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
            return;
        }
        try {
            this.stack.peek().getClient().flush(timeoutMillis);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'client.flush'.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public final IHub clone() {
        Hub hub = this;
        if (!hub.isEnabled) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabled Hub cloned.", new Object[0]);
        }
        return new Hub(this.options, new Stack(this.stack));
    }

    /*
     * WARNING - void declaration
     */
    private Scope buildLocalScope(Scope scope, ScopeCallback callback) {
        void var1_1;
        if (callback != null) {
            try {
                void var2_2;
                Scope localScope = new Scope(scope);
                var2_2.run(localScope);
                return localScope;
            }
            catch (Throwable t) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ScopeCallback' callback.", (Throwable)var3_4);
            }
        }
        return var1_1;
    }
}

