/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectDeserializer;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonReader;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class JsonObjectReader
extends JsonReader {
    /*
     * WARNING - void declaration
     */
    public JsonObjectReader(Reader in) {
        super((Reader)var1_1);
        void var1_1;
    }

    public final String nextStringOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextString();
    }

    public final Double nextDoubleOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextDouble();
    }

    public final Float nextFloatOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        JsonObjectReader jsonObjectReader = this;
        return Float.valueOf((float)jsonObjectReader.nextDouble());
    }

    public final Long nextLongOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextLong();
    }

    public final Integer nextIntegerOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextInt();
    }

    public final Boolean nextBooleanOrNull() throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextBoolean();
    }

    /*
     * WARNING - void declaration
     */
    public final void nextUnknown(ILogger logger, Map<String, Object> unknown, String name) {
        try {
            unknown.put(name, this.nextObjectOrNull());
            return;
        }
        catch (Exception exception) {
            void var3_4;
            void var2_3;
            void var1_1;
            var1_1.log(SentryLevel.ERROR, (Throwable)var2_3, "Error deserializing unknown key: %s", var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> List<T> nextList(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        void var3_3;
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        this.beginArray();
        ArrayList<T> list = new ArrayList<T>();
        do {
            try {
                list.add(deserializer.deserialize(this, logger));
            }
            catch (Exception e) {
                logger.log(SentryLevel.ERROR, "Failed to deserialize object in list.", e);
            }
        } while (this.peek() == JsonToken.BEGIN_OBJECT);
        this.endArray();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Map<String, T> nextMapOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        void var3_3;
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        this.beginObject();
        HashMap<String, T> map = new HashMap<String, T>();
        do {
            try {
                String key = this.nextName();
                map.put(key, deserializer.deserialize(this, logger));
            }
            catch (Exception e) {
                logger.log(SentryLevel.ERROR, "Failed to deserialize object in map.", e);
            }
        } while (this.peek() == JsonToken.BEGIN_OBJECT || this.peek() == JsonToken.NAME);
        this.endObject();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T nextOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws Exception {
        void var1_1;
        void var2_2;
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return var2_2.deserialize(this, (ILogger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Date nextDateOrNull(ILogger logger) throws IOException {
        void var1_1;
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return JsonObjectReader.dateOrNull(this.nextString(), (ILogger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Date dateOrNull(String dateString, ILogger logger) {
        if (dateString == null) {
            return null;
        }
        try {
            return AnimationSpecKt.getDateTime((String)dateString);
        }
        catch (Exception e) {
            logger.log(SentryLevel.DEBUG, "Error when deserializing UTC timestamp format, it might be millis timestamp format.", e);
            try {
                String string;
                return AnimationSpecKt.getDateTimeWithMillisPrecision((String)string);
            }
            catch (Exception e2) {
                void var2_3;
                void var1_1;
                var1_1.log(SentryLevel.ERROR, "Error when deserializing millis timestamp format.", (Throwable)var2_3);
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final TimeZone nextTimeZoneOrNull(ILogger logger) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        try {
            return TimeZone.getTimeZone(this.nextString());
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            var1_1.log(SentryLevel.ERROR, "Error when deserializing TimeZone", (Throwable)var2_2);
            return null;
        }
    }

    public final Object nextObjectOrNull() throws IOException {
        return new JsonObjectDeserializer().deserialize(this);
    }
}

