/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HostnameCache;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SentryThreadFactory;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Cached;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.SentryException;
import io.sentry.util.HintUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MainEventProcessor
implements EventProcessor,
Closeable {
    private final SentryOptions options;
    private final SentryThreadFactory sentryThreadFactory;
    private final SentryExceptionFactory sentryExceptionFactory;
    private volatile HostnameCache hostnameCache = null;

    /*
     * WARNING - void declaration
     */
    public MainEventProcessor(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)options, (String)"The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory((SentryStackTraceFactory)var1_1, this.options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEvent process(SentryEvent event, Hint hint) {
        void var1_1;
        Map<String, String> map;
        Object object = event;
        Map<String, String> map2 = this;
        MainEventProcessor.setPlatform((SentryBaseEvent)object);
        SentryEvent sentryEvent = event;
        object = this;
        map2 = sentryEvent.getThrowableMechanism();
        if (map2 != null) {
            sentryEvent.setExceptions(((MainEventProcessor)object).sentryExceptionFactory.getSentryExceptions((Throwable)((Object)map2)));
        }
        this.setDebugMeta(event);
        sentryEvent = event;
        object = this;
        map2 = ((MainEventProcessor)object).options.getModulesLoader().getOrLoadModules();
        if (map2 != null) {
            map = sentryEvent.getModules();
            if (map == null) {
                sentryEvent.setModules(map2);
            } else {
                map.putAll(map2);
            }
        }
        if (this.shouldApplyScopeData(event, hint)) {
            Object object2;
            this.processNonCachedEvent(event);
            map2 = object2;
            sentryEvent = event;
            object = this;
            if (sentryEvent.getThreads() == null) {
                Object object3;
                map = null;
                object2 = sentryEvent.getExceptions();
                if (object2 != null && !object2.isEmpty()) {
                    object3 = object2.iterator();
                    while (object3.hasNext()) {
                        SentryException sentryException = (SentryException)object3.next();
                        if (sentryException.getMechanism() == null || sentryException.getThreadId() == null) continue;
                        if (map == null) {
                            map = new ArrayList();
                        }
                        map.add(sentryException.getThreadId());
                    }
                }
                object3 = ((MainEventProcessor)object).options;
                if (HintUtils.hasType(map2, AbnormalExit.class)) {
                    ((Hint)((Object)map2)).get("sentry:typeCheckHint");
                    boolean bl = false;
                    object2 = map;
                    object3 = ((MainEventProcessor)object).sentryThreadFactory;
                    sentryEvent.setThreads(((SentryThreadFactory)object3).getCurrentThreads(Thread.getAllStackTraces(), (List<Long>)object2, bl));
                } else if (((MainEventProcessor)object).options.isAttachStacktrace() && (object2 == null || object2.isEmpty()) && !HintUtils.hasType(object3 = map2, Cached.class)) {
                    object3 = ((MainEventProcessor)object).sentryThreadFactory;
                    object2 = new HashMap<Thread, StackTraceElement[]>();
                    Object object4 = object = Thread.currentThread();
                    object2.put(object4, ((Thread)object4).getStackTrace());
                    sentryEvent.setThreads(((SentryThreadFactory)object3).getCurrentThreads((Map<Thread, StackTraceElement[]>)object2, null, false));
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setDebugMeta(SentryBaseEvent event) {
        ArrayList<DebugImage> debugImages = new ArrayList<DebugImage>();
        if (this.options.getProguardUuid() != null) {
            DebugImage proguardMappingImage = new DebugImage();
            proguardMappingImage.setType("proguard");
            proguardMappingImage.setUuid(this.options.getProguardUuid());
            debugImages.add(proguardMappingImage);
        }
        for (String bundleId : this.options.getBundleIds()) {
            DebugImage sourceBundleImage = new DebugImage();
            sourceBundleImage.setType("jvm");
            sourceBundleImage.setDebugId(bundleId);
            debugImages.add(sourceBundleImage);
        }
        if (!debugImages.isEmpty()) {
            void var3_3;
            void var1_1;
            DebugMeta debugMeta = event.getDebugMeta();
            if (debugMeta == null) {
                debugMeta = new DebugMeta();
            }
            if (debugMeta.getImages() == null) {
                debugMeta.setImages(debugImages);
            } else {
                void var2_2;
                debugMeta.getImages().addAll((Collection<DebugImage>)var2_2);
            }
            var1_1.setDebugMeta((DebugMeta)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", var1_1.getEventId());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void processNonCachedEvent(SentryBaseEvent event) {
        void var1_1;
        this.setRelease(event);
        this.setEnvironment(event);
        this.setServerName(event);
        this.setDist(event);
        this.setSdk(event);
        this.setTags(event);
        this.mergeUser((SentryBaseEvent)var1_1);
    }

    private static void setPlatform(SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            SentryBaseEvent sentryBaseEvent;
            sentryBaseEvent.setPlatform("java");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setRelease(SentryBaseEvent event) {
        if (event.getRelease() == null) {
            void var1_1;
            var1_1.setRelease(this.options.getRelease());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnvironment(SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            void var1_1;
            var1_1.setEnvironment(this.options.getEnvironment());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setServerName(SentryBaseEvent event) {
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && event.getServerName() == null) {
            this.ensureHostnameCache();
            if (this.hostnameCache != null) {
                void var1_1;
                var1_1.setServerName(this.hostnameCache.getHostname());
            }
        }
    }

    private void ensureHostnameCache() {
        if (this.hostnameCache == null) {
            MainEventProcessor mainEventProcessor = this;
            synchronized (mainEventProcessor) {
                if (this.hostnameCache == null) {
                    this.hostnameCache = HostnameCache.getInstance();
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setDist(SentryBaseEvent event) {
        if (event.getDist() == null) {
            void var1_1;
            var1_1.setDist(this.options.getDist());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSdk(SentryBaseEvent event) {
        if (event.getSdk() == null) {
            void var1_1;
            var1_1.setSdk(this.options.getSdkVersion());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setTags(SentryBaseEvent event) {
        if (event.getTags() == null) {
            event.setTags(new HashMap<String, String>(this.options.getTags()));
            return;
        }
        for (Map.Entry<String, String> item : this.options.getTags().entrySet()) {
            void var3_3;
            if (event.getTags().containsKey(item.getKey())) continue;
            event.setTag(item.getKey(), (String)var3_3.getValue());
        }
    }

    private void mergeUser(SentryBaseEvent event) {
        SentryOptions sentryOptions = this.options;
    }

    @Override
    public final void close() throws IOException {
        if (this.hostnameCache != null) {
            this.hostnameCache.close();
        }
    }
}

