/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.NoOpTransaction;
import io.sentry.ProfilingTransactionData;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public final class ProfilingTraceData
implements JsonSerializable {
    private final File traceFile;
    private final Callable<List<Integer>> deviceCpuFrequenciesReader;
    private int androidApiLevel;
    private String deviceLocale;
    private String deviceManufacturer;
    private String deviceModel;
    private String deviceOsBuildNumber;
    private String deviceOsName;
    private String deviceOsVersion;
    private boolean deviceIsEmulator;
    private String cpuArchitecture;
    private List<Integer> deviceCpuFrequencies = new ArrayList<Integer>();
    private String devicePhysicalMemoryBytes;
    private String platform;
    private String buildId;
    private List<ProfilingTransactionData> transactions;
    private String transactionName;
    private String durationNs;
    private String versionCode;
    private String release;
    private String transactionId;
    private String traceId;
    private String profileId;
    private String environment;
    private String truncationReason;
    private final Map<String, ProfileMeasurement> measurementsMap;
    private String sampledProfile = null;
    private Map<String, Object> unknown;

    private ProfilingTraceData() {
        this(new File("dummy"), NoOpTransaction.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTraceData(File traceFile, ITransaction transaction) {
        this((File)var1_1, new ArrayList<ProfilingTransactionData>(), (ITransaction)var2_2, "0", 0, "", () -> new ArrayList(), null, null, null, null, null, null, null, null, "normal", new HashMap<String, ProfileMeasurement>());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTraceData(File traceFile, List<ProfilingTransactionData> transactions, ITransaction transaction, String durationNanos, int sdkInt, String cpuArchitecture, Callable<List<Integer>> deviceCpuFrequenciesReader, String deviceManufacturer, String deviceModel, String deviceOsVersion, Boolean deviceIsEmulator, String devicePhysicalMemoryBytes, String buildId, String release, String environment, String truncationReason, Map<String, ProfileMeasurement> measurementsMap) {
        void var3_3;
        void var2_2;
        ProfilingTraceData profilingTraceData;
        this.traceFile = profilingTraceData;
        this.cpuArchitecture = cpuArchitecture;
        this.deviceCpuFrequenciesReader = deviceCpuFrequenciesReader;
        this.androidApiLevel = 0;
        this.deviceLocale = Locale.getDefault().toString();
        this.deviceManufacturer = deviceManufacturer != null ? deviceManufacturer : "";
        this.deviceModel = deviceModel != null ? deviceModel : "";
        this.deviceOsVersion = deviceOsVersion != null ? deviceOsVersion : "";
        this.deviceIsEmulator = deviceIsEmulator != null ? deviceIsEmulator : false;
        this.devicePhysicalMemoryBytes = devicePhysicalMemoryBytes != null ? devicePhysicalMemoryBytes : "0";
        this.deviceOsBuildNumber = "";
        this.deviceOsName = "android";
        this.platform = "android";
        this.buildId = buildId != null ? buildId : "";
        this.transactions = var2_2;
        this.transactionName = transaction.getName();
        this.durationNs = durationNanos;
        this.versionCode = "";
        this.release = release != null ? release : "";
        this.transactionId = transaction.getEventId().toString();
        this.traceId = var3_3.getSpanContext().getTraceId().toString();
        this.profileId = UUID.randomUUID().toString();
        this.environment = environment != null ? environment : "production";
        this.truncationReason = truncationReason;
        profilingTraceData = this;
        if (!(profilingTraceData.truncationReason.equals("normal") || profilingTraceData.truncationReason.equals("timeout") || profilingTraceData.truncationReason.equals("backgrounded"))) {
            this.truncationReason = "normal";
        }
        this.measurementsMap = measurementsMap;
    }

    public final File getTraceFile() {
        return this.traceFile;
    }

    public final String getProfileId() {
        return this.profileId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampledProfile(String sampledProfile) {
        void var1_1;
        this.sampledProfile = var1_1;
    }

    public final void readDeviceCpuFrequencies() {
        try {
            this.deviceCpuFrequencies = this.deviceCpuFrequenciesReader.call();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("android_api_level").value(logger, this.androidApiLevel);
        writer.name("device_locale").value(logger, this.deviceLocale);
        writer.name("device_manufacturer").value(this.deviceManufacturer);
        writer.name("device_model").value(this.deviceModel);
        writer.name("device_os_build_number").value(this.deviceOsBuildNumber);
        writer.name("device_os_name").value(this.deviceOsName);
        writer.name("device_os_version").value(this.deviceOsVersion);
        writer.name("device_is_emulator").value(this.deviceIsEmulator);
        writer.name("architecture").value(logger, this.cpuArchitecture);
        writer.name("device_cpu_frequencies").value(logger, this.deviceCpuFrequencies);
        writer.name("device_physical_memory_bytes").value(this.devicePhysicalMemoryBytes);
        writer.name("platform").value(this.platform);
        writer.name("build_id").value(this.buildId);
        writer.name("transaction_name").value(this.transactionName);
        writer.name("duration_ns").value(this.durationNs);
        writer.name("version_name").value(this.release);
        writer.name("version_code").value(this.versionCode);
        if (!this.transactions.isEmpty()) {
            writer.name("transactions").value(logger, this.transactions);
        }
        writer.name("transaction_id").value(this.transactionId);
        writer.name("trace_id").value(this.traceId);
        writer.name("profile_id").value(this.profileId);
        writer.name("environment").value(this.environment);
        writer.name("truncation_reason").value(this.truncationReason);
        if (this.sampledProfile != null) {
            writer.name("sampled_profile").value(this.sampledProfile);
        }
        writer.name("measurements").value(logger, this.measurementsMap);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /* synthetic */ ProfilingTraceData(byte by) {
        this();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$102(ProfilingTraceData x0, int x1) {
        void var1_1;
        x0.androidApiLevel = var1_1;
        return x0.androidApiLevel;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceLocale = var1_1;
        return x0.deviceLocale;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceManufacturer = var1_1;
        return x0.deviceManufacturer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceModel = var1_1;
        return x0.deviceModel;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsBuildNumber = var1_1;
        return x0.deviceOsBuildNumber;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsName = var1_1;
        return x0.deviceOsName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$702(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsVersion = var1_1;
        return x0.deviceOsVersion;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$802(ProfilingTraceData x0, boolean x1) {
        void var1_1;
        x0.deviceIsEmulator = var1_1;
        return x0.deviceIsEmulator;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$902(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.cpuArchitecture = var1_1;
        return x0.cpuArchitecture;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$1002(ProfilingTraceData x0, List x1) {
        void var1_1;
        x0.deviceCpuFrequencies = var1_1;
        return x0.deviceCpuFrequencies;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1102(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.devicePhysicalMemoryBytes = var1_1;
        return x0.devicePhysicalMemoryBytes;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.platform = var1_1;
        return x0.platform;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.buildId = var1_1;
        return x0.buildId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1402(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.transactionName = var1_1;
        return x0.transactionName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1502(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.durationNs = var1_1;
        return x0.durationNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1602(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.versionCode = var1_1;
        return x0.versionCode;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1702(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.release = var1_1;
        return x0.release;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1902(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.transactionId = var1_1;
        return x0.transactionId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2002(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.traceId = var1_1;
        return x0.traceId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2102(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.profileId = var1_1;
        return x0.profileId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.environment = var1_1;
        return x0.environment;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.truncationReason = var1_1;
        return x0.truncationReason;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2502(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.sampledProfile = var1_1;
        return x0.sampledProfile;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfilingTraceData> {
        /*
         * WARNING - void declaration
         */
        private static ProfilingTraceData deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            JsonObjectReader jsonObjectReader;
            void var3_3;
            reader.beginObject();
            ProfilingTraceData data = new ProfilingTraceData(0);
            ConcurrentHashMap<String, Object> unknown = null;
            block54: while (reader.peek() == JsonToken.NAME) {
                void var4_4;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "android_api_level": {
                        Integer apiLevel = reader.nextIntegerOrNull();
                        if (apiLevel == null) continue block54;
                        ProfilingTraceData.access$102(data, apiLevel);
                        continue block54;
                    }
                    case "device_locale": {
                        String deviceLocale = reader.nextStringOrNull();
                        if (deviceLocale == null) continue block54;
                        ProfilingTraceData.access$202(data, deviceLocale);
                        continue block54;
                    }
                    case "device_manufacturer": {
                        String deviceManufacturer = reader.nextStringOrNull();
                        if (deviceManufacturer == null) continue block54;
                        ProfilingTraceData.access$302(data, deviceManufacturer);
                        continue block54;
                    }
                    case "device_model": {
                        String deviceModel = reader.nextStringOrNull();
                        if (deviceModel == null) continue block54;
                        ProfilingTraceData.access$402(data, deviceModel);
                        continue block54;
                    }
                    case "device_os_build_number": {
                        String deviceOsBuildNumber = reader.nextStringOrNull();
                        if (deviceOsBuildNumber == null) continue block54;
                        ProfilingTraceData.access$502(data, deviceOsBuildNumber);
                        continue block54;
                    }
                    case "device_os_name": {
                        String deviceOsName = reader.nextStringOrNull();
                        if (deviceOsName == null) continue block54;
                        ProfilingTraceData.access$602(data, deviceOsName);
                        continue block54;
                    }
                    case "device_os_version": {
                        String deviceOsVersion = reader.nextStringOrNull();
                        if (deviceOsVersion == null) continue block54;
                        ProfilingTraceData.access$702(data, deviceOsVersion);
                        continue block54;
                    }
                    case "device_is_emulator": {
                        Boolean deviceIsEmulator = reader.nextBooleanOrNull();
                        if (deviceIsEmulator == null) continue block54;
                        ProfilingTraceData.access$802(data, deviceIsEmulator);
                        continue block54;
                    }
                    case "architecture": {
                        String cpuArchitecture = reader.nextStringOrNull();
                        if (cpuArchitecture == null) continue block54;
                        ProfilingTraceData.access$902(data, cpuArchitecture);
                        continue block54;
                    }
                    case "device_cpu_frequencies": {
                        List deviceCpuFrequencies = (List)reader.nextObjectOrNull();
                        if (deviceCpuFrequencies == null) continue block54;
                        ProfilingTraceData.access$1002(data, deviceCpuFrequencies);
                        continue block54;
                    }
                    case "device_physical_memory_bytes": {
                        String devicePhysicalMemoryBytes = reader.nextStringOrNull();
                        if (devicePhysicalMemoryBytes == null) continue block54;
                        ProfilingTraceData.access$1102(data, devicePhysicalMemoryBytes);
                        continue block54;
                    }
                    case "platform": {
                        String platform = reader.nextStringOrNull();
                        if (platform == null) continue block54;
                        ProfilingTraceData.access$1202(data, platform);
                        continue block54;
                    }
                    case "build_id": {
                        String buildId = reader.nextStringOrNull();
                        if (buildId == null) continue block54;
                        ProfilingTraceData.access$1302(data, buildId);
                        continue block54;
                    }
                    case "transaction_name": {
                        String transactionName = reader.nextStringOrNull();
                        if (transactionName == null) continue block54;
                        ProfilingTraceData.access$1402(data, transactionName);
                        continue block54;
                    }
                    case "duration_ns": {
                        String durationNs = reader.nextStringOrNull();
                        if (durationNs == null) continue block54;
                        ProfilingTraceData.access$1502(data, durationNs);
                        continue block54;
                    }
                    case "version_code": {
                        String versionCode = reader.nextStringOrNull();
                        if (versionCode == null) continue block54;
                        ProfilingTraceData.access$1602(data, versionCode);
                        continue block54;
                    }
                    case "version_name": {
                        String versionName = reader.nextStringOrNull();
                        if (versionName == null) continue block54;
                        ProfilingTraceData.access$1702(data, versionName);
                        continue block54;
                    }
                    case "transactions": {
                        List<ProfilingTransactionData> transactions = reader.nextList(logger, new ProfilingTransactionData.Deserializer());
                        if (transactions == null) continue block54;
                        data.transactions.addAll(transactions);
                        continue block54;
                    }
                    case "transaction_id": {
                        String transactionId = reader.nextStringOrNull();
                        if (transactionId == null) continue block54;
                        ProfilingTraceData.access$1902(data, transactionId);
                        continue block54;
                    }
                    case "trace_id": {
                        String traceId = reader.nextStringOrNull();
                        if (traceId == null) continue block54;
                        ProfilingTraceData.access$2002(data, traceId);
                        continue block54;
                    }
                    case "profile_id": {
                        String profileId = reader.nextStringOrNull();
                        if (profileId == null) continue block54;
                        ProfilingTraceData.access$2102(data, profileId);
                        continue block54;
                    }
                    case "environment": {
                        String environment = reader.nextStringOrNull();
                        if (environment == null) continue block54;
                        ProfilingTraceData.access$2202(data, environment);
                        continue block54;
                    }
                    case "truncation_reason": {
                        String truncationReason = reader.nextStringOrNull();
                        if (truncationReason == null) continue block54;
                        ProfilingTraceData.access$2302(data, truncationReason);
                        continue block54;
                    }
                    case "measurements": {
                        Map<String, ProfileMeasurement> measurements = reader.nextMapOrNull(logger, new ProfileMeasurement.Deserializer());
                        if (measurements == null) continue block54;
                        data.measurementsMap.putAll(measurements);
                        continue block54;
                    }
                    case "sampled_profile": {
                        String sampledProfile = reader.nextStringOrNull();
                        if (sampledProfile == null) continue block54;
                        ProfilingTraceData.access$2502(data, sampledProfile);
                        continue block54;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var4_4);
            }
            data.setUnknown((Map<String, Object>)var3_3);
            jsonObjectReader.endObject();
            return var2_2;
        }
    }
}

