/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.NoOpTransaction;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ProfilingTransactionData
implements JsonSerializable {
    private String id;
    private String traceId;
    private String name;
    private Long relativeStartNs;
    private Long relativeEndNs;
    private Long relativeStartCpuMs;
    private Long relativeEndCpuMs;
    private Map<String, Object> unknown;

    public ProfilingTransactionData() {
        this(NoOpTransaction.getInstance(), 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTransactionData(ITransaction transaction, Long startNs, Long startCpuMs) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = transaction.getEventId().toString();
        this.traceId = transaction.getSpanContext().getTraceId().toString();
        this.name = var1_1.getName();
        this.relativeStartNs = var2_2;
        this.relativeStartCpuMs = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfilingTransactionData that = (ProfilingTransactionData)o;
        return this.id.equals(that.id) && this.traceId.equals(that.traceId) && this.name.equals(that.name) && this.relativeStartNs.equals(that.relativeStartNs) && this.relativeStartCpuMs.equals(that.relativeStartCpuMs) && AnimationSpecKt.equals((Object)this.relativeEndCpuMs, (Object)that.relativeEndCpuMs) && AnimationSpecKt.equals((Object)this.relativeEndNs, (Object)that.relativeEndNs) && AnimationSpecKt.equals(this.unknown, var1_1.unknown);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.id, this.traceId, this.name, this.relativeStartNs, this.relativeEndNs, this.relativeStartCpuMs, this.relativeEndCpuMs, this.unknown};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("id").value(logger, this.id);
        writer.name("trace_id").value(logger, this.traceId);
        writer.name("name").value(logger, this.name);
        writer.name("relative_start_ns").value(logger, this.relativeStartNs);
        writer.name("relative_end_ns").value(logger, this.relativeEndNs);
        writer.name("relative_cpu_start_ms").value(logger, this.relativeStartCpuMs);
        writer.name("relative_cpu_end_ms").value(logger, this.relativeEndCpuMs);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.id = var1_1;
        return x0.id;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.traceId = var1_1;
        return x0.traceId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(ProfilingTransactionData x0, String x1) {
        void var1_1;
        x0.name = var1_1;
        return x0.name;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$302(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeStartNs = var1_1;
        return x0.relativeStartNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$402(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeEndNs = var1_1;
        return x0.relativeEndNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$502(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeStartCpuMs = var1_1;
        return x0.relativeStartCpuMs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$602(ProfilingTransactionData x0, Long x1) {
        void var1_1;
        x0.relativeEndCpuMs = var1_1;
        return x0.relativeEndCpuMs;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfilingTransactionData> {
        /*
         * WARNING - void declaration
         */
        private static ProfilingTransactionData deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            JsonObjectReader jsonObjectReader;
            void var3_3;
            reader.beginObject();
            ProfilingTransactionData data = new ProfilingTransactionData();
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                void var4_4;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "id": {
                        String id = reader.nextStringOrNull();
                        if (id == null) continue block18;
                        ProfilingTransactionData.access$002(data, id);
                        continue block18;
                    }
                    case "trace_id": {
                        String traceId = reader.nextStringOrNull();
                        if (traceId == null) continue block18;
                        ProfilingTransactionData.access$102(data, traceId);
                        continue block18;
                    }
                    case "name": {
                        String name = reader.nextStringOrNull();
                        if (name == null) continue block18;
                        ProfilingTransactionData.access$202(data, name);
                        continue block18;
                    }
                    case "relative_start_ns": {
                        Long startNs = reader.nextLongOrNull();
                        if (startNs == null) continue block18;
                        ProfilingTransactionData.access$302(data, startNs);
                        continue block18;
                    }
                    case "relative_end_ns": {
                        Long endNs = reader.nextLongOrNull();
                        if (endNs == null) continue block18;
                        ProfilingTransactionData.access$402(data, endNs);
                        continue block18;
                    }
                    case "relative_cpu_start_ms": {
                        Long startCpuMs = reader.nextLongOrNull();
                        if (startCpuMs == null) continue block18;
                        ProfilingTransactionData.access$502(data, startCpuMs);
                        continue block18;
                    }
                    case "relative_cpu_end_ms": {
                        Long endCpuMs = reader.nextLongOrNull();
                        if (endCpuMs == null) continue block18;
                        ProfilingTransactionData.access$602(data, endCpuMs);
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var4_4);
            }
            data.setUnknown((Map<String, Object>)var3_3);
            jsonObjectReader.endObject();
            return var2_2;
        }
    }
}

