/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import io.sentry.Breadcrumb;
import io.sentry.CircularFifoQueue;
import io.sentry.EventProcessor;
import io.sentry.HostnameCache;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SynchronizedQueue;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.User;
import io.sentry.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Scope {
    private SentryLevel level;
    private ITransaction transaction;
    private String transactionName;
    private User user;
    private Request request;
    private List<String> fingerprint = new ArrayList<String>();
    private final Queue<Breadcrumb> breadcrumbs;
    private Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Map<String, Object> extra = new ConcurrentHashMap<String, Object>();
    private List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    private final SentryOptions options;
    private volatile Session session;
    private final Object sessionLock = new Object();
    private final Object transactionLock = new Object();
    private Contexts contexts = new Contexts();
    private List<HostnameCache.1> attachments = new CopyOnWriteArrayList<HostnameCache.1>();

    /*
     * WARNING - void declaration
     */
    public Scope(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"SentryOptions is required.");
        this.breadcrumbs = Scope.createBreadcrumbsList(this.options.getMaxBreadcrumbs());
    }

    /*
     * WARNING - void declaration
     */
    Scope(Scope scope) {
        void var1_1;
        void var3_3;
        this.transaction = scope.transaction;
        this.transactionName = scope.transactionName;
        this.session = scope.session;
        this.options = scope.options;
        this.level = scope.level;
        User userRef = scope.user;
        this.user = userRef != null ? new User(userRef) : null;
        Request requestRef = scope.request;
        this.request = requestRef != null ? new Request(requestRef) : null;
        this.fingerprint = new ArrayList<String>(scope.fingerprint);
        this.eventProcessors = new CopyOnWriteArrayList<EventProcessor>(scope.eventProcessors);
        Breadcrumb[] breadcrumbsRef = scope.breadcrumbs.toArray(new Breadcrumb[0]);
        Queue<Breadcrumb> breadcrumbsClone = Scope.createBreadcrumbsList(scope.options.getMaxBreadcrumbs());
        for (Breadcrumb breadcrumb : breadcrumbsRef) {
            Breadcrumb breadcrumbClone = new Breadcrumb(breadcrumb);
            breadcrumbsClone.add(breadcrumbClone);
        }
        this.breadcrumbs = var3_3;
        Map<String, String> tagsRef = scope.tags;
        ConcurrentHashMap<String, String> tagsClone = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : tagsRef.entrySet()) {
            if (entry == null) continue;
            tagsClone.put(entry.getKey(), entry.getValue());
        }
        this.tags = tagsClone;
        Map<String, Object> extraRef = scope.extra;
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> item : extraRef.entrySet()) {
            void var2_2;
            if (item == null) continue;
            concurrentHashMap.put(item.getKey(), var2_2.getValue());
        }
        this.extra = concurrentHashMap;
        this.contexts = new Contexts(scope.contexts);
        this.attachments = new CopyOnWriteArrayList<HostnameCache.1>(var1_1.attachments);
    }

    public final SentryLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public final String getTransactionName() {
        ITransaction tx = this.transaction;
        if (tx != null) {
            void var1_1;
            return var1_1.getName();
        }
        return this.transactionName;
    }

    /*
     * WARNING - void declaration
     */
    public final ISpan getSpan() {
        void var1_1;
        HostnameCache.1 span;
        ITransaction tx = this.transaction;
        if (tx != null && (span = tx.getLatestActiveSpan$1f2f6f5f()) != null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    public final User getUser() {
        return this.user;
    }

    public final Request getRequest() {
        return this.request;
    }

    final List<String> getFingerprint() {
        return this.fingerprint;
    }

    final Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public final void clearTransaction() {
        Iterator<LazyLayoutPrefetchState.Prefetcher> iterator = this.transactionLock;
        synchronized (iterator) {
            this.transaction = null;
        }
        this.transactionName = null;
        iterator = this.options.getScopeObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public final ITransaction getTransaction() {
        return this.transaction;
    }

    public final void clear() {
        this.level = null;
        this.user = null;
        this.request = null;
        this.fingerprint.clear();
        Object object = this;
        ((Scope)object).breadcrumbs.clear();
        object = ((Scope)object).options.getScopeObservers().iterator();
        while (object.hasNext()) {
            object.next();
        }
        this.tags.clear();
        this.extra.clear();
        this.eventProcessors.clear();
        this.clearTransaction();
        object = this;
        ((Scope)object).attachments.clear();
    }

    public final Map<String, String> getTags() {
        return CollectionUtils.newConcurrentHashMap(this.tags);
    }

    final Map<String, Object> getExtras() {
        return this.extra;
    }

    public final Contexts getContexts() {
        return this.contexts;
    }

    final List<HostnameCache.1> getAttachments() {
        return new CopyOnWriteArrayList<HostnameCache.1>(this.attachments);
    }

    private static Queue<Breadcrumb> createBreadcrumbsList(int maxBreadcrumb) {
        int n;
        return SynchronizedQueue.synchronizedQueue(new CircularFifoQueue(n));
    }

    final List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    /*
     * WARNING - void declaration
     */
    final Session withSession(IWithSession sessionCallback) {
        void var2_3;
        Session cloneSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            void var1_1;
            var1_1.accept(this.session);
            if (this.session != null) {
                cloneSession = this.session.clone();
            }
        }
        return var2_3;
    }

    static interface IWithSession {
        public void accept(Session var1);
    }
}

