/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.interaction.DragInteraction;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.text.selection.TextFieldSelectionManagerKt;
import androidx.compose.material3.IconButtonKt;
import io.sentry.Dsn;
import io.sentry.Hint;
import io.sentry.Hub;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.IntegrationName;
import io.sentry.NoOpHub;
import io.sentry.NoOpLogger;
import io.sentry.PreviousSessionFinalizer;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.cache.EnvelopeCache;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.sentry.internal.modules.CompositeModulesLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.ManifestModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.internal.modules.ResourcesModulesLoader;
import io.sentry.protocol.SentryId;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.DebugMetaPropertiesApplier;
import io.sentry.util.thread.MainThreadChecker;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;

public final class Sentry {
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static volatile boolean globalHubMode = false;

    /*
     * WARNING - void declaration
     */
    public static IHub getCurrentHub() {
        void var0;
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null || hub instanceof NoOpHub) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return var0;
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init(OptionsConfiguration<SentryOptions> optionsConfiguration) {
        boolean bl = false;
        OptionsConfiguration<SentryOptions> optionsConfiguration2 = optionsConfiguration;
        SentryOptions sentryOptions = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration2, sentryOptions);
        Sentry.init(sentryOptions, false);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options) {
        try {
            optionsConfiguration.configure(options);
            return;
        }
        catch (Throwable t) {
            void var0_1;
            void var1_2;
            var1_2.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", (Throwable)var0_1);
            return;
        }
    }

    private static synchronized void init(SentryOptions options, boolean globalHubMode) {
        SentryOptions sentryOptions;
        Object object2;
        if (Sentry.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
        }
        if (!Sentry.initConfigurations(options)) {
            return;
        }
        options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = globalHubMode;
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        object2.close();
        object2 = options.getExecutorService();
        if (object2.isClosed()) {
            options.setExecutorService(new SentryExecutorService());
        }
        for (IntegrationName object3 : options.getIntegrations()) {
            object3.register(HubAdapter.getInstance(), options);
        }
        object2 = options;
        try {
            ((SentryOptions)object2).getExecutorService().submit(() -> Sentry.lambda$notifyOptionsObservers$2((SentryOptions)object2));
        }
        catch (Throwable throwable) {
            ((SentryOptions)object2).getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", throwable);
        }
        HubAdapter hubAdapter = HubAdapter.getInstance();
        object2 = sentryOptions;
        try {
            ((SentryOptions)object2).getExecutorService().submit(new PreviousSessionFinalizer((SentryOptions)object2, hubAdapter));
            return;
        }
        catch (Throwable throwable) {
            ((SentryOptions)object2).getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", throwable);
            return;
        }
    }

    private static boolean initConfigurations(SentryOptions options) {
        DragInteraction dragInteraction;
        IModulesLoader e2;
        Object object = options;
        String dsn = options.getDsn();
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string to disable SDK.");
        }
        if (dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        new Dsn(dsn);
        Object logger = options.getLogger();
        if (options.isDebug() && logger instanceof NoOpLogger) {
            options.setLogger((ILogger)new IconButtonKt());
            logger = options.getLogger();
        }
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        object = options;
        object = ((SentryOptions)object).getCacheDirPath();
        String outboxPath = object == null ? null : new File((String)object, "outbox").getAbsolutePath();
        if (outboxPath != null) {
            logger = new File((String)object);
            ((File)logger).mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        Object cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath != null) {
            cacheDirPath = new File((String)cacheDirPath);
            ((File)cacheDirPath).mkdirs();
            cacheDirPath = options.getEnvelopeDiskCache();
            if (cacheDirPath instanceof NoOpEnvelopeCache) {
                SentryOptions sentryOptions = options;
                sentryOptions.setEnvelopeDiskCache(EnvelopeCache.create(sentryOptions));
            }
        }
        object = options;
        String profilingTracesDirPath = (object = ((SentryOptions)object).getCacheDirPath()) == null ? null : new File((String)object, "profiling_traces").getAbsolutePath();
        object = options;
        if ((((SentryOptions)object).getProfilesSampleRate() != null && ((SentryOptions)object).getProfilesSampleRate() > 0.0 || ((SentryOptions)object).getProfilesSampler() != null) && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            File[] oldTracesDirContent = profilingTracesDir.listFiles();
            try {
                options.getExecutorService().submit(() -> {
                    File[] fileArray;
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File file : fileArray) {
                        AnimationSpecKt.deleteRecursively((File)file);
                    }
                });
            }
            catch (RejectedExecutionException e2) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e2);
            }
        }
        if ((e2 = options.getModulesLoader()) instanceof NoOpModulesLoader) {
            options.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options.getLogger()), new ResourcesModulesLoader(options.getLogger())), options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader(new ResourcesDebugMetaLoader(options.getLogger()));
        }
        Properties properties = options.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options, (Properties)dragInteraction);
        dragInteraction = options.getMainThreadChecker$523ee008();
        if (dragInteraction instanceof NoOpMainThreadChecker) {
            options.setMainThreadChecker$28b81ffc(MainThreadChecker.getInstance());
        }
        if (options.getCollectors().isEmpty()) {
            SentryOptions sentryOptions;
            sentryOptions.addCollector$6d9d2c87(new TextFieldSelectionManagerKt());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void close() {
        void var0;
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        currentHub.remove();
        var0.close();
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureEvent(SentryEvent event, Hint hint) {
        void var1_1;
        SentryEvent sentryEvent;
        return Sentry.getCurrentHub().captureEvent(sentryEvent, (Hint)var1_1);
    }

    public static SentryId captureException(Throwable throwable) {
        Throwable throwable2;
        return Sentry.getCurrentHub().captureException(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureException(Throwable throwable, Hint hint) {
        void var1_1;
        Throwable throwable2;
        return Sentry.getCurrentHub().captureException(throwable2, (Hint)var1_1);
    }

    public static void flush(long timeoutMillis) {
        long l;
        Sentry.getCurrentHub().flush(l);
    }

    private static /* synthetic */ void lambda$notifyOptionsObservers$2(SentryOptions options) {
        Iterator<LazyLayoutPrefetchState.Prefetcher> iterator = options.getOptionsObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            options.getRelease();
            options.getProguardUuid();
            options.getSdkVersion();
            options.getDist();
            options.getEnvironment();
            options.getTags();
        }
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(T var1);
    }
}

