/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.text.selection.SelectionManagerKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Breadcrumb;
import io.sentry.DataCategory;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HostnameCache;
import io.sentry.ISentryClient;
import io.sentry.ITransportFactory;
import io.sentry.NoOpTransportFactory;
import io.sentry.ProfilingTraceData;
import io.sentry.RequestDetailsResolver;
import io.sentry.Scope;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.clientreport.DiscardReason;
import io.sentry.exception.SentryEnvelopeException;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.TransactionEnd;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ITransport;
import io.sentry.util.HintUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SentryClient
implements ISentryClient {
    private final SentryOptions options;
    private final ITransport transport;
    private final SecureRandom random;
    private final SortBreadcrumbsByDate sortBreadcrumbsByDate = new SortBreadcrumbsByDate(0);

    /*
     * WARNING - void declaration
     */
    SentryClient(SentryOptions options) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)options, (String)"SentryOptions is required.");
        ITransportFactory transportFactory = options.getTransportFactory();
        if (transportFactory instanceof NoOpTransportFactory) {
            transportFactory = new SelectionManagerKt();
            options.setTransportFactory(transportFactory);
        }
        RequestDetailsResolver requestDetailsResolver = new RequestDetailsResolver(options);
        this.transport = var2_2.create$1c4f8b51(options, var3_3.resolve$461d0996());
        this.random = var1_1.getSampleRate() == null ? null : new SecureRandom();
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", var1_1.getEventId());
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, Scope scope, Hint hint) {
        AnimationSpecKt.requireNonNull((Object)event, (String)"SentryEvent is required.");
        if (hint == null) {
            hint = new Hint();
        }
        if (this.shouldApplyScopeData(event, hint)) {
            SentryClient.addScopeAttachmentsToHint(scope, hint);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", new Object[]{event.getEventId()});
        if (event != null && (eventThrowable = event.getThrowable()) != null && this.options.containsIgnoredExceptionForType(eventThrowable)) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as the exception %s is ignored", new Object[]{eventThrowable.getClass()});
            var6_7 = this.options;
            var6_7.clientReportRecorder.recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            return SentryId.EMPTY_ID;
        }
        if (this.shouldApplyScopeData(event, hint)) {
            var7_10 = hint;
            var14_14 = scope;
            var13_15 = event;
            var6_8 = this;
            if (var14_14 != null) {
                var6_8.applyScope(var13_15, (Scope)var14_14);
                if (var13_15.getTransaction() == null) {
                    var13_15.setTransaction(var14_14.getTransactionName());
                }
                if (var13_15.getFingerprints() == null) {
                    var13_15.setFingerprints(var14_14.getFingerprint());
                }
                if (var14_14.getLevel() != null) {
                    var13_15.setLevel(var14_14.getLevel());
                }
                var8_18 = var14_14.getSpan();
                if (var13_15.getContexts().getTrace() == null && var8_18 != null) {
                    var13_15.getContexts().setTrace(var8_18.getSpanContext());
                }
                var13_15 = super.processEvent(var13_15, (Hint)var7_10, var14_14.getEventProcessors());
            }
            if ((event = var13_15) == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by applyScope", new Object[0]);
                return SentryId.EMPTY_ID;
            }
        }
        if ((event = this.processEvent(event, hint, this.options.getEventProcessors())) != null && (event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            var6_8 = this.options;
            var6_8.clientReportRecorder.recordLostEvent(DiscardReason.BEFORE_SEND, DataCategory.Error);
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        sessionBeforeUpdate = scope != null ? scope.withSession((Scope.IWithSession)LambdaMetafactory.metafactory(null, null, null, (Lio/sentry/Session;)V, lambda$captureEvent$0(io.sentry.Session ), (Lio/sentry/Session;)V)()) : null;
        session = null;
        if (event != null) {
            var7_10 = scope;
            var14_14 = hint;
            var13_15 = event;
            var6_8 = this;
            var8_18 = null;
            if (HintUtils.shouldApplyScopeData((Hint)var14_14)) {
                if (var7_10 != null) {
                    var8_18 = var7_10.withSession((Scope.IWithSession)LambdaMetafactory.metafactory(null, null, null, (Lio/sentry/Session;)V, lambda$updateSessionData$1(io.sentry.SentryEvent io.sentry.Hint io.sentry.Session ), (Lio/sentry/Session;)V)((SentryClient)var6_8, (SentryEvent)var13_15, (Hint)var14_14));
                } else {
                    var6_8.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
                }
            }
            session = var8_18;
            var6_8 = this;
            if (!(var6_8.options.getSampleRate() != null && var6_8.random != null ? !((var13_16 = var6_8.options.getSampleRate().doubleValue()) < var6_8.random.nextDouble()) : true)) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", new Object[]{event.getEventId()});
                var6_8 = this.options;
                var6_8.clientReportRecorder.recordLostEvent(DiscardReason.SAMPLE_RATE, DataCategory.Error);
                event = null;
            }
        }
        var13_17 = session;
        var6_8 = sessionBeforeUpdate;
        if (var13_17 == null) ** GOTO lbl-1000
        if (var6_8 == null) {
            v0 = true;
        } else {
            var7_11 = var13_17.getStatus() == Session.State.Crashed && var6_8.getStatus() != Session.State.Crashed;
            if (var7_11) {
                v0 = true;
            } else {
                var8_19 = var13_17.errorCount() > 0 && var6_8.errorCount() <= 0;
                if (var8_19) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = shouldSendSessionUpdate = false;
                }
            }
        }
        if (event == null && !shouldSendSessionUpdate) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Not sending session update for dropped event as it did not cause the session health to change.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        sentryId = SentryId.EMPTY_ID;
        if (event != null && event.getEventId() != null) {
            sentryId = event.getEventId();
        }
        try {
            traceContext = scope != null && scope.getTransaction() != null ? scope.getTransaction().traceContext() : null;
            var7_12 = event != null;
            attachments = var7_12 != false ? SentryClient.getAttachments(hint) : null;
            envelope = this.buildEnvelope$79f271c6(event, attachments, (Session)session, traceContext, null);
            hint.clear();
            if (envelope != null) {
                this.transport.send$74b70ef((CloseKt)var1_1, hint);
            }
        }
        catch (SentryEnvelopeException | IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing event %s failed.", new Object[]{sentryId});
            sentryId = SentryId.EMPTY_ID;
        }
        if (scope != null && (transaction = var2_2.getTransaction()) != null && HintUtils.hasType((Hint)var3_3, TransactionEnd.class)) {
            transaction.forceFinish(SpanStatus.ABORTED, false);
        }
        return sentryId;
    }

    /*
     * WARNING - void declaration
     */
    private static void addScopeAttachmentsToHint(Scope scope, Hint hint) {
        if (scope != null) {
            Scope scope2;
            void var1_1;
            var1_1.addAttachments(scope2.getAttachments());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<HostnameCache.1> getAttachments(Hint hint) {
        void var1_1;
        Object viewHierarchy;
        List<HostnameCache.1> attachments = hint.getAttachments();
        HostnameCache.1 screenshot = hint.getScreenshot$44672e26();
        if (screenshot != null) {
            void var2_2;
            attachments.add(var2_2);
        }
        if ((viewHierarchy = hint.getViewHierarchy$44672e26()) != null) {
            Object object;
            attachments.add(object);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private CloseKt buildEnvelope$79f271c6(SentryBaseEvent event, List<HostnameCache.1> attachments, Session session, TraceContext traceContext, ProfilingTraceData profilingTraceData) throws IOException, SentryEnvelopeException {
        SentryId sentryId = null;
        ArrayList<Object> envelopeItems = new ArrayList<Object>();
        if (event != null) {
            SentryEnvelopeItem eventItem = SentryEnvelopeItem.fromEvent(this.options.getSerializer(), event);
            envelopeItems.add(eventItem);
            sentryId = event.getEventId();
        }
        if (session != null) {
            void var3_3;
            SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession(this.options.getSerializer(), (Session)var3_3);
            envelopeItems.add(sessionItem);
        }
        if (profilingTraceData != null) {
            SentryEnvelopeItem profilingTraceItem = SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, this.options.getMaxTraceFileSize(), this.options.getSerializer());
            envelopeItems.add(profilingTraceItem);
            if (sentryId == null) {
                sentryId = new SentryId(profilingTraceData.getProfileId());
            }
        }
        if (attachments != null) {
            void var2_2;
            for (HostnameCache.1 attachment : var2_2) {
                void var1_1;
                SentryEnvelopeItem attachmentItem = SentryEnvelopeItem.fromAttachment$12fa04b4(this.options.getSerializer(), this.options.getLogger(), attachment, this.options.getMaxAttachmentSize());
                envelopeItems.add(var1_1);
            }
        }
        if (!envelopeItems.isEmpty()) {
            SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(sentryId, this.options.getSdkVersion(), traceContext);
            return new CloseKt(envelopeHeader, envelopeItems);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent processEvent(SentryEvent event, Hint hint, List<EventProcessor> eventProcessors) {
        void var1_1;
        for (EventProcessor processor : eventProcessors) {
            try {
                boolean isBackfillingProcessor = processor instanceof BackfillingEventProcessor;
                boolean isBackfillable = HintUtils.hasType((Hint)hint, Backfillable.class);
                if (isBackfillable && isBackfillingProcessor) {
                    event = processor.process(event, (Hint)hint);
                } else if (!isBackfillable && !isBackfillingProcessor) {
                    event = processor.process(event, (Hint)hint);
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing event by processor: %s", processor.getClass().getName());
            }
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by a processor: %s", processor.getClass().getName());
            hint = this.options;
            ((SentryOptions)hint).clientReportRecorder.recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            break;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope$87b3736(CloseKt envelope, Hint hint) {
        AnimationSpecKt.requireNonNull((Object)envelope, (String)"SentryEnvelope is required.");
        if (hint == null) {
            hint = new Hint();
        }
        try {
            void var2_3;
            hint.clear();
            this.transport.send$74b70ef(envelope, (Hint)var2_3);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", e);
            return SentryId.EMPTY_ID;
        }
        SentryId eventId = e.getHeader().getEventId();
        if (eventId != null) {
            void var1_1;
            return var1_1;
        }
        return SentryId.EMPTY_ID;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends SentryBaseEvent> T applyScope(T sentryBaseEvent, Scope scope) {
        void var1_1;
        if (scope != null) {
            if (sentryBaseEvent.getRequest() == null) {
                sentryBaseEvent.setRequest(scope.getRequest());
            }
            if (sentryBaseEvent.getUser() == null) {
                sentryBaseEvent.setUser(scope.getUser());
            }
            if (sentryBaseEvent.getTags() == null) {
                sentryBaseEvent.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (sentryBaseEvent.getTags().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (sentryBaseEvent.getBreadcrumbs() == null) {
                sentryBaseEvent.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                this.sortBreadcrumbsByDate(sentryBaseEvent, scope.getBreadcrumbs());
            }
            if (sentryBaseEvent.getExtras() == null) {
                sentryBaseEvent.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (sentryBaseEvent.getExtras().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            Contexts contexts = sentryBaseEvent.getContexts();
            for (Map.Entry entry : new Contexts(scope.getContexts()).entrySet()) {
                void var2_2;
                if (contexts.containsKey(entry.getKey())) continue;
                contexts.put((String)entry.getKey(), var2_2.getValue());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void sortBreadcrumbsByDate(SentryBaseEvent event, Collection<Breadcrumb> breadcrumbs) {
        List<Breadcrumb> sortedBreadcrumbs = event.getBreadcrumbs();
        if (sortedBreadcrumbs != null && !breadcrumbs.isEmpty()) {
            void var1_1;
            void var2_2;
            sortedBreadcrumbs.addAll((Collection<Breadcrumb>)var2_2);
            Collections.sort(var1_1, this.sortBreadcrumbsByDate);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent executeBeforeSend(SentryEvent event, Hint hint) {
        Object var1_1;
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                void var2_3;
                event = var2_3.execute$5b469cf6();
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", (Throwable)var1_2);
                var1_1 = null;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            SentryClient sentryClient = this;
            sentryClient.flush(sentryClient.options.getShutdownTimeoutMillis());
            this.transport.close();
        }
        catch (IOException e) {
            void var1_1;
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", (Throwable)var1_1);
        }
        for (EventProcessor eventProcessor : this.options.getEventProcessors()) {
            if (!(eventProcessor instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)eventProcessor)).close();
            }
            catch (IOException e) {
                void var3_4;
                void var2_3;
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the event processor {}.", var2_3, var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        void var1_1;
        this.transport.flush((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$updateSessionData$1(SentryEvent event, Hint hint, Session session) {
        if (session != null) {
            void var2_2;
            void var1_1;
            Session.State status = null;
            if (((SentryEvent)event).isCrashed()) {
                status = Session.State.Crashed;
            }
            boolean crashedOrErrored = false;
            if (Session.State.Crashed == status || ((SentryEvent)event).isErrored()) {
                crashedOrErrored = true;
            }
            String userAgent = null;
            if (((SentryBaseEvent)event).getRequest() != null && ((SentryBaseEvent)event).getRequest().getHeaders() != null && ((SentryBaseEvent)event).getRequest().getHeaders().containsKey("user-agent")) {
                userAgent = ((SentryBaseEvent)event).getRequest().getHeaders().get("user-agent");
            }
            event = hint;
            Object sentrySdkHint = ((Hint)event).get("sentry:typeCheckHint");
            String abnormalMechanism = null;
            if (sentrySdkHint instanceof AbnormalExit) {
                abnormalMechanism = ((AbnormalExit)var1_1).mechanism();
                status = Session.State.Abnormal;
            }
            if (session.update(status, userAgent, crashedOrErrored, abnormalMechanism) && HintUtils.hasType((Hint)var2_2, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
                void var3_3;
                var1_1 = var3_3;
                var1_1.end(AnimationSpecKt.getCurrentDateTime());
            }
            return;
        }
        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
    }

    private static /* synthetic */ void lambda$captureEvent$0(Session session) {
    }

    static final class SortBreadcrumbsByDate
    implements Comparator<Breadcrumb> {
        private SortBreadcrumbsByDate() {
        }

        /* synthetic */ SortBreadcrumbsByDate(byte by) {
            this();
        }
    }
}

