/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.TraceContext;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class SentryEnvelopeHeader
implements JsonSerializable {
    private final SentryId eventId;
    private final SdkVersion sdkVersion;
    private final TraceContext traceContext;
    private Date sentAt;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeHeader(SentryId eventId, SdkVersion sdkVersion) {
        this((SentryId)var1_1, (SdkVersion)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeHeader(SentryId eventId, SdkVersion sdkVersion, TraceContext traceContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.eventId = var1_1;
        this.sdkVersion = var2_2;
        this.traceContext = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelopeHeader(SentryId eventId) {
        this((SentryId)var1_1, null);
        void var1_1;
    }

    public SentryEnvelopeHeader() {
        this(new SentryId());
    }

    public final SentryId getEventId() {
        return this.eventId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSentAt(Date sentAt) {
        void var1_1;
        this.sentAt = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.eventId != null) {
            writer.name("event_id").value(logger, this.eventId);
        }
        if (this.sdkVersion != null) {
            writer.name("sdk").value(logger, this.sdkVersion);
        }
        if (this.traceContext != null) {
            writer.name("trace").value(logger, this.traceContext);
        }
        if (this.sentAt != null) {
            Date date = this.sentAt;
            writer.name("sent_at").value(logger, ISO8601Utils.format(date, true));
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeHeader> {
        /*
         * WARNING - void declaration
         */
        private static SentryEnvelopeHeader deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            JsonObjectReader jsonObjectReader;
            void var3_3;
            void var2_2;
            reader.beginObject();
            SentryId eventId = null;
            SdkVersion sdkVersion = null;
            TraceContext traceContext = null;
            Date sentAt = null;
            HashMap<String, Object> unknown = null;
            block12: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "event_id": {
                        eventId = reader.nextOrNull(logger, new SentryId.Deserializer());
                        continue block12;
                    }
                    case "sdk": {
                        sdkVersion = reader.nextOrNull(logger, new SdkVersion.Deserializer());
                        continue block12;
                    }
                    case "trace": {
                        traceContext = reader.nextOrNull(logger, new TraceContext.Deserializer());
                        continue block12;
                    }
                    case "sent_at": {
                        sentAt = reader.nextDateOrNull(logger);
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            SentryEnvelopeHeader sentryEnvelopeHeader = new SentryEnvelopeHeader((SentryId)var2_2, (SdkVersion)var3_3, traceContext);
            sentryEnvelopeHeader.setSentAt(sentAt);
            sentryEnvelopeHeader.setUnknown(unknown);
            jsonObjectReader.endObject();
            return sentryEnvelopeHeader;
        }
    }
}

