/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonReader;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public final class SentryEnvelopeItemHeader
implements JsonSerializable {
    private final String contentType;
    private final String fileName;
    private final SentryItemType type;
    private final int length;
    private final Callable<Integer> getLength;
    private final String attachmentType;
    private Map<String, Object> unknown;

    public final SentryItemType getType() {
        return this.type;
    }

    public final int getLength() {
        if (this.getLength != null) {
            try {
                return this.getLength.call();
            }
            catch (Throwable throwable) {
                return -1;
            }
        }
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeItemHeader(SentryItemType type, int length, String contentType, String fileName, String attachmentType) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.type = (SentryItemType)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"type is required");
        this.contentType = var3_3;
        this.length = var2_2;
        this.fileName = fileName;
        this.getLength = null;
        this.attachmentType = attachmentType;
    }

    /*
     * WARNING - void declaration
     */
    SentryEnvelopeItemHeader(SentryItemType type, Callable<Integer> getLength, String contentType, String fileName, String attachmentType) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.type = (SentryItemType)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"type is required");
        this.contentType = var3_3;
        this.length = -1;
        this.fileName = fileName;
        this.getLength = var2_2;
        this.attachmentType = attachmentType;
    }

    /*
     * WARNING - void declaration
     */
    SentryEnvelopeItemHeader(SentryItemType type, Callable<Integer> getLength, String contentType, String fileName) {
        this((SentryItemType)var1_1, (Callable<Integer>)var2_2, (String)var3_3, fileName, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.contentType != null) {
            writer.name("content_type").value(this.contentType);
        }
        if (this.fileName != null) {
            writer.name("filename").value(this.fileName);
        }
        writer.name("type").value(logger, this.type);
        if (this.attachmentType != null) {
            writer.name("attachment_type").value(this.attachmentType);
        }
        writer.name("length").value(this.getLength());
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeItemHeader> {
        /*
         * WARNING - void declaration
         */
        @Override
        private SentryEnvelopeItemHeader deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            ((JsonReader)reader).beginObject();
            Object contentType = null;
            String fileName = null;
            SentryItemType type = null;
            int length = 0;
            String attachmentType = null;
            HashMap<String, Object> unknown = null;
            block14: while (((JsonReader)reader).peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = ((JsonReader)reader).nextName()) {
                    case "content_type": {
                        contentType = ((JsonObjectReader)reader).nextStringOrNull();
                        continue block14;
                    }
                    case "filename": {
                        fileName = ((JsonObjectReader)reader).nextStringOrNull();
                        continue block14;
                    }
                    case "type": {
                        type = ((JsonObjectReader)reader).nextOrNull(logger, new SentryItemType.Deserializer());
                        continue block14;
                    }
                    case "length": {
                        length = ((JsonReader)reader).nextInt();
                        continue block14;
                    }
                    case "attachment_type": {
                        attachmentType = ((JsonObjectReader)reader).nextStringOrNull();
                        continue block14;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                ((JsonObjectReader)reader).nextUnknown(logger, unknown, nextName);
            }
            if (type == null) {
                void var2_2;
                reader = "type";
                reader = "Missing required field \"" + (String)reader + "\"";
                contentType = new IllegalStateException((String)reader);
                var2_2.log(SentryLevel.ERROR, (String)reader, (Throwable)contentType);
                throw contentType;
            }
            SentryEnvelopeItemHeader sentryEnvelopeItemHeader = new SentryEnvelopeItemHeader(type, length, (String)var3_3, fileName, attachmentType);
            sentryEnvelopeItemHeader.setUnknown(unknown);
            var1_1.endObject();
            return sentryEnvelopeItemHeader;
        }
    }
}

