/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISentryExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class SentryExecutorService
implements ISentryExecutorService {
    private final ScheduledExecutorService executorService;

    /*
     * WARNING - void declaration
     */
    private SentryExecutorService(ScheduledExecutorService executorService) {
        void var1_1;
        this.executorService = var1_1;
    }

    SentryExecutorService() {
        this(Executors.newSingleThreadScheduledExecutor(new SentryExecutorServiceThreadFactory(0)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable runnable) {
        void var1_1;
        return this.executorService.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(long timeoutMillis) {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
                try {
                    void var1_1;
                    if (!this.executorService.awaitTermination((long)var1_1, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    @Override
    public final boolean isClosed() {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            return this.executorService.isShutdown();
        }
    }

    static final class SentryExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        private SentryExecutorServiceThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(Runnable r) {
            void var1_1;
            Thread ret = new Thread(r, "SentryExecutorServiceThreadFactory-" + this.cnt++);
            ret.setDaemon(true);
            return var1_1;
        }

        /* synthetic */ SentryExecutorServiceThreadFactory(byte by) {
            this();
        }
    }
}

