/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.protocol.SentryPackage;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SentryIntegrationPackageStorage {
    private static volatile SentryIntegrationPackageStorage INSTANCE;
    private final Set<String> integrations = new CopyOnWriteArraySet<String>();
    private final Set<SentryPackage> packages = new CopyOnWriteArraySet<SentryPackage>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SentryIntegrationPackageStorage getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SentryIntegrationPackageStorage> clazz = SentryIntegrationPackageStorage.class;
        synchronized (SentryIntegrationPackageStorage.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SentryIntegrationPackageStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private SentryIntegrationPackageStorage() {
    }

    /*
     * WARNING - void declaration
     */
    public final void addIntegration(String integration) {
        void var1_1;
        AnimationSpecKt.requireNonNull((Object)integration, (String)"integration is required.");
        this.integrations.add((String)var1_1);
    }

    public final Set<String> getIntegrations() {
        return this.integrations;
    }

    /*
     * WARNING - void declaration
     */
    public final void addPackage(String name, String version) {
        void var1_1;
        void var2_2;
        AnimationSpecKt.requireNonNull((Object)name, (String)"name is required.");
        AnimationSpecKt.requireNonNull((Object)version, (String)"version is required.");
        SentryPackage newPackage = new SentryPackage(name, (String)var2_2);
        this.packages.add((SentryPackage)var1_1);
    }

    public final Set<SentryPackage> getPackages() {
        return this.packages;
    }
}

