/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.foundation.interaction.DragInteraction;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.text.selection.SimpleLayoutKt;
import androidx.compose.foundation.text.selection.TextFieldSelectionDelegateKt;
import androidx.compose.foundation.text.selection.TextFieldSelectionManagerKt;
import androidx.compose.foundation.v2.Scrollbar_desktopKt;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.FullyDisplayedReporter;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.ISerializer;
import io.sentry.ITransactionProfiler;
import io.sentry.ITransportFactory;
import io.sentry.IntegrationName;
import io.sentry.JsonSerializer;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpLogger;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpTransactionPerformanceCollector;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoOpTransportFactory;
import io.sentry.SentryDateProvider;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.ClientReportRecorder;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.protocol.SdkVersion;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.Platform;
import io.sentry.util.StringUtils;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;

public final class SentryOptions {
    private static SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    private final List<IntegrationName> integrations = new CopyOnWriteArrayList<IntegrationName>();
    private final Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    private String dsn;
    private String dsnHash;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private boolean debug;
    private ILogger logger = NoOpLogger.getInstance();
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    private IEnvelopeReader envelopeReader = new EnvelopeReader(new JsonSerializer(this));
    private ISerializer serializer = new JsonSerializer(this);
    private int maxDepth = 100;
    private String sentryClientName;
    private BeforeSendCallback beforeSend;
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    private String release;
    private String environment;
    private Proxy proxy;
    private Double sampleRate;
    private Boolean enableTracing;
    private Double tracesSampleRate;
    private TracesSamplerCallback tracesSampler;
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    private String dist;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private String serverName;
    private boolean attachServerName = true;
    private boolean enableUncaughtExceptionHandler = true;
    private boolean printUncaughtStackTrace = false;
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private final List<LazyLayoutPrefetchState.Prefetcher> observers = new CopyOnWriteArrayList<LazyLayoutPrefetchState.Prefetcher>();
    private final List<LazyLayoutPrefetchState.Prefetcher> optionsObservers = new CopyOnWriteArrayList<LazyLayoutPrefetchState.Prefetcher>();
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    private boolean enableDeduplication = true;
    private boolean enableShutdownHook = true;
    private boolean traceSampling = true;
    private Double profilesSampleRate;
    private ProfilesSamplerCallback profilesSampler;
    private long maxTraceFileSize = 0x500000L;
    private ITransactionProfiler transactionProfiler = NoOpTransactionProfiler.getInstance();
    private String proguardUuid;
    private final List<String> contextTags;
    IClientReportRecorder clientReportRecorder;
    private IModulesLoader modulesLoader;
    private IDebugMetaLoader debugMetaLoader;
    private DragInteraction mainThreadChecker$25d3ac47;
    private SentryDateProvider dateProvider;
    private final List<TextFieldSelectionManagerKt> collectors;
    private TransactionPerformanceCollector transactionPerformanceCollector;

    public final List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public final List<IntegrationName> getIntegrations() {
        return this.integrations;
    }

    public final String getDsn() {
        return this.dsn;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDsn(String dsn) {
        void var1_1;
        this.dsn = var1_1;
        this.dsnHash = StringUtils.calculateStringHash(this.dsn, this.logger);
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLogger(ILogger logger) {
        void var1_1;
        this.logger = new SimpleLayoutKt(this, (ILogger)var1_1);
    }

    public final SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public final ISerializer getSerializer() {
        return this.serializer;
    }

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader;
    }

    public final long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public final String getSentryClientName() {
        return this.sentryClientName;
    }

    public final BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public final String getCacheDirPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        if (this.dsnHash != null) {
            return new File(this.cacheDirPath, this.dsnHash).getAbsolutePath();
        }
        return this.cacheDirPath;
    }

    public final int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public final String getRelease() {
        return this.release;
    }

    public final String getEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        return "production";
    }

    public final Proxy getProxy() {
        return this.proxy;
    }

    public final Double getSampleRate() {
        return this.sampleRate;
    }

    public final List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public final List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public final ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransportFactory(ITransportFactory transportFactory) {
        void var1_1;
        this.transportFactory = var1_1;
    }

    public final String getDist() {
        return this.dist;
    }

    public final ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public final boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    public final boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final boolean isAttachServerName() {
        return this.attachServerName;
    }

    public final long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public final boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public final boolean isPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public final ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - void declaration
     */
    public final void setExecutorService(ISentryExecutorService executorService) {
        void var1_1;
        this.executorService = var1_1;
    }

    public final int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public final int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public final IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvelopeDiskCache(IEnvelopeCache envelopeDiskCache) {
        void var1_1;
        this.envelopeDiskCache = envelopeDiskCache != null ? var1_1 : NoOpEnvelopeCache.getInstance();
    }

    public final int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public final SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public final SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final List<LazyLayoutPrefetchState.Prefetcher> getScopeObservers() {
        return this.observers;
    }

    public final List<LazyLayoutPrefetchState.Prefetcher> getOptionsObservers() {
        return this.optionsObservers;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public final boolean isEnableDeduplication() {
        return this.enableDeduplication;
    }

    public final boolean isTracingEnabled() {
        block5: {
            block4: {
                if (this.enableTracing != null) {
                    return this.enableTracing;
                }
                SentryOptions sentryOptions = this;
                if (sentryOptions.tracesSampleRate != null) break block4;
                sentryOptions = this;
                if (sentryOptions.tracesSampler == null) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsIgnoredExceptionForType(Throwable throwable) {
        void var1_1;
        return this.ignoredExceptionsForType.contains(var1_1.getClass());
    }

    public final boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public final int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public final long getMaxTraceFileSize() {
        return this.maxTraceFileSize;
    }

    public final ITransactionProfiler getTransactionProfiler() {
        return this.transactionProfiler;
    }

    public final ProfilesSamplerCallback getProfilesSampler() {
        return this.profilesSampler;
    }

    public final Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    public final String getProguardUuid() {
        return this.proguardUuid;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProguardUuid(String proguardUuid) {
        void var1_1;
        this.proguardUuid = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addBundleId(String bundleId) {
        String trimmedBundleId;
        if (bundleId != null && !(trimmedBundleId = bundleId.trim()).isEmpty()) {
            void var1_1;
            this.bundleIds.add((String)var1_1);
        }
    }

    public final Set<String> getBundleIds() {
        return this.bundleIds;
    }

    public final IClientReportRecorder getClientReportRecorder() {
        return this.clientReportRecorder;
    }

    public final IModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    /*
     * WARNING - void declaration
     */
    public final void setModulesLoader(IModulesLoader modulesLoader) {
        void var1_1;
        this.modulesLoader = var1_1;
    }

    public final IDebugMetaLoader getDebugMetaLoader() {
        return this.debugMetaLoader;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDebugMetaLoader(IDebugMetaLoader debugMetaLoader) {
        void var1_1;
        this.debugMetaLoader = var1_1;
    }

    public final DragInteraction getMainThreadChecker$523ee008() {
        return this.mainThreadChecker$25d3ac47;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMainThreadChecker$28b81ffc(DragInteraction mainThreadChecker) {
        void var1_1;
        this.mainThreadChecker$25d3ac47 = var1_1;
    }

    public final TransactionPerformanceCollector getTransactionPerformanceCollector() {
        return this.transactionPerformanceCollector;
    }

    public final SentryDateProvider getDateProvider() {
        return this.dateProvider;
    }

    /*
     * WARNING - void declaration
     */
    public final void addCollector$6d9d2c87(TextFieldSelectionManagerKt collector) {
        void var1_1;
        this.collectors.add((TextFieldSelectionManagerKt)var1_1);
    }

    public final List<TextFieldSelectionManagerKt> getCollectors() {
        return this.collectors;
    }

    static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private SentryOptions(boolean empty) {
        void var1_1;
        Collections.singletonList(".*");
        Long.valueOf(3000L);
        this.contextTags = new CopyOnWriteArrayList<String>();
        this.clientReportRecorder = new ClientReportRecorder(this);
        this.modulesLoader = NoOpModulesLoader.getInstance();
        this.debugMetaLoader = NoOpDebugMetaLoader.getInstance();
        new ArrayList();
        new ArrayList();
        this.mainThreadChecker$25d3ac47 = NoOpMainThreadChecker.getInstance();
        this.dateProvider = new Scrollbar_desktopKt();
        this.collectors = new ArrayList<TextFieldSelectionManagerKt>();
        this.transactionPerformanceCollector = NoOpTransactionPerformanceCollector.getInstance();
        FullyDisplayedReporter.getInstance();
        if (var1_1 == false) {
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add((EventProcessor)new TextFieldSelectionDelegateKt(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            Object object = "sentry.java/6.21.0";
            Object object2 = this;
            this.sentryClientName = object;
            object2 = new SdkVersion("sentry.java", "6.21.0");
            ((SdkVersion)object2).setVersion("6.21.0");
            object = object2;
            object2 = this;
            this.sdkVersion = object;
            SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry", "6.21.0");
        }
    }

    public static interface BeforeSendCallback {
        public SentryEvent execute$5b469cf6();
    }

    public static final class Proxy {
        private String host;
        private String port;
        private String user;
        private String pass;

        public final String getHost() {
            return this.host;
        }

        public final String getPort() {
            return this.port;
        }

        public final String getUser() {
            return this.user;
        }

        public final String getPass() {
            return this.pass;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Landroidx/compose/animation/core/Easing;", "", "transform", "", "fraction", "animation-core"})
    public static interface TracesSamplerCallback {
        public float transform(float var1);
    }

    public static final class RequestSize
    extends Enum<RequestSize> {
        public static final /* enum */ RequestSize NONE = new RequestSize();
        private static /* enum */ RequestSize SMALL = new RequestSize();
        private static /* enum */ RequestSize MEDIUM = new RequestSize();
        private static /* enum */ RequestSize ALWAYS = new RequestSize();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b`\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Landroidx/compose/animation/core/Animations;", "", "get", "Landroidx/compose/animation/core/FloatAnimationSpec;", "index", "", "animation-core"})
    public static interface ProfilesSamplerCallback {
        public FloatAnimationSpec get(int var1);
    }
}

