/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SentryThreadFactory {
    private final SentryStackTraceFactory sentryStackTraceFactory;
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public SentryThreadFactory(SentryStackTraceFactory sentryStackTraceFactory, SentryOptions options) {
        void var2_2;
        void var1_1;
        this.sentryStackTraceFactory = (SentryStackTraceFactory)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"The SentryStackTraceFactory is required.");
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"The SentryOptions is required");
    }

    final List<SentryThread> getCurrentThreads(Map<Thread, StackTraceElement[]> threads, List<Long> mechanismThreadIds, boolean ignoreCurrentThread) {
        ArrayList<SentryThread> result = null;
        Thread currentThread = Thread.currentThread();
        if (!threads.isEmpty()) {
            Iterator iterator;
            result = new ArrayList<SentryThread>();
            if (!threads.containsKey(currentThread)) {
                Thread thread = currentThread;
                threads.put(thread, thread.getStackTrace());
            }
            for (Map.Entry item : iterator.entrySet()) {
                Thread thread = (Thread)item.getKey();
                boolean crashed = thread == currentThread && !ignoreCurrentThread || mechanismThreadIds != null && mechanismThreadIds.contains(thread.getId());
                result.add(this.getSentryThread(crashed, (StackTraceElement[])item.getValue(), (Thread)item.getKey()));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private SentryThread getSentryThread(boolean crashed, StackTraceElement[] stackFramesElements, Thread thread) {
        void var2_3;
        void var3_4;
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(var3_4.getState().name());
        sentryThread.setCrashed(crashed);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames((StackTraceElement[])var2_3);
        if (this.options.isAttachStacktrace() && frames != null && !frames.isEmpty()) {
            void var1_2;
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            sentryStackTrace.setSnapshot(Boolean.TRUE);
            sentryThread.setStacktrace((SentryStackTrace)var1_2);
        }
        return sentryThread;
    }
}

