/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.IHub;
import io.sentry.IntegrationName;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.io.Closeable;
import java.io.IOException;

public final class ShutdownHookIntegration
implements IntegrationName,
Closeable {
    private final Runtime runtime;
    private Thread thread;

    /*
     * WARNING - void declaration
     */
    private ShutdownHookIntegration(Runtime runtime) {
        void var1_1;
        this.runtime = (Runtime)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register(IHub hub, SentryOptions options) {
        void var2_2;
        AnimationSpecKt.requireNonNull((Object)hub, (String)"Hub is required");
        AnimationSpecKt.requireNonNull((Object)options, (String)"SentryOptions is required");
        if (options.isEnableShutdownHook()) {
            void var1_1;
            this.thread = new Thread(() -> ShutdownHookIntegration.lambda$register$0((IHub)var1_1, options));
            this.runtime.addShutdownHook(this.thread);
            options.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
            this.addIntegrationToSdkVersion();
            return;
        }
        var2_2.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        block3: {
            if (this.thread != null) {
                try {
                    this.runtime.removeShutdownHook(this.thread);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    void var1_1;
                    void var2_2;
                    IllegalStateException e = illegalStateException;
                    String message = illegalStateException.getMessage();
                    if (message != null && var2_2.equals("Shutdown in progress")) break block3;
                    throw var1_1;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$register$0(IHub hub, SentryOptions options) {
        void var1_1;
        hub.flush(var1_1.getFlushTimeoutMillis());
    }
}

