/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.gestures.DraggableKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.protocol.SentryId;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpanContext
implements JsonSerializable {
    private final SentryId traceId;
    private final SpanId spanId;
    private final SpanId parentSpanId;
    private transient DraggableKt samplingDecision$6544c989;
    private String op;
    private String description;
    protected SpanStatus status;
    protected Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, String operation, SpanId parentSpanId, DraggableKt samplingDecision) {
        this((SentryId)var1_1, (SpanId)var2_2, parentSpanId, (String)var3_3, null, samplingDecision, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, SpanId parentSpanId, String operation, String description, DraggableKt samplingDecision, SpanStatus status) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.traceId = (SentryId)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"traceId is required");
        this.spanId = (SpanId)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"spanId is required");
        this.op = (String)AnimationSpecKt.requireNonNull((Object)operation, (String)"operation is required");
        this.parentSpanId = var3_3;
        this.samplingDecision$6544c989 = samplingDecision;
        this.description = description;
        this.status = status;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SpanContext spanContext) {
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.samplingDecision$6544c989 = spanContext.samplingDecision$6544c989;
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            void var1_1;
            this.tags = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDescription(String description) {
        void var1_1;
        this.description = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStatus(SpanStatus status) {
        void var1_1;
        this.status = var1_1;
    }

    public final SentryId getTraceId() {
        return this.traceId;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)o;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && AnimationSpecKt.equals((Object)this.parentSpanId, (Object)that.parentSpanId) && this.op.equals(that.op) && AnimationSpecKt.equals((Object)this.description, (Object)that.description) && this.status == var1_1.status;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.traceId, this.spanId, this.parentSpanId, this.op, this.description, this.status};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("trace_id");
        this.traceId.serialize(writer, logger);
        writer.name("span_id");
        this.spanId.serialize(writer, logger);
        if (this.parentSpanId != null) {
            writer.name("parent_span_id");
            this.parentSpanId.serialize(writer, logger);
        }
        writer.name("op").value(this.op);
        if (this.description != null) {
            writer.name("description").value(this.description);
        }
        if (this.status != null) {
            writer.name("status").value(logger, this.status);
        }
        if (!this.tags.isEmpty()) {
            writer.name("tags").value(logger, this.tags);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanContext> {
        /*
         * WARNING - void declaration
         */
        public static SpanContext deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            JsonObjectReader jsonObjectReader;
            void var3_3;
            void var2_2;
            IllegalStateException exception;
            String message;
            reader.beginObject();
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            Map tags = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        new SentryId.Deserializer();
                        traceId = SentryId.Deserializer.deserialize$7961c0e3(reader);
                        continue block18;
                    }
                    case "span_id": {
                        new SpanId.Deserializer();
                        spanId = SpanId.Deserializer.deserialize$13205d43(reader);
                        continue block18;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block18;
                    }
                    case "op": {
                        op = reader.nextString();
                        continue block18;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block18;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block18;
                    }
                    case "tags": {
                        tags = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                message = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (spanId == null) {
                message = "Missing required field \"span_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (op == null) {
                void var1_1;
                message = "Missing required field \"op\"";
                exception = new IllegalStateException(message);
                var1_1.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            SpanContext spanContext = new SpanContext((SentryId)var2_2, (SpanId)var3_3, op, parentSpanId, null);
            spanContext.setDescription(description);
            spanContext.setStatus(status);
            if (tags != null) {
                spanContext.tags = tags;
            }
            spanContext.setUnknown(unknown);
            jsonObjectReader.endObject();
            return spanContext;
        }
    }
}

