/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.ISentryClient;
import io.sentry.Scope;
import io.sentry.SentryOptions;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

final class Stack {
    private final Deque<StackItem> items = new LinkedBlockingDeque<StackItem>();
    private final ILogger logger;

    /*
     * WARNING - void declaration
     */
    public Stack(ILogger logger, StackItem rootStackItem) {
        void var2_2;
        void var1_1;
        this.logger = (ILogger)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"logger is required");
        this.items.push((StackItem)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"rootStackItem is required"));
    }

    public Stack(Stack stack) {
        this(stack.logger, new StackItem(stack.items.getLast()));
        Iterator<StackItem> iterator = stack.items.descendingIterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            StackItem stackItem = new StackItem(iterator.next());
            Stack stack2 = this;
            stack2.items.push(stackItem);
        }
    }

    final StackItem peek() {
        return this.items.peek();
    }

    static final class StackItem {
        private final SentryOptions options;
        private volatile ISentryClient client;
        private volatile Scope scope;

        /*
         * WARNING - void declaration
         */
        StackItem(SentryOptions options, ISentryClient client, Scope scope) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.client = (ISentryClient)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"ISentryClient is required.");
            this.scope = (Scope)AnimationSpecKt.requireNonNull((Object)var3_3, (String)"Scope is required.");
            this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"Options is required");
        }

        /*
         * WARNING - void declaration
         */
        StackItem(StackItem item) {
            void var1_1;
            this.options = item.options;
            this.client = item.client;
            this.scope = new Scope(var1_1.scope);
        }

        public final ISentryClient getClient() {
            return this.client;
        }

        public final Scope getScope() {
            return this.scope;
        }
    }
}

