/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TraceContext
implements JsonSerializable {
    private final SentryId traceId;
    private final String publicKey;
    private final String release;
    private final String environment;
    private final String userId;
    private final String userSegment;
    private final String transaction;
    private final String sampleRate;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    TraceContext(SentryId traceId, String publicKey) {
        this((SentryId)var1_1, (String)var2_2, null, null, null, null, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    TraceContext(SentryId traceId, String publicKey, String release, String environment, String userId, String userSegment, String transaction, String sampleRate) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.traceId = var1_1;
        this.publicKey = var2_2;
        this.release = var3_3;
        this.environment = environment;
        this.userId = userId;
        this.userSegment = userSegment;
        this.transaction = transaction;
        this.sampleRate = sampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("trace_id").value(logger, this.traceId);
        writer.name("public_key").value(this.publicKey);
        if (this.release != null) {
            writer.name("release").value(this.release);
        }
        if (this.environment != null) {
            writer.name("environment").value(this.environment);
        }
        if (this.userId != null) {
            writer.name("user_id").value(this.userId);
        }
        if (this.userSegment != null) {
            writer.name("user_segment").value(this.userSegment);
        }
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        if (this.sampleRate != null) {
            writer.name("sample_rate").value(this.sampleRate);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<TraceContext> {
        /*
         * WARNING - void declaration
         */
        @Override
        private TraceContext deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            SentryId traceId = null;
            String publicKey = null;
            String release = null;
            String environment = null;
            TraceContextUser user = null;
            String userId = null;
            String userSegment = null;
            String transaction = null;
            String sampleRate = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block22: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        new SentryId.Deserializer();
                        traceId = SentryId.Deserializer.deserialize$7961c0e3(reader);
                        continue block22;
                    }
                    case "public_key": {
                        publicKey = reader.nextString();
                        continue block22;
                    }
                    case "release": {
                        release = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "environment": {
                        environment = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "user": {
                        user = reader.nextOrNull(logger, new TraceContextUser.Deserializer());
                        continue block22;
                    }
                    case "user_id": {
                        userId = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "user_segment": {
                        userSegment = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "transaction": {
                        transaction = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "sample_rate": {
                        sampleRate = reader.nextStringOrNull();
                        continue block22;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                throw Deserializer.missingRequiredFieldException("trace_id", logger);
            }
            if (publicKey == null) {
                void var2_2;
                throw Deserializer.missingRequiredFieldException("public_key", (ILogger)var2_2);
            }
            if (user != null) {
                if (userId == null) {
                    userId = user.getId();
                }
                if (userSegment == null) {
                    userSegment = user.getSegment();
                }
            }
            TraceContext traceContext = new TraceContext((SentryId)var3_3, publicKey, release, environment, userId, userSegment, transaction, sampleRate);
            traceContext.setUnknown(unknown);
            var1_1.endObject();
            return traceContext;
        }

        /*
         * WARNING - void declaration
         */
        private static Exception missingRequiredFieldException(String field, ILogger logger) {
            void var2_2;
            String string;
            void var1_1;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var1_1.log(SentryLevel.ERROR, string, exception);
            return var2_2;
        }
    }

    @Deprecated
    static final class TraceContextUser {
        private String id;
        private String segment;

        /*
         * WARNING - void declaration
         */
        private TraceContextUser(String id, String segment) {
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.segment = var2_2;
        }

        public final String getId() {
            return this.id;
        }

        public final String getSegment() {
            return this.segment;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ TraceContextUser(String x0, String x1, byte by) {
            this((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        public static final class Deserializer
        implements JsonDeserializer<TraceContextUser> {
            /*
             * WARNING - void declaration
             */
            private static TraceContextUser deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
                JsonObjectReader jsonObjectReader;
                void var3_3;
                void var2_2;
                reader.beginObject();
                String id = null;
                String segment = null;
                ConcurrentHashMap<String, Object> unknown = null;
                block8: while (reader.peek() == JsonToken.NAME) {
                    String nextName;
                    switch (nextName = reader.nextName()) {
                        case "id": {
                            id = reader.nextStringOrNull();
                            continue block8;
                        }
                        case "segment": {
                            segment = reader.nextStringOrNull();
                            continue block8;
                        }
                    }
                    if (unknown == null) {
                        unknown = new ConcurrentHashMap<String, Object>();
                    }
                    reader.nextUnknown(logger, unknown, nextName);
                }
                TraceContextUser traceStateUser = new TraceContextUser((String)var2_2, (String)var3_3, 0);
                jsonObjectReader.endObject();
                return traceStateUser;
            }
        }
    }
}

