/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.IntegrationName;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandler;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.hints.SessionEnd;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.SentryId;
import java.io.Closeable;

public final class UncaughtExceptionHandlerIntegration
implements IntegrationName,
Closeable,
Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private IHub hub;
    private SentryOptions options;
    private boolean registered = false;
    private final UncaughtExceptionHandler threadAdapter;

    public UncaughtExceptionHandlerIntegration() {
        this(UncaughtExceptionHandler.Adapter.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private UncaughtExceptionHandlerIntegration(UncaughtExceptionHandler threadAdapter) {
        void var1_1;
        this.threadAdapter = (UncaughtExceptionHandler)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"threadAdapter is required.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register(IHub hub, SentryOptions options) {
        void var2_2;
        if (this.registered) {
            options.getLogger().log(SentryLevel.ERROR, "Attempt to register a UncaughtExceptionHandlerIntegration twice.", new Object[0]);
            return;
        }
        this.registered = true;
        this.hub = (IHub)AnimationSpecKt.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"SentryOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration enabled: %s", this.options.isEnableUncaughtExceptionHandler());
        if (this.options.isEnableUncaughtExceptionHandler()) {
            Thread.UncaughtExceptionHandler currentHandler = this.threadAdapter.getDefaultUncaughtExceptionHandler();
            if (currentHandler != null) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.DEBUG, "default UncaughtExceptionHandler class='" + currentHandler.getClass().getName() + "'", new Object[0]);
                this.defaultExceptionHandler = var1_1;
            }
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this);
            this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration installed.", new Object[0]);
            this.addIntegrationToSdkVersion();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void uncaughtException(Thread thread, Throwable thrown) {
        if (this.options != null && this.hub != null) {
            this.options.getLogger().log(SentryLevel.INFO, "Uncaught exception received.", new Object[0]);
            try {
                UncaughtExceptionHint exceptionHint = new UncaughtExceptionHint(this.options.getFlushTimeoutMillis(), this.options.getLogger());
                Object object = thrown;
                Object object2 = thread;
                Object object3 = new Mechanism();
                ((Mechanism)object3).setHandled(Boolean.FALSE);
                ((Mechanism)object3).setType("UncaughtExceptionHandler");
                ExceptionMechanismException throwable = new ExceptionMechanismException((Mechanism)object3, (Throwable)object, (Thread)object2);
                SentryEvent event = new SentryEvent(throwable);
                event.setLevel(SentryLevel.FATAL);
                object2 = exceptionHint;
                object3 = object = new Hint();
                ((Hint)object).set("sentry:typeCheckHint", object2);
                Object hint = object;
                object2 = this.hub.captureEvent(event, (Hint)hint);
                boolean bl = ((SentryId)object2).equals(SentryId.EMPTY_ID);
                if (!bl && !exceptionHint.waitFlush()) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush event to disk before crashing. Event: %s", event.getEventId());
                }
            }
            catch (Throwable e) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, "Error sending uncaught exception to Sentry.", (Throwable)var3_4);
            }
            if (this.defaultExceptionHandler != null) {
                void var1_1;
                this.options.getLogger().log(SentryLevel.INFO, "Invoking inner uncaught exception handler.", new Object[0]);
                this.defaultExceptionHandler.uncaughtException((Thread)var1_1, thrown);
                return;
            }
            if (this.options.isPrintUncaughtStackTrace()) {
                void var2_2;
                var2_2.printStackTrace();
            }
        }
    }

    @Override
    public final void close() {
        UncaughtExceptionHandlerIntegration uncaughtExceptionHandlerIntegration = this;
        if (uncaughtExceptionHandlerIntegration == uncaughtExceptionHandlerIntegration.threadAdapter.getDefaultUncaughtExceptionHandler()) {
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration removed.", new Object[0]);
            }
        }
    }

    public static class UncaughtExceptionHint
    extends BlockingFlushHint
    implements SessionEnd {
        /*
         * WARNING - void declaration
         */
        public UncaughtExceptionHint(long flushTimeoutMillis, ILogger logger) {
            super((long)var1_1, (ILogger)var3_2);
            void var3_2;
            void var1_1;
        }
    }
}

