/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.ISerializer;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.clientreport.DiscardReason;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

abstract class CacheStrategy {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final SentryOptions options;
    protected final ISerializer serializer;
    protected final File directory;
    private final int maxSize;

    /*
     * WARNING - void declaration
     */
    CacheStrategy(SentryOptions options, String directoryPath, int maxSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        AnimationSpecKt.requireNonNull((Object)directoryPath, (String)"Directory is required.");
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)options, (String)"SentryOptions is required.");
        this.serializer = var1_1.getSerializer();
        this.directory = new File((String)var2_2);
        this.maxSize = var3_3;
    }

    protected final boolean isDirectoryValid() {
        if (!(this.directory.isDirectory() && this.directory.canWrite() && this.directory.canRead())) {
            this.options.getLogger().log(SentryLevel.ERROR, "The directory for caching files is inaccessible.: %s", this.directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    protected final void rotateCacheIfNeeded(File[] files) {
        int length = files.length;
        if (length >= this.maxSize) {
            this.options.getLogger().log(SentryLevel.WARNING, "Cache folder if full (respecting maxSize). Rotating files", new Object[0]);
            int totalToBeDeleted = length - this.maxSize + 1;
            Object object = files;
            if (files.length > 1) {
                Arrays.sort(object, (f1, f2) -> {
                    void var1_1;
                    return Long.compare(f1.lastModified(), var1_1.lastModified());
                });
            }
            File[] notDeletedFiles = Arrays.copyOfRange(files, totalToBeDeleted, length);
            for (int i = 0; i < totalToBeDeleted; ++i) {
                Object file = files[i];
                File[] fileArray = notDeletedFiles;
                Object object2 = file;
                object = this;
                if ((object2 = ((CacheStrategy)object).readEnvelope$2bff8c23((File)object2)) != null && CacheStrategy.isValidEnvelope$6b7e7272((CloseKt)object2)) {
                    Object object3;
                    Object object4;
                    block13: {
                        ((CacheStrategy)object).options.getClientReportRecorder().recordLostEnvelope$280c6a9c(DiscardReason.CACHE_OVERFLOW, (CloseKt)object2);
                        object4 = object2;
                        object2 = object;
                        object4 = object4.getItems().iterator();
                        while (object4.hasNext()) {
                            SentryEnvelopeItem sentryEnvelopeItem = (SentryEnvelopeItem)object4.next();
                            if (!CacheStrategy.isSessionType(sentryEnvelopeItem)) continue;
                            object3 = super.readSession(sentryEnvelopeItem);
                            break block13;
                        }
                        object3 = object2 = null;
                    }
                    if (object3 != null && CacheStrategy.isValidSession((Session)object2) && (object4 = ((Session)object2).getInit()) != null && ((Boolean)object4).booleanValue()) {
                        int n = fileArray.length;
                        block4: for (int j = 0; j < n; ++j) {
                            SentryEnvelopeItem sentryEnvelopeItem;
                            File file2 = fileArray[j];
                            Object object52 = super.readEnvelope$2bff8c23(file2);
                            if (object52 == null || !CacheStrategy.isValidEnvelope$6b7e7272(object52)) continue;
                            SentryEnvelopeItem sentryEnvelopeItem2 = null;
                            Iterator iterator = object52.getItems().iterator();
                            while (iterator.hasNext()) {
                                Session session;
                                sentryEnvelopeItem = (SentryEnvelopeItem)iterator.next();
                                if (!CacheStrategy.isSessionType(sentryEnvelopeItem) || (session = super.readSession(sentryEnvelopeItem)) == null || !CacheStrategy.isValidSession(session)) continue;
                                Boolean bl = session.getInit();
                                if (bl != null && bl.booleanValue()) {
                                    ((CacheStrategy)object).options.getLogger().log(SentryLevel.ERROR, "Session %s has 2 times the init flag.", ((Session)object2).getSessionId());
                                    break block4;
                                }
                                if (((Session)object2).getSessionId() == null || !((Session)object2).getSessionId().equals(session.getSessionId())) continue;
                                session.setInitAsTrue();
                                try {
                                    sentryEnvelopeItem2 = SentryEnvelopeItem.fromSession(((CacheStrategy)object).serializer, session);
                                    iterator.remove();
                                }
                                catch (IOException iOException) {
                                    ((CacheStrategy)object).options.getLogger().log(SentryLevel.ERROR, iOException, "Failed to create new envelope item for the session %s", ((Session)object2).getSessionId());
                                }
                                break;
                            }
                            if (sentryEnvelopeItem2 == null) continue;
                            SentryEnvelopeItem sentryEnvelopeItem3 = sentryEnvelopeItem2;
                            object2 = object52;
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (Object object52 : object2.getItems()) {
                                arrayList.add(object52);
                            }
                            arrayList.add(sentryEnvelopeItem3);
                            sentryEnvelopeItem = new CloseKt(object2.getHeader(), arrayList);
                            long l = file2.lastModified();
                            if (!file2.delete()) {
                                ((CacheStrategy)object).options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", file2.getAbsolutePath());
                            }
                            super.saveNewEnvelope$f56c001((CloseKt)sentryEnvelopeItem, file2, l);
                            break;
                        }
                    }
                }
                if (((File)file).delete()) continue;
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", ((File)file).getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private CloseKt readEnvelope$2bff8c23(File file) {
        CloseKt closeKt;
        BufferedInputStream inputStream2 = new BufferedInputStream(new FileInputStream(file));
        try {
            closeKt = this.serializer.deserializeEnvelope$7815be51(inputStream2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable inputStream2) {
                    throwable.addSuppressed(inputStream2);
                }
                throw throwable;
            }
            catch (IOException e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the envelope.", (Throwable)var1_3);
                return null;
            }
        }
        ((InputStream)inputStream2).close();
        return closeKt;
    }

    private static boolean isValidSession(Session session) {
        Object object;
        if (!session.getStatus().equals((Object)Session.State.Ok)) {
            return false;
        }
        return (object = ((Session)object).getSessionId()) != null;
    }

    private static boolean isSessionType(SentryEnvelopeItem item) {
        SentryEnvelopeItem sentryEnvelopeItem;
        if (item == null) {
            return false;
        }
        return sentryEnvelopeItem.getHeader().getType().equals(SentryItemType.Session);
    }

    /*
     * WARNING - void declaration
     */
    private Session readSession(SentryEnvelopeItem item) {
        Session session;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
        try {
            session = this.serializer.deserialize(reader2, Session.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader2).close();
                }
                catch (Throwable reader2) {
                    throwable.addSuppressed(reader2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the session.", (Throwable)var1_3);
                return null;
            }
        }
        ((Reader)reader2).close();
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private void saveNewEnvelope$f56c001(CloseKt envelope, File file, long timestamp) {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            void var3_5;
            void var2_3;
            void var1_1;
            this.serializer.serialize$55b83620((CloseKt)var1_1, outputStream);
            var2_3.setLastModified((long)var3_5);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to serialize the new envelope to the disk.", e);
        }
    }

    private static boolean isValidEnvelope$6b7e7272(CloseKt envelope) {
        return envelope.getItems().iterator().hasNext();
    }
}

