/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.Hint;
import io.sentry.SentryCrashLastRunState;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.CacheStrategy;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.SessionEnd;
import io.sentry.hints.SessionStart;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.HintUtils;
import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class EnvelopeCache
extends CacheStrategy
implements IEnvelopeCache {
    private final CountDownLatch previousSessionLatch;
    private final Map<CloseKt, String> fileNameMap = new WeakHashMap<CloseKt, String>();

    /*
     * WARNING - void declaration
     */
    public static IEnvelopeCache create(SentryOptions options) {
        void var2_2;
        void var1_1;
        SentryOptions sentryOptions;
        String cacheDirPath = options.getCacheDirPath();
        int maxCacheItems = options.getMaxCacheItems();
        if (cacheDirPath == null) {
            options.getLogger().log(SentryLevel.WARNING, "cacheDirPath is null, returning NoOpEnvelopeCache", new Object[0]);
            return NoOpEnvelopeCache.getInstance();
        }
        return new EnvelopeCache(sentryOptions, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private EnvelopeCache(SentryOptions options, String cacheDirPath, int maxCacheItems) {
        super((SentryOptions)var1_1, (String)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.previousSessionLatch = new CountDownLatch(1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void store$74b70ef(CloseKt envelope, Hint hint) {
        block55: {
            block60: {
                AnimationSpecKt.requireNonNull((Object)envelope, (String)"Envelope is required.");
                v0 = this;
                v0.rotateCacheIfNeeded(v0.allEnvelopeFiles());
                var5_3 = this.directory.getAbsolutePath();
                currentSessionFile = new File((String)var5_3, "session.json");
                previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
                if (HintUtils.hasType(hint, SessionEnd.class) && !currentSessionFile.delete()) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Current envelope doesn't exist.", new Object[0]);
                }
                if (!HintUtils.hasType(hint, AbnormalExit.class)) break block55;
                var6_10 = hint;
                var5_3 = this;
                var7_13 = var6_10.get("sentry:typeCheckHint");
                if (!(var7_13 instanceof AbnormalExit)) break block55;
                var8_17 = EnvelopeCache.getPreviousSessionFile(var5_3.directory.getAbsolutePath());
                if (!var8_17.exists()) break block60;
                var5_3.options.getLogger().log(SentryLevel.WARNING, "Previous session is not ended, we'd need to end it.", new Object[0]);
                try {
                    var9_20 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)var8_17), EnvelopeCache.UTF_8));
                    try {
                        var10_24 = var5_3.serializer.deserialize((Reader)var9_20, Session.class);
                        if (var10_24 == null) break block55;
                        var7_13 = (AbnormalExit)var7_13;
                        var6_10 = var7_13.timestamp();
                        var11_28 = null;
                        if (var6_10 == null) ** GOTO lbl-1000
                        var11_28 = AnimationSpecKt.getDateTime((long)var6_10.longValue());
                        var6_10 = var10_24.getStarted();
                        if (var6_10 == null || var11_28.before((Date)var6_10)) {
                            var5_3.options.getLogger().log(SentryLevel.WARNING, "Abnormal exit happened before previous session start, not ending the session.", new Object[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_10 = var7_13.mechanism();
                            var10_24.update(Session.State.Abnormal, null, true, (String)var6_10);
                            var10_24.end(var11_28);
                            super.writeSessionToDisk((File)var8_17, (Session)var10_24);
                        }
                        break block55;
                    }
                    finally {
                        var9_20.close();
                    }
                }
                catch (Throwable var9_21) {
                    var5_3.options.getLogger().log(SentryLevel.ERROR, "Error processing previous session.", var9_21);
                }
                break block55;
            }
            var5_3.options.getLogger().log(SentryLevel.DEBUG, "No previous session file to end.", new Object[0]);
        }
        if (HintUtils.hasType(hint, SessionStart.class)) {
            if (currentSessionFile.exists()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Current session is not ended, we'd need to end it.", new Object[0]);
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentSessionFile), EnvelopeCache.UTF_8));
                    try {
                        session = this.serializer.deserialize(reader, Session.class);
                        if (session != null) {
                            this.writeSessionToDisk(previousSessionFile, session);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error processing session.", e);
                }
            }
            var7_13 = envelope;
            var6_10 = var3_7;
            e = this;
            var8_17 = var7_13.getItems();
            if (var8_17.iterator().hasNext()) {
                var9_20 = (SentryEnvelopeItem)var8_17.iterator().next();
                if (SentryItemType.Session.equals(var9_20.getHeader().getType())) {
                    try {
                        var10_24 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(var9_20.getData()), EnvelopeCache.UTF_8));
                        try {
                            var7_13 = e.serializer.deserialize((Reader)var10_24, Session.class);
                            if (var7_13 == null) {
                                e.options.getLogger().log(SentryLevel.ERROR, "Item of type %s returned null by the parser.", new Object[]{var9_20.getHeader().getType()});
                            } else {
                                e.writeSessionToDisk((File)var6_10, (Session)var7_13);
                            }
                        }
                        finally {
                            var10_24.close();
                        }
                    }
                    catch (Throwable var10_26) {
                        e.options.getLogger().log(SentryLevel.ERROR, "Item failed to process.", var10_26);
                    }
                } else {
                    e.options.getLogger().log(SentryLevel.INFO, "Current envelope has a different envelope type %s", new Object[]{var9_20.getHeader().getType()});
                }
            } else {
                e.options.getLogger().log(SentryLevel.INFO, "Current envelope %s is empty", new Object[]{var6_10.getAbsolutePath()});
            }
            crashedLastRun = false;
            var6_10 = new File(this.options.getCacheDirPath(), ".sentry-native/last_crash");
            if (var6_10.exists()) {
                crashedLastRun = true;
            }
            if (!crashedLastRun && (javaCrashMarkerFile = new File(this.options.getCacheDirPath(), "last_crash")).exists()) {
                this.options.getLogger().log(SentryLevel.INFO, "Crash marker file exists, crashedLastRun will return true.", new Object[0]);
                crashedLastRun = true;
                if (!javaCrashMarkerFile.delete()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete the crash marker file. %s.", new Object[]{javaCrashMarkerFile.getAbsolutePath()});
                }
            }
            SentryCrashLastRunState.getInstance().setCrashedLastRun(crashedLastRun);
            this.previousSessionLatch.countDown();
        }
        if ((envelopeFile = this.getEnvelopeFile$5a84caa1(envelope)).exists()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Not adding Envelope to offline storage because it already exists: %s", new Object[]{envelopeFile.getAbsolutePath()});
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Adding Envelope to offline storage: %s", new Object[]{envelopeFile.getAbsolutePath()});
        var7_13 = var1_1;
        var6_10 = envelopeFile;
        var5_6 = this;
        if (var6_10.exists()) {
            var5_6.options.getLogger().log(SentryLevel.DEBUG, "Overwriting envelope to offline storage: %s", new Object[]{var6_10.getAbsolutePath()});
            if (!var6_10.delete()) {
                var5_6.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", new Object[]{var6_10.getAbsolutePath()});
            }
        }
        try {
            var8_17 = new FileOutputStream((File)var6_10);
            try {
                var5_6.serializer.serialize$55b83620((CloseKt)var7_13, (OutputStream)var8_17);
            }
            finally {
                var8_17.close();
            }
        }
        catch (Throwable var8_18) {
            var5_6.options.getLogger().log(SentryLevel.ERROR, var8_18, "Error writing Envelope %s to offline storage", new Object[]{var6_10.getAbsolutePath()});
        }
        if (HintUtils.hasType((Hint)var2_2, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
            var5_6 = this;
            var6_10 = new File(var5_6.options.getCacheDirPath(), "last_crash");
            try {
                var7_13 = new FileOutputStream((File)var6_10);
                try {
                    var6_10 = AnimationSpecKt.getCurrentDateTime();
                    var8_17 = ISO8601Utils.format((Date)var6_10, true);
                    var7_13.write(var8_17.getBytes(EnvelopeCache.UTF_8));
                    var7_13.flush();
                }
                finally {
                    var7_13.close();
                }
            }
            catch (Throwable var7_16) {
                var5_6.options.getLogger().log(SentryLevel.ERROR, "Error writing the crash marker file to the disk", var7_16);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSessionToDisk(File file, Session session) {
        if (file.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting session to offline storage: %s", session.getSessionId());
            if (!file.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));
            try {
                this.serializer.serialize(session, writer);
            }
            catch (Throwable throwable) {
                try {
                    void var3_4;
                    var3_4.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((Writer)writer).close();
        }
        catch (Throwable e) {
            void var2_3;
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var1_2, "Error writing Session to offline storage: %s", var2_3.getSessionId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void discard$6b7e726e(CloseKt envelope) {
        AnimationSpecKt.requireNonNull((Object)envelope, (String)"Envelope is required.");
        File envelopeFile = this.getEnvelopeFile$5a84caa1(envelope);
        if (envelopeFile.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Discarding envelope from cache: %s", envelopeFile.getAbsolutePath());
            if (!envelopeFile.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete envelope: %s", envelopeFile.getAbsolutePath());
                return;
            }
        } else {
            void var1_1;
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope was not cached: %s", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized File getEnvelopeFile$5a84caa1(CloseKt envelope) {
        void var2_2;
        String fileName;
        if (this.fileNameMap.containsKey(envelope)) {
            fileName = this.fileNameMap.get(envelope);
        } else {
            void var1_1;
            fileName = envelope.getHeader().getEventId() != null ? envelope.getHeader().getEventId().toString() : UUID.randomUUID().toString();
            fileName = fileName + ".envelope";
            this.fileNameMap.put((CloseKt)var1_1, fileName);
        }
        return new File(this.directory.getAbsolutePath(), (String)var2_2);
    }

    public static File getPreviousSessionFile(String cacheDirPath) {
        String string;
        return new File(string, "previous_session.json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<CloseKt> iterator() {
        void var2_2;
        void var1_1;
        File[] allCachedEnvelopes = this.allEnvelopeFiles();
        ArrayList<CloseKt> ret = new ArrayList<CloseKt>(allCachedEnvelopes.length);
        for (void file : var1_1) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((File)file));){
                ret.add(this.serializer.deserializeEnvelope$7815be51(is));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Envelope file '%s' disappeared while converting all cached files to envelopes.", file.getAbsolutePath());
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, String.format("Error while reading cached envelope from file %s", file.getAbsolutePath()), e);
            }
        }
        return var2_2.iterator();
    }

    /*
     * WARNING - void declaration
     */
    private File[] allEnvelopeFiles() {
        File[] files;
        if (this.isDirectoryValid() && (files = this.directory.listFiles((__, fileName) -> fileName.endsWith(".envelope"))) != null) {
            void var1_1;
            return var1_1;
        }
        return new File[0];
    }

    public final boolean waitPreviousSessionFlush() {
        try {
            return this.previousSessionLatch.await(this.options.getFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.options.getLogger().log(SentryLevel.DEBUG, "Timed out waiting for previous session to flush.", new Object[0]);
            return false;
        }
    }
}

